import { createRequire } from 'module'; const require = createRequire(import.meta.url);
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __require = /* @__PURE__ */ ((x11) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x11, {
  get: (a9, b9) => (typeof require !== "undefined" ? require : a9)[b9]
}) : x11)(function(x11) {
  if (typeof require !== "undefined") return require.apply(this, arguments);
  throw Error('Dynamic require of "' + x11 + '" is not supported');
});
var __esm = (fn3, res) => function __init() {
  return fn3 && (res = (0, fn3[__getOwnPropNames(fn3)[0]])(fn3 = 0)), res;
};
var __commonJS = (cb, mod) => function __require2() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name3 in all)
    __defProp(target, name3, { get: all[name3], enumerable: true });
};
var __copyProps = (to3, from, except5, desc2) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to3, key) && key !== except5)
        __defProp(to3, key, { get: () => from[key], enumerable: !(desc2 = __getOwnPropDesc(from, key)) || desc2.enumerable });
  }
  return to3;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});

// ../drizzle-orm/dist/entity.js
function is(value, type) {
  if (!value || typeof value !== "object") {
    return false;
  }
  if (value instanceof type) {
    return true;
  }
  if (!Object.prototype.hasOwnProperty.call(type, entityKind)) {
    throw new Error(
      `Class "${type.name ?? "<unknown>"}" doesn't look like a Drizzle entity. If this is incorrect and the class is provided by Drizzle, please report this as a bug.`
    );
  }
  let cls = Object.getPrototypeOf(value).constructor;
  if (cls) {
    while (cls) {
      if (entityKind in cls && cls[entityKind] === type[entityKind]) {
        return true;
      }
      cls = Object.getPrototypeOf(cls);
    }
  }
  return false;
}
var entityKind, hasOwnEntityKind;
var init_entity = __esm({
  "../drizzle-orm/dist/entity.js"() {
    "use strict";
    entityKind = Symbol.for("drizzle:entityKind");
    hasOwnEntityKind = Symbol.for("drizzle:hasOwnEntityKind");
  }
});

// ../drizzle-orm/dist/column.js
var _a, Column;
var init_column = __esm({
  "../drizzle-orm/dist/column.js"() {
    "use strict";
    init_entity();
    _a = entityKind;
    Column = class {
      constructor(table6, config) {
        __publicField(this, "name");
        __publicField(this, "keyAsName");
        __publicField(this, "primary");
        __publicField(this, "notNull");
        __publicField(this, "default");
        __publicField(this, "defaultFn");
        __publicField(this, "onUpdateFn");
        __publicField(this, "hasDefault");
        __publicField(this, "isUnique");
        __publicField(this, "uniqueName");
        __publicField(this, "uniqueType");
        __publicField(this, "dataType");
        __publicField(this, "columnType");
        __publicField(this, "enumValues");
        __publicField(this, "generated");
        __publicField(this, "generatedIdentity");
        __publicField(this, "config");
        this.table = table6;
        this.config = config;
        this.name = config.name;
        this.keyAsName = config.keyAsName;
        this.notNull = config.notNull;
        this.default = config.default;
        this.defaultFn = config.defaultFn;
        this.onUpdateFn = config.onUpdateFn;
        this.hasDefault = config.hasDefault;
        this.primary = config.primaryKey;
        this.isUnique = config.isUnique;
        this.uniqueName = config.uniqueName;
        this.uniqueType = config.uniqueType;
        this.dataType = config.dataType;
        this.columnType = config.columnType;
        this.generated = config.generated;
        this.generatedIdentity = config.generatedIdentity;
      }
      mapFromDriverValue(value) {
        return value;
      }
      mapToDriverValue(value) {
        return value;
      }
      // ** @internal */
      shouldDisableInsert() {
        return this.config.generated !== void 0 && this.config.generated.type !== "byDefault";
      }
    };
    __publicField(Column, _a, "Column");
  }
});

// ../drizzle-orm/dist/column-builder.js
var _a2, ColumnBuilder;
var init_column_builder = __esm({
  "../drizzle-orm/dist/column-builder.js"() {
    "use strict";
    init_entity();
    _a2 = entityKind;
    ColumnBuilder = class {
      constructor(name3, dataType, columnType) {
        __publicField(this, "config");
        /**
         * Alias for {@link $defaultFn}.
         */
        __publicField(this, "$default", this.$defaultFn);
        /**
         * Alias for {@link $onUpdateFn}.
         */
        __publicField(this, "$onUpdate", this.$onUpdateFn);
        this.config = {
          name: name3,
          keyAsName: name3 === "",
          notNull: false,
          default: void 0,
          hasDefault: false,
          primaryKey: false,
          isUnique: false,
          uniqueName: void 0,
          uniqueType: void 0,
          dataType,
          columnType,
          generated: void 0
        };
      }
      /**
       * Changes the data type of the column. Commonly used with `json` columns. Also, useful for branded types.
       *
       * @example
       * ```ts
       * const users = pgTable('users', {
       * 	id: integer('id').$type<UserId>().primaryKey(),
       * 	details: json('details').$type<UserDetails>().notNull(),
       * });
       * ```
       */
      $type() {
        return this;
      }
      /**
       * Adds a `not null` clause to the column definition.
       *
       * Affects the `select` model of the table - columns *without* `not null` will be nullable on select.
       */
      notNull() {
        this.config.notNull = true;
        return this;
      }
      /**
       * Adds a `default <value>` clause to the column definition.
       *
       * Affects the `insert` model of the table - columns *with* `default` are optional on insert.
       *
       * If you need to set a dynamic default value, use {@link $defaultFn} instead.
       */
      default(value) {
        this.config.default = value;
        this.config.hasDefault = true;
        return this;
      }
      /**
       * Adds a dynamic default value to the column.
       * The function will be called when the row is inserted, and the returned value will be used as the column value.
       *
       * **Note:** This value does not affect the `drizzle-kit` behavior, it is only used at runtime in `drizzle-orm`.
       */
      $defaultFn(fn3) {
        this.config.defaultFn = fn3;
        this.config.hasDefault = true;
        return this;
      }
      /**
       * Adds a dynamic update value to the column.
       * The function will be called when the row is updated, and the returned value will be used as the column value if none is provided.
       * If no `default` (or `$defaultFn`) value is provided, the function will be called when the row is inserted as well, and the returned value will be used as the column value.
       *
       * **Note:** This value does not affect the `drizzle-kit` behavior, it is only used at runtime in `drizzle-orm`.
       */
      $onUpdateFn(fn3) {
        this.config.onUpdateFn = fn3;
        this.config.hasDefault = true;
        return this;
      }
      /**
       * Adds a `primary key` clause to the column definition. This implicitly makes the column `not null`.
       *
       * In SQLite, `integer primary key` implicitly makes the column auto-incrementing.
       */
      primaryKey() {
        this.config.primaryKey = true;
        this.config.notNull = true;
        return this;
      }
      /** @internal Sets the name of the column to the key within the table definition if a name was not given. */
      setName(name3) {
        if (this.config.name !== "") return;
        this.config.name = name3;
      }
    };
    __publicField(ColumnBuilder, _a2, "ColumnBuilder");
  }
});

// ../drizzle-orm/dist/table.utils.js
var TableName;
var init_table_utils = __esm({
  "../drizzle-orm/dist/table.utils.js"() {
    "use strict";
    TableName = Symbol.for("drizzle:Name");
  }
});

// ../drizzle-orm/dist/pg-core/foreign-keys.js
function foreignKey(config) {
  function mappedConfig() {
    const { name: name3, columns, foreignColumns } = config;
    return {
      name: name3,
      columns,
      foreignColumns
    };
  }
  return new ForeignKeyBuilder(mappedConfig);
}
var _a3, ForeignKeyBuilder, _a4, ForeignKey;
var init_foreign_keys = __esm({
  "../drizzle-orm/dist/pg-core/foreign-keys.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a3 = entityKind;
    ForeignKeyBuilder = class {
      constructor(config, actions) {
        /** @internal */
        __publicField(this, "reference");
        /** @internal */
        __publicField(this, "_onUpdate", "no action");
        /** @internal */
        __publicField(this, "_onDelete", "no action");
        this.reference = () => {
          const { name: name3, columns, foreignColumns } = config();
          return { name: name3, columns, foreignTable: foreignColumns[0].table, foreignColumns };
        };
        if (actions) {
          this._onUpdate = actions.onUpdate;
          this._onDelete = actions.onDelete;
        }
      }
      onUpdate(action) {
        this._onUpdate = action === void 0 ? "no action" : action;
        return this;
      }
      onDelete(action) {
        this._onDelete = action === void 0 ? "no action" : action;
        return this;
      }
      /** @internal */
      build(table6) {
        return new ForeignKey(table6, this);
      }
    };
    __publicField(ForeignKeyBuilder, _a3, "PgForeignKeyBuilder");
    _a4 = entityKind;
    ForeignKey = class {
      constructor(table6, builder) {
        __publicField(this, "reference");
        __publicField(this, "onUpdate");
        __publicField(this, "onDelete");
        this.table = table6;
        this.reference = builder.reference;
        this.onUpdate = builder._onUpdate;
        this.onDelete = builder._onDelete;
      }
      getName() {
        const { name: name3, columns, foreignColumns } = this.reference();
        const columnNames = columns.map((column6) => column6.name);
        const foreignColumnNames = foreignColumns.map((column6) => column6.name);
        const chunks = [
          this.table[TableName],
          ...columnNames,
          foreignColumns[0].table[TableName],
          ...foreignColumnNames
        ];
        return name3 ?? `${chunks.join("_")}_fk`;
      }
    };
    __publicField(ForeignKey, _a4, "PgForeignKey");
  }
});

// ../drizzle-orm/dist/tracing-utils.js
function iife(fn3, ...args2) {
  return fn3(...args2);
}
var init_tracing_utils = __esm({
  "../drizzle-orm/dist/tracing-utils.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/pg-core/unique-constraint.js
function unique(name3) {
  return new UniqueOnConstraintBuilder(name3);
}
function uniqueKeyName(table6, columns) {
  return `${table6[TableName]}_${columns.join("_")}_unique`;
}
var _a5, UniqueConstraintBuilder, _a6, UniqueOnConstraintBuilder, _a7, UniqueConstraint;
var init_unique_constraint = __esm({
  "../drizzle-orm/dist/pg-core/unique-constraint.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a5 = entityKind;
    UniqueConstraintBuilder = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        /** @internal */
        __publicField(this, "nullsNotDistinctConfig", false);
        this.name = name3;
        this.columns = columns;
      }
      nullsNotDistinct() {
        this.nullsNotDistinctConfig = true;
        return this;
      }
      /** @internal */
      build(table6) {
        return new UniqueConstraint(table6, this.columns, this.nullsNotDistinctConfig, this.name);
      }
    };
    __publicField(UniqueConstraintBuilder, _a5, "PgUniqueConstraintBuilder");
    _a6 = entityKind;
    UniqueOnConstraintBuilder = class {
      constructor(name3) {
        /** @internal */
        __publicField(this, "name");
        this.name = name3;
      }
      on(...columns) {
        return new UniqueConstraintBuilder(columns, this.name);
      }
    };
    __publicField(UniqueOnConstraintBuilder, _a6, "PgUniqueOnConstraintBuilder");
    _a7 = entityKind;
    UniqueConstraint = class {
      constructor(table6, columns, nullsNotDistinct, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        __publicField(this, "nullsNotDistinct", false);
        this.table = table6;
        this.columns = columns;
        this.name = name3 ?? uniqueKeyName(this.table, this.columns.map((column6) => column6.name));
        this.nullsNotDistinct = nullsNotDistinct;
      }
      getName() {
        return this.name;
      }
    };
    __publicField(UniqueConstraint, _a7, "PgUniqueConstraint");
  }
});

// ../drizzle-orm/dist/pg-core/utils/array.js
function parsePgArrayValue(arrayString, startFrom, inQuotes) {
  for (let i8 = startFrom; i8 < arrayString.length; i8++) {
    const char4 = arrayString[i8];
    if (char4 === "\\") {
      i8++;
      continue;
    }
    if (char4 === '"') {
      return [arrayString.slice(startFrom, i8).replace(/\\/g, ""), i8 + 1];
    }
    if (inQuotes) {
      continue;
    }
    if (char4 === "," || char4 === "}") {
      return [arrayString.slice(startFrom, i8).replace(/\\/g, ""), i8];
    }
  }
  return [arrayString.slice(startFrom).replace(/\\/g, ""), arrayString.length];
}
function parsePgNestedArray(arrayString, startFrom = 0) {
  const result = [];
  let i8 = startFrom;
  let lastCharIsComma = false;
  while (i8 < arrayString.length) {
    const char4 = arrayString[i8];
    if (char4 === ",") {
      if (lastCharIsComma || i8 === startFrom) {
        result.push("");
      }
      lastCharIsComma = true;
      i8++;
      continue;
    }
    lastCharIsComma = false;
    if (char4 === "\\") {
      i8 += 2;
      continue;
    }
    if (char4 === '"') {
      const [value2, startFrom2] = parsePgArrayValue(arrayString, i8 + 1, true);
      result.push(value2);
      i8 = startFrom2;
      continue;
    }
    if (char4 === "}") {
      return [result, i8 + 1];
    }
    if (char4 === "{") {
      const [value2, startFrom2] = parsePgNestedArray(arrayString, i8 + 1);
      result.push(value2);
      i8 = startFrom2;
      continue;
    }
    const [value, newStartFrom] = parsePgArrayValue(arrayString, i8, false);
    result.push(value);
    i8 = newStartFrom;
  }
  return [result, i8];
}
function parsePgArray(arrayString) {
  const [result] = parsePgNestedArray(arrayString, 1);
  return result;
}
function makePgArray(array3) {
  return `{${array3.map((item) => {
    if (Array.isArray(item)) {
      return makePgArray(item);
    }
    if (typeof item === "string") {
      return `"${item.replace(/\\/g, "\\\\").replace(/"/g, '\\"')}"`;
    }
    return `${item}`;
  }).join(",")}}`;
}
var init_array = __esm({
  "../drizzle-orm/dist/pg-core/utils/array.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/pg-core/columns/common.js
var _a8, _b, PgColumnBuilder, _a9, _b2, PgColumn, _a10, _b3, ExtraConfigColumn, _a11, IndexedColumn, _a12, _b4, PgArrayBuilder, _a13, _b5, _PgArray, PgArray;
var init_common = __esm({
  "../drizzle-orm/dist/pg-core/columns/common.js"() {
    "use strict";
    init_column_builder();
    init_column();
    init_entity();
    init_foreign_keys();
    init_tracing_utils();
    init_unique_constraint();
    init_array();
    PgColumnBuilder = class extends (_b = ColumnBuilder, _a8 = entityKind, _b) {
      constructor() {
        super(...arguments);
        __publicField(this, "foreignKeyConfigs", []);
      }
      array(size2) {
        return new PgArrayBuilder(this.config.name, this, size2);
      }
      references(ref, actions = {}) {
        this.foreignKeyConfigs.push({ ref, actions });
        return this;
      }
      unique(name3, config) {
        this.config.isUnique = true;
        this.config.uniqueName = name3;
        this.config.uniqueType = config?.nulls;
        return this;
      }
      generatedAlwaysAs(as) {
        this.config.generated = {
          as,
          type: "always",
          mode: "stored"
        };
        return this;
      }
      /** @internal */
      buildForeignKeys(column6, table6) {
        return this.foreignKeyConfigs.map(({ ref, actions }) => {
          return iife(
            (ref2, actions2) => {
              const builder = new ForeignKeyBuilder(() => {
                const foreignColumn = ref2();
                return { columns: [column6], foreignColumns: [foreignColumn] };
              });
              if (actions2.onUpdate) {
                builder.onUpdate(actions2.onUpdate);
              }
              if (actions2.onDelete) {
                builder.onDelete(actions2.onDelete);
              }
              return builder.build(table6);
            },
            ref,
            actions
          );
        });
      }
      /** @internal */
      buildExtraConfigColumn(table6) {
        return new ExtraConfigColumn(table6, this.config);
      }
    };
    __publicField(PgColumnBuilder, _a8, "PgColumnBuilder");
    PgColumn = class extends (_b2 = Column, _a9 = entityKind, _b2) {
      constructor(table6, config) {
        if (!config.uniqueName) {
          config.uniqueName = uniqueKeyName(table6, [config.name]);
        }
        super(table6, config);
        this.table = table6;
      }
    };
    __publicField(PgColumn, _a9, "PgColumn");
    ExtraConfigColumn = class extends (_b3 = PgColumn, _a10 = entityKind, _b3) {
      constructor() {
        super(...arguments);
        __publicField(this, "indexConfig", {
          order: this.config.order ?? "asc",
          nulls: this.config.nulls ?? "last",
          opClass: this.config.opClass
        });
        __publicField(this, "defaultConfig", {
          order: "asc",
          nulls: "last",
          opClass: void 0
        });
      }
      getSQLType() {
        return this.getSQLType();
      }
      asc() {
        this.indexConfig.order = "asc";
        return this;
      }
      desc() {
        this.indexConfig.order = "desc";
        return this;
      }
      nullsFirst() {
        this.indexConfig.nulls = "first";
        return this;
      }
      nullsLast() {
        this.indexConfig.nulls = "last";
        return this;
      }
      /**
       * ### PostgreSQL documentation quote
       *
       * > An operator class with optional parameters can be specified for each column of an index.
       * The operator class identifies the operators to be used by the index for that column.
       * For example, a B-tree index on four-byte integers would use the int4_ops class;
       * this operator class includes comparison functions for four-byte integers.
       * In practice the default operator class for the column's data type is usually sufficient.
       * The main point of having operator classes is that for some data types, there could be more than one meaningful ordering.
       * For example, we might want to sort a complex-number data type either by absolute value or by real part.
       * We could do this by defining two operator classes for the data type and then selecting the proper class when creating an index.
       * More information about operator classes check:
       *
       * ### Useful links
       * https://www.postgresql.org/docs/current/sql-createindex.html
       *
       * https://www.postgresql.org/docs/current/indexes-opclass.html
       *
       * https://www.postgresql.org/docs/current/xindex.html
       *
       * ### Additional types
       * If you have the `pg_vector` extension installed in your database, you can use the
       * `vector_l2_ops`, `vector_ip_ops`, `vector_cosine_ops`, `vector_l1_ops`, `bit_hamming_ops`, `bit_jaccard_ops`, `halfvec_l2_ops`, `sparsevec_l2_ops` options, which are predefined types.
       *
       * **You can always specify any string you want in the operator class, in case Drizzle doesn't have it natively in its types**
       *
       * @param opClass
       * @returns
       */
      op(opClass) {
        this.indexConfig.opClass = opClass;
        return this;
      }
    };
    __publicField(ExtraConfigColumn, _a10, "ExtraConfigColumn");
    _a11 = entityKind;
    IndexedColumn = class {
      constructor(name3, keyAsName, type, indexConfig) {
        __publicField(this, "name");
        __publicField(this, "keyAsName");
        __publicField(this, "type");
        __publicField(this, "indexConfig");
        this.name = name3;
        this.keyAsName = keyAsName;
        this.type = type;
        this.indexConfig = indexConfig;
      }
    };
    __publicField(IndexedColumn, _a11, "IndexedColumn");
    PgArrayBuilder = class extends (_b4 = PgColumnBuilder, _a12 = entityKind, _b4) {
      constructor(name3, baseBuilder, size2) {
        super(name3, "array", "PgArray");
        this.config.baseBuilder = baseBuilder;
        this.config.size = size2;
      }
      /** @internal */
      build(table6) {
        const baseColumn = this.config.baseBuilder.build(table6);
        return new PgArray(
          table6,
          this.config,
          baseColumn
        );
      }
    };
    __publicField(PgArrayBuilder, _a12, "PgArrayBuilder");
    _PgArray = class _PgArray extends (_b5 = PgColumn, _a13 = entityKind, _b5) {
      constructor(table6, config, baseColumn, range) {
        super(table6, config);
        __publicField(this, "size");
        this.baseColumn = baseColumn;
        this.range = range;
        this.size = config.size;
      }
      getSQLType() {
        return `${this.baseColumn.getSQLType()}[${typeof this.size === "number" ? this.size : ""}]`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          value = parsePgArray(value);
        }
        return value.map((v11) => this.baseColumn.mapFromDriverValue(v11));
      }
      mapToDriverValue(value, isNestedArray = false) {
        const a9 = value.map(
          (v11) => v11 === null ? null : is(this.baseColumn, _PgArray) ? this.baseColumn.mapToDriverValue(v11, true) : this.baseColumn.mapToDriverValue(v11)
        );
        if (isNestedArray) return a9;
        return makePgArray(a9);
      }
    };
    __publicField(_PgArray, _a13, "PgArray");
    PgArray = _PgArray;
  }
});

// ../drizzle-orm/dist/pg-core/columns/enum.js
function isPgEnum(obj) {
  return !!obj && typeof obj === "function" && isPgEnumSym in obj && obj[isPgEnumSym] === true;
}
function pgEnum(enumName, input) {
  return Array.isArray(input) ? pgEnumWithSchema(enumName, [...input], void 0) : pgEnumObjectWithSchema(enumName, input, void 0);
}
function pgEnumWithSchema(enumName, values2, schema6) {
  const enumInstance = Object.assign(
    (name3) => new PgEnumColumnBuilder(name3 ?? "", enumInstance),
    {
      enumName,
      enumValues: values2,
      schema: schema6,
      [isPgEnumSym]: true
    }
  );
  return enumInstance;
}
function pgEnumObjectWithSchema(enumName, values2, schema6) {
  const enumInstance = Object.assign(
    (name3) => new PgEnumObjectColumnBuilder(name3 ?? "", enumInstance),
    {
      enumName,
      enumValues: Object.values(values2),
      schema: schema6,
      [isPgEnumSym]: true
    }
  );
  return enumInstance;
}
var _a14, _b6, PgEnumObjectColumnBuilder, _a15, _b7, PgEnumObjectColumn, isPgEnumSym, _a16, _b8, PgEnumColumnBuilder, _a17, _b9, PgEnumColumn;
var init_enum = __esm({
  "../drizzle-orm/dist/pg-core/columns/enum.js"() {
    "use strict";
    init_entity();
    init_common();
    PgEnumObjectColumnBuilder = class extends (_b6 = PgColumnBuilder, _a14 = entityKind, _b6) {
      constructor(name3, enumInstance) {
        super(name3, "string", "PgEnumObjectColumn");
        this.config.enum = enumInstance;
      }
      /** @internal */
      build(table6) {
        return new PgEnumObjectColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(PgEnumObjectColumnBuilder, _a14, "PgEnumObjectColumnBuilder");
    PgEnumObjectColumn = class extends (_b7 = PgColumn, _a15 = entityKind, _b7) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "enum");
        __publicField(this, "enumValues", this.config.enum.enumValues);
        this.enum = config.enum;
      }
      getSQLType() {
        return this.enum.enumName;
      }
    };
    __publicField(PgEnumObjectColumn, _a15, "PgEnumObjectColumn");
    isPgEnumSym = Symbol.for("drizzle:isPgEnum");
    PgEnumColumnBuilder = class extends (_b8 = PgColumnBuilder, _a16 = entityKind, _b8) {
      constructor(name3, enumInstance) {
        super(name3, "string", "PgEnumColumn");
        this.config.enum = enumInstance;
      }
      /** @internal */
      build(table6) {
        return new PgEnumColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(PgEnumColumnBuilder, _a16, "PgEnumColumnBuilder");
    PgEnumColumn = class extends (_b9 = PgColumn, _a17 = entityKind, _b9) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "enum", this.config.enum);
        __publicField(this, "enumValues", this.config.enum.enumValues);
        this.enum = config.enum;
      }
      getSQLType() {
        return this.enum.enumName;
      }
    };
    __publicField(PgEnumColumn, _a17, "PgEnumColumn");
  }
});

// ../drizzle-orm/dist/subquery.js
var _a18, Subquery, _a19, _b10, WithSubquery;
var init_subquery = __esm({
  "../drizzle-orm/dist/subquery.js"() {
    "use strict";
    init_entity();
    _a18 = entityKind;
    Subquery = class {
      constructor(sql3, fields, alias2, isWith = false, usedTables = []) {
        this._ = {
          brand: "Subquery",
          sql: sql3,
          selectedFields: fields,
          alias: alias2,
          isWith,
          usedTables
        };
      }
      // getSQL(): SQL<unknown> {
      // 	return new SQL([this]);
      // }
    };
    __publicField(Subquery, _a18, "Subquery");
    WithSubquery = class extends (_b10 = Subquery, _a19 = entityKind, _b10) {
    };
    __publicField(WithSubquery, _a19, "WithSubquery");
  }
});

// ../drizzle-orm/dist/version.js
var version;
var init_version = __esm({
  "../drizzle-orm/dist/version.js"() {
    "use strict";
    version = "0.44.7";
  }
});

// ../drizzle-orm/dist/tracing.js
var otel, rawTracer, tracer;
var init_tracing = __esm({
  "../drizzle-orm/dist/tracing.js"() {
    "use strict";
    init_tracing_utils();
    init_version();
    tracer = {
      startActiveSpan(name3, fn3) {
        if (!otel) {
          return fn3();
        }
        if (!rawTracer) {
          rawTracer = otel.trace.getTracer("drizzle-orm", version);
        }
        return iife(
          (otel2, rawTracer2) => rawTracer2.startActiveSpan(
            name3,
            (span) => {
              try {
                return fn3(span);
              } catch (e6) {
                span.setStatus({
                  code: otel2.SpanStatusCode.ERROR,
                  message: e6 instanceof Error ? e6.message : "Unknown error"
                  // eslint-disable-line no-instanceof/no-instanceof
                });
                throw e6;
              } finally {
                span.end();
              }
            }
          ),
          otel,
          rawTracer
        );
      }
    };
  }
});

// ../drizzle-orm/dist/view-common.js
var ViewBaseConfig;
var init_view_common = __esm({
  "../drizzle-orm/dist/view-common.js"() {
    "use strict";
    ViewBaseConfig = Symbol.for("drizzle:ViewBaseConfig");
  }
});

// ../drizzle-orm/dist/table.js
function isTable(table6) {
  return typeof table6 === "object" && table6 !== null && IsDrizzleTable in table6;
}
function getTableName(table6) {
  return table6[TableName];
}
function getTableUniqueName(table6) {
  return `${table6[Schema] ?? "public"}.${table6[TableName]}`;
}
var Schema, Columns, ExtraConfigColumns, OriginalName, BaseName, IsAlias, ExtraConfigBuilder, IsDrizzleTable, _a20, _b11, _c, _d, _e, _f, _g, _h, _i, _j, Table;
var init_table = __esm({
  "../drizzle-orm/dist/table.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    Schema = Symbol.for("drizzle:Schema");
    Columns = Symbol.for("drizzle:Columns");
    ExtraConfigColumns = Symbol.for("drizzle:ExtraConfigColumns");
    OriginalName = Symbol.for("drizzle:OriginalName");
    BaseName = Symbol.for("drizzle:BaseName");
    IsAlias = Symbol.for("drizzle:IsAlias");
    ExtraConfigBuilder = Symbol.for("drizzle:ExtraConfigBuilder");
    IsDrizzleTable = Symbol.for("drizzle:IsDrizzleTable");
    _j = entityKind, _i = TableName, _h = OriginalName, _g = Schema, _f = Columns, _e = ExtraConfigColumns, _d = BaseName, _c = IsAlias, _b11 = IsDrizzleTable, _a20 = ExtraConfigBuilder;
    Table = class {
      constructor(name3, schema6, baseName) {
        /**
         * @internal
         * Can be changed if the table is aliased.
         */
        __publicField(this, _i);
        /**
         * @internal
         * Used to store the original name of the table, before any aliasing.
         */
        __publicField(this, _h);
        /** @internal */
        __publicField(this, _g);
        /** @internal */
        __publicField(this, _f);
        /** @internal */
        __publicField(this, _e);
        /**
         *  @internal
         * Used to store the table name before the transformation via the `tableCreator` functions.
         */
        __publicField(this, _d);
        /** @internal */
        __publicField(this, _c, false);
        /** @internal */
        __publicField(this, _b11, true);
        /** @internal */
        __publicField(this, _a20);
        this[TableName] = this[OriginalName] = name3;
        this[Schema] = schema6;
        this[BaseName] = baseName;
      }
    };
    __publicField(Table, _j, "Table");
    /** @internal */
    __publicField(Table, "Symbol", {
      Name: TableName,
      Schema,
      OriginalName,
      Columns,
      ExtraConfigColumns,
      BaseName,
      IsAlias,
      ExtraConfigBuilder
    });
  }
});

// ../drizzle-orm/dist/sql/sql.js
function isSQLWrapper(value) {
  return value !== null && value !== void 0 && typeof value.getSQL === "function";
}
function mergeQueries(queries) {
  const result = { sql: "", params: [] };
  for (const query of queries) {
    result.sql += query.sql;
    result.params.push(...query.params);
    if (query.typings?.length) {
      if (!result.typings) {
        result.typings = [];
      }
      result.typings.push(...query.typings);
    }
  }
  return result;
}
function name2(value) {
  return new Name(value);
}
function isDriverValueEncoder(value) {
  return typeof value === "object" && value !== null && "mapToDriverValue" in value && typeof value.mapToDriverValue === "function";
}
function param(value, encoder) {
  return new Param(value, encoder);
}
function sql(strings, ...params) {
  const queryChunks = [];
  if (params.length > 0 || strings.length > 0 && strings[0] !== "") {
    queryChunks.push(new StringChunk(strings[0]));
  }
  for (const [paramIndex, param2] of params.entries()) {
    queryChunks.push(param2, new StringChunk(strings[paramIndex + 1]));
  }
  return new SQL(queryChunks);
}
function placeholder(name22) {
  return new Placeholder(name22);
}
function fillPlaceholders(params, values2) {
  return params.map((p11) => {
    if (is(p11, Placeholder)) {
      if (!(p11.name in values2)) {
        throw new Error(`No value for placeholder "${p11.name}" was provided`);
      }
      return values2[p11.name];
    }
    if (is(p11, Param) && is(p11.value, Placeholder)) {
      if (!(p11.value.name in values2)) {
        throw new Error(`No value for placeholder "${p11.value.name}" was provided`);
      }
      return p11.encoder.mapToDriverValue(values2[p11.value.name]);
    }
    return p11;
  });
}
function isView(view5) {
  return typeof view5 === "object" && view5 !== null && IsDrizzleView in view5;
}
function getViewName(view5) {
  return view5[ViewBaseConfig].name;
}
var _a21, FakePrimitiveParam, _a22, StringChunk, _a23, _SQL, SQL, _a24, Name, noopDecoder, noopEncoder, noopMapper, _a25, Param, _a26, Placeholder, IsDrizzleView, _a27, _b12, _c2, View;
var init_sql = __esm({
  "../drizzle-orm/dist/sql/sql.js"() {
    "use strict";
    init_entity();
    init_enum();
    init_subquery();
    init_tracing();
    init_view_common();
    init_column();
    init_table();
    _a21 = entityKind;
    FakePrimitiveParam = class {
    };
    __publicField(FakePrimitiveParam, _a21, "FakePrimitiveParam");
    _a22 = entityKind;
    StringChunk = class {
      constructor(value) {
        __publicField(this, "value");
        this.value = Array.isArray(value) ? value : [value];
      }
      getSQL() {
        return new SQL([this]);
      }
    };
    __publicField(StringChunk, _a22, "StringChunk");
    _a23 = entityKind;
    _SQL = class _SQL {
      constructor(queryChunks) {
        /** @internal */
        __publicField(this, "decoder", noopDecoder);
        __publicField(this, "shouldInlineParams", false);
        /** @internal */
        __publicField(this, "usedTables", []);
        this.queryChunks = queryChunks;
        for (const chunk of queryChunks) {
          if (is(chunk, Table)) {
            const schemaName = chunk[Table.Symbol.Schema];
            this.usedTables.push(
              schemaName === void 0 ? chunk[Table.Symbol.Name] : schemaName + "." + chunk[Table.Symbol.Name]
            );
          }
        }
      }
      append(query) {
        this.queryChunks.push(...query.queryChunks);
        return this;
      }
      toQuery(config) {
        return tracer.startActiveSpan("drizzle.buildSQL", (span) => {
          const query = this.buildQueryFromSourceParams(this.queryChunks, config);
          span?.setAttributes({
            "drizzle.query.text": query.sql,
            "drizzle.query.params": JSON.stringify(query.params)
          });
          return query;
        });
      }
      buildQueryFromSourceParams(chunks, _config) {
        const config = Object.assign({}, _config, {
          inlineParams: _config.inlineParams || this.shouldInlineParams,
          paramStartIndex: _config.paramStartIndex || { value: 0 }
        });
        const {
          casing: casing2,
          escapeName,
          escapeParam,
          prepareTyping,
          inlineParams,
          paramStartIndex
        } = config;
        return mergeQueries(chunks.map((chunk) => {
          if (is(chunk, StringChunk)) {
            return { sql: chunk.value.join(""), params: [] };
          }
          if (is(chunk, Name)) {
            return { sql: escapeName(chunk.value), params: [] };
          }
          if (chunk === void 0) {
            return { sql: "", params: [] };
          }
          if (Array.isArray(chunk)) {
            const result = [new StringChunk("(")];
            for (const [i8, p11] of chunk.entries()) {
              result.push(p11);
              if (i8 < chunk.length - 1) {
                result.push(new StringChunk(", "));
              }
            }
            result.push(new StringChunk(")"));
            return this.buildQueryFromSourceParams(result, config);
          }
          if (is(chunk, _SQL)) {
            return this.buildQueryFromSourceParams(chunk.queryChunks, {
              ...config,
              inlineParams: inlineParams || chunk.shouldInlineParams
            });
          }
          if (is(chunk, Table)) {
            const schemaName = chunk[Table.Symbol.Schema];
            const tableName = chunk[Table.Symbol.Name];
            return {
              sql: schemaName === void 0 || chunk[IsAlias] ? escapeName(tableName) : escapeName(schemaName) + "." + escapeName(tableName),
              params: []
            };
          }
          if (is(chunk, Column)) {
            const columnName = casing2.getColumnCasing(chunk);
            if (_config.invokeSource === "indexes") {
              return { sql: escapeName(columnName), params: [] };
            }
            const schemaName = chunk.table[Table.Symbol.Schema];
            return {
              sql: chunk.table[IsAlias] || schemaName === void 0 ? escapeName(chunk.table[Table.Symbol.Name]) + "." + escapeName(columnName) : escapeName(schemaName) + "." + escapeName(chunk.table[Table.Symbol.Name]) + "." + escapeName(columnName),
              params: []
            };
          }
          if (is(chunk, View)) {
            const schemaName = chunk[ViewBaseConfig].schema;
            const viewName = chunk[ViewBaseConfig].name;
            return {
              sql: schemaName === void 0 || chunk[ViewBaseConfig].isAlias ? escapeName(viewName) : escapeName(schemaName) + "." + escapeName(viewName),
              params: []
            };
          }
          if (is(chunk, Param)) {
            if (is(chunk.value, Placeholder)) {
              return { sql: escapeParam(paramStartIndex.value++, chunk), params: [chunk], typings: ["none"] };
            }
            const mappedValue = chunk.value === null ? null : chunk.encoder.mapToDriverValue(chunk.value);
            if (is(mappedValue, _SQL)) {
              return this.buildQueryFromSourceParams([mappedValue], config);
            }
            if (inlineParams) {
              return { sql: this.mapInlineParam(mappedValue, config), params: [] };
            }
            let typings = ["none"];
            if (prepareTyping) {
              typings = [prepareTyping(chunk.encoder)];
            }
            return { sql: escapeParam(paramStartIndex.value++, mappedValue), params: [mappedValue], typings };
          }
          if (is(chunk, Placeholder)) {
            return { sql: escapeParam(paramStartIndex.value++, chunk), params: [chunk], typings: ["none"] };
          }
          if (is(chunk, _SQL.Aliased) && chunk.fieldAlias !== void 0) {
            return { sql: escapeName(chunk.fieldAlias), params: [] };
          }
          if (is(chunk, Subquery)) {
            if (chunk._.isWith) {
              return { sql: escapeName(chunk._.alias), params: [] };
            }
            return this.buildQueryFromSourceParams([
              new StringChunk("("),
              chunk._.sql,
              new StringChunk(") "),
              new Name(chunk._.alias)
            ], config);
          }
          if (isPgEnum(chunk)) {
            if (chunk.schema) {
              return { sql: escapeName(chunk.schema) + "." + escapeName(chunk.enumName), params: [] };
            }
            return { sql: escapeName(chunk.enumName), params: [] };
          }
          if (isSQLWrapper(chunk)) {
            if (chunk.shouldOmitSQLParens?.()) {
              return this.buildQueryFromSourceParams([chunk.getSQL()], config);
            }
            return this.buildQueryFromSourceParams([
              new StringChunk("("),
              chunk.getSQL(),
              new StringChunk(")")
            ], config);
          }
          if (inlineParams) {
            return { sql: this.mapInlineParam(chunk, config), params: [] };
          }
          return { sql: escapeParam(paramStartIndex.value++, chunk), params: [chunk], typings: ["none"] };
        }));
      }
      mapInlineParam(chunk, { escapeString }) {
        if (chunk === null) {
          return "null";
        }
        if (typeof chunk === "number" || typeof chunk === "boolean") {
          return chunk.toString();
        }
        if (typeof chunk === "string") {
          return escapeString(chunk);
        }
        if (typeof chunk === "object") {
          const mappedValueAsString = chunk.toString();
          if (mappedValueAsString === "[object Object]") {
            return escapeString(JSON.stringify(chunk));
          }
          return escapeString(mappedValueAsString);
        }
        throw new Error("Unexpected param value: " + chunk);
      }
      getSQL() {
        return this;
      }
      as(alias2) {
        if (alias2 === void 0) {
          return this;
        }
        return new _SQL.Aliased(this, alias2);
      }
      mapWith(decoder2) {
        this.decoder = typeof decoder2 === "function" ? { mapFromDriverValue: decoder2 } : decoder2;
        return this;
      }
      inlineParams() {
        this.shouldInlineParams = true;
        return this;
      }
      /**
       * This method is used to conditionally include a part of the query.
       *
       * @param condition - Condition to check
       * @returns itself if the condition is `true`, otherwise `undefined`
       */
      if(condition) {
        return condition ? this : void 0;
      }
    };
    __publicField(_SQL, _a23, "SQL");
    SQL = _SQL;
    _a24 = entityKind;
    Name = class {
      constructor(value) {
        __publicField(this, "brand");
        this.value = value;
      }
      getSQL() {
        return new SQL([this]);
      }
    };
    __publicField(Name, _a24, "Name");
    noopDecoder = {
      mapFromDriverValue: (value) => value
    };
    noopEncoder = {
      mapToDriverValue: (value) => value
    };
    noopMapper = {
      ...noopDecoder,
      ...noopEncoder
    };
    _a25 = entityKind;
    Param = class {
      /**
       * @param value - Parameter value
       * @param encoder - Encoder to convert the value to a driver parameter
       */
      constructor(value, encoder = noopEncoder) {
        __publicField(this, "brand");
        this.value = value;
        this.encoder = encoder;
      }
      getSQL() {
        return new SQL([this]);
      }
    };
    __publicField(Param, _a25, "Param");
    ((sql22) => {
      function empty() {
        return new SQL([]);
      }
      sql22.empty = empty;
      function fromList(list) {
        return new SQL(list);
      }
      sql22.fromList = fromList;
      function raw2(str) {
        return new SQL([new StringChunk(str)]);
      }
      sql22.raw = raw2;
      function join7(chunks, separator) {
        const result = [];
        for (const [i8, chunk] of chunks.entries()) {
          if (i8 > 0 && separator !== void 0) {
            result.push(separator);
          }
          result.push(chunk);
        }
        return new SQL(result);
      }
      sql22.join = join7;
      function identifier(value) {
        return new Name(value);
      }
      sql22.identifier = identifier;
      function placeholder2(name22) {
        return new Placeholder(name22);
      }
      sql22.placeholder = placeholder2;
      function param2(value, encoder) {
        return new Param(value, encoder);
      }
      sql22.param = param2;
    })(sql || (sql = {}));
    ((SQL2) => {
      var _a506;
      _a506 = entityKind;
      const _Aliased = class _Aliased {
        constructor(sql22, fieldAlias) {
          /** @internal */
          __publicField(this, "isSelectionField", false);
          this.sql = sql22;
          this.fieldAlias = fieldAlias;
        }
        getSQL() {
          return this.sql;
        }
        /** @internal */
        clone() {
          return new _Aliased(this.sql, this.fieldAlias);
        }
      };
      __publicField(_Aliased, _a506, "SQL.Aliased");
      let Aliased = _Aliased;
      SQL2.Aliased = Aliased;
    })(SQL || (SQL = {}));
    _a26 = entityKind;
    Placeholder = class {
      constructor(name22) {
        this.name = name22;
      }
      getSQL() {
        return new SQL([this]);
      }
    };
    __publicField(Placeholder, _a26, "Placeholder");
    IsDrizzleView = Symbol.for("drizzle:IsDrizzleView");
    _c2 = entityKind, _b12 = ViewBaseConfig, _a27 = IsDrizzleView;
    View = class {
      constructor({ name: name22, schema: schema6, selectedFields, query }) {
        /** @internal */
        __publicField(this, _b12);
        /** @internal */
        __publicField(this, _a27, true);
        this[ViewBaseConfig] = {
          name: name22,
          originalName: name22,
          schema: schema6,
          selectedFields,
          query,
          isExisting: !query,
          isAlias: false
        };
      }
      getSQL() {
        return new SQL([this]);
      }
    };
    __publicField(View, _c2, "View");
    Column.prototype.getSQL = function() {
      return new SQL([this]);
    };
    Table.prototype.getSQL = function() {
      return new SQL([this]);
    };
    Subquery.prototype.getSQL = function() {
      return new SQL([this]);
    };
  }
});

// ../drizzle-orm/dist/alias.js
function aliasedTable(table6, tableAlias) {
  return new Proxy(table6, new TableAliasProxyHandler(tableAlias, false));
}
function aliasedRelation(relation, tableAlias) {
  return new Proxy(relation, new RelationTableAliasProxyHandler(tableAlias));
}
function aliasedTableColumn(column6, tableAlias) {
  return new Proxy(
    column6,
    new ColumnAliasProxyHandler(new Proxy(column6.table, new TableAliasProxyHandler(tableAlias, false)))
  );
}
function mapColumnsInAliasedSQLToAlias(query, alias2) {
  return new SQL.Aliased(mapColumnsInSQLToAlias(query.sql, alias2), query.fieldAlias);
}
function mapColumnsInSQLToAlias(query, alias2) {
  return sql.join(query.queryChunks.map((c6) => {
    if (is(c6, Column)) {
      return aliasedTableColumn(c6, alias2);
    }
    if (is(c6, SQL)) {
      return mapColumnsInSQLToAlias(c6, alias2);
    }
    if (is(c6, SQL.Aliased)) {
      return mapColumnsInAliasedSQLToAlias(c6, alias2);
    }
    return c6;
  }));
}
var _a28, ColumnAliasProxyHandler, _a29, TableAliasProxyHandler, _a30, RelationTableAliasProxyHandler;
var init_alias = __esm({
  "../drizzle-orm/dist/alias.js"() {
    "use strict";
    init_column();
    init_entity();
    init_sql();
    init_table();
    init_view_common();
    _a28 = entityKind;
    ColumnAliasProxyHandler = class {
      constructor(table6) {
        this.table = table6;
      }
      get(columnObj, prop) {
        if (prop === "table") {
          return this.table;
        }
        return columnObj[prop];
      }
    };
    __publicField(ColumnAliasProxyHandler, _a28, "ColumnAliasProxyHandler");
    _a29 = entityKind;
    TableAliasProxyHandler = class {
      constructor(alias2, replaceOriginalName) {
        this.alias = alias2;
        this.replaceOriginalName = replaceOriginalName;
      }
      get(target, prop) {
        if (prop === Table.Symbol.IsAlias) {
          return true;
        }
        if (prop === Table.Symbol.Name) {
          return this.alias;
        }
        if (this.replaceOriginalName && prop === Table.Symbol.OriginalName) {
          return this.alias;
        }
        if (prop === ViewBaseConfig) {
          return {
            ...target[ViewBaseConfig],
            name: this.alias,
            isAlias: true
          };
        }
        if (prop === Table.Symbol.Columns) {
          const columns = target[Table.Symbol.Columns];
          if (!columns) {
            return columns;
          }
          const proxiedColumns = {};
          Object.keys(columns).map((key) => {
            proxiedColumns[key] = new Proxy(
              columns[key],
              new ColumnAliasProxyHandler(new Proxy(target, this))
            );
          });
          return proxiedColumns;
        }
        const value = target[prop];
        if (is(value, Column)) {
          return new Proxy(value, new ColumnAliasProxyHandler(new Proxy(target, this)));
        }
        return value;
      }
    };
    __publicField(TableAliasProxyHandler, _a29, "TableAliasProxyHandler");
    _a30 = entityKind;
    RelationTableAliasProxyHandler = class {
      constructor(alias2) {
        this.alias = alias2;
      }
      get(target, prop) {
        if (prop === "sourceTable") {
          return aliasedTable(target.sourceTable, this.alias);
        }
        return target[prop];
      }
    };
    __publicField(RelationTableAliasProxyHandler, _a30, "RelationTableAliasProxyHandler");
  }
});

// ../drizzle-orm/dist/errors.js
var _a31, _b13, DrizzleError, DrizzleQueryError, _a32, _b14, TransactionRollbackError;
var init_errors = __esm({
  "../drizzle-orm/dist/errors.js"() {
    "use strict";
    init_entity();
    DrizzleError = class extends (_b13 = Error, _a31 = entityKind, _b13) {
      constructor({ message, cause }) {
        super(message);
        this.name = "DrizzleError";
        this.cause = cause;
      }
    };
    __publicField(DrizzleError, _a31, "DrizzleError");
    DrizzleQueryError = class _DrizzleQueryError extends Error {
      constructor(query, params, cause) {
        super(`Failed query: ${query}
params: ${params}`);
        this.query = query;
        this.params = params;
        this.cause = cause;
        Error.captureStackTrace(this, _DrizzleQueryError);
        if (cause) this.cause = cause;
      }
    };
    TransactionRollbackError = class extends (_b14 = DrizzleError, _a32 = entityKind, _b14) {
      constructor() {
        super({ message: "Rollback" });
      }
    };
    __publicField(TransactionRollbackError, _a32, "TransactionRollbackError");
  }
});

// ../drizzle-orm/dist/logger.js
var _a33, ConsoleLogWriter, _a34, DefaultLogger, _a35, NoopLogger;
var init_logger = __esm({
  "../drizzle-orm/dist/logger.js"() {
    "use strict";
    init_entity();
    _a33 = entityKind;
    ConsoleLogWriter = class {
      write(message) {
        console.log(message);
      }
    };
    __publicField(ConsoleLogWriter, _a33, "ConsoleLogWriter");
    _a34 = entityKind;
    DefaultLogger = class {
      constructor(config) {
        __publicField(this, "writer");
        this.writer = config?.writer ?? new ConsoleLogWriter();
      }
      logQuery(query, params) {
        const stringifiedParams = params.map((p11) => {
          try {
            return JSON.stringify(p11);
          } catch {
            return String(p11);
          }
        });
        const paramsStr = stringifiedParams.length ? ` -- params: [${stringifiedParams.join(", ")}]` : "";
        this.writer.write(`Query: ${query}${paramsStr}`);
      }
    };
    __publicField(DefaultLogger, _a34, "DefaultLogger");
    _a35 = entityKind;
    NoopLogger = class {
      logQuery() {
      }
    };
    __publicField(NoopLogger, _a35, "NoopLogger");
  }
});

// ../drizzle-orm/dist/operations.js
var init_operations = __esm({
  "../drizzle-orm/dist/operations.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/query-promise.js
var _a36, _b15, QueryPromise;
var init_query_promise = __esm({
  "../drizzle-orm/dist/query-promise.js"() {
    "use strict";
    init_entity();
    _b15 = entityKind, _a36 = Symbol.toStringTag;
    QueryPromise = class {
      constructor() {
        __publicField(this, _a36, "QueryPromise");
      }
      catch(onRejected) {
        return this.then(void 0, onRejected);
      }
      finally(onFinally) {
        return this.then(
          (value) => {
            onFinally?.();
            return value;
          },
          (reason) => {
            onFinally?.();
            throw reason;
          }
        );
      }
      then(onFulfilled, onRejected) {
        return this.execute().then(onFulfilled, onRejected);
      }
    };
    __publicField(QueryPromise, _b15, "QueryPromise");
  }
});

// ../drizzle-orm/dist/utils.js
function mapResultRow(columns, row, joinsNotNullableMap) {
  const nullifyMap = {};
  const result = columns.reduce(
    (result2, { path: path3, field }, columnIndex) => {
      let decoder2;
      if (is(field, Column)) {
        decoder2 = field;
      } else if (is(field, SQL)) {
        decoder2 = field.decoder;
      } else {
        decoder2 = field.sql.decoder;
      }
      let node = result2;
      for (const [pathChunkIndex, pathChunk] of path3.entries()) {
        if (pathChunkIndex < path3.length - 1) {
          if (!(pathChunk in node)) {
            node[pathChunk] = {};
          }
          node = node[pathChunk];
        } else {
          const rawValue = row[columnIndex];
          const value = node[pathChunk] = rawValue === null ? null : decoder2.mapFromDriverValue(rawValue);
          if (joinsNotNullableMap && is(field, Column) && path3.length === 2) {
            const objectName = path3[0];
            if (!(objectName in nullifyMap)) {
              nullifyMap[objectName] = value === null ? getTableName(field.table) : false;
            } else if (typeof nullifyMap[objectName] === "string" && nullifyMap[objectName] !== getTableName(field.table)) {
              nullifyMap[objectName] = false;
            }
          }
        }
      }
      return result2;
    },
    {}
  );
  if (joinsNotNullableMap && Object.keys(nullifyMap).length > 0) {
    for (const [objectName, tableName] of Object.entries(nullifyMap)) {
      if (typeof tableName === "string" && !joinsNotNullableMap[tableName]) {
        result[objectName] = null;
      }
    }
  }
  return result;
}
function orderSelectedFields(fields, pathPrefix) {
  return Object.entries(fields).reduce((result, [name3, field]) => {
    if (typeof name3 !== "string") {
      return result;
    }
    const newPath = pathPrefix ? [...pathPrefix, name3] : [name3];
    if (is(field, Column) || is(field, SQL) || is(field, SQL.Aliased)) {
      result.push({ path: newPath, field });
    } else if (is(field, Table)) {
      result.push(...orderSelectedFields(field[Table.Symbol.Columns], newPath));
    } else {
      result.push(...orderSelectedFields(field, newPath));
    }
    return result;
  }, []);
}
function haveSameKeys(left, right) {
  const leftKeys = Object.keys(left);
  const rightKeys = Object.keys(right);
  if (leftKeys.length !== rightKeys.length) {
    return false;
  }
  for (const [index7, key] of leftKeys.entries()) {
    if (key !== rightKeys[index7]) {
      return false;
    }
  }
  return true;
}
function mapUpdateSet(table6, values2) {
  const entries = Object.entries(values2).filter(([, value]) => value !== void 0).map(([key, value]) => {
    if (is(value, SQL) || is(value, Column)) {
      return [key, value];
    } else {
      return [key, new Param(value, table6[Table.Symbol.Columns][key])];
    }
  });
  if (entries.length === 0) {
    throw new Error("No values to set");
  }
  return Object.fromEntries(entries);
}
function applyMixins(baseClass, extendedClasses) {
  for (const extendedClass of extendedClasses) {
    for (const name3 of Object.getOwnPropertyNames(extendedClass.prototype)) {
      if (name3 === "constructor") continue;
      Object.defineProperty(
        baseClass.prototype,
        name3,
        Object.getOwnPropertyDescriptor(extendedClass.prototype, name3) || /* @__PURE__ */ Object.create(null)
      );
    }
  }
}
function getTableColumns(table6) {
  return table6[Table.Symbol.Columns];
}
function getViewSelectedFields(view5) {
  return view5[ViewBaseConfig].selectedFields;
}
function getTableLikeName(table6) {
  return is(table6, Subquery) ? table6._.alias : is(table6, View) ? table6[ViewBaseConfig].name : is(table6, SQL) ? void 0 : table6[Table.Symbol.IsAlias] ? table6[Table.Symbol.Name] : table6[Table.Symbol.BaseName];
}
function getColumnNameAndConfig(a9, b9) {
  return {
    name: typeof a9 === "string" && a9.length > 0 ? a9 : "",
    config: typeof a9 === "object" ? a9 : b9
  };
}
function isConfig(data) {
  if (typeof data !== "object" || data === null) return false;
  if (data.constructor.name !== "Object") return false;
  if ("logger" in data) {
    const type = typeof data["logger"];
    if (type !== "boolean" && (type !== "object" || typeof data["logger"]["logQuery"] !== "function") && type !== "undefined") return false;
    return true;
  }
  if ("schema" in data) {
    const type = typeof data["schema"];
    if (type !== "object" && type !== "undefined") return false;
    return true;
  }
  if ("casing" in data) {
    const type = typeof data["casing"];
    if (type !== "string" && type !== "undefined") return false;
    return true;
  }
  if ("mode" in data) {
    if (data["mode"] !== "default" || data["mode"] !== "planetscale" || data["mode"] !== void 0) return false;
    return true;
  }
  if ("connection" in data) {
    const type = typeof data["connection"];
    if (type !== "string" && type !== "object" && type !== "undefined") return false;
    return true;
  }
  if ("client" in data) {
    const type = typeof data["client"];
    if (type !== "object" && type !== "function" && type !== "undefined") return false;
    return true;
  }
  if (Object.keys(data).length === 0) return true;
  return false;
}
var textDecoder;
var init_utils = __esm({
  "../drizzle-orm/dist/utils.js"() {
    "use strict";
    init_column();
    init_entity();
    init_sql();
    init_subquery();
    init_table();
    init_view_common();
    textDecoder = typeof TextDecoder === "undefined" ? null : new TextDecoder();
  }
});

// ../drizzle-orm/dist/pg-core/columns/int.common.js
var _a37, _b16, PgIntColumnBaseBuilder;
var init_int_common = __esm({
  "../drizzle-orm/dist/pg-core/columns/int.common.js"() {
    "use strict";
    init_entity();
    init_common();
    PgIntColumnBaseBuilder = class extends (_b16 = PgColumnBuilder, _a37 = entityKind, _b16) {
      generatedAlwaysAsIdentity(sequence) {
        if (sequence) {
          const { name: name3, ...options } = sequence;
          this.config.generatedIdentity = {
            type: "always",
            sequenceName: name3,
            sequenceOptions: options
          };
        } else {
          this.config.generatedIdentity = {
            type: "always"
          };
        }
        this.config.hasDefault = true;
        this.config.notNull = true;
        return this;
      }
      generatedByDefaultAsIdentity(sequence) {
        if (sequence) {
          const { name: name3, ...options } = sequence;
          this.config.generatedIdentity = {
            type: "byDefault",
            sequenceName: name3,
            sequenceOptions: options
          };
        } else {
          this.config.generatedIdentity = {
            type: "byDefault"
          };
        }
        this.config.hasDefault = true;
        this.config.notNull = true;
        return this;
      }
    };
    __publicField(PgIntColumnBaseBuilder, _a37, "PgIntColumnBaseBuilder");
  }
});

// ../drizzle-orm/dist/pg-core/columns/bigint.js
function bigint(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config.mode === "number") {
    return new PgBigInt53Builder(name3);
  }
  return new PgBigInt64Builder(name3);
}
var _a38, _b17, PgBigInt53Builder, _a39, _b18, PgBigInt53, _a40, _b19, PgBigInt64Builder, _a41, _b20, PgBigInt64;
var init_bigint = __esm({
  "../drizzle-orm/dist/pg-core/columns/bigint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    init_int_common();
    PgBigInt53Builder = class extends (_b17 = PgIntColumnBaseBuilder, _a38 = entityKind, _b17) {
      constructor(name3) {
        super(name3, "number", "PgBigInt53");
      }
      /** @internal */
      build(table6) {
        return new PgBigInt53(table6, this.config);
      }
    };
    __publicField(PgBigInt53Builder, _a38, "PgBigInt53Builder");
    PgBigInt53 = class extends (_b18 = PgColumn, _a39 = entityKind, _b18) {
      getSQLType() {
        return "bigint";
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") {
          return value;
        }
        return Number(value);
      }
    };
    __publicField(PgBigInt53, _a39, "PgBigInt53");
    PgBigInt64Builder = class extends (_b19 = PgIntColumnBaseBuilder, _a40 = entityKind, _b19) {
      constructor(name3) {
        super(name3, "bigint", "PgBigInt64");
      }
      /** @internal */
      build(table6) {
        return new PgBigInt64(
          table6,
          this.config
        );
      }
    };
    __publicField(PgBigInt64Builder, _a40, "PgBigInt64Builder");
    PgBigInt64 = class extends (_b20 = PgColumn, _a41 = entityKind, _b20) {
      getSQLType() {
        return "bigint";
      }
      // eslint-disable-next-line unicorn/prefer-native-coercion-functions
      mapFromDriverValue(value) {
        return BigInt(value);
      }
    };
    __publicField(PgBigInt64, _a41, "PgBigInt64");
  }
});

// ../drizzle-orm/dist/pg-core/columns/bigserial.js
function bigserial(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config.mode === "number") {
    return new PgBigSerial53Builder(name3);
  }
  return new PgBigSerial64Builder(name3);
}
var _a42, _b21, PgBigSerial53Builder, _a43, _b22, PgBigSerial53, _a44, _b23, PgBigSerial64Builder, _a45, _b24, PgBigSerial64;
var init_bigserial = __esm({
  "../drizzle-orm/dist/pg-core/columns/bigserial.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgBigSerial53Builder = class extends (_b21 = PgColumnBuilder, _a42 = entityKind, _b21) {
      constructor(name3) {
        super(name3, "number", "PgBigSerial53");
        this.config.hasDefault = true;
        this.config.notNull = true;
      }
      /** @internal */
      build(table6) {
        return new PgBigSerial53(
          table6,
          this.config
        );
      }
    };
    __publicField(PgBigSerial53Builder, _a42, "PgBigSerial53Builder");
    PgBigSerial53 = class extends (_b22 = PgColumn, _a43 = entityKind, _b22) {
      getSQLType() {
        return "bigserial";
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") {
          return value;
        }
        return Number(value);
      }
    };
    __publicField(PgBigSerial53, _a43, "PgBigSerial53");
    PgBigSerial64Builder = class extends (_b23 = PgColumnBuilder, _a44 = entityKind, _b23) {
      constructor(name3) {
        super(name3, "bigint", "PgBigSerial64");
        this.config.hasDefault = true;
      }
      /** @internal */
      build(table6) {
        return new PgBigSerial64(
          table6,
          this.config
        );
      }
    };
    __publicField(PgBigSerial64Builder, _a44, "PgBigSerial64Builder");
    PgBigSerial64 = class extends (_b24 = PgColumn, _a45 = entityKind, _b24) {
      getSQLType() {
        return "bigserial";
      }
      // eslint-disable-next-line unicorn/prefer-native-coercion-functions
      mapFromDriverValue(value) {
        return BigInt(value);
      }
    };
    __publicField(PgBigSerial64, _a45, "PgBigSerial64");
  }
});

// ../drizzle-orm/dist/pg-core/columns/boolean.js
function boolean(name3) {
  return new PgBooleanBuilder(name3 ?? "");
}
var _a46, _b25, PgBooleanBuilder, _a47, _b26, PgBoolean;
var init_boolean = __esm({
  "../drizzle-orm/dist/pg-core/columns/boolean.js"() {
    "use strict";
    init_entity();
    init_common();
    PgBooleanBuilder = class extends (_b25 = PgColumnBuilder, _a46 = entityKind, _b25) {
      constructor(name3) {
        super(name3, "boolean", "PgBoolean");
      }
      /** @internal */
      build(table6) {
        return new PgBoolean(table6, this.config);
      }
    };
    __publicField(PgBooleanBuilder, _a46, "PgBooleanBuilder");
    PgBoolean = class extends (_b26 = PgColumn, _a47 = entityKind, _b26) {
      getSQLType() {
        return "boolean";
      }
    };
    __publicField(PgBoolean, _a47, "PgBoolean");
  }
});

// ../drizzle-orm/dist/pg-core/columns/char.js
function char(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgCharBuilder(name3, config);
}
var _a48, _b27, PgCharBuilder, _a49, _b28, PgChar;
var init_char = __esm({
  "../drizzle-orm/dist/pg-core/columns/char.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgCharBuilder = class extends (_b27 = PgColumnBuilder, _a48 = entityKind, _b27) {
      constructor(name3, config) {
        super(name3, "string", "PgChar");
        this.config.length = config.length;
        this.config.enumValues = config.enum;
      }
      /** @internal */
      build(table6) {
        return new PgChar(
          table6,
          this.config
        );
      }
    };
    __publicField(PgCharBuilder, _a48, "PgCharBuilder");
    PgChar = class extends (_b28 = PgColumn, _a49 = entityKind, _b28) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return this.length === void 0 ? `char` : `char(${this.length})`;
      }
    };
    __publicField(PgChar, _a49, "PgChar");
  }
});

// ../drizzle-orm/dist/pg-core/columns/cidr.js
function cidr(name3) {
  return new PgCidrBuilder(name3 ?? "");
}
var _a50, _b29, PgCidrBuilder, _a51, _b30, PgCidr;
var init_cidr = __esm({
  "../drizzle-orm/dist/pg-core/columns/cidr.js"() {
    "use strict";
    init_entity();
    init_common();
    PgCidrBuilder = class extends (_b29 = PgColumnBuilder, _a50 = entityKind, _b29) {
      constructor(name3) {
        super(name3, "string", "PgCidr");
      }
      /** @internal */
      build(table6) {
        return new PgCidr(table6, this.config);
      }
    };
    __publicField(PgCidrBuilder, _a50, "PgCidrBuilder");
    PgCidr = class extends (_b30 = PgColumn, _a51 = entityKind, _b30) {
      getSQLType() {
        return "cidr";
      }
    };
    __publicField(PgCidr, _a51, "PgCidr");
  }
});

// ../drizzle-orm/dist/pg-core/columns/custom.js
function customType(customTypeParams) {
  return (a9, b9) => {
    const { name: name3, config } = getColumnNameAndConfig(a9, b9);
    return new PgCustomColumnBuilder(name3, config, customTypeParams);
  };
}
var _a52, _b31, PgCustomColumnBuilder, _a53, _b32, PgCustomColumn;
var init_custom = __esm({
  "../drizzle-orm/dist/pg-core/columns/custom.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgCustomColumnBuilder = class extends (_b31 = PgColumnBuilder, _a52 = entityKind, _b31) {
      constructor(name3, fieldConfig, customTypeParams) {
        super(name3, "custom", "PgCustomColumn");
        this.config.fieldConfig = fieldConfig;
        this.config.customTypeParams = customTypeParams;
      }
      /** @internal */
      build(table6) {
        return new PgCustomColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(PgCustomColumnBuilder, _a52, "PgCustomColumnBuilder");
    PgCustomColumn = class extends (_b32 = PgColumn, _a53 = entityKind, _b32) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "sqlName");
        __publicField(this, "mapTo");
        __publicField(this, "mapFrom");
        this.sqlName = config.customTypeParams.dataType(config.fieldConfig);
        this.mapTo = config.customTypeParams.toDriver;
        this.mapFrom = config.customTypeParams.fromDriver;
      }
      getSQLType() {
        return this.sqlName;
      }
      mapFromDriverValue(value) {
        return typeof this.mapFrom === "function" ? this.mapFrom(value) : value;
      }
      mapToDriverValue(value) {
        return typeof this.mapTo === "function" ? this.mapTo(value) : value;
      }
    };
    __publicField(PgCustomColumn, _a53, "PgCustomColumn");
  }
});

// ../drizzle-orm/dist/pg-core/columns/date.common.js
var _a54, _b33, PgDateColumnBaseBuilder;
var init_date_common = __esm({
  "../drizzle-orm/dist/pg-core/columns/date.common.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_common();
    PgDateColumnBaseBuilder = class extends (_b33 = PgColumnBuilder, _a54 = entityKind, _b33) {
      defaultNow() {
        return this.default(sql`now()`);
      }
    };
    __publicField(PgDateColumnBaseBuilder, _a54, "PgDateColumnBaseBuilder");
  }
});

// ../drizzle-orm/dist/pg-core/columns/date.js
function date(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "date") {
    return new PgDateBuilder(name3);
  }
  return new PgDateStringBuilder(name3);
}
var _a55, _b34, PgDateBuilder, _a56, _b35, PgDate, _a57, _b36, PgDateStringBuilder, _a58, _b37, PgDateString;
var init_date = __esm({
  "../drizzle-orm/dist/pg-core/columns/date.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    init_date_common();
    PgDateBuilder = class extends (_b34 = PgDateColumnBaseBuilder, _a55 = entityKind, _b34) {
      constructor(name3) {
        super(name3, "date", "PgDate");
      }
      /** @internal */
      build(table6) {
        return new PgDate(table6, this.config);
      }
    };
    __publicField(PgDateBuilder, _a55, "PgDateBuilder");
    PgDate = class extends (_b35 = PgColumn, _a56 = entityKind, _b35) {
      getSQLType() {
        return "date";
      }
      mapFromDriverValue(value) {
        return new Date(value);
      }
      mapToDriverValue(value) {
        return value.toISOString();
      }
    };
    __publicField(PgDate, _a56, "PgDate");
    PgDateStringBuilder = class extends (_b36 = PgDateColumnBaseBuilder, _a57 = entityKind, _b36) {
      constructor(name3) {
        super(name3, "string", "PgDateString");
      }
      /** @internal */
      build(table6) {
        return new PgDateString(
          table6,
          this.config
        );
      }
    };
    __publicField(PgDateStringBuilder, _a57, "PgDateStringBuilder");
    PgDateString = class extends (_b37 = PgColumn, _a58 = entityKind, _b37) {
      getSQLType() {
        return "date";
      }
    };
    __publicField(PgDateString, _a58, "PgDateString");
  }
});

// ../drizzle-orm/dist/pg-core/columns/double-precision.js
function doublePrecision(name3) {
  return new PgDoublePrecisionBuilder(name3 ?? "");
}
var _a59, _b38, PgDoublePrecisionBuilder, _a60, _b39, PgDoublePrecision;
var init_double_precision = __esm({
  "../drizzle-orm/dist/pg-core/columns/double-precision.js"() {
    "use strict";
    init_entity();
    init_common();
    PgDoublePrecisionBuilder = class extends (_b38 = PgColumnBuilder, _a59 = entityKind, _b38) {
      constructor(name3) {
        super(name3, "number", "PgDoublePrecision");
      }
      /** @internal */
      build(table6) {
        return new PgDoublePrecision(
          table6,
          this.config
        );
      }
    };
    __publicField(PgDoublePrecisionBuilder, _a59, "PgDoublePrecisionBuilder");
    PgDoublePrecision = class extends (_b39 = PgColumn, _a60 = entityKind, _b39) {
      getSQLType() {
        return "double precision";
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number.parseFloat(value);
        }
        return value;
      }
    };
    __publicField(PgDoublePrecision, _a60, "PgDoublePrecision");
  }
});

// ../drizzle-orm/dist/pg-core/columns/inet.js
function inet(name3) {
  return new PgInetBuilder(name3 ?? "");
}
var _a61, _b40, PgInetBuilder, _a62, _b41, PgInet;
var init_inet = __esm({
  "../drizzle-orm/dist/pg-core/columns/inet.js"() {
    "use strict";
    init_entity();
    init_common();
    PgInetBuilder = class extends (_b40 = PgColumnBuilder, _a61 = entityKind, _b40) {
      constructor(name3) {
        super(name3, "string", "PgInet");
      }
      /** @internal */
      build(table6) {
        return new PgInet(table6, this.config);
      }
    };
    __publicField(PgInetBuilder, _a61, "PgInetBuilder");
    PgInet = class extends (_b41 = PgColumn, _a62 = entityKind, _b41) {
      getSQLType() {
        return "inet";
      }
    };
    __publicField(PgInet, _a62, "PgInet");
  }
});

// ../drizzle-orm/dist/pg-core/columns/integer.js
function integer(name3) {
  return new PgIntegerBuilder(name3 ?? "");
}
var _a63, _b42, PgIntegerBuilder, _a64, _b43, PgInteger;
var init_integer = __esm({
  "../drizzle-orm/dist/pg-core/columns/integer.js"() {
    "use strict";
    init_entity();
    init_common();
    init_int_common();
    PgIntegerBuilder = class extends (_b42 = PgIntColumnBaseBuilder, _a63 = entityKind, _b42) {
      constructor(name3) {
        super(name3, "number", "PgInteger");
      }
      /** @internal */
      build(table6) {
        return new PgInteger(table6, this.config);
      }
    };
    __publicField(PgIntegerBuilder, _a63, "PgIntegerBuilder");
    PgInteger = class extends (_b43 = PgColumn, _a64 = entityKind, _b43) {
      getSQLType() {
        return "integer";
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number.parseInt(value);
        }
        return value;
      }
    };
    __publicField(PgInteger, _a64, "PgInteger");
  }
});

// ../drizzle-orm/dist/pg-core/columns/interval.js
function interval(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgIntervalBuilder(name3, config);
}
var _a65, _b44, PgIntervalBuilder, _a66, _b45, PgInterval;
var init_interval = __esm({
  "../drizzle-orm/dist/pg-core/columns/interval.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgIntervalBuilder = class extends (_b44 = PgColumnBuilder, _a65 = entityKind, _b44) {
      constructor(name3, intervalConfig) {
        super(name3, "string", "PgInterval");
        this.config.intervalConfig = intervalConfig;
      }
      /** @internal */
      build(table6) {
        return new PgInterval(table6, this.config);
      }
    };
    __publicField(PgIntervalBuilder, _a65, "PgIntervalBuilder");
    PgInterval = class extends (_b45 = PgColumn, _a66 = entityKind, _b45) {
      constructor() {
        super(...arguments);
        __publicField(this, "fields", this.config.intervalConfig.fields);
        __publicField(this, "precision", this.config.intervalConfig.precision);
      }
      getSQLType() {
        const fields = this.fields ? ` ${this.fields}` : "";
        const precision = this.precision ? `(${this.precision})` : "";
        return `interval${fields}${precision}`;
      }
    };
    __publicField(PgInterval, _a66, "PgInterval");
  }
});

// ../drizzle-orm/dist/pg-core/columns/json.js
function json(name3) {
  return new PgJsonBuilder(name3 ?? "");
}
var _a67, _b46, PgJsonBuilder, _a68, _b47, PgJson;
var init_json = __esm({
  "../drizzle-orm/dist/pg-core/columns/json.js"() {
    "use strict";
    init_entity();
    init_common();
    PgJsonBuilder = class extends (_b46 = PgColumnBuilder, _a67 = entityKind, _b46) {
      constructor(name3) {
        super(name3, "json", "PgJson");
      }
      /** @internal */
      build(table6) {
        return new PgJson(table6, this.config);
      }
    };
    __publicField(PgJsonBuilder, _a67, "PgJsonBuilder");
    PgJson = class extends (_b47 = PgColumn, _a68 = entityKind, _b47) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return "json";
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          try {
            return JSON.parse(value);
          } catch {
            return value;
          }
        }
        return value;
      }
    };
    __publicField(PgJson, _a68, "PgJson");
  }
});

// ../drizzle-orm/dist/pg-core/columns/jsonb.js
function jsonb(name3) {
  return new PgJsonbBuilder(name3 ?? "");
}
var _a69, _b48, PgJsonbBuilder, _a70, _b49, PgJsonb;
var init_jsonb = __esm({
  "../drizzle-orm/dist/pg-core/columns/jsonb.js"() {
    "use strict";
    init_entity();
    init_common();
    PgJsonbBuilder = class extends (_b48 = PgColumnBuilder, _a69 = entityKind, _b48) {
      constructor(name3) {
        super(name3, "json", "PgJsonb");
      }
      /** @internal */
      build(table6) {
        return new PgJsonb(table6, this.config);
      }
    };
    __publicField(PgJsonbBuilder, _a69, "PgJsonbBuilder");
    PgJsonb = class extends (_b49 = PgColumn, _a70 = entityKind, _b49) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return "jsonb";
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          try {
            return JSON.parse(value);
          } catch {
            return value;
          }
        }
        return value;
      }
    };
    __publicField(PgJsonb, _a70, "PgJsonb");
  }
});

// ../drizzle-orm/dist/pg-core/columns/line.js
function line(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (!config?.mode || config.mode === "tuple") {
    return new PgLineBuilder(name3);
  }
  return new PgLineABCBuilder(name3);
}
var _a71, _b50, PgLineBuilder, _a72, _b51, PgLineTuple, _a73, _b52, PgLineABCBuilder, _a74, _b53, PgLineABC;
var init_line = __esm({
  "../drizzle-orm/dist/pg-core/columns/line.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgLineBuilder = class extends (_b50 = PgColumnBuilder, _a71 = entityKind, _b50) {
      constructor(name3) {
        super(name3, "array", "PgLine");
      }
      /** @internal */
      build(table6) {
        return new PgLineTuple(
          table6,
          this.config
        );
      }
    };
    __publicField(PgLineBuilder, _a71, "PgLineBuilder");
    PgLineTuple = class extends (_b51 = PgColumn, _a72 = entityKind, _b51) {
      getSQLType() {
        return "line";
      }
      mapFromDriverValue(value) {
        const [a9, b9, c6] = value.slice(1, -1).split(",");
        return [Number.parseFloat(a9), Number.parseFloat(b9), Number.parseFloat(c6)];
      }
      mapToDriverValue(value) {
        return `{${value[0]},${value[1]},${value[2]}}`;
      }
    };
    __publicField(PgLineTuple, _a72, "PgLine");
    PgLineABCBuilder = class extends (_b52 = PgColumnBuilder, _a73 = entityKind, _b52) {
      constructor(name3) {
        super(name3, "json", "PgLineABC");
      }
      /** @internal */
      build(table6) {
        return new PgLineABC(
          table6,
          this.config
        );
      }
    };
    __publicField(PgLineABCBuilder, _a73, "PgLineABCBuilder");
    PgLineABC = class extends (_b53 = PgColumn, _a74 = entityKind, _b53) {
      getSQLType() {
        return "line";
      }
      mapFromDriverValue(value) {
        const [a9, b9, c6] = value.slice(1, -1).split(",");
        return { a: Number.parseFloat(a9), b: Number.parseFloat(b9), c: Number.parseFloat(c6) };
      }
      mapToDriverValue(value) {
        return `{${value.a},${value.b},${value.c}}`;
      }
    };
    __publicField(PgLineABC, _a74, "PgLineABC");
  }
});

// ../drizzle-orm/dist/pg-core/columns/macaddr.js
function macaddr(name3) {
  return new PgMacaddrBuilder(name3 ?? "");
}
var _a75, _b54, PgMacaddrBuilder, _a76, _b55, PgMacaddr;
var init_macaddr = __esm({
  "../drizzle-orm/dist/pg-core/columns/macaddr.js"() {
    "use strict";
    init_entity();
    init_common();
    PgMacaddrBuilder = class extends (_b54 = PgColumnBuilder, _a75 = entityKind, _b54) {
      constructor(name3) {
        super(name3, "string", "PgMacaddr");
      }
      /** @internal */
      build(table6) {
        return new PgMacaddr(table6, this.config);
      }
    };
    __publicField(PgMacaddrBuilder, _a75, "PgMacaddrBuilder");
    PgMacaddr = class extends (_b55 = PgColumn, _a76 = entityKind, _b55) {
      getSQLType() {
        return "macaddr";
      }
    };
    __publicField(PgMacaddr, _a76, "PgMacaddr");
  }
});

// ../drizzle-orm/dist/pg-core/columns/macaddr8.js
function macaddr8(name3) {
  return new PgMacaddr8Builder(name3 ?? "");
}
var _a77, _b56, PgMacaddr8Builder, _a78, _b57, PgMacaddr8;
var init_macaddr8 = __esm({
  "../drizzle-orm/dist/pg-core/columns/macaddr8.js"() {
    "use strict";
    init_entity();
    init_common();
    PgMacaddr8Builder = class extends (_b56 = PgColumnBuilder, _a77 = entityKind, _b56) {
      constructor(name3) {
        super(name3, "string", "PgMacaddr8");
      }
      /** @internal */
      build(table6) {
        return new PgMacaddr8(table6, this.config);
      }
    };
    __publicField(PgMacaddr8Builder, _a77, "PgMacaddr8Builder");
    PgMacaddr8 = class extends (_b57 = PgColumn, _a78 = entityKind, _b57) {
      getSQLType() {
        return "macaddr8";
      }
    };
    __publicField(PgMacaddr8, _a78, "PgMacaddr8");
  }
});

// ../drizzle-orm/dist/pg-core/columns/numeric.js
function numeric(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  const mode = config?.mode;
  return mode === "number" ? new PgNumericNumberBuilder(name3, config?.precision, config?.scale) : mode === "bigint" ? new PgNumericBigIntBuilder(name3, config?.precision, config?.scale) : new PgNumericBuilder(name3, config?.precision, config?.scale);
}
var _a79, _b58, PgNumericBuilder, _a80, _b59, PgNumeric, _a81, _b60, PgNumericNumberBuilder, _a82, _b61, PgNumericNumber, _a83, _b62, PgNumericBigIntBuilder, _a84, _b63, PgNumericBigInt, decimal;
var init_numeric = __esm({
  "../drizzle-orm/dist/pg-core/columns/numeric.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgNumericBuilder = class extends (_b58 = PgColumnBuilder, _a79 = entityKind, _b58) {
      constructor(name3, precision, scale) {
        super(name3, "string", "PgNumeric");
        this.config.precision = precision;
        this.config.scale = scale;
      }
      /** @internal */
      build(table6) {
        return new PgNumeric(table6, this.config);
      }
    };
    __publicField(PgNumericBuilder, _a79, "PgNumericBuilder");
    PgNumeric = class extends (_b59 = PgColumn, _a80 = entityKind, _b59) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "precision");
        __publicField(this, "scale");
        this.precision = config.precision;
        this.scale = config.scale;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        return String(value);
      }
      getSQLType() {
        if (this.precision !== void 0 && this.scale !== void 0) {
          return `numeric(${this.precision}, ${this.scale})`;
        } else if (this.precision === void 0) {
          return "numeric";
        } else {
          return `numeric(${this.precision})`;
        }
      }
    };
    __publicField(PgNumeric, _a80, "PgNumeric");
    PgNumericNumberBuilder = class extends (_b60 = PgColumnBuilder, _a81 = entityKind, _b60) {
      constructor(name3, precision, scale) {
        super(name3, "number", "PgNumericNumber");
        this.config.precision = precision;
        this.config.scale = scale;
      }
      /** @internal */
      build(table6) {
        return new PgNumericNumber(
          table6,
          this.config
        );
      }
    };
    __publicField(PgNumericNumberBuilder, _a81, "PgNumericNumberBuilder");
    PgNumericNumber = class extends (_b61 = PgColumn, _a82 = entityKind, _b61) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "precision");
        __publicField(this, "scale");
        __publicField(this, "mapToDriverValue", String);
        this.precision = config.precision;
        this.scale = config.scale;
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") return value;
        return Number(value);
      }
      getSQLType() {
        if (this.precision !== void 0 && this.scale !== void 0) {
          return `numeric(${this.precision}, ${this.scale})`;
        } else if (this.precision === void 0) {
          return "numeric";
        } else {
          return `numeric(${this.precision})`;
        }
      }
    };
    __publicField(PgNumericNumber, _a82, "PgNumericNumber");
    PgNumericBigIntBuilder = class extends (_b62 = PgColumnBuilder, _a83 = entityKind, _b62) {
      constructor(name3, precision, scale) {
        super(name3, "bigint", "PgNumericBigInt");
        this.config.precision = precision;
        this.config.scale = scale;
      }
      /** @internal */
      build(table6) {
        return new PgNumericBigInt(
          table6,
          this.config
        );
      }
    };
    __publicField(PgNumericBigIntBuilder, _a83, "PgNumericBigIntBuilder");
    PgNumericBigInt = class extends (_b63 = PgColumn, _a84 = entityKind, _b63) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "precision");
        __publicField(this, "scale");
        __publicField(this, "mapFromDriverValue", BigInt);
        __publicField(this, "mapToDriverValue", String);
        this.precision = config.precision;
        this.scale = config.scale;
      }
      getSQLType() {
        if (this.precision !== void 0 && this.scale !== void 0) {
          return `numeric(${this.precision}, ${this.scale})`;
        } else if (this.precision === void 0) {
          return "numeric";
        } else {
          return `numeric(${this.precision})`;
        }
      }
    };
    __publicField(PgNumericBigInt, _a84, "PgNumericBigInt");
    decimal = numeric;
  }
});

// ../drizzle-orm/dist/pg-core/columns/point.js
function point(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (!config?.mode || config.mode === "tuple") {
    return new PgPointTupleBuilder(name3);
  }
  return new PgPointObjectBuilder(name3);
}
var _a85, _b64, PgPointTupleBuilder, _a86, _b65, PgPointTuple, _a87, _b66, PgPointObjectBuilder, _a88, _b67, PgPointObject;
var init_point = __esm({
  "../drizzle-orm/dist/pg-core/columns/point.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgPointTupleBuilder = class extends (_b64 = PgColumnBuilder, _a85 = entityKind, _b64) {
      constructor(name3) {
        super(name3, "array", "PgPointTuple");
      }
      /** @internal */
      build(table6) {
        return new PgPointTuple(
          table6,
          this.config
        );
      }
    };
    __publicField(PgPointTupleBuilder, _a85, "PgPointTupleBuilder");
    PgPointTuple = class extends (_b65 = PgColumn, _a86 = entityKind, _b65) {
      getSQLType() {
        return "point";
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          const [x11, y7] = value.slice(1, -1).split(",");
          return [Number.parseFloat(x11), Number.parseFloat(y7)];
        }
        return [value.x, value.y];
      }
      mapToDriverValue(value) {
        return `(${value[0]},${value[1]})`;
      }
    };
    __publicField(PgPointTuple, _a86, "PgPointTuple");
    PgPointObjectBuilder = class extends (_b66 = PgColumnBuilder, _a87 = entityKind, _b66) {
      constructor(name3) {
        super(name3, "json", "PgPointObject");
      }
      /** @internal */
      build(table6) {
        return new PgPointObject(
          table6,
          this.config
        );
      }
    };
    __publicField(PgPointObjectBuilder, _a87, "PgPointObjectBuilder");
    PgPointObject = class extends (_b67 = PgColumn, _a88 = entityKind, _b67) {
      getSQLType() {
        return "point";
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          const [x11, y7] = value.slice(1, -1).split(",");
          return { x: Number.parseFloat(x11), y: Number.parseFloat(y7) };
        }
        return value;
      }
      mapToDriverValue(value) {
        return `(${value.x},${value.y})`;
      }
    };
    __publicField(PgPointObject, _a88, "PgPointObject");
  }
});

// ../drizzle-orm/dist/pg-core/columns/postgis_extension/utils.js
function hexToBytes(hex2) {
  const bytes2 = [];
  for (let c6 = 0; c6 < hex2.length; c6 += 2) {
    bytes2.push(Number.parseInt(hex2.slice(c6, c6 + 2), 16));
  }
  return new Uint8Array(bytes2);
}
function bytesToFloat64(bytes2, offset) {
  const buffer2 = new ArrayBuffer(8);
  const view5 = new DataView(buffer2);
  for (let i8 = 0; i8 < 8; i8++) {
    view5.setUint8(i8, bytes2[offset + i8]);
  }
  return view5.getFloat64(0, true);
}
function parseEWKB(hex2) {
  const bytes2 = hexToBytes(hex2);
  let offset = 0;
  const byteOrder = bytes2[offset];
  offset += 1;
  const view5 = new DataView(bytes2.buffer);
  const geomType = view5.getUint32(offset, byteOrder === 1);
  offset += 4;
  let _srid;
  if (geomType & 536870912) {
    _srid = view5.getUint32(offset, byteOrder === 1);
    offset += 4;
  }
  if ((geomType & 65535) === 1) {
    const x11 = bytesToFloat64(bytes2, offset);
    offset += 8;
    const y7 = bytesToFloat64(bytes2, offset);
    offset += 8;
    return [x11, y7];
  }
  throw new Error("Unsupported geometry type");
}
var init_utils2 = __esm({
  "../drizzle-orm/dist/pg-core/columns/postgis_extension/utils.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/pg-core/columns/postgis_extension/geometry.js
function geometry(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (!config?.mode || config.mode === "tuple") {
    return new PgGeometryBuilder(name3);
  }
  return new PgGeometryObjectBuilder(name3);
}
var _a89, _b68, PgGeometryBuilder, _a90, _b69, PgGeometry, _a91, _b70, PgGeometryObjectBuilder, _a92, _b71, PgGeometryObject;
var init_geometry = __esm({
  "../drizzle-orm/dist/pg-core/columns/postgis_extension/geometry.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    init_utils2();
    PgGeometryBuilder = class extends (_b68 = PgColumnBuilder, _a89 = entityKind, _b68) {
      constructor(name3) {
        super(name3, "array", "PgGeometry");
      }
      /** @internal */
      build(table6) {
        return new PgGeometry(
          table6,
          this.config
        );
      }
    };
    __publicField(PgGeometryBuilder, _a89, "PgGeometryBuilder");
    PgGeometry = class extends (_b69 = PgColumn, _a90 = entityKind, _b69) {
      getSQLType() {
        return "geometry(point)";
      }
      mapFromDriverValue(value) {
        return parseEWKB(value);
      }
      mapToDriverValue(value) {
        return `point(${value[0]} ${value[1]})`;
      }
    };
    __publicField(PgGeometry, _a90, "PgGeometry");
    PgGeometryObjectBuilder = class extends (_b70 = PgColumnBuilder, _a91 = entityKind, _b70) {
      constructor(name3) {
        super(name3, "json", "PgGeometryObject");
      }
      /** @internal */
      build(table6) {
        return new PgGeometryObject(
          table6,
          this.config
        );
      }
    };
    __publicField(PgGeometryObjectBuilder, _a91, "PgGeometryObjectBuilder");
    PgGeometryObject = class extends (_b71 = PgColumn, _a92 = entityKind, _b71) {
      getSQLType() {
        return "geometry(point)";
      }
      mapFromDriverValue(value) {
        const parsed = parseEWKB(value);
        return { x: parsed[0], y: parsed[1] };
      }
      mapToDriverValue(value) {
        return `point(${value.x} ${value.y})`;
      }
    };
    __publicField(PgGeometryObject, _a92, "PgGeometryObject");
  }
});

// ../drizzle-orm/dist/pg-core/columns/real.js
function real(name3) {
  return new PgRealBuilder(name3 ?? "");
}
var _a93, _b72, PgRealBuilder, _a94, _b73, PgReal;
var init_real = __esm({
  "../drizzle-orm/dist/pg-core/columns/real.js"() {
    "use strict";
    init_entity();
    init_common();
    PgRealBuilder = class extends (_b72 = PgColumnBuilder, _a93 = entityKind, _b72) {
      constructor(name3, length) {
        super(name3, "number", "PgReal");
        this.config.length = length;
      }
      /** @internal */
      build(table6) {
        return new PgReal(table6, this.config);
      }
    };
    __publicField(PgRealBuilder, _a93, "PgRealBuilder");
    PgReal = class extends (_b73 = PgColumn, _a94 = entityKind, _b73) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "mapFromDriverValue", (value) => {
          if (typeof value === "string") {
            return Number.parseFloat(value);
          }
          return value;
        });
      }
      getSQLType() {
        return "real";
      }
    };
    __publicField(PgReal, _a94, "PgReal");
  }
});

// ../drizzle-orm/dist/pg-core/columns/serial.js
function serial(name3) {
  return new PgSerialBuilder(name3 ?? "");
}
var _a95, _b74, PgSerialBuilder, _a96, _b75, PgSerial;
var init_serial = __esm({
  "../drizzle-orm/dist/pg-core/columns/serial.js"() {
    "use strict";
    init_entity();
    init_common();
    PgSerialBuilder = class extends (_b74 = PgColumnBuilder, _a95 = entityKind, _b74) {
      constructor(name3) {
        super(name3, "number", "PgSerial");
        this.config.hasDefault = true;
        this.config.notNull = true;
      }
      /** @internal */
      build(table6) {
        return new PgSerial(table6, this.config);
      }
    };
    __publicField(PgSerialBuilder, _a95, "PgSerialBuilder");
    PgSerial = class extends (_b75 = PgColumn, _a96 = entityKind, _b75) {
      getSQLType() {
        return "serial";
      }
    };
    __publicField(PgSerial, _a96, "PgSerial");
  }
});

// ../drizzle-orm/dist/pg-core/columns/smallint.js
function smallint(name3) {
  return new PgSmallIntBuilder(name3 ?? "");
}
var _a97, _b76, PgSmallIntBuilder, _a98, _b77, PgSmallInt;
var init_smallint = __esm({
  "../drizzle-orm/dist/pg-core/columns/smallint.js"() {
    "use strict";
    init_entity();
    init_common();
    init_int_common();
    PgSmallIntBuilder = class extends (_b76 = PgIntColumnBaseBuilder, _a97 = entityKind, _b76) {
      constructor(name3) {
        super(name3, "number", "PgSmallInt");
      }
      /** @internal */
      build(table6) {
        return new PgSmallInt(table6, this.config);
      }
    };
    __publicField(PgSmallIntBuilder, _a97, "PgSmallIntBuilder");
    PgSmallInt = class extends (_b77 = PgColumn, _a98 = entityKind, _b77) {
      constructor() {
        super(...arguments);
        __publicField(this, "mapFromDriverValue", (value) => {
          if (typeof value === "string") {
            return Number(value);
          }
          return value;
        });
      }
      getSQLType() {
        return "smallint";
      }
    };
    __publicField(PgSmallInt, _a98, "PgSmallInt");
  }
});

// ../drizzle-orm/dist/pg-core/columns/smallserial.js
function smallserial(name3) {
  return new PgSmallSerialBuilder(name3 ?? "");
}
var _a99, _b78, PgSmallSerialBuilder, _a100, _b79, PgSmallSerial;
var init_smallserial = __esm({
  "../drizzle-orm/dist/pg-core/columns/smallserial.js"() {
    "use strict";
    init_entity();
    init_common();
    PgSmallSerialBuilder = class extends (_b78 = PgColumnBuilder, _a99 = entityKind, _b78) {
      constructor(name3) {
        super(name3, "number", "PgSmallSerial");
        this.config.hasDefault = true;
        this.config.notNull = true;
      }
      /** @internal */
      build(table6) {
        return new PgSmallSerial(
          table6,
          this.config
        );
      }
    };
    __publicField(PgSmallSerialBuilder, _a99, "PgSmallSerialBuilder");
    PgSmallSerial = class extends (_b79 = PgColumn, _a100 = entityKind, _b79) {
      getSQLType() {
        return "smallserial";
      }
    };
    __publicField(PgSmallSerial, _a100, "PgSmallSerial");
  }
});

// ../drizzle-orm/dist/pg-core/columns/text.js
function text(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgTextBuilder(name3, config);
}
var _a101, _b80, PgTextBuilder, _a102, _b81, PgText;
var init_text = __esm({
  "../drizzle-orm/dist/pg-core/columns/text.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgTextBuilder = class extends (_b80 = PgColumnBuilder, _a101 = entityKind, _b80) {
      constructor(name3, config) {
        super(name3, "string", "PgText");
        this.config.enumValues = config.enum;
      }
      /** @internal */
      build(table6) {
        return new PgText(table6, this.config);
      }
    };
    __publicField(PgTextBuilder, _a101, "PgTextBuilder");
    PgText = class extends (_b81 = PgColumn, _a102 = entityKind, _b81) {
      constructor() {
        super(...arguments);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return "text";
      }
    };
    __publicField(PgText, _a102, "PgText");
  }
});

// ../drizzle-orm/dist/pg-core/columns/time.js
function time(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgTimeBuilder(name3, config.withTimezone ?? false, config.precision);
}
var _a103, _b82, PgTimeBuilder, _a104, _b83, PgTime;
var init_time = __esm({
  "../drizzle-orm/dist/pg-core/columns/time.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    init_date_common();
    PgTimeBuilder = class extends (_b82 = PgDateColumnBaseBuilder, _a103 = entityKind, _b82) {
      constructor(name3, withTimezone, precision) {
        super(name3, "string", "PgTime");
        this.withTimezone = withTimezone;
        this.precision = precision;
        this.config.withTimezone = withTimezone;
        this.config.precision = precision;
      }
      /** @internal */
      build(table6) {
        return new PgTime(table6, this.config);
      }
    };
    __publicField(PgTimeBuilder, _a103, "PgTimeBuilder");
    PgTime = class extends (_b83 = PgColumn, _a104 = entityKind, _b83) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "withTimezone");
        __publicField(this, "precision");
        this.withTimezone = config.withTimezone;
        this.precision = config.precision;
      }
      getSQLType() {
        const precision = this.precision === void 0 ? "" : `(${this.precision})`;
        return `time${precision}${this.withTimezone ? " with time zone" : ""}`;
      }
    };
    __publicField(PgTime, _a104, "PgTime");
  }
});

// ../drizzle-orm/dist/pg-core/columns/timestamp.js
function timestamp(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new PgTimestampStringBuilder(name3, config.withTimezone ?? false, config.precision);
  }
  return new PgTimestampBuilder(name3, config?.withTimezone ?? false, config?.precision);
}
var _a105, _b84, PgTimestampBuilder, _a106, _b85, PgTimestamp, _a107, _b86, PgTimestampStringBuilder, _a108, _b87, PgTimestampString;
var init_timestamp = __esm({
  "../drizzle-orm/dist/pg-core/columns/timestamp.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    init_date_common();
    PgTimestampBuilder = class extends (_b84 = PgDateColumnBaseBuilder, _a105 = entityKind, _b84) {
      constructor(name3, withTimezone, precision) {
        super(name3, "date", "PgTimestamp");
        this.config.withTimezone = withTimezone;
        this.config.precision = precision;
      }
      /** @internal */
      build(table6) {
        return new PgTimestamp(table6, this.config);
      }
    };
    __publicField(PgTimestampBuilder, _a105, "PgTimestampBuilder");
    PgTimestamp = class extends (_b85 = PgColumn, _a106 = entityKind, _b85) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "withTimezone");
        __publicField(this, "precision");
        __publicField(this, "mapFromDriverValue", (value) => {
          return new Date(this.withTimezone ? value : value + "+0000");
        });
        __publicField(this, "mapToDriverValue", (value) => {
          return value.toISOString();
        });
        this.withTimezone = config.withTimezone;
        this.precision = config.precision;
      }
      getSQLType() {
        const precision = this.precision === void 0 ? "" : ` (${this.precision})`;
        return `timestamp${precision}${this.withTimezone ? " with time zone" : ""}`;
      }
    };
    __publicField(PgTimestamp, _a106, "PgTimestamp");
    PgTimestampStringBuilder = class extends (_b86 = PgDateColumnBaseBuilder, _a107 = entityKind, _b86) {
      constructor(name3, withTimezone, precision) {
        super(name3, "string", "PgTimestampString");
        this.config.withTimezone = withTimezone;
        this.config.precision = precision;
      }
      /** @internal */
      build(table6) {
        return new PgTimestampString(
          table6,
          this.config
        );
      }
    };
    __publicField(PgTimestampStringBuilder, _a107, "PgTimestampStringBuilder");
    PgTimestampString = class extends (_b87 = PgColumn, _a108 = entityKind, _b87) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "withTimezone");
        __publicField(this, "precision");
        this.withTimezone = config.withTimezone;
        this.precision = config.precision;
      }
      getSQLType() {
        const precision = this.precision === void 0 ? "" : `(${this.precision})`;
        return `timestamp${precision}${this.withTimezone ? " with time zone" : ""}`;
      }
    };
    __publicField(PgTimestampString, _a108, "PgTimestampString");
  }
});

// ../drizzle-orm/dist/pg-core/columns/uuid.js
function uuid(name3) {
  return new PgUUIDBuilder(name3 ?? "");
}
var _a109, _b88, PgUUIDBuilder, _a110, _b89, PgUUID;
var init_uuid = __esm({
  "../drizzle-orm/dist/pg-core/columns/uuid.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_common();
    PgUUIDBuilder = class extends (_b88 = PgColumnBuilder, _a109 = entityKind, _b88) {
      constructor(name3) {
        super(name3, "string", "PgUUID");
      }
      /**
       * Adds `default gen_random_uuid()` to the column definition.
       */
      defaultRandom() {
        return this.default(sql`gen_random_uuid()`);
      }
      /** @internal */
      build(table6) {
        return new PgUUID(table6, this.config);
      }
    };
    __publicField(PgUUIDBuilder, _a109, "PgUUIDBuilder");
    PgUUID = class extends (_b89 = PgColumn, _a110 = entityKind, _b89) {
      getSQLType() {
        return "uuid";
      }
    };
    __publicField(PgUUID, _a110, "PgUUID");
  }
});

// ../drizzle-orm/dist/pg-core/columns/varchar.js
function varchar(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgVarcharBuilder(name3, config);
}
var _a111, _b90, PgVarcharBuilder, _a112, _b91, PgVarchar;
var init_varchar = __esm({
  "../drizzle-orm/dist/pg-core/columns/varchar.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgVarcharBuilder = class extends (_b90 = PgColumnBuilder, _a111 = entityKind, _b90) {
      constructor(name3, config) {
        super(name3, "string", "PgVarchar");
        this.config.length = config.length;
        this.config.enumValues = config.enum;
      }
      /** @internal */
      build(table6) {
        return new PgVarchar(
          table6,
          this.config
        );
      }
    };
    __publicField(PgVarcharBuilder, _a111, "PgVarcharBuilder");
    PgVarchar = class extends (_b91 = PgColumn, _a112 = entityKind, _b91) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return this.length === void 0 ? `varchar` : `varchar(${this.length})`;
      }
    };
    __publicField(PgVarchar, _a112, "PgVarchar");
  }
});

// ../drizzle-orm/dist/pg-core/columns/vector_extension/bit.js
function bit(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgBinaryVectorBuilder(name3, config);
}
var _a113, _b92, PgBinaryVectorBuilder, _a114, _b93, PgBinaryVector;
var init_bit = __esm({
  "../drizzle-orm/dist/pg-core/columns/vector_extension/bit.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgBinaryVectorBuilder = class extends (_b92 = PgColumnBuilder, _a113 = entityKind, _b92) {
      constructor(name3, config) {
        super(name3, "string", "PgBinaryVector");
        this.config.dimensions = config.dimensions;
      }
      /** @internal */
      build(table6) {
        return new PgBinaryVector(
          table6,
          this.config
        );
      }
    };
    __publicField(PgBinaryVectorBuilder, _a113, "PgBinaryVectorBuilder");
    PgBinaryVector = class extends (_b93 = PgColumn, _a114 = entityKind, _b93) {
      constructor() {
        super(...arguments);
        __publicField(this, "dimensions", this.config.dimensions);
      }
      getSQLType() {
        return `bit(${this.dimensions})`;
      }
    };
    __publicField(PgBinaryVector, _a114, "PgBinaryVector");
  }
});

// ../drizzle-orm/dist/pg-core/columns/vector_extension/halfvec.js
function halfvec(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgHalfVectorBuilder(name3, config);
}
var _a115, _b94, PgHalfVectorBuilder, _a116, _b95, PgHalfVector;
var init_halfvec = __esm({
  "../drizzle-orm/dist/pg-core/columns/vector_extension/halfvec.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgHalfVectorBuilder = class extends (_b94 = PgColumnBuilder, _a115 = entityKind, _b94) {
      constructor(name3, config) {
        super(name3, "array", "PgHalfVector");
        this.config.dimensions = config.dimensions;
      }
      /** @internal */
      build(table6) {
        return new PgHalfVector(
          table6,
          this.config
        );
      }
    };
    __publicField(PgHalfVectorBuilder, _a115, "PgHalfVectorBuilder");
    PgHalfVector = class extends (_b95 = PgColumn, _a116 = entityKind, _b95) {
      constructor() {
        super(...arguments);
        __publicField(this, "dimensions", this.config.dimensions);
      }
      getSQLType() {
        return `halfvec(${this.dimensions})`;
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
      mapFromDriverValue(value) {
        return value.slice(1, -1).split(",").map((v11) => Number.parseFloat(v11));
      }
    };
    __publicField(PgHalfVector, _a116, "PgHalfVector");
  }
});

// ../drizzle-orm/dist/pg-core/columns/vector_extension/sparsevec.js
function sparsevec(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgSparseVectorBuilder(name3, config);
}
var _a117, _b96, PgSparseVectorBuilder, _a118, _b97, PgSparseVector;
var init_sparsevec = __esm({
  "../drizzle-orm/dist/pg-core/columns/vector_extension/sparsevec.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgSparseVectorBuilder = class extends (_b96 = PgColumnBuilder, _a117 = entityKind, _b96) {
      constructor(name3, config) {
        super(name3, "string", "PgSparseVector");
        this.config.dimensions = config.dimensions;
      }
      /** @internal */
      build(table6) {
        return new PgSparseVector(
          table6,
          this.config
        );
      }
    };
    __publicField(PgSparseVectorBuilder, _a117, "PgSparseVectorBuilder");
    PgSparseVector = class extends (_b97 = PgColumn, _a118 = entityKind, _b97) {
      constructor() {
        super(...arguments);
        __publicField(this, "dimensions", this.config.dimensions);
      }
      getSQLType() {
        return `sparsevec(${this.dimensions})`;
      }
    };
    __publicField(PgSparseVector, _a118, "PgSparseVector");
  }
});

// ../drizzle-orm/dist/pg-core/columns/vector_extension/vector.js
function vector(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new PgVectorBuilder(name3, config);
}
var _a119, _b98, PgVectorBuilder, _a120, _b99, PgVector;
var init_vector = __esm({
  "../drizzle-orm/dist/pg-core/columns/vector_extension/vector.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common();
    PgVectorBuilder = class extends (_b98 = PgColumnBuilder, _a119 = entityKind, _b98) {
      constructor(name3, config) {
        super(name3, "array", "PgVector");
        this.config.dimensions = config.dimensions;
      }
      /** @internal */
      build(table6) {
        return new PgVector(
          table6,
          this.config
        );
      }
    };
    __publicField(PgVectorBuilder, _a119, "PgVectorBuilder");
    PgVector = class extends (_b99 = PgColumn, _a120 = entityKind, _b99) {
      constructor() {
        super(...arguments);
        __publicField(this, "dimensions", this.config.dimensions);
      }
      getSQLType() {
        return `vector(${this.dimensions})`;
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
      mapFromDriverValue(value) {
        return value.slice(1, -1).split(",").map((v11) => Number.parseFloat(v11));
      }
    };
    __publicField(PgVector, _a120, "PgVector");
  }
});

// ../drizzle-orm/dist/pg-core/columns/all.js
function getPgColumnBuilders() {
  return {
    bigint,
    bigserial,
    boolean,
    char,
    cidr,
    customType,
    date,
    doublePrecision,
    inet,
    integer,
    interval,
    json,
    jsonb,
    line,
    macaddr,
    macaddr8,
    numeric,
    point,
    geometry,
    real,
    serial,
    smallint,
    smallserial,
    text,
    time,
    timestamp,
    uuid,
    varchar,
    bit,
    halfvec,
    sparsevec,
    vector
  };
}
var init_all = __esm({
  "../drizzle-orm/dist/pg-core/columns/all.js"() {
    "use strict";
    init_bigint();
    init_bigserial();
    init_boolean();
    init_char();
    init_cidr();
    init_custom();
    init_date();
    init_double_precision();
    init_inet();
    init_integer();
    init_interval();
    init_json();
    init_jsonb();
    init_line();
    init_macaddr();
    init_macaddr8();
    init_numeric();
    init_point();
    init_geometry();
    init_real();
    init_serial();
    init_smallint();
    init_smallserial();
    init_text();
    init_time();
    init_timestamp();
    init_uuid();
    init_varchar();
    init_bit();
    init_halfvec();
    init_sparsevec();
    init_vector();
  }
});

// ../drizzle-orm/dist/pg-core/table.js
function pgTableWithSchema(name3, columns, extraConfig, schema6, baseName = name3) {
  const rawTable = new PgTable(name3, schema6, baseName);
  const parsedColumns = typeof columns === "function" ? columns(getPgColumnBuilders()) : columns;
  const builtColumns = Object.fromEntries(
    Object.entries(parsedColumns).map(([name22, colBuilderBase]) => {
      const colBuilder = colBuilderBase;
      colBuilder.setName(name22);
      const column6 = colBuilder.build(rawTable);
      rawTable[InlineForeignKeys].push(...colBuilder.buildForeignKeys(column6, rawTable));
      return [name22, column6];
    })
  );
  const builtColumnsForExtraConfig = Object.fromEntries(
    Object.entries(parsedColumns).map(([name22, colBuilderBase]) => {
      const colBuilder = colBuilderBase;
      colBuilder.setName(name22);
      const column6 = colBuilder.buildExtraConfigColumn(rawTable);
      return [name22, column6];
    })
  );
  const table6 = Object.assign(rawTable, builtColumns);
  table6[Table.Symbol.Columns] = builtColumns;
  table6[Table.Symbol.ExtraConfigColumns] = builtColumnsForExtraConfig;
  if (extraConfig) {
    table6[PgTable.Symbol.ExtraConfigBuilder] = extraConfig;
  }
  return Object.assign(table6, {
    enableRLS: () => {
      table6[PgTable.Symbol.EnableRLS] = true;
      return table6;
    }
  });
}
function pgTableCreator(customizeTableName) {
  return (name3, columns, extraConfig) => {
    return pgTableWithSchema(customizeTableName(name3), columns, extraConfig, void 0, name3);
  };
}
var InlineForeignKeys, EnableRLS, _a121, _b100, _c3, _d2, _e2, _f2, PgTable, pgTable;
var init_table2 = __esm({
  "../drizzle-orm/dist/pg-core/table.js"() {
    "use strict";
    init_entity();
    init_table();
    init_all();
    InlineForeignKeys = Symbol.for("drizzle:PgInlineForeignKeys");
    EnableRLS = Symbol.for("drizzle:EnableRLS");
    PgTable = class extends (_f2 = Table, _e2 = entityKind, _d2 = InlineForeignKeys, _c3 = EnableRLS, _b100 = Table.Symbol.ExtraConfigBuilder, _a121 = Table.Symbol.ExtraConfigColumns, _f2) {
      constructor() {
        super(...arguments);
        /**@internal */
        __publicField(this, _d2, []);
        /** @internal */
        __publicField(this, _c3, false);
        /** @internal */
        __publicField(this, _b100);
        /** @internal */
        __publicField(this, _a121, {});
      }
    };
    __publicField(PgTable, _e2, "PgTable");
    /** @internal */
    __publicField(PgTable, "Symbol", Object.assign({}, Table.Symbol, {
      InlineForeignKeys,
      EnableRLS
    }));
    pgTable = (name3, columns, extraConfig) => {
      return pgTableWithSchema(name3, columns, extraConfig, void 0);
    };
  }
});

// ../drizzle-orm/dist/pg-core/primary-keys.js
function primaryKey(...config) {
  if (config[0].columns) {
    return new PrimaryKeyBuilder(config[0].columns, config[0].name);
  }
  return new PrimaryKeyBuilder(config);
}
var _a122, PrimaryKeyBuilder, _a123, PrimaryKey;
var init_primary_keys = __esm({
  "../drizzle-orm/dist/pg-core/primary-keys.js"() {
    "use strict";
    init_entity();
    init_table2();
    _a122 = entityKind;
    PrimaryKeyBuilder = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        /** @internal */
        __publicField(this, "name");
        this.columns = columns;
        this.name = name3;
      }
      /** @internal */
      build(table6) {
        return new PrimaryKey(table6, this.columns, this.name);
      }
    };
    __publicField(PrimaryKeyBuilder, _a122, "PgPrimaryKeyBuilder");
    _a123 = entityKind;
    PrimaryKey = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        this.table = table6;
        this.columns = columns;
        this.name = name3;
      }
      getName() {
        return this.name ?? `${this.table[PgTable.Symbol.Name]}_${this.columns.map((column6) => column6.name).join("_")}_pk`;
      }
    };
    __publicField(PrimaryKey, _a123, "PgPrimaryKey");
  }
});

// ../drizzle-orm/dist/sql/expressions/conditions.js
function bindIfParam(value, column6) {
  if (isDriverValueEncoder(column6) && !isSQLWrapper(value) && !is(value, Param) && !is(value, Placeholder) && !is(value, Column) && !is(value, Table) && !is(value, View)) {
    return new Param(value, column6);
  }
  return value;
}
function and(...unfilteredConditions) {
  const conditions = unfilteredConditions.filter(
    (c6) => c6 !== void 0
  );
  if (conditions.length === 0) {
    return void 0;
  }
  if (conditions.length === 1) {
    return new SQL(conditions);
  }
  return new SQL([
    new StringChunk("("),
    sql.join(conditions, new StringChunk(" and ")),
    new StringChunk(")")
  ]);
}
function or(...unfilteredConditions) {
  const conditions = unfilteredConditions.filter(
    (c6) => c6 !== void 0
  );
  if (conditions.length === 0) {
    return void 0;
  }
  if (conditions.length === 1) {
    return new SQL(conditions);
  }
  return new SQL([
    new StringChunk("("),
    sql.join(conditions, new StringChunk(" or ")),
    new StringChunk(")")
  ]);
}
function not(condition) {
  return sql`not ${condition}`;
}
function inArray(column6, values2) {
  if (Array.isArray(values2)) {
    if (values2.length === 0) {
      return sql`false`;
    }
    return sql`${column6} in ${values2.map((v11) => bindIfParam(v11, column6))}`;
  }
  return sql`${column6} in ${bindIfParam(values2, column6)}`;
}
function notInArray(column6, values2) {
  if (Array.isArray(values2)) {
    if (values2.length === 0) {
      return sql`true`;
    }
    return sql`${column6} not in ${values2.map((v11) => bindIfParam(v11, column6))}`;
  }
  return sql`${column6} not in ${bindIfParam(values2, column6)}`;
}
function isNull(value) {
  return sql`${value} is null`;
}
function isNotNull(value) {
  return sql`${value} is not null`;
}
function exists(subquery) {
  return sql`exists ${subquery}`;
}
function notExists(subquery) {
  return sql`not exists ${subquery}`;
}
function between(column6, min2, max2) {
  return sql`${column6} between ${bindIfParam(min2, column6)} and ${bindIfParam(
    max2,
    column6
  )}`;
}
function notBetween(column6, min2, max2) {
  return sql`${column6} not between ${bindIfParam(
    min2,
    column6
  )} and ${bindIfParam(max2, column6)}`;
}
function like(column6, value) {
  return sql`${column6} like ${value}`;
}
function notLike(column6, value) {
  return sql`${column6} not like ${value}`;
}
function ilike(column6, value) {
  return sql`${column6} ilike ${value}`;
}
function notIlike(column6, value) {
  return sql`${column6} not ilike ${value}`;
}
function arrayContains(column6, values2) {
  if (Array.isArray(values2)) {
    if (values2.length === 0) {
      throw new Error("arrayContains requires at least one value");
    }
    const array3 = sql`${bindIfParam(values2, column6)}`;
    return sql`${column6} @> ${array3}`;
  }
  return sql`${column6} @> ${bindIfParam(values2, column6)}`;
}
function arrayContained(column6, values2) {
  if (Array.isArray(values2)) {
    if (values2.length === 0) {
      throw new Error("arrayContained requires at least one value");
    }
    const array3 = sql`${bindIfParam(values2, column6)}`;
    return sql`${column6} <@ ${array3}`;
  }
  return sql`${column6} <@ ${bindIfParam(values2, column6)}`;
}
function arrayOverlaps(column6, values2) {
  if (Array.isArray(values2)) {
    if (values2.length === 0) {
      throw new Error("arrayOverlaps requires at least one value");
    }
    const array3 = sql`${bindIfParam(values2, column6)}`;
    return sql`${column6} && ${array3}`;
  }
  return sql`${column6} && ${bindIfParam(values2, column6)}`;
}
var eq, ne, gt, gte, lt, lte;
var init_conditions = __esm({
  "../drizzle-orm/dist/sql/expressions/conditions.js"() {
    "use strict";
    init_column();
    init_entity();
    init_table();
    init_sql();
    eq = (left, right) => {
      return sql`${left} = ${bindIfParam(right, left)}`;
    };
    ne = (left, right) => {
      return sql`${left} <> ${bindIfParam(right, left)}`;
    };
    gt = (left, right) => {
      return sql`${left} > ${bindIfParam(right, left)}`;
    };
    gte = (left, right) => {
      return sql`${left} >= ${bindIfParam(right, left)}`;
    };
    lt = (left, right) => {
      return sql`${left} < ${bindIfParam(right, left)}`;
    };
    lte = (left, right) => {
      return sql`${left} <= ${bindIfParam(right, left)}`;
    };
  }
});

// ../drizzle-orm/dist/sql/expressions/select.js
function asc(column6) {
  return sql`${column6} asc`;
}
function desc(column6) {
  return sql`${column6} desc`;
}
var init_select = __esm({
  "../drizzle-orm/dist/sql/expressions/select.js"() {
    "use strict";
    init_sql();
  }
});

// ../drizzle-orm/dist/sql/expressions/index.js
var init_expressions = __esm({
  "../drizzle-orm/dist/sql/expressions/index.js"() {
    "use strict";
    init_conditions();
    init_select();
  }
});

// ../drizzle-orm/dist/relations.js
function getOperators() {
  return {
    and,
    between,
    eq,
    exists,
    gt,
    gte,
    ilike,
    inArray,
    isNull,
    isNotNull,
    like,
    lt,
    lte,
    ne,
    not,
    notBetween,
    notExists,
    notLike,
    notIlike,
    notInArray,
    or,
    sql
  };
}
function getOrderByOperators() {
  return {
    sql,
    asc,
    desc
  };
}
function extractTablesRelationalConfig(schema6, configHelpers) {
  if (Object.keys(schema6).length === 1 && "default" in schema6 && !is(schema6["default"], Table)) {
    schema6 = schema6["default"];
  }
  const tableNamesMap = {};
  const relationsBuffer = {};
  const tablesConfig = {};
  for (const [key, value] of Object.entries(schema6)) {
    if (is(value, Table)) {
      const dbName = getTableUniqueName(value);
      const bufferedRelations = relationsBuffer[dbName];
      tableNamesMap[dbName] = key;
      tablesConfig[key] = {
        tsName: key,
        dbName: value[Table.Symbol.Name],
        schema: value[Table.Symbol.Schema],
        columns: value[Table.Symbol.Columns],
        relations: bufferedRelations?.relations ?? {},
        primaryKey: bufferedRelations?.primaryKey ?? []
      };
      for (const column6 of Object.values(
        value[Table.Symbol.Columns]
      )) {
        if (column6.primary) {
          tablesConfig[key].primaryKey.push(column6);
        }
      }
      const extraConfig = value[Table.Symbol.ExtraConfigBuilder]?.(value[Table.Symbol.ExtraConfigColumns]);
      if (extraConfig) {
        for (const configEntry of Object.values(extraConfig)) {
          if (is(configEntry, PrimaryKeyBuilder)) {
            tablesConfig[key].primaryKey.push(...configEntry.columns);
          }
        }
      }
    } else if (is(value, Relations)) {
      const dbName = getTableUniqueName(value.table);
      const tableName = tableNamesMap[dbName];
      const relations2 = value.config(
        configHelpers(value.table)
      );
      let primaryKey2;
      for (const [relationName, relation] of Object.entries(relations2)) {
        if (tableName) {
          const tableConfig = tablesConfig[tableName];
          tableConfig.relations[relationName] = relation;
          if (primaryKey2) {
            tableConfig.primaryKey.push(...primaryKey2);
          }
        } else {
          if (!(dbName in relationsBuffer)) {
            relationsBuffer[dbName] = {
              relations: {},
              primaryKey: primaryKey2
            };
          }
          relationsBuffer[dbName].relations[relationName] = relation;
        }
      }
    }
  }
  return { tables: tablesConfig, tableNamesMap };
}
function relations(table6, relations2) {
  return new Relations(
    table6,
    (helpers) => Object.fromEntries(
      Object.entries(relations2(helpers)).map(([key, value]) => [
        key,
        value.withFieldName(key)
      ])
    )
  );
}
function createOne(sourceTable) {
  return function one(table6, config) {
    return new One(
      sourceTable,
      table6,
      config,
      config?.fields.reduce((res, f9) => res && f9.notNull, true) ?? false
    );
  };
}
function createMany(sourceTable) {
  return function many(referencedTable, config) {
    return new Many(sourceTable, referencedTable, config);
  };
}
function normalizeRelation(schema6, tableNamesMap, relation) {
  if (is(relation, One) && relation.config) {
    return {
      fields: relation.config.fields,
      references: relation.config.references
    };
  }
  const referencedTableTsName = tableNamesMap[getTableUniqueName(relation.referencedTable)];
  if (!referencedTableTsName) {
    throw new Error(
      `Table "${relation.referencedTable[Table.Symbol.Name]}" not found in schema`
    );
  }
  const referencedTableConfig = schema6[referencedTableTsName];
  if (!referencedTableConfig) {
    throw new Error(`Table "${referencedTableTsName}" not found in schema`);
  }
  const sourceTable = relation.sourceTable;
  const sourceTableTsName = tableNamesMap[getTableUniqueName(sourceTable)];
  if (!sourceTableTsName) {
    throw new Error(
      `Table "${sourceTable[Table.Symbol.Name]}" not found in schema`
    );
  }
  const reverseRelations = [];
  for (const referencedTableRelation of Object.values(
    referencedTableConfig.relations
  )) {
    if (relation.relationName && relation !== referencedTableRelation && referencedTableRelation.relationName === relation.relationName || !relation.relationName && referencedTableRelation.referencedTable === relation.sourceTable) {
      reverseRelations.push(referencedTableRelation);
    }
  }
  if (reverseRelations.length > 1) {
    throw relation.relationName ? new Error(
      `There are multiple relations with name "${relation.relationName}" in table "${referencedTableTsName}"`
    ) : new Error(
      `There are multiple relations between "${referencedTableTsName}" and "${relation.sourceTable[Table.Symbol.Name]}". Please specify relation name`
    );
  }
  if (reverseRelations[0] && is(reverseRelations[0], One) && reverseRelations[0].config) {
    return {
      fields: reverseRelations[0].config.references,
      references: reverseRelations[0].config.fields
    };
  }
  throw new Error(
    `There is not enough information to infer relation "${sourceTableTsName}.${relation.fieldName}"`
  );
}
function createTableRelationsHelpers(sourceTable) {
  return {
    one: createOne(sourceTable),
    many: createMany(sourceTable)
  };
}
function mapRelationalRow(tablesConfig, tableConfig, row, buildQueryResultSelection, mapColumnValue = (value) => value) {
  const result = {};
  for (const [
    selectionItemIndex,
    selectionItem
  ] of buildQueryResultSelection.entries()) {
    if (selectionItem.isJson) {
      const relation = tableConfig.relations[selectionItem.tsKey];
      const rawSubRows = row[selectionItemIndex];
      const subRows = typeof rawSubRows === "string" ? JSON.parse(rawSubRows) : rawSubRows;
      result[selectionItem.tsKey] = is(relation, One) ? subRows && mapRelationalRow(
        tablesConfig,
        tablesConfig[selectionItem.relationTableTsKey],
        subRows,
        selectionItem.selection,
        mapColumnValue
      ) : subRows.map(
        (subRow) => mapRelationalRow(
          tablesConfig,
          tablesConfig[selectionItem.relationTableTsKey],
          subRow,
          selectionItem.selection,
          mapColumnValue
        )
      );
    } else {
      const value = mapColumnValue(row[selectionItemIndex]);
      const field = selectionItem.field;
      let decoder2;
      if (is(field, Column)) {
        decoder2 = field;
      } else if (is(field, SQL)) {
        decoder2 = field.decoder;
      } else {
        decoder2 = field.sql.decoder;
      }
      result[selectionItem.tsKey] = value === null ? null : decoder2.mapFromDriverValue(value);
    }
  }
  return result;
}
var _a124, Relation, _a125, Relations, _a126, _b101, _One, One, _a127, _b102, _Many, Many;
var init_relations = __esm({
  "../drizzle-orm/dist/relations.js"() {
    "use strict";
    init_table();
    init_column();
    init_entity();
    init_primary_keys();
    init_expressions();
    init_sql();
    _a124 = entityKind;
    Relation = class {
      constructor(sourceTable, referencedTable, relationName) {
        __publicField(this, "referencedTableName");
        __publicField(this, "fieldName");
        this.sourceTable = sourceTable;
        this.referencedTable = referencedTable;
        this.relationName = relationName;
        this.referencedTableName = referencedTable[Table.Symbol.Name];
      }
    };
    __publicField(Relation, _a124, "Relation");
    _a125 = entityKind;
    Relations = class {
      constructor(table6, config) {
        this.table = table6;
        this.config = config;
      }
    };
    __publicField(Relations, _a125, "Relations");
    _One = class _One extends (_b101 = Relation, _a126 = entityKind, _b101) {
      constructor(sourceTable, referencedTable, config, isNullable) {
        super(sourceTable, referencedTable, config?.relationName);
        this.config = config;
        this.isNullable = isNullable;
      }
      withFieldName(fieldName) {
        const relation = new _One(
          this.sourceTable,
          this.referencedTable,
          this.config,
          this.isNullable
        );
        relation.fieldName = fieldName;
        return relation;
      }
    };
    __publicField(_One, _a126, "One");
    One = _One;
    _Many = class _Many extends (_b102 = Relation, _a127 = entityKind, _b102) {
      constructor(sourceTable, referencedTable, config) {
        super(sourceTable, referencedTable, config?.relationName);
        this.config = config;
      }
      withFieldName(fieldName) {
        const relation = new _Many(
          this.sourceTable,
          this.referencedTable,
          this.config
        );
        relation.fieldName = fieldName;
        return relation;
      }
    };
    __publicField(_Many, _a127, "Many");
    Many = _Many;
  }
});

// ../drizzle-orm/dist/sql/functions/aggregate.js
function count(expression) {
  return sql`count(${expression || sql.raw("*")})`.mapWith(Number);
}
function countDistinct(expression) {
  return sql`count(distinct ${expression})`.mapWith(Number);
}
function avg(expression) {
  return sql`avg(${expression})`.mapWith(String);
}
function avgDistinct(expression) {
  return sql`avg(distinct ${expression})`.mapWith(String);
}
function sum(expression) {
  return sql`sum(${expression})`.mapWith(String);
}
function sumDistinct(expression) {
  return sql`sum(distinct ${expression})`.mapWith(String);
}
function max(expression) {
  return sql`max(${expression})`.mapWith(is(expression, Column) ? expression : String);
}
function min(expression) {
  return sql`min(${expression})`.mapWith(is(expression, Column) ? expression : String);
}
var init_aggregate = __esm({
  "../drizzle-orm/dist/sql/functions/aggregate.js"() {
    "use strict";
    init_column();
    init_entity();
    init_sql();
  }
});

// ../drizzle-orm/dist/sql/functions/vector.js
function toSql(value) {
  return JSON.stringify(value);
}
function l2Distance(column6, value) {
  if (Array.isArray(value)) {
    return sql`${column6} <-> ${toSql(value)}`;
  }
  return sql`${column6} <-> ${value}`;
}
function l1Distance(column6, value) {
  if (Array.isArray(value)) {
    return sql`${column6} <+> ${toSql(value)}`;
  }
  return sql`${column6} <+> ${value}`;
}
function innerProduct(column6, value) {
  if (Array.isArray(value)) {
    return sql`${column6} <#> ${toSql(value)}`;
  }
  return sql`${column6} <#> ${value}`;
}
function cosineDistance(column6, value) {
  if (Array.isArray(value)) {
    return sql`${column6} <=> ${toSql(value)}`;
  }
  return sql`${column6} <=> ${value}`;
}
function hammingDistance(column6, value) {
  if (Array.isArray(value)) {
    return sql`${column6} <~> ${toSql(value)}`;
  }
  return sql`${column6} <~> ${value}`;
}
function jaccardDistance(column6, value) {
  if (Array.isArray(value)) {
    return sql`${column6} <%> ${toSql(value)}`;
  }
  return sql`${column6} <%> ${value}`;
}
var init_vector2 = __esm({
  "../drizzle-orm/dist/sql/functions/vector.js"() {
    "use strict";
    init_sql();
  }
});

// ../drizzle-orm/dist/sql/functions/index.js
var init_functions = __esm({
  "../drizzle-orm/dist/sql/functions/index.js"() {
    "use strict";
    init_aggregate();
    init_vector2();
  }
});

// ../drizzle-orm/dist/sql/index.js
var init_sql2 = __esm({
  "../drizzle-orm/dist/sql/index.js"() {
    "use strict";
    init_expressions();
    init_functions();
    init_sql();
  }
});

// ../drizzle-orm/dist/index.js
var dist_exports = {};
__export(dist_exports, {
  BaseName: () => BaseName,
  Column: () => Column,
  ColumnAliasProxyHandler: () => ColumnAliasProxyHandler,
  ColumnBuilder: () => ColumnBuilder,
  Columns: () => Columns,
  ConsoleLogWriter: () => ConsoleLogWriter,
  DefaultLogger: () => DefaultLogger,
  DrizzleError: () => DrizzleError,
  DrizzleQueryError: () => DrizzleQueryError,
  ExtraConfigBuilder: () => ExtraConfigBuilder,
  ExtraConfigColumns: () => ExtraConfigColumns,
  FakePrimitiveParam: () => FakePrimitiveParam,
  IsAlias: () => IsAlias,
  Many: () => Many,
  Name: () => Name,
  NoopLogger: () => NoopLogger,
  One: () => One,
  OriginalName: () => OriginalName,
  Param: () => Param,
  Placeholder: () => Placeholder,
  QueryPromise: () => QueryPromise,
  Relation: () => Relation,
  RelationTableAliasProxyHandler: () => RelationTableAliasProxyHandler,
  Relations: () => Relations,
  SQL: () => SQL,
  Schema: () => Schema,
  StringChunk: () => StringChunk,
  Subquery: () => Subquery,
  Table: () => Table,
  TableAliasProxyHandler: () => TableAliasProxyHandler,
  TransactionRollbackError: () => TransactionRollbackError,
  View: () => View,
  ViewBaseConfig: () => ViewBaseConfig,
  WithSubquery: () => WithSubquery,
  aliasedRelation: () => aliasedRelation,
  aliasedTable: () => aliasedTable,
  aliasedTableColumn: () => aliasedTableColumn,
  and: () => and,
  applyMixins: () => applyMixins,
  arrayContained: () => arrayContained,
  arrayContains: () => arrayContains,
  arrayOverlaps: () => arrayOverlaps,
  asc: () => asc,
  avg: () => avg,
  avgDistinct: () => avgDistinct,
  between: () => between,
  bindIfParam: () => bindIfParam,
  cosineDistance: () => cosineDistance,
  count: () => count,
  countDistinct: () => countDistinct,
  createMany: () => createMany,
  createOne: () => createOne,
  createTableRelationsHelpers: () => createTableRelationsHelpers,
  desc: () => desc,
  entityKind: () => entityKind,
  eq: () => eq,
  exists: () => exists,
  extractTablesRelationalConfig: () => extractTablesRelationalConfig,
  fillPlaceholders: () => fillPlaceholders,
  getColumnNameAndConfig: () => getColumnNameAndConfig,
  getOperators: () => getOperators,
  getOrderByOperators: () => getOrderByOperators,
  getTableColumns: () => getTableColumns,
  getTableLikeName: () => getTableLikeName,
  getTableName: () => getTableName,
  getTableUniqueName: () => getTableUniqueName,
  getViewName: () => getViewName,
  getViewSelectedFields: () => getViewSelectedFields,
  gt: () => gt,
  gte: () => gte,
  hammingDistance: () => hammingDistance,
  hasOwnEntityKind: () => hasOwnEntityKind,
  haveSameKeys: () => haveSameKeys,
  ilike: () => ilike,
  inArray: () => inArray,
  innerProduct: () => innerProduct,
  is: () => is,
  isConfig: () => isConfig,
  isDriverValueEncoder: () => isDriverValueEncoder,
  isNotNull: () => isNotNull,
  isNull: () => isNull,
  isSQLWrapper: () => isSQLWrapper,
  isTable: () => isTable,
  isView: () => isView,
  jaccardDistance: () => jaccardDistance,
  l1Distance: () => l1Distance,
  l2Distance: () => l2Distance,
  like: () => like,
  lt: () => lt,
  lte: () => lte,
  mapColumnsInAliasedSQLToAlias: () => mapColumnsInAliasedSQLToAlias,
  mapColumnsInSQLToAlias: () => mapColumnsInSQLToAlias,
  mapRelationalRow: () => mapRelationalRow,
  mapResultRow: () => mapResultRow,
  mapUpdateSet: () => mapUpdateSet,
  max: () => max,
  min: () => min,
  name: () => name2,
  ne: () => ne,
  noopDecoder: () => noopDecoder,
  noopEncoder: () => noopEncoder,
  noopMapper: () => noopMapper,
  normalizeRelation: () => normalizeRelation,
  not: () => not,
  notBetween: () => notBetween,
  notExists: () => notExists,
  notIlike: () => notIlike,
  notInArray: () => notInArray,
  notLike: () => notLike,
  or: () => or,
  orderSelectedFields: () => orderSelectedFields,
  param: () => param,
  placeholder: () => placeholder,
  relations: () => relations,
  sql: () => sql,
  sum: () => sum,
  sumDistinct: () => sumDistinct,
  textDecoder: () => textDecoder
});
var init_dist = __esm({
  "../drizzle-orm/dist/index.js"() {
    "use strict";
    init_alias();
    init_column_builder();
    init_column();
    init_entity();
    init_errors();
    init_logger();
    init_operations();
    init_query_promise();
    init_relations();
    init_sql2();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
  }
});

// ../drizzle-orm/dist/mysql-core/alias.js
var init_alias2 = __esm({
  "../drizzle-orm/dist/mysql-core/alias.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/mysql-core/checks.js
var _a128, CheckBuilder, _a129, Check;
var init_checks = __esm({
  "../drizzle-orm/dist/mysql-core/checks.js"() {
    "use strict";
    init_entity();
    _a128 = entityKind;
    CheckBuilder = class {
      constructor(name3, value) {
        __publicField(this, "brand");
        this.name = name3;
        this.value = value;
      }
      /** @internal */
      build(table6) {
        return new Check(table6, this);
      }
    };
    __publicField(CheckBuilder, _a128, "MySqlCheckBuilder");
    _a129 = entityKind;
    Check = class {
      constructor(table6, builder) {
        __publicField(this, "name");
        __publicField(this, "value");
        this.table = table6;
        this.name = builder.name;
        this.value = builder.value;
      }
    };
    __publicField(Check, _a129, "MySqlCheck");
  }
});

// ../drizzle-orm/dist/mysql-core/foreign-keys.js
var _a130, ForeignKeyBuilder2, _a131, ForeignKey2;
var init_foreign_keys2 = __esm({
  "../drizzle-orm/dist/mysql-core/foreign-keys.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a130 = entityKind;
    ForeignKeyBuilder2 = class {
      constructor(config, actions) {
        /** @internal */
        __publicField(this, "reference");
        /** @internal */
        __publicField(this, "_onUpdate");
        /** @internal */
        __publicField(this, "_onDelete");
        this.reference = () => {
          const { name: name3, columns, foreignColumns } = config();
          return { name: name3, columns, foreignTable: foreignColumns[0].table, foreignColumns };
        };
        if (actions) {
          this._onUpdate = actions.onUpdate;
          this._onDelete = actions.onDelete;
        }
      }
      onUpdate(action) {
        this._onUpdate = action;
        return this;
      }
      onDelete(action) {
        this._onDelete = action;
        return this;
      }
      /** @internal */
      build(table6) {
        return new ForeignKey2(table6, this);
      }
    };
    __publicField(ForeignKeyBuilder2, _a130, "MySqlForeignKeyBuilder");
    _a131 = entityKind;
    ForeignKey2 = class {
      constructor(table6, builder) {
        __publicField(this, "reference");
        __publicField(this, "onUpdate");
        __publicField(this, "onDelete");
        this.table = table6;
        this.reference = builder.reference;
        this.onUpdate = builder._onUpdate;
        this.onDelete = builder._onDelete;
      }
      getName() {
        const { name: name3, columns, foreignColumns } = this.reference();
        const columnNames = columns.map((column6) => column6.name);
        const foreignColumnNames = foreignColumns.map((column6) => column6.name);
        const chunks = [
          this.table[TableName],
          ...columnNames,
          foreignColumns[0].table[TableName],
          ...foreignColumnNames
        ];
        return name3 ?? `${chunks.join("_")}_fk`;
      }
    };
    __publicField(ForeignKey2, _a131, "MySqlForeignKey");
  }
});

// ../drizzle-orm/dist/mysql-core/unique-constraint.js
function uniqueKeyName2(table6, columns) {
  return `${table6[TableName]}_${columns.join("_")}_unique`;
}
var _a132, UniqueConstraintBuilder2, _a133, UniqueOnConstraintBuilder2, _a134, UniqueConstraint2;
var init_unique_constraint2 = __esm({
  "../drizzle-orm/dist/mysql-core/unique-constraint.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a132 = entityKind;
    UniqueConstraintBuilder2 = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        this.name = name3;
        this.columns = columns;
      }
      /** @internal */
      build(table6) {
        return new UniqueConstraint2(table6, this.columns, this.name);
      }
    };
    __publicField(UniqueConstraintBuilder2, _a132, "MySqlUniqueConstraintBuilder");
    _a133 = entityKind;
    UniqueOnConstraintBuilder2 = class {
      constructor(name3) {
        /** @internal */
        __publicField(this, "name");
        this.name = name3;
      }
      on(...columns) {
        return new UniqueConstraintBuilder2(columns, this.name);
      }
    };
    __publicField(UniqueOnConstraintBuilder2, _a133, "MySqlUniqueOnConstraintBuilder");
    _a134 = entityKind;
    UniqueConstraint2 = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        __publicField(this, "nullsNotDistinct", false);
        this.table = table6;
        this.columns = columns;
        this.name = name3 ?? uniqueKeyName2(this.table, this.columns.map((column6) => column6.name));
      }
      getName() {
        return this.name;
      }
    };
    __publicField(UniqueConstraint2, _a134, "MySqlUniqueConstraint");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/common.js
var _a135, _b103, MySqlColumnBuilder, _a136, _b104, MySqlColumn, _a137, _b105, MySqlColumnBuilderWithAutoIncrement, _a138, _b106, MySqlColumnWithAutoIncrement;
var init_common2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/common.js"() {
    "use strict";
    init_column_builder();
    init_column();
    init_entity();
    init_foreign_keys2();
    init_unique_constraint2();
    MySqlColumnBuilder = class extends (_b103 = ColumnBuilder, _a135 = entityKind, _b103) {
      constructor() {
        super(...arguments);
        __publicField(this, "foreignKeyConfigs", []);
      }
      references(ref, actions = {}) {
        this.foreignKeyConfigs.push({ ref, actions });
        return this;
      }
      unique(name3) {
        this.config.isUnique = true;
        this.config.uniqueName = name3;
        return this;
      }
      generatedAlwaysAs(as, config) {
        this.config.generated = {
          as,
          type: "always",
          mode: config?.mode ?? "virtual"
        };
        return this;
      }
      /** @internal */
      buildForeignKeys(column6, table6) {
        return this.foreignKeyConfigs.map(({ ref, actions }) => {
          return ((ref2, actions2) => {
            const builder = new ForeignKeyBuilder2(() => {
              const foreignColumn = ref2();
              return { columns: [column6], foreignColumns: [foreignColumn] };
            });
            if (actions2.onUpdate) {
              builder.onUpdate(actions2.onUpdate);
            }
            if (actions2.onDelete) {
              builder.onDelete(actions2.onDelete);
            }
            return builder.build(table6);
          })(ref, actions);
        });
      }
    };
    __publicField(MySqlColumnBuilder, _a135, "MySqlColumnBuilder");
    MySqlColumn = class extends (_b104 = Column, _a136 = entityKind, _b104) {
      constructor(table6, config) {
        if (!config.uniqueName) {
          config.uniqueName = uniqueKeyName2(table6, [config.name]);
        }
        super(table6, config);
        this.table = table6;
      }
    };
    __publicField(MySqlColumn, _a136, "MySqlColumn");
    MySqlColumnBuilderWithAutoIncrement = class extends (_b105 = MySqlColumnBuilder, _a137 = entityKind, _b105) {
      constructor(name3, dataType, columnType) {
        super(name3, dataType, columnType);
        this.config.autoIncrement = false;
      }
      autoincrement() {
        this.config.autoIncrement = true;
        this.config.hasDefault = true;
        return this;
      }
    };
    __publicField(MySqlColumnBuilderWithAutoIncrement, _a137, "MySqlColumnBuilderWithAutoIncrement");
    MySqlColumnWithAutoIncrement = class extends (_b106 = MySqlColumn, _a138 = entityKind, _b106) {
      constructor() {
        super(...arguments);
        __publicField(this, "autoIncrement", this.config.autoIncrement);
      }
    };
    __publicField(MySqlColumnWithAutoIncrement, _a138, "MySqlColumnWithAutoIncrement");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/bigint.js
function bigint2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config.mode === "number") {
    return new MySqlBigInt53Builder(name3, config.unsigned);
  }
  return new MySqlBigInt64Builder(name3, config.unsigned);
}
var _a139, _b107, MySqlBigInt53Builder, _a140, _b108, MySqlBigInt53, _a141, _b109, MySqlBigInt64Builder, _a142, _b110, MySqlBigInt64;
var init_bigint2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/bigint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlBigInt53Builder = class extends (_b107 = MySqlColumnBuilderWithAutoIncrement, _a139 = entityKind, _b107) {
      constructor(name3, unsigned = false) {
        super(name3, "number", "MySqlBigInt53");
        this.config.unsigned = unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlBigInt53(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlBigInt53Builder, _a139, "MySqlBigInt53Builder");
    MySqlBigInt53 = class extends (_b108 = MySqlColumnWithAutoIncrement, _a140 = entityKind, _b108) {
      getSQLType() {
        return `bigint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") {
          return value;
        }
        return Number(value);
      }
    };
    __publicField(MySqlBigInt53, _a140, "MySqlBigInt53");
    MySqlBigInt64Builder = class extends (_b109 = MySqlColumnBuilderWithAutoIncrement, _a141 = entityKind, _b109) {
      constructor(name3, unsigned = false) {
        super(name3, "bigint", "MySqlBigInt64");
        this.config.unsigned = unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlBigInt64(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlBigInt64Builder, _a141, "MySqlBigInt64Builder");
    MySqlBigInt64 = class extends (_b110 = MySqlColumnWithAutoIncrement, _a142 = entityKind, _b110) {
      getSQLType() {
        return `bigint${this.config.unsigned ? " unsigned" : ""}`;
      }
      // eslint-disable-next-line unicorn/prefer-native-coercion-functions
      mapFromDriverValue(value) {
        return BigInt(value);
      }
    };
    __publicField(MySqlBigInt64, _a142, "MySqlBigInt64");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/binary.js
function binary2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlBinaryBuilder(name3, config.length);
}
var _a143, _b111, MySqlBinaryBuilder, _a144, _b112, MySqlBinary;
var init_binary = __esm({
  "../drizzle-orm/dist/mysql-core/columns/binary.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlBinaryBuilder = class extends (_b111 = MySqlColumnBuilder, _a143 = entityKind, _b111) {
      constructor(name3, length) {
        super(name3, "string", "MySqlBinary");
        this.config.length = length;
      }
      /** @internal */
      build(table6) {
        return new MySqlBinary(table6, this.config);
      }
    };
    __publicField(MySqlBinaryBuilder, _a143, "MySqlBinaryBuilder");
    MySqlBinary = class extends (_b112 = MySqlColumn, _a144 = entityKind, _b112) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        if (Buffer.isBuffer(value)) return value.toString();
        const str = [];
        for (const v11 of value) {
          str.push(v11 === 49 ? "1" : "0");
        }
        return str.join("");
      }
      getSQLType() {
        return this.length === void 0 ? `binary` : `binary(${this.length})`;
      }
    };
    __publicField(MySqlBinary, _a144, "MySqlBinary");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/boolean.js
function boolean2(name3) {
  return new MySqlBooleanBuilder(name3 ?? "");
}
var _a145, _b113, MySqlBooleanBuilder, _a146, _b114, MySqlBoolean;
var init_boolean2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/boolean.js"() {
    "use strict";
    init_entity();
    init_common2();
    MySqlBooleanBuilder = class extends (_b113 = MySqlColumnBuilder, _a145 = entityKind, _b113) {
      constructor(name3) {
        super(name3, "boolean", "MySqlBoolean");
      }
      /** @internal */
      build(table6) {
        return new MySqlBoolean(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlBooleanBuilder, _a145, "MySqlBooleanBuilder");
    MySqlBoolean = class extends (_b114 = MySqlColumn, _a146 = entityKind, _b114) {
      getSQLType() {
        return "boolean";
      }
      mapFromDriverValue(value) {
        if (typeof value === "boolean") {
          return value;
        }
        return value === 1;
      }
    };
    __publicField(MySqlBoolean, _a146, "MySqlBoolean");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/char.js
function char2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlCharBuilder(name3, config);
}
var _a147, _b115, MySqlCharBuilder, _a148, _b116, MySqlChar;
var init_char2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/char.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlCharBuilder = class extends (_b115 = MySqlColumnBuilder, _a147 = entityKind, _b115) {
      constructor(name3, config) {
        super(name3, "string", "MySqlChar");
        this.config.length = config.length;
        this.config.enum = config.enum;
      }
      /** @internal */
      build(table6) {
        return new MySqlChar(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlCharBuilder, _a147, "MySqlCharBuilder");
    MySqlChar = class extends (_b116 = MySqlColumn, _a148 = entityKind, _b116) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
        __publicField(this, "enumValues", this.config.enum);
      }
      getSQLType() {
        return this.length === void 0 ? `char` : `char(${this.length})`;
      }
    };
    __publicField(MySqlChar, _a148, "MySqlChar");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/custom.js
function customType2(customTypeParams) {
  return (a9, b9) => {
    const { name: name3, config } = getColumnNameAndConfig(a9, b9);
    return new MySqlCustomColumnBuilder(name3, config, customTypeParams);
  };
}
var _a149, _b117, MySqlCustomColumnBuilder, _a150, _b118, MySqlCustomColumn;
var init_custom2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/custom.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlCustomColumnBuilder = class extends (_b117 = MySqlColumnBuilder, _a149 = entityKind, _b117) {
      constructor(name3, fieldConfig, customTypeParams) {
        super(name3, "custom", "MySqlCustomColumn");
        this.config.fieldConfig = fieldConfig;
        this.config.customTypeParams = customTypeParams;
      }
      /** @internal */
      build(table6) {
        return new MySqlCustomColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlCustomColumnBuilder, _a149, "MySqlCustomColumnBuilder");
    MySqlCustomColumn = class extends (_b118 = MySqlColumn, _a150 = entityKind, _b118) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "sqlName");
        __publicField(this, "mapTo");
        __publicField(this, "mapFrom");
        this.sqlName = config.customTypeParams.dataType(config.fieldConfig);
        this.mapTo = config.customTypeParams.toDriver;
        this.mapFrom = config.customTypeParams.fromDriver;
      }
      getSQLType() {
        return this.sqlName;
      }
      mapFromDriverValue(value) {
        return typeof this.mapFrom === "function" ? this.mapFrom(value) : value;
      }
      mapToDriverValue(value) {
        return typeof this.mapTo === "function" ? this.mapTo(value) : value;
      }
    };
    __publicField(MySqlCustomColumn, _a150, "MySqlCustomColumn");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/date.js
function date2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new MySqlDateStringBuilder(name3);
  }
  return new MySqlDateBuilder(name3);
}
var _a151, _b119, MySqlDateBuilder, _a152, _b120, MySqlDate, _a153, _b121, MySqlDateStringBuilder, _a154, _b122, MySqlDateString;
var init_date2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/date.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlDateBuilder = class extends (_b119 = MySqlColumnBuilder, _a151 = entityKind, _b119) {
      constructor(name3) {
        super(name3, "date", "MySqlDate");
      }
      /** @internal */
      build(table6) {
        return new MySqlDate(table6, this.config);
      }
    };
    __publicField(MySqlDateBuilder, _a151, "MySqlDateBuilder");
    MySqlDate = class extends (_b120 = MySqlColumn, _a152 = entityKind, _b120) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return `date`;
      }
      mapFromDriverValue(value) {
        return new Date(value);
      }
    };
    __publicField(MySqlDate, _a152, "MySqlDate");
    MySqlDateStringBuilder = class extends (_b121 = MySqlColumnBuilder, _a153 = entityKind, _b121) {
      constructor(name3) {
        super(name3, "string", "MySqlDateString");
      }
      /** @internal */
      build(table6) {
        return new MySqlDateString(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlDateStringBuilder, _a153, "MySqlDateStringBuilder");
    MySqlDateString = class extends (_b122 = MySqlColumn, _a154 = entityKind, _b122) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return `date`;
      }
    };
    __publicField(MySqlDateString, _a154, "MySqlDateString");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/datetime.js
function datetime(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new MySqlDateTimeStringBuilder(name3, config);
  }
  return new MySqlDateTimeBuilder(name3, config);
}
var _a155, _b123, MySqlDateTimeBuilder, _a156, _b124, MySqlDateTime, _a157, _b125, MySqlDateTimeStringBuilder, _a158, _b126, MySqlDateTimeString;
var init_datetime = __esm({
  "../drizzle-orm/dist/mysql-core/columns/datetime.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlDateTimeBuilder = class extends (_b123 = MySqlColumnBuilder, _a155 = entityKind, _b123) {
      constructor(name3, config) {
        super(name3, "date", "MySqlDateTime");
        this.config.fsp = config?.fsp;
      }
      /** @internal */
      build(table6) {
        return new MySqlDateTime(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlDateTimeBuilder, _a155, "MySqlDateTimeBuilder");
    MySqlDateTime = class extends (_b124 = MySqlColumn, _a156 = entityKind, _b124) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "fsp");
        this.fsp = config.fsp;
      }
      getSQLType() {
        const precision = this.fsp === void 0 ? "" : `(${this.fsp})`;
        return `datetime${precision}`;
      }
      mapToDriverValue(value) {
        return value.toISOString().replace("T", " ").replace("Z", "");
      }
      mapFromDriverValue(value) {
        return /* @__PURE__ */ new Date(value.replace(" ", "T") + "Z");
      }
    };
    __publicField(MySqlDateTime, _a156, "MySqlDateTime");
    MySqlDateTimeStringBuilder = class extends (_b125 = MySqlColumnBuilder, _a157 = entityKind, _b125) {
      constructor(name3, config) {
        super(name3, "string", "MySqlDateTimeString");
        this.config.fsp = config?.fsp;
      }
      /** @internal */
      build(table6) {
        return new MySqlDateTimeString(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlDateTimeStringBuilder, _a157, "MySqlDateTimeStringBuilder");
    MySqlDateTimeString = class extends (_b126 = MySqlColumn, _a158 = entityKind, _b126) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "fsp");
        this.fsp = config.fsp;
      }
      getSQLType() {
        const precision = this.fsp === void 0 ? "" : `(${this.fsp})`;
        return `datetime${precision}`;
      }
    };
    __publicField(MySqlDateTimeString, _a158, "MySqlDateTimeString");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/decimal.js
function decimal2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  const mode = config?.mode;
  return mode === "number" ? new MySqlDecimalNumberBuilder(name3, config) : mode === "bigint" ? new MySqlDecimalBigIntBuilder(name3, config) : new MySqlDecimalBuilder(name3, config);
}
var _a159, _b127, MySqlDecimalBuilder, _a160, _b128, MySqlDecimal, _a161, _b129, MySqlDecimalNumberBuilder, _a162, _b130, MySqlDecimalNumber, _a163, _b131, MySqlDecimalBigIntBuilder, _a164, _b132, MySqlDecimalBigInt;
var init_decimal = __esm({
  "../drizzle-orm/dist/mysql-core/columns/decimal.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlDecimalBuilder = class extends (_b127 = MySqlColumnBuilderWithAutoIncrement, _a159 = entityKind, _b127) {
      constructor(name3, config) {
        super(name3, "string", "MySqlDecimal");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlDecimal(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlDecimalBuilder, _a159, "MySqlDecimalBuilder");
    MySqlDecimal = class extends (_b128 = MySqlColumnWithAutoIncrement, _a160 = entityKind, _b128) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        return String(value);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `decimal(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "decimal";
        } else {
          type += `decimal(${this.precision})`;
        }
        type = type === "decimal(10,0)" || type === "decimal(10)" ? "decimal" : type;
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(MySqlDecimal, _a160, "MySqlDecimal");
    MySqlDecimalNumberBuilder = class extends (_b129 = MySqlColumnBuilderWithAutoIncrement, _a161 = entityKind, _b129) {
      constructor(name3, config) {
        super(name3, "number", "MySqlDecimalNumber");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlDecimalNumber(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlDecimalNumberBuilder, _a161, "MySqlDecimalNumberBuilder");
    MySqlDecimalNumber = class extends (_b130 = MySqlColumnWithAutoIncrement, _a162 = entityKind, _b130) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
        __publicField(this, "mapToDriverValue", String);
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") return value;
        return Number(value);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `decimal(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "decimal";
        } else {
          type += `decimal(${this.precision})`;
        }
        type = type === "decimal(10,0)" || type === "decimal(10)" ? "decimal" : type;
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(MySqlDecimalNumber, _a162, "MySqlDecimalNumber");
    MySqlDecimalBigIntBuilder = class extends (_b131 = MySqlColumnBuilderWithAutoIncrement, _a163 = entityKind, _b131) {
      constructor(name3, config) {
        super(name3, "bigint", "MySqlDecimalBigInt");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlDecimalBigInt(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlDecimalBigIntBuilder, _a163, "MySqlDecimalBigIntBuilder");
    MySqlDecimalBigInt = class extends (_b132 = MySqlColumnWithAutoIncrement, _a164 = entityKind, _b132) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
        __publicField(this, "mapFromDriverValue", BigInt);
        __publicField(this, "mapToDriverValue", String);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `decimal(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "decimal";
        } else {
          type += `decimal(${this.precision})`;
        }
        type = type === "decimal(10,0)" || type === "decimal(10)" ? "decimal" : type;
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(MySqlDecimalBigInt, _a164, "MySqlDecimalBigInt");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/double.js
function double(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlDoubleBuilder(name3, config);
}
var _a165, _b133, MySqlDoubleBuilder, _a166, _b134, MySqlDouble;
var init_double = __esm({
  "../drizzle-orm/dist/mysql-core/columns/double.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlDoubleBuilder = class extends (_b133 = MySqlColumnBuilderWithAutoIncrement, _a165 = entityKind, _b133) {
      constructor(name3, config) {
        super(name3, "number", "MySqlDouble");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlDouble(table6, this.config);
      }
    };
    __publicField(MySqlDoubleBuilder, _a165, "MySqlDoubleBuilder");
    MySqlDouble = class extends (_b134 = MySqlColumnWithAutoIncrement, _a166 = entityKind, _b134) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `double(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "double";
        } else {
          type += `double(${this.precision})`;
        }
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(MySqlDouble, _a166, "MySqlDouble");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/enum.js
function mysqlEnum(a9, b9) {
  if (typeof a9 === "string" && Array.isArray(b9) || Array.isArray(a9)) {
    const name3 = typeof a9 === "string" && a9.length > 0 ? a9 : "";
    const values2 = (typeof a9 === "string" ? b9 : a9) ?? [];
    if (values2.length === 0) {
      throw new Error(`You have an empty array for "${name3}" enum values`);
    }
    return new MySqlEnumColumnBuilder(name3, values2);
  }
  if (typeof a9 === "string" && typeof b9 === "object" || typeof a9 === "object") {
    const name3 = typeof a9 === "object" ? "" : a9;
    const values2 = typeof a9 === "object" ? Object.values(a9) : typeof b9 === "object" ? Object.values(b9) : [];
    if (values2.length === 0) {
      throw new Error(`You have an empty array for "${name3}" enum values`);
    }
    return new MySqlEnumObjectColumnBuilder(name3, values2);
  }
}
var _a167, _b135, MySqlEnumColumnBuilder, _a168, _b136, MySqlEnumColumn, _a169, _b137, MySqlEnumObjectColumnBuilder, _a170, _b138, MySqlEnumObjectColumn;
var init_enum2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/enum.js"() {
    "use strict";
    init_entity();
    init_common2();
    MySqlEnumColumnBuilder = class extends (_b135 = MySqlColumnBuilder, _a167 = entityKind, _b135) {
      constructor(name3, values2) {
        super(name3, "string", "MySqlEnumColumn");
        this.config.enumValues = values2;
      }
      /** @internal */
      build(table6) {
        return new MySqlEnumColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlEnumColumnBuilder, _a167, "MySqlEnumColumnBuilder");
    MySqlEnumColumn = class extends (_b136 = MySqlColumn, _a168 = entityKind, _b136) {
      constructor() {
        super(...arguments);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return `enum(${this.enumValues.map((value) => `'${value}'`).join(",")})`;
      }
    };
    __publicField(MySqlEnumColumn, _a168, "MySqlEnumColumn");
    MySqlEnumObjectColumnBuilder = class extends (_b137 = MySqlColumnBuilder, _a169 = entityKind, _b137) {
      constructor(name3, values2) {
        super(name3, "string", "MySqlEnumObjectColumn");
        this.config.enumValues = values2;
      }
      /** @internal */
      build(table6) {
        return new MySqlEnumObjectColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlEnumObjectColumnBuilder, _a169, "MySqlEnumObjectColumnBuilder");
    MySqlEnumObjectColumn = class extends (_b138 = MySqlColumn, _a170 = entityKind, _b138) {
      constructor() {
        super(...arguments);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return `enum(${this.enumValues.map((value) => `'${value}'`).join(",")})`;
      }
    };
    __publicField(MySqlEnumObjectColumn, _a170, "MySqlEnumObjectColumn");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/float.js
function float(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlFloatBuilder(name3, config);
}
var _a171, _b139, MySqlFloatBuilder, _a172, _b140, MySqlFloat;
var init_float = __esm({
  "../drizzle-orm/dist/mysql-core/columns/float.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlFloatBuilder = class extends (_b139 = MySqlColumnBuilderWithAutoIncrement, _a171 = entityKind, _b139) {
      constructor(name3, config) {
        super(name3, "number", "MySqlFloat");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new MySqlFloat(table6, this.config);
      }
    };
    __publicField(MySqlFloatBuilder, _a171, "MySqlFloatBuilder");
    MySqlFloat = class extends (_b140 = MySqlColumnWithAutoIncrement, _a172 = entityKind, _b140) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `float(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "float";
        } else {
          type += `float(${this.precision})`;
        }
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(MySqlFloat, _a172, "MySqlFloat");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/int.js
function int(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlIntBuilder(name3, config);
}
var _a173, _b141, MySqlIntBuilder, _a174, _b142, MySqlInt;
var init_int = __esm({
  "../drizzle-orm/dist/mysql-core/columns/int.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlIntBuilder = class extends (_b141 = MySqlColumnBuilderWithAutoIncrement, _a173 = entityKind, _b141) {
      constructor(name3, config) {
        super(name3, "number", "MySqlInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new MySqlInt(table6, this.config);
      }
    };
    __publicField(MySqlIntBuilder, _a173, "MySqlIntBuilder");
    MySqlInt = class extends (_b142 = MySqlColumnWithAutoIncrement, _a174 = entityKind, _b142) {
      getSQLType() {
        return `int${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(MySqlInt, _a174, "MySqlInt");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/json.js
function json2(name3) {
  return new MySqlJsonBuilder(name3 ?? "");
}
var _a175, _b143, MySqlJsonBuilder, _a176, _b144, MySqlJson;
var init_json2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/json.js"() {
    "use strict";
    init_entity();
    init_common2();
    MySqlJsonBuilder = class extends (_b143 = MySqlColumnBuilder, _a175 = entityKind, _b143) {
      constructor(name3) {
        super(name3, "json", "MySqlJson");
      }
      /** @internal */
      build(table6) {
        return new MySqlJson(table6, this.config);
      }
    };
    __publicField(MySqlJsonBuilder, _a175, "MySqlJsonBuilder");
    MySqlJson = class extends (_b144 = MySqlColumn, _a176 = entityKind, _b144) {
      getSQLType() {
        return "json";
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
    };
    __publicField(MySqlJson, _a176, "MySqlJson");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/mediumint.js
function mediumint(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlMediumIntBuilder(name3, config);
}
var _a177, _b145, MySqlMediumIntBuilder, _a178, _b146, MySqlMediumInt;
var init_mediumint = __esm({
  "../drizzle-orm/dist/mysql-core/columns/mediumint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlMediumIntBuilder = class extends (_b145 = MySqlColumnBuilderWithAutoIncrement, _a177 = entityKind, _b145) {
      constructor(name3, config) {
        super(name3, "number", "MySqlMediumInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new MySqlMediumInt(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlMediumIntBuilder, _a177, "MySqlMediumIntBuilder");
    MySqlMediumInt = class extends (_b146 = MySqlColumnWithAutoIncrement, _a178 = entityKind, _b146) {
      getSQLType() {
        return `mediumint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(MySqlMediumInt, _a178, "MySqlMediumInt");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/real.js
function real2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlRealBuilder(name3, config);
}
var _a179, _b147, MySqlRealBuilder, _a180, _b148, MySqlReal;
var init_real2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/real.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlRealBuilder = class extends (_b147 = MySqlColumnBuilderWithAutoIncrement, _a179 = entityKind, _b147) {
      constructor(name3, config) {
        super(name3, "number", "MySqlReal");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
      }
      /** @internal */
      build(table6) {
        return new MySqlReal(table6, this.config);
      }
    };
    __publicField(MySqlRealBuilder, _a179, "MySqlRealBuilder");
    MySqlReal = class extends (_b148 = MySqlColumnWithAutoIncrement, _a180 = entityKind, _b148) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
      }
      getSQLType() {
        if (this.precision !== void 0 && this.scale !== void 0) {
          return `real(${this.precision}, ${this.scale})`;
        } else if (this.precision === void 0) {
          return "real";
        } else {
          return `real(${this.precision})`;
        }
      }
    };
    __publicField(MySqlReal, _a180, "MySqlReal");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/serial.js
function serial2(name3) {
  return new MySqlSerialBuilder(name3 ?? "");
}
var _a181, _b149, MySqlSerialBuilder, _a182, _b150, MySqlSerial;
var init_serial2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/serial.js"() {
    "use strict";
    init_entity();
    init_common2();
    MySqlSerialBuilder = class extends (_b149 = MySqlColumnBuilderWithAutoIncrement, _a181 = entityKind, _b149) {
      constructor(name3) {
        super(name3, "number", "MySqlSerial");
        this.config.hasDefault = true;
        this.config.autoIncrement = true;
      }
      /** @internal */
      build(table6) {
        return new MySqlSerial(table6, this.config);
      }
    };
    __publicField(MySqlSerialBuilder, _a181, "MySqlSerialBuilder");
    MySqlSerial = class extends (_b150 = MySqlColumnWithAutoIncrement, _a182 = entityKind, _b150) {
      getSQLType() {
        return "serial";
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(MySqlSerial, _a182, "MySqlSerial");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/smallint.js
function smallint2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlSmallIntBuilder(name3, config);
}
var _a183, _b151, MySqlSmallIntBuilder, _a184, _b152, MySqlSmallInt;
var init_smallint2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/smallint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlSmallIntBuilder = class extends (_b151 = MySqlColumnBuilderWithAutoIncrement, _a183 = entityKind, _b151) {
      constructor(name3, config) {
        super(name3, "number", "MySqlSmallInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new MySqlSmallInt(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlSmallIntBuilder, _a183, "MySqlSmallIntBuilder");
    MySqlSmallInt = class extends (_b152 = MySqlColumnWithAutoIncrement, _a184 = entityKind, _b152) {
      getSQLType() {
        return `smallint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(MySqlSmallInt, _a184, "MySqlSmallInt");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/text.js
function text2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlTextBuilder(name3, "text", config);
}
function tinytext(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlTextBuilder(name3, "tinytext", config);
}
function mediumtext(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlTextBuilder(name3, "mediumtext", config);
}
function longtext(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlTextBuilder(name3, "longtext", config);
}
var _a185, _b153, MySqlTextBuilder, _a186, _b154, MySqlText;
var init_text2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/text.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlTextBuilder = class extends (_b153 = MySqlColumnBuilder, _a185 = entityKind, _b153) {
      constructor(name3, textType, config) {
        super(name3, "string", "MySqlText");
        this.config.textType = textType;
        this.config.enumValues = config.enum;
      }
      /** @internal */
      build(table6) {
        return new MySqlText(table6, this.config);
      }
    };
    __publicField(MySqlTextBuilder, _a185, "MySqlTextBuilder");
    MySqlText = class extends (_b154 = MySqlColumn, _a186 = entityKind, _b154) {
      constructor() {
        super(...arguments);
        __publicField(this, "textType", this.config.textType);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return this.textType;
      }
    };
    __publicField(MySqlText, _a186, "MySqlText");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/time.js
function time2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlTimeBuilder(name3, config);
}
var _a187, _b155, MySqlTimeBuilder, _a188, _b156, MySqlTime;
var init_time2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/time.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlTimeBuilder = class extends (_b155 = MySqlColumnBuilder, _a187 = entityKind, _b155) {
      constructor(name3, config) {
        super(name3, "string", "MySqlTime");
        this.config.fsp = config?.fsp;
      }
      /** @internal */
      build(table6) {
        return new MySqlTime(table6, this.config);
      }
    };
    __publicField(MySqlTimeBuilder, _a187, "MySqlTimeBuilder");
    MySqlTime = class extends (_b156 = MySqlColumn, _a188 = entityKind, _b156) {
      constructor() {
        super(...arguments);
        __publicField(this, "fsp", this.config.fsp);
      }
      getSQLType() {
        const precision = this.fsp === void 0 ? "" : `(${this.fsp})`;
        return `time${precision}`;
      }
    };
    __publicField(MySqlTime, _a188, "MySqlTime");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/date.common.js
var _a189, _b157, MySqlDateColumnBaseBuilder, _a190, _b158, MySqlDateBaseColumn;
var init_date_common2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/date.common.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_common2();
    MySqlDateColumnBaseBuilder = class extends (_b157 = MySqlColumnBuilder, _a189 = entityKind, _b157) {
      defaultNow() {
        return this.default(sql`(now())`);
      }
      // "on update now" also adds an implicit default value to the column - https://dev.mysql.com/doc/refman/8.0/en/timestamp-initialization.html
      onUpdateNow() {
        this.config.hasOnUpdateNow = true;
        this.config.hasDefault = true;
        return this;
      }
    };
    __publicField(MySqlDateColumnBaseBuilder, _a189, "MySqlDateColumnBuilder");
    MySqlDateBaseColumn = class extends (_b158 = MySqlColumn, _a190 = entityKind, _b158) {
      constructor() {
        super(...arguments);
        __publicField(this, "hasOnUpdateNow", this.config.hasOnUpdateNow);
      }
    };
    __publicField(MySqlDateBaseColumn, _a190, "MySqlDateColumn");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/timestamp.js
function timestamp2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new MySqlTimestampStringBuilder(name3, config);
  }
  return new MySqlTimestampBuilder(name3, config);
}
var _a191, _b159, MySqlTimestampBuilder, _a192, _b160, MySqlTimestamp, _a193, _b161, MySqlTimestampStringBuilder, _a194, _b162, MySqlTimestampString;
var init_timestamp2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/timestamp.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_date_common2();
    MySqlTimestampBuilder = class extends (_b159 = MySqlDateColumnBaseBuilder, _a191 = entityKind, _b159) {
      constructor(name3, config) {
        super(name3, "date", "MySqlTimestamp");
        this.config.fsp = config?.fsp;
      }
      /** @internal */
      build(table6) {
        return new MySqlTimestamp(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlTimestampBuilder, _a191, "MySqlTimestampBuilder");
    MySqlTimestamp = class extends (_b160 = MySqlDateBaseColumn, _a192 = entityKind, _b160) {
      constructor() {
        super(...arguments);
        __publicField(this, "fsp", this.config.fsp);
      }
      getSQLType() {
        const precision = this.fsp === void 0 ? "" : `(${this.fsp})`;
        return `timestamp${precision}`;
      }
      mapFromDriverValue(value) {
        return /* @__PURE__ */ new Date(value + "+0000");
      }
      mapToDriverValue(value) {
        return value.toISOString().slice(0, -1).replace("T", " ");
      }
    };
    __publicField(MySqlTimestamp, _a192, "MySqlTimestamp");
    MySqlTimestampStringBuilder = class extends (_b161 = MySqlDateColumnBaseBuilder, _a193 = entityKind, _b161) {
      constructor(name3, config) {
        super(name3, "string", "MySqlTimestampString");
        this.config.fsp = config?.fsp;
      }
      /** @internal */
      build(table6) {
        return new MySqlTimestampString(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlTimestampStringBuilder, _a193, "MySqlTimestampStringBuilder");
    MySqlTimestampString = class extends (_b162 = MySqlDateBaseColumn, _a194 = entityKind, _b162) {
      constructor() {
        super(...arguments);
        __publicField(this, "fsp", this.config.fsp);
      }
      getSQLType() {
        const precision = this.fsp === void 0 ? "" : `(${this.fsp})`;
        return `timestamp${precision}`;
      }
    };
    __publicField(MySqlTimestampString, _a194, "MySqlTimestampString");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/tinyint.js
function tinyint(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlTinyIntBuilder(name3, config);
}
var _a195, _b163, MySqlTinyIntBuilder, _a196, _b164, MySqlTinyInt;
var init_tinyint = __esm({
  "../drizzle-orm/dist/mysql-core/columns/tinyint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlTinyIntBuilder = class extends (_b163 = MySqlColumnBuilderWithAutoIncrement, _a195 = entityKind, _b163) {
      constructor(name3, config) {
        super(name3, "number", "MySqlTinyInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new MySqlTinyInt(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlTinyIntBuilder, _a195, "MySqlTinyIntBuilder");
    MySqlTinyInt = class extends (_b164 = MySqlColumnWithAutoIncrement, _a196 = entityKind, _b164) {
      getSQLType() {
        return `tinyint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(MySqlTinyInt, _a196, "MySqlTinyInt");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/varbinary.js
function varbinary(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlVarBinaryBuilder(name3, config);
}
var _a197, _b165, MySqlVarBinaryBuilder, _a198, _b166, MySqlVarBinary;
var init_varbinary = __esm({
  "../drizzle-orm/dist/mysql-core/columns/varbinary.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlVarBinaryBuilder = class extends (_b165 = MySqlColumnBuilder, _a197 = entityKind, _b165) {
      /** @internal */
      constructor(name3, config) {
        super(name3, "string", "MySqlVarBinary");
        this.config.length = config?.length;
      }
      /** @internal */
      build(table6) {
        return new MySqlVarBinary(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlVarBinaryBuilder, _a197, "MySqlVarBinaryBuilder");
    MySqlVarBinary = class extends (_b166 = MySqlColumn, _a198 = entityKind, _b166) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        if (Buffer.isBuffer(value)) return value.toString();
        const str = [];
        for (const v11 of value) {
          str.push(v11 === 49 ? "1" : "0");
        }
        return str.join("");
      }
      getSQLType() {
        return this.length === void 0 ? `varbinary` : `varbinary(${this.length})`;
      }
    };
    __publicField(MySqlVarBinary, _a198, "MySqlVarBinary");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/varchar.js
function varchar2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new MySqlVarCharBuilder(name3, config);
}
var _a199, _b167, MySqlVarCharBuilder, _a200, _b168, MySqlVarChar;
var init_varchar2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/varchar.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common2();
    MySqlVarCharBuilder = class extends (_b167 = MySqlColumnBuilder, _a199 = entityKind, _b167) {
      /** @internal */
      constructor(name3, config) {
        super(name3, "string", "MySqlVarChar");
        this.config.length = config.length;
        this.config.enum = config.enum;
      }
      /** @internal */
      build(table6) {
        return new MySqlVarChar(
          table6,
          this.config
        );
      }
    };
    __publicField(MySqlVarCharBuilder, _a199, "MySqlVarCharBuilder");
    MySqlVarChar = class extends (_b168 = MySqlColumn, _a200 = entityKind, _b168) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
        __publicField(this, "enumValues", this.config.enum);
      }
      getSQLType() {
        return this.length === void 0 ? `varchar` : `varchar(${this.length})`;
      }
    };
    __publicField(MySqlVarChar, _a200, "MySqlVarChar");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/year.js
function year(name3) {
  return new MySqlYearBuilder(name3 ?? "");
}
var _a201, _b169, MySqlYearBuilder, _a202, _b170, MySqlYear;
var init_year = __esm({
  "../drizzle-orm/dist/mysql-core/columns/year.js"() {
    "use strict";
    init_entity();
    init_common2();
    MySqlYearBuilder = class extends (_b169 = MySqlColumnBuilder, _a201 = entityKind, _b169) {
      constructor(name3) {
        super(name3, "number", "MySqlYear");
      }
      /** @internal */
      build(table6) {
        return new MySqlYear(table6, this.config);
      }
    };
    __publicField(MySqlYearBuilder, _a201, "MySqlYearBuilder");
    MySqlYear = class extends (_b170 = MySqlColumn, _a202 = entityKind, _b170) {
      getSQLType() {
        return `year`;
      }
    };
    __publicField(MySqlYear, _a202, "MySqlYear");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/index.js
var init_columns = __esm({
  "../drizzle-orm/dist/mysql-core/columns/index.js"() {
    "use strict";
    init_bigint2();
    init_binary();
    init_boolean2();
    init_char2();
    init_common2();
    init_custom2();
    init_date2();
    init_datetime();
    init_decimal();
    init_double();
    init_enum2();
    init_float();
    init_int();
    init_json2();
    init_mediumint();
    init_real2();
    init_serial2();
    init_smallint2();
    init_text2();
    init_time2();
    init_timestamp2();
    init_tinyint();
    init_varbinary();
    init_varchar2();
    init_year();
  }
});

// ../drizzle-orm/dist/selection-proxy.js
var _a203, _SelectionProxyHandler, SelectionProxyHandler;
var init_selection_proxy = __esm({
  "../drizzle-orm/dist/selection-proxy.js"() {
    "use strict";
    init_alias();
    init_column();
    init_entity();
    init_sql();
    init_subquery();
    init_view_common();
    _a203 = entityKind;
    _SelectionProxyHandler = class _SelectionProxyHandler {
      constructor(config) {
        __publicField(this, "config");
        this.config = { ...config };
      }
      get(subquery, prop) {
        if (prop === "_") {
          return {
            ...subquery["_"],
            selectedFields: new Proxy(
              subquery._.selectedFields,
              this
            )
          };
        }
        if (prop === ViewBaseConfig) {
          return {
            ...subquery[ViewBaseConfig],
            selectedFields: new Proxy(
              subquery[ViewBaseConfig].selectedFields,
              this
            )
          };
        }
        if (typeof prop === "symbol") {
          return subquery[prop];
        }
        const columns = is(subquery, Subquery) ? subquery._.selectedFields : is(subquery, View) ? subquery[ViewBaseConfig].selectedFields : subquery;
        const value = columns[prop];
        if (is(value, SQL.Aliased)) {
          if (this.config.sqlAliasedBehavior === "sql" && !value.isSelectionField) {
            return value.sql;
          }
          const newValue = value.clone();
          newValue.isSelectionField = true;
          return newValue;
        }
        if (is(value, SQL)) {
          if (this.config.sqlBehavior === "sql") {
            return value;
          }
          throw new Error(
            `You tried to reference "${prop}" field from a subquery, which is a raw SQL field, but it doesn't have an alias declared. Please add an alias to the field using ".as('alias')" method.`
          );
        }
        if (is(value, Column)) {
          if (this.config.alias) {
            return new Proxy(
              value,
              new ColumnAliasProxyHandler(
                new Proxy(
                  value.table,
                  new TableAliasProxyHandler(this.config.alias, this.config.replaceOriginalName ?? false)
                )
              )
            );
          }
          return value;
        }
        if (typeof value !== "object" || value === null) {
          return value;
        }
        return new Proxy(value, new _SelectionProxyHandler(this.config));
      }
    };
    __publicField(_SelectionProxyHandler, _a203, "SelectionProxyHandler");
    SelectionProxyHandler = _SelectionProxyHandler;
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/count.js
var _a204, _b171, _c4, _MySqlCountBuilder, MySqlCountBuilder;
var init_count = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/count.js"() {
    "use strict";
    init_entity();
    init_sql();
    _MySqlCountBuilder = class _MySqlCountBuilder extends (_c4 = SQL, _b171 = entityKind, _a204 = Symbol.toStringTag, _c4) {
      constructor(params) {
        super(_MySqlCountBuilder.buildEmbeddedCount(params.source, params.filters).queryChunks);
        __publicField(this, "sql");
        __publicField(this, _a204, "MySqlCountBuilder");
        __publicField(this, "session");
        this.params = params;
        this.mapWith(Number);
        this.session = params.session;
        this.sql = _MySqlCountBuilder.buildCount(
          params.source,
          params.filters
        );
      }
      static buildEmbeddedCount(source, filters) {
        return sql`(select count(*) from ${source}${sql.raw(" where ").if(filters)}${filters})`;
      }
      static buildCount(source, filters) {
        return sql`select count(*) as count from ${source}${sql.raw(" where ").if(filters)}${filters}`;
      }
      then(onfulfilled, onrejected) {
        return Promise.resolve(this.session.count(this.sql)).then(
          onfulfilled,
          onrejected
        );
      }
      catch(onRejected) {
        return this.then(void 0, onRejected);
      }
      finally(onFinally) {
        return this.then(
          (value) => {
            onFinally?.();
            return value;
          },
          (reason) => {
            onFinally?.();
            throw reason;
          }
        );
      }
    };
    __publicField(_MySqlCountBuilder, _b171, "MySqlCountBuilder");
    MySqlCountBuilder = _MySqlCountBuilder;
  }
});

// ../drizzle-orm/dist/mysql-core/indexes.js
var _a205, IndexBuilderOn, _a206, IndexBuilder, _a207, Index;
var init_indexes = __esm({
  "../drizzle-orm/dist/mysql-core/indexes.js"() {
    "use strict";
    init_entity();
    _a205 = entityKind;
    IndexBuilderOn = class {
      constructor(name3, unique2) {
        this.name = name3;
        this.unique = unique2;
      }
      on(...columns) {
        return new IndexBuilder(this.name, columns, this.unique);
      }
    };
    __publicField(IndexBuilderOn, _a205, "MySqlIndexBuilderOn");
    _a206 = entityKind;
    IndexBuilder = class {
      constructor(name3, columns, unique2) {
        /** @internal */
        __publicField(this, "config");
        this.config = {
          name: name3,
          columns,
          unique: unique2
        };
      }
      using(using) {
        this.config.using = using;
        return this;
      }
      algorythm(algorythm) {
        this.config.algorythm = algorythm;
        return this;
      }
      lock(lock) {
        this.config.lock = lock;
        return this;
      }
      /** @internal */
      build(table6) {
        return new Index(this.config, table6);
      }
    };
    __publicField(IndexBuilder, _a206, "MySqlIndexBuilder");
    _a207 = entityKind;
    Index = class {
      constructor(config, table6) {
        __publicField(this, "config");
        this.config = { ...config, table: table6 };
      }
    };
    __publicField(Index, _a207, "MySqlIndex");
  }
});

// ../drizzle-orm/dist/mysql-core/columns/all.js
function getMySqlColumnBuilders() {
  return {
    bigint: bigint2,
    binary: binary2,
    boolean: boolean2,
    char: char2,
    customType: customType2,
    date: date2,
    datetime,
    decimal: decimal2,
    double,
    mysqlEnum,
    float,
    int,
    json: json2,
    mediumint,
    real: real2,
    serial: serial2,
    smallint: smallint2,
    text: text2,
    time: time2,
    timestamp: timestamp2,
    tinyint,
    varbinary,
    varchar: varchar2,
    year,
    longtext,
    mediumtext,
    tinytext
  };
}
var init_all2 = __esm({
  "../drizzle-orm/dist/mysql-core/columns/all.js"() {
    "use strict";
    init_bigint2();
    init_binary();
    init_boolean2();
    init_char2();
    init_custom2();
    init_date2();
    init_datetime();
    init_decimal();
    init_double();
    init_enum2();
    init_float();
    init_int();
    init_json2();
    init_mediumint();
    init_real2();
    init_serial2();
    init_smallint2();
    init_text2();
    init_time2();
    init_timestamp2();
    init_tinyint();
    init_varbinary();
    init_varchar2();
    init_year();
  }
});

// ../drizzle-orm/dist/mysql-core/table.js
function mysqlTableWithSchema(name3, columns, extraConfig, schema6, baseName = name3) {
  const rawTable = new MySqlTable(name3, schema6, baseName);
  const parsedColumns = typeof columns === "function" ? columns(getMySqlColumnBuilders()) : columns;
  const builtColumns = Object.fromEntries(
    Object.entries(parsedColumns).map(([name22, colBuilderBase]) => {
      const colBuilder = colBuilderBase;
      colBuilder.setName(name22);
      const column6 = colBuilder.build(rawTable);
      rawTable[InlineForeignKeys2].push(...colBuilder.buildForeignKeys(column6, rawTable));
      return [name22, column6];
    })
  );
  const table6 = Object.assign(rawTable, builtColumns);
  table6[Table.Symbol.Columns] = builtColumns;
  table6[Table.Symbol.ExtraConfigColumns] = builtColumns;
  if (extraConfig) {
    table6[MySqlTable.Symbol.ExtraConfigBuilder] = extraConfig;
  }
  return table6;
}
var InlineForeignKeys2, _a208, _b172, _c5, _d3, _e3, MySqlTable, mysqlTable;
var init_table3 = __esm({
  "../drizzle-orm/dist/mysql-core/table.js"() {
    "use strict";
    init_entity();
    init_table();
    init_all2();
    InlineForeignKeys2 = Symbol.for("drizzle:MySqlInlineForeignKeys");
    MySqlTable = class extends (_e3 = Table, _d3 = entityKind, _c5 = Table.Symbol.Columns, _b172 = InlineForeignKeys2, _a208 = Table.Symbol.ExtraConfigBuilder, _e3) {
      constructor() {
        super(...arguments);
        /** @internal */
        __publicField(this, _c5);
        /** @internal */
        __publicField(this, _b172, []);
        /** @internal */
        __publicField(this, _a208);
      }
    };
    __publicField(MySqlTable, _d3, "MySqlTable");
    /** @internal */
    __publicField(MySqlTable, "Symbol", Object.assign({}, Table.Symbol, {
      InlineForeignKeys: InlineForeignKeys2
    }));
    mysqlTable = (name3, columns, extraConfig) => {
      return mysqlTableWithSchema(name3, columns, extraConfig, void 0, name3);
    };
  }
});

// ../drizzle-orm/dist/mysql-core/primary-keys.js
var _a209, PrimaryKeyBuilder2, _a210, PrimaryKey2;
var init_primary_keys2 = __esm({
  "../drizzle-orm/dist/mysql-core/primary-keys.js"() {
    "use strict";
    init_entity();
    init_table3();
    _a209 = entityKind;
    PrimaryKeyBuilder2 = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        /** @internal */
        __publicField(this, "name");
        this.columns = columns;
        this.name = name3;
      }
      /** @internal */
      build(table6) {
        return new PrimaryKey2(table6, this.columns, this.name);
      }
    };
    __publicField(PrimaryKeyBuilder2, _a209, "MySqlPrimaryKeyBuilder");
    _a210 = entityKind;
    PrimaryKey2 = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        this.table = table6;
        this.columns = columns;
        this.name = name3;
      }
      getName() {
        return this.name ?? `${this.table[MySqlTable.Symbol.Name]}_${this.columns.map((column6) => column6.name).join("_")}_pk`;
      }
    };
    __publicField(PrimaryKey2, _a210, "MySqlPrimaryKey");
  }
});

// ../drizzle-orm/dist/mysql-core/view-common.js
var MySqlViewConfig;
var init_view_common2 = __esm({
  "../drizzle-orm/dist/mysql-core/view-common.js"() {
    "use strict";
    MySqlViewConfig = Symbol.for("drizzle:MySqlViewConfig");
  }
});

// ../drizzle-orm/dist/mysql-core/utils.js
function extractUsedTable(table6) {
  if (is(table6, MySqlTable)) {
    return [`${table6[Table.Symbol.BaseName]}`];
  }
  if (is(table6, Subquery)) {
    return table6._.usedTables ?? [];
  }
  if (is(table6, SQL)) {
    return table6.usedTables ?? [];
  }
  return [];
}
function getTableConfig(table6) {
  const columns = Object.values(table6[MySqlTable.Symbol.Columns]);
  const indexes = [];
  const checks = [];
  const primaryKeys = [];
  const uniqueConstraints = [];
  const foreignKeys = Object.values(table6[MySqlTable.Symbol.InlineForeignKeys]);
  const name3 = table6[Table.Symbol.Name];
  const schema6 = table6[Table.Symbol.Schema];
  const baseName = table6[Table.Symbol.BaseName];
  const extraConfigBuilder = table6[MySqlTable.Symbol.ExtraConfigBuilder];
  if (extraConfigBuilder !== void 0) {
    const extraConfig = extraConfigBuilder(table6[MySqlTable.Symbol.Columns]);
    const extraValues = Array.isArray(extraConfig) ? extraConfig.flat(1) : Object.values(extraConfig);
    for (const builder of Object.values(extraValues)) {
      if (is(builder, IndexBuilder)) {
        indexes.push(builder.build(table6));
      } else if (is(builder, CheckBuilder)) {
        checks.push(builder.build(table6));
      } else if (is(builder, UniqueConstraintBuilder2)) {
        uniqueConstraints.push(builder.build(table6));
      } else if (is(builder, PrimaryKeyBuilder2)) {
        primaryKeys.push(builder.build(table6));
      } else if (is(builder, ForeignKeyBuilder2)) {
        foreignKeys.push(builder.build(table6));
      }
    }
  }
  return {
    columns,
    indexes,
    foreignKeys,
    checks,
    primaryKeys,
    uniqueConstraints,
    name: name3,
    schema: schema6,
    baseName
  };
}
function getViewConfig(view5) {
  return {
    ...view5[ViewBaseConfig],
    ...view5[MySqlViewConfig]
  };
}
function convertIndexToString(indexes) {
  return indexes.map((idx) => {
    return typeof idx === "object" ? idx.config.name : idx;
  });
}
function toArray(value) {
  return Array.isArray(value) ? value : [value];
}
var init_utils3 = __esm({
  "../drizzle-orm/dist/mysql-core/utils.js"() {
    "use strict";
    init_entity();
    init_dist();
    init_subquery();
    init_table();
    init_view_common();
    init_checks();
    init_foreign_keys2();
    init_indexes();
    init_primary_keys2();
    init_table3();
    init_unique_constraint2();
    init_view_common2();
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/delete.js
var _a211, _b173, MySqlDeleteBase;
var init_delete = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/delete.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table();
    init_utils3();
    MySqlDeleteBase = class extends (_b173 = QueryPromise, _a211 = entityKind, _b173) {
      constructor(table6, session, dialect6, withList) {
        super();
        __publicField(this, "config");
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, withList };
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will delete only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be deleted.
       *
       * ```ts
       * // Delete all cars with green color
       * db.delete(cars).where(eq(cars.color, 'green'));
       * // or
       * db.delete(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Delete all BMW cars with a green color
       * db.delete(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Delete all cars with the green or blue color
       * db.delete(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.table[Table.Symbol.Columns],
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          this.config.orderBy = orderByArray;
        } else {
          const orderByArray = columns;
          this.config.orderBy = orderByArray;
        }
        return this;
      }
      limit(limit) {
        this.config.limit = limit;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildDeleteQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      prepare() {
        return this.session.prepareQuery(
          this.dialect.sqlToQuery(this.getSQL()),
          this.config.returning,
          void 0,
          void 0,
          void 0,
          {
            type: "delete",
            tables: extractUsedTable(this.config.table)
          }
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(MySqlDeleteBase, _a211, "MySqlDelete");
  }
});

// ../drizzle-orm/dist/casing.js
function toSnakeCase(input) {
  const words = input.replace(/['\u2019]/g, "").match(/[\da-z]+|[A-Z]+(?![a-z])|[A-Z][\da-z]+/g) ?? [];
  return words.map((word) => word.toLowerCase()).join("_");
}
function toCamelCase(input) {
  const words = input.replace(/['\u2019]/g, "").match(/[\da-z]+|[A-Z]+(?![a-z])|[A-Z][\da-z]+/g) ?? [];
  return words.reduce((acc, word, i8) => {
    const formattedWord = i8 === 0 ? word.toLowerCase() : `${word[0].toUpperCase()}${word.slice(1)}`;
    return acc + formattedWord;
  }, "");
}
function noopCase(input) {
  return input;
}
var _a212, CasingCache;
var init_casing = __esm({
  "../drizzle-orm/dist/casing.js"() {
    "use strict";
    init_entity();
    init_table();
    _a212 = entityKind;
    CasingCache = class {
      constructor(casing2) {
        /** @internal */
        __publicField(this, "cache", {});
        __publicField(this, "cachedTables", {});
        __publicField(this, "convert");
        this.convert = casing2 === "snake_case" ? toSnakeCase : casing2 === "camelCase" ? toCamelCase : noopCase;
      }
      getColumnCasing(column6) {
        if (!column6.keyAsName) return column6.name;
        const schema6 = column6.table[Table.Symbol.Schema] ?? "public";
        const tableName = column6.table[Table.Symbol.OriginalName];
        const key = `${schema6}.${tableName}.${column6.name}`;
        if (!this.cache[key]) {
          this.cacheTable(column6.table);
        }
        return this.cache[key];
      }
      cacheTable(table6) {
        const schema6 = table6[Table.Symbol.Schema] ?? "public";
        const tableName = table6[Table.Symbol.OriginalName];
        const tableKey2 = `${schema6}.${tableName}`;
        if (!this.cachedTables[tableKey2]) {
          for (const column6 of Object.values(table6[Table.Symbol.Columns])) {
            const columnKey = `${tableKey2}.${column6.name}`;
            this.cache[columnKey] = this.convert(column6.name);
          }
          this.cachedTables[tableKey2] = true;
        }
      }
      clearCache() {
        this.cache = {};
        this.cachedTables = {};
      }
    };
    __publicField(CasingCache, _a212, "CasingCache");
  }
});

// ../drizzle-orm/dist/mysql-core/view-base.js
var _a213, _b174, MySqlViewBase;
var init_view_base = __esm({
  "../drizzle-orm/dist/mysql-core/view-base.js"() {
    "use strict";
    init_entity();
    init_sql();
    MySqlViewBase = class extends (_b174 = View, _a213 = entityKind, _b174) {
    };
    __publicField(MySqlViewBase, _a213, "MySqlViewBase");
  }
});

// ../drizzle-orm/dist/mysql-core/dialect.js
var _a214, MySqlDialect;
var init_dialect = __esm({
  "../drizzle-orm/dist/mysql-core/dialect.js"() {
    "use strict";
    init_alias();
    init_casing();
    init_column();
    init_entity();
    init_errors();
    init_relations();
    init_expressions();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_common2();
    init_table3();
    init_view_base();
    _a214 = entityKind;
    MySqlDialect = class {
      constructor(config) {
        /** @internal */
        __publicField(this, "casing");
        this.casing = new CasingCache(config?.casing);
      }
      async migrate(migrations, session, config) {
        const migrationsTable = config.migrationsTable ?? "__drizzle_migrations";
        const migrationTableCreate = sql`
			create table if not exists ${sql.identifier(migrationsTable)} (
				id serial primary key,
				hash text not null,
				created_at bigint
			)
		`;
        await session.execute(migrationTableCreate);
        const dbMigrations = await session.all(
          sql`select id, hash, created_at from ${sql.identifier(migrationsTable)} order by created_at desc limit 1`
        );
        const lastDbMigration = dbMigrations[0];
        await session.transaction(async (tx) => {
          for (const migration of migrations) {
            if (!lastDbMigration || Number(lastDbMigration.created_at) < migration.folderMillis) {
              for (const stmt of migration.sql) {
                await tx.execute(sql.raw(stmt));
              }
              await tx.execute(
                sql`insert into ${sql.identifier(migrationsTable)} (\`hash\`, \`created_at\`) values(${migration.hash}, ${migration.folderMillis})`
              );
            }
          }
        });
      }
      escapeName(name3) {
        return `\`${name3}\``;
      }
      escapeParam(_num) {
        return `?`;
      }
      escapeString(str) {
        return `'${str.replace(/'/g, "''")}'`;
      }
      buildWithCTE(queries) {
        if (!queries?.length) return void 0;
        const withSqlChunks = [sql`with `];
        for (const [i8, w10] of queries.entries()) {
          withSqlChunks.push(sql`${sql.identifier(w10._.alias)} as (${w10._.sql})`);
          if (i8 < queries.length - 1) {
            withSqlChunks.push(sql`, `);
          }
        }
        withSqlChunks.push(sql` `);
        return sql.join(withSqlChunks);
      }
      buildDeleteQuery({ table: table6, where, returning, withList, limit, orderBy }) {
        const withSql = this.buildWithCTE(withList);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        return sql`${withSql}delete from ${table6}${whereSql}${orderBySql}${limitSql}${returningSql}`;
      }
      buildUpdateSet(table6, set) {
        const tableColumns = table6[Table.Symbol.Columns];
        const columnNames = Object.keys(tableColumns).filter(
          (colName) => set[colName] !== void 0 || tableColumns[colName]?.onUpdateFn !== void 0
        );
        const setSize = columnNames.length;
        return sql.join(columnNames.flatMap((colName, i8) => {
          const col = tableColumns[colName];
          const value = set[colName] ?? sql.param(col.onUpdateFn(), col);
          const res = sql`${sql.identifier(this.casing.getColumnCasing(col))} = ${value}`;
          if (i8 < setSize - 1) {
            return [res, sql.raw(", ")];
          }
          return [res];
        }));
      }
      buildUpdateQuery({ table: table6, set, where, returning, withList, limit, orderBy }) {
        const withSql = this.buildWithCTE(withList);
        const setSql = this.buildUpdateSet(table6, set);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        return sql`${withSql}update ${table6} set ${setSql}${whereSql}${orderBySql}${limitSql}${returningSql}`;
      }
      /**
       * Builds selection SQL with provided fields/expressions
       *
       * Examples:
       *
       * `select <selection> from`
       *
       * `insert ... returning <selection>`
       *
       * If `isSingleTable` is true, then columns won't be prefixed with table name
       */
      buildSelection(fields, { isSingleTable = false } = {}) {
        const columnsLen = fields.length;
        const chunks = fields.flatMap(({ field }, i8) => {
          const chunk = [];
          if (is(field, SQL.Aliased) && field.isSelectionField) {
            chunk.push(sql.identifier(field.fieldAlias));
          } else if (is(field, SQL.Aliased) || is(field, SQL)) {
            const query = is(field, SQL.Aliased) ? field.sql : field;
            if (isSingleTable) {
              chunk.push(
                new SQL(
                  query.queryChunks.map((c6) => {
                    if (is(c6, MySqlColumn)) {
                      return sql.identifier(this.casing.getColumnCasing(c6));
                    }
                    return c6;
                  })
                )
              );
            } else {
              chunk.push(query);
            }
            if (is(field, SQL.Aliased)) {
              chunk.push(sql` as ${sql.identifier(field.fieldAlias)}`);
            }
          } else if (is(field, Column)) {
            if (isSingleTable) {
              chunk.push(sql.identifier(this.casing.getColumnCasing(field)));
            } else {
              chunk.push(field);
            }
          }
          if (i8 < columnsLen - 1) {
            chunk.push(sql`, `);
          }
          return chunk;
        });
        return sql.join(chunks);
      }
      buildLimit(limit) {
        return typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
      }
      buildOrderBy(orderBy) {
        return orderBy && orderBy.length > 0 ? sql` order by ${sql.join(orderBy, sql`, `)}` : void 0;
      }
      buildIndex({
        indexes,
        indexFor
      }) {
        return indexes && indexes.length > 0 ? sql` ${sql.raw(indexFor)} INDEX (${sql.raw(indexes.join(`, `))})` : void 0;
      }
      buildSelectQuery({
        withList,
        fields,
        fieldsFlat,
        where,
        having,
        table: table6,
        joins,
        orderBy,
        groupBy,
        limit,
        offset,
        lockingClause,
        distinct,
        setOperators,
        useIndex,
        forceIndex,
        ignoreIndex
      }) {
        const fieldsList = fieldsFlat ?? orderSelectedFields(fields);
        for (const f9 of fieldsList) {
          if (is(f9.field, Column) && getTableName(f9.field.table) !== (is(table6, Subquery) ? table6._.alias : is(table6, MySqlViewBase) ? table6[ViewBaseConfig].name : is(table6, SQL) ? void 0 : getTableName(table6)) && !((table22) => joins?.some(
            ({ alias: alias2 }) => alias2 === (table22[Table.Symbol.IsAlias] ? getTableName(table22) : table22[Table.Symbol.BaseName])
          ))(f9.field.table)) {
            const tableName = getTableName(f9.field.table);
            throw new Error(
              `Your "${f9.path.join("->")}" field references a column "${tableName}"."${f9.field.name}", but the table "${tableName}" is not part of the query! Did you forget to join it?`
            );
          }
        }
        const isSingleTable = !joins || joins.length === 0;
        const withSql = this.buildWithCTE(withList);
        const distinctSql = distinct ? sql` distinct` : void 0;
        const selection = this.buildSelection(fieldsList, { isSingleTable });
        const tableSql = (() => {
          if (is(table6, Table) && table6[Table.Symbol.IsAlias]) {
            return sql`${sql`${sql.identifier(table6[Table.Symbol.Schema] ?? "")}.`.if(table6[Table.Symbol.Schema])}${sql.identifier(table6[Table.Symbol.OriginalName])} ${sql.identifier(table6[Table.Symbol.Name])}`;
          }
          return table6;
        })();
        const joinsArray = [];
        if (joins) {
          for (const [index7, joinMeta] of joins.entries()) {
            if (index7 === 0) {
              joinsArray.push(sql` `);
            }
            const table22 = joinMeta.table;
            const lateralSql = joinMeta.lateral ? sql` lateral` : void 0;
            const onSql = joinMeta.on ? sql` on ${joinMeta.on}` : void 0;
            if (is(table22, MySqlTable)) {
              const tableName = table22[MySqlTable.Symbol.Name];
              const tableSchema = table22[MySqlTable.Symbol.Schema];
              const origTableName = table22[MySqlTable.Symbol.OriginalName];
              const alias2 = tableName === origTableName ? void 0 : joinMeta.alias;
              const useIndexSql2 = this.buildIndex({ indexes: joinMeta.useIndex, indexFor: "USE" });
              const forceIndexSql2 = this.buildIndex({ indexes: joinMeta.forceIndex, indexFor: "FORCE" });
              const ignoreIndexSql2 = this.buildIndex({ indexes: joinMeta.ignoreIndex, indexFor: "IGNORE" });
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${tableSchema ? sql`${sql.identifier(tableSchema)}.` : void 0}${sql.identifier(origTableName)}${useIndexSql2}${forceIndexSql2}${ignoreIndexSql2}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
              );
            } else if (is(table22, View)) {
              const viewName = table22[ViewBaseConfig].name;
              const viewSchema = table22[ViewBaseConfig].schema;
              const origViewName = table22[ViewBaseConfig].originalName;
              const alias2 = viewName === origViewName ? void 0 : joinMeta.alias;
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${viewSchema ? sql`${sql.identifier(viewSchema)}.` : void 0}${sql.identifier(origViewName)}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
              );
            } else {
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${table22}${onSql}`
              );
            }
            if (index7 < joins.length - 1) {
              joinsArray.push(sql` `);
            }
          }
        }
        const joinsSql = sql.join(joinsArray);
        const whereSql = where ? sql` where ${where}` : void 0;
        const havingSql = having ? sql` having ${having}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const groupBySql = groupBy && groupBy.length > 0 ? sql` group by ${sql.join(groupBy, sql`, `)}` : void 0;
        const limitSql = this.buildLimit(limit);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        const useIndexSql = this.buildIndex({ indexes: useIndex, indexFor: "USE" });
        const forceIndexSql = this.buildIndex({ indexes: forceIndex, indexFor: "FORCE" });
        const ignoreIndexSql = this.buildIndex({ indexes: ignoreIndex, indexFor: "IGNORE" });
        let lockingClausesSql;
        if (lockingClause) {
          const { config, strength } = lockingClause;
          lockingClausesSql = sql` for ${sql.raw(strength)}`;
          if (config.noWait) {
            lockingClausesSql.append(sql` nowait`);
          } else if (config.skipLocked) {
            lockingClausesSql.append(sql` skip locked`);
          }
        }
        const finalQuery = sql`${withSql}select${distinctSql} ${selection} from ${tableSql}${useIndexSql}${forceIndexSql}${ignoreIndexSql}${joinsSql}${whereSql}${groupBySql}${havingSql}${orderBySql}${limitSql}${offsetSql}${lockingClausesSql}`;
        if (setOperators.length > 0) {
          return this.buildSetOperations(finalQuery, setOperators);
        }
        return finalQuery;
      }
      buildSetOperations(leftSelect, setOperators) {
        const [setOperator, ...rest] = setOperators;
        if (!setOperator) {
          throw new Error("Cannot pass undefined values to any set operator");
        }
        if (rest.length === 0) {
          return this.buildSetOperationQuery({ leftSelect, setOperator });
        }
        return this.buildSetOperations(
          this.buildSetOperationQuery({ leftSelect, setOperator }),
          rest
        );
      }
      buildSetOperationQuery({
        leftSelect,
        setOperator: { type, isAll, rightSelect, limit, orderBy, offset }
      }) {
        const leftChunk = sql`(${leftSelect.getSQL()}) `;
        const rightChunk = sql`(${rightSelect.getSQL()})`;
        let orderBySql;
        if (orderBy && orderBy.length > 0) {
          const orderByValues = [];
          for (const orderByUnit of orderBy) {
            if (is(orderByUnit, MySqlColumn)) {
              orderByValues.push(sql.identifier(this.casing.getColumnCasing(orderByUnit)));
            } else if (is(orderByUnit, SQL)) {
              for (let i8 = 0; i8 < orderByUnit.queryChunks.length; i8++) {
                const chunk = orderByUnit.queryChunks[i8];
                if (is(chunk, MySqlColumn)) {
                  orderByUnit.queryChunks[i8] = sql.identifier(this.casing.getColumnCasing(chunk));
                }
              }
              orderByValues.push(sql`${orderByUnit}`);
            } else {
              orderByValues.push(sql`${orderByUnit}`);
            }
          }
          orderBySql = sql` order by ${sql.join(orderByValues, sql`, `)} `;
        }
        const limitSql = typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
        const operatorChunk = sql.raw(`${type} ${isAll ? "all " : ""}`);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        return sql`${leftChunk}${operatorChunk}${rightChunk}${orderBySql}${limitSql}${offsetSql}`;
      }
      buildInsertQuery({ table: table6, values: valuesOrSelect, ignore, onConflict, select: select2 }) {
        const valuesSqlList = [];
        const columns = table6[Table.Symbol.Columns];
        const colEntries = Object.entries(columns).filter(
          ([_7, col]) => !col.shouldDisableInsert()
        );
        const insertOrder = colEntries.map(([, column6]) => sql.identifier(this.casing.getColumnCasing(column6)));
        const generatedIdsResponse = [];
        if (select2) {
          const select22 = valuesOrSelect;
          if (is(select22, SQL)) {
            valuesSqlList.push(select22);
          } else {
            valuesSqlList.push(select22.getSQL());
          }
        } else {
          const values2 = valuesOrSelect;
          valuesSqlList.push(sql.raw("values "));
          for (const [valueIndex, value] of values2.entries()) {
            const generatedIds = {};
            const valueList = [];
            for (const [fieldName, col] of colEntries) {
              const colValue = value[fieldName];
              if (colValue === void 0 || is(colValue, Param) && colValue.value === void 0) {
                if (col.defaultFn !== void 0) {
                  const defaultFnResult = col.defaultFn();
                  generatedIds[fieldName] = defaultFnResult;
                  const defaultValue = is(defaultFnResult, SQL) ? defaultFnResult : sql.param(defaultFnResult, col);
                  valueList.push(defaultValue);
                } else if (!col.default && col.onUpdateFn !== void 0) {
                  const onUpdateFnResult = col.onUpdateFn();
                  const newValue = is(onUpdateFnResult, SQL) ? onUpdateFnResult : sql.param(onUpdateFnResult, col);
                  valueList.push(newValue);
                } else {
                  valueList.push(sql`default`);
                }
              } else {
                if (col.defaultFn && is(colValue, Param)) {
                  generatedIds[fieldName] = colValue.value;
                }
                valueList.push(colValue);
              }
            }
            generatedIdsResponse.push(generatedIds);
            valuesSqlList.push(valueList);
            if (valueIndex < values2.length - 1) {
              valuesSqlList.push(sql`, `);
            }
          }
        }
        const valuesSql = sql.join(valuesSqlList);
        const ignoreSql = ignore ? sql` ignore` : void 0;
        const onConflictSql = onConflict ? sql` on duplicate key ${onConflict}` : void 0;
        return {
          sql: sql`insert${ignoreSql} into ${table6} ${insertOrder} ${valuesSql}${onConflictSql}`,
          generatedIds: generatedIdsResponse
        };
      }
      sqlToQuery(sql22, invokeSource) {
        return sql22.toQuery({
          casing: this.casing,
          escapeName: this.escapeName,
          escapeParam: this.escapeParam,
          escapeString: this.escapeString,
          invokeSource
        });
      }
      buildRelationalQuery({
        fullSchema,
        schema: schema6,
        tableNamesMap,
        table: table6,
        tableConfig,
        queryConfig: config,
        tableAlias,
        nestedQueryRelation,
        joinOn
      }) {
        let selection = [];
        let limit, offset, orderBy, where;
        const joins = [];
        if (config === true) {
          const selectionEntries = Object.entries(tableConfig.columns);
          selection = selectionEntries.map(([key, value]) => ({
            dbKey: value.name,
            tsKey: key,
            field: aliasedTableColumn(value, tableAlias),
            relationTableTsKey: void 0,
            isJson: false,
            selection: []
          }));
        } else {
          const aliasedColumns = Object.fromEntries(
            Object.entries(tableConfig.columns).map(([key, value]) => [key, aliasedTableColumn(value, tableAlias)])
          );
          if (config.where) {
            const whereSql = typeof config.where === "function" ? config.where(aliasedColumns, getOperators()) : config.where;
            where = whereSql && mapColumnsInSQLToAlias(whereSql, tableAlias);
          }
          const fieldsSelection = [];
          let selectedColumns = [];
          if (config.columns) {
            let isIncludeMode = false;
            for (const [field, value] of Object.entries(config.columns)) {
              if (value === void 0) {
                continue;
              }
              if (field in tableConfig.columns) {
                if (!isIncludeMode && value === true) {
                  isIncludeMode = true;
                }
                selectedColumns.push(field);
              }
            }
            if (selectedColumns.length > 0) {
              selectedColumns = isIncludeMode ? selectedColumns.filter((c6) => config.columns?.[c6] === true) : Object.keys(tableConfig.columns).filter((key) => !selectedColumns.includes(key));
            }
          } else {
            selectedColumns = Object.keys(tableConfig.columns);
          }
          for (const field of selectedColumns) {
            const column6 = tableConfig.columns[field];
            fieldsSelection.push({ tsKey: field, value: column6 });
          }
          let selectedRelations = [];
          if (config.with) {
            selectedRelations = Object.entries(config.with).filter((entry) => !!entry[1]).map(([tsKey, queryConfig]) => ({ tsKey, queryConfig, relation: tableConfig.relations[tsKey] }));
          }
          let extras;
          if (config.extras) {
            extras = typeof config.extras === "function" ? config.extras(aliasedColumns, { sql }) : config.extras;
            for (const [tsKey, value] of Object.entries(extras)) {
              fieldsSelection.push({
                tsKey,
                value: mapColumnsInAliasedSQLToAlias(value, tableAlias)
              });
            }
          }
          for (const { tsKey, value } of fieldsSelection) {
            selection.push({
              dbKey: is(value, SQL.Aliased) ? value.fieldAlias : tableConfig.columns[tsKey].name,
              tsKey,
              field: is(value, Column) ? aliasedTableColumn(value, tableAlias) : value,
              relationTableTsKey: void 0,
              isJson: false,
              selection: []
            });
          }
          let orderByOrig = typeof config.orderBy === "function" ? config.orderBy(aliasedColumns, getOrderByOperators()) : config.orderBy ?? [];
          if (!Array.isArray(orderByOrig)) {
            orderByOrig = [orderByOrig];
          }
          orderBy = orderByOrig.map((orderByValue) => {
            if (is(orderByValue, Column)) {
              return aliasedTableColumn(orderByValue, tableAlias);
            }
            return mapColumnsInSQLToAlias(orderByValue, tableAlias);
          });
          limit = config.limit;
          offset = config.offset;
          for (const {
            tsKey: selectedRelationTsKey,
            queryConfig: selectedRelationConfigValue,
            relation
          } of selectedRelations) {
            const normalizedRelation = normalizeRelation(schema6, tableNamesMap, relation);
            const relationTableName = getTableUniqueName(relation.referencedTable);
            const relationTableTsName = tableNamesMap[relationTableName];
            const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
            const joinOn2 = and(
              ...normalizedRelation.fields.map(
                (field2, i8) => eq(
                  aliasedTableColumn(normalizedRelation.references[i8], relationTableAlias),
                  aliasedTableColumn(field2, tableAlias)
                )
              )
            );
            const builtRelation = this.buildRelationalQuery({
              fullSchema,
              schema: schema6,
              tableNamesMap,
              table: fullSchema[relationTableTsName],
              tableConfig: schema6[relationTableTsName],
              queryConfig: is(relation, One) ? selectedRelationConfigValue === true ? { limit: 1 } : { ...selectedRelationConfigValue, limit: 1 } : selectedRelationConfigValue,
              tableAlias: relationTableAlias,
              joinOn: joinOn2,
              nestedQueryRelation: relation
            });
            const field = sql`${sql.identifier(relationTableAlias)}.${sql.identifier("data")}`.as(selectedRelationTsKey);
            joins.push({
              on: sql`true`,
              table: new Subquery(builtRelation.sql, {}, relationTableAlias),
              alias: relationTableAlias,
              joinType: "left",
              lateral: true
            });
            selection.push({
              dbKey: selectedRelationTsKey,
              tsKey: selectedRelationTsKey,
              field,
              relationTableTsKey: relationTableTsName,
              isJson: true,
              selection: builtRelation.selection
            });
          }
        }
        if (selection.length === 0) {
          throw new DrizzleError({ message: `No fields selected for table "${tableConfig.tsName}" ("${tableAlias}")` });
        }
        let result;
        where = and(joinOn, where);
        if (nestedQueryRelation) {
          let field = sql`json_array(${sql.join(
            selection.map(
              ({ field: field2, tsKey, isJson: isJson2 }) => isJson2 ? sql`${sql.identifier(`${tableAlias}_${tsKey}`)}.${sql.identifier("data")}` : is(field2, SQL.Aliased) ? field2.sql : field2
            ),
            sql`, `
          )})`;
          if (is(nestedQueryRelation, Many)) {
            field = sql`coalesce(json_arrayagg(${field}), json_array())`;
          }
          const nestedSelection = [{
            dbKey: "data",
            tsKey: "data",
            field: field.as("data"),
            isJson: true,
            relationTableTsKey: tableConfig.tsName,
            selection
          }];
          const needsSubquery = limit !== void 0 || offset !== void 0 || (orderBy?.length ?? 0) > 0;
          if (needsSubquery) {
            result = this.buildSelectQuery({
              table: aliasedTable(table6, tableAlias),
              fields: {},
              fieldsFlat: [
                {
                  path: [],
                  field: sql.raw("*")
                },
                ...(orderBy?.length ?? 0) > 0 ? [{
                  path: [],
                  field: sql`row_number() over (order by ${sql.join(orderBy, sql`, `)})`
                }] : []
              ],
              where,
              limit,
              offset,
              setOperators: []
            });
            where = void 0;
            limit = void 0;
            offset = void 0;
            orderBy = void 0;
          } else {
            result = aliasedTable(table6, tableAlias);
          }
          result = this.buildSelectQuery({
            table: is(result, MySqlTable) ? result : new Subquery(result, {}, tableAlias),
            fields: {},
            fieldsFlat: nestedSelection.map(({ field: field2 }) => ({
              path: [],
              field: is(field2, Column) ? aliasedTableColumn(field2, tableAlias) : field2
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        } else {
          result = this.buildSelectQuery({
            table: aliasedTable(table6, tableAlias),
            fields: {},
            fieldsFlat: selection.map(({ field }) => ({
              path: [],
              field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        }
        return {
          tableTsKey: tableConfig.tsName,
          sql: result,
          selection
        };
      }
      buildRelationalQueryWithoutLateralSubqueries({
        fullSchema,
        schema: schema6,
        tableNamesMap,
        table: table6,
        tableConfig,
        queryConfig: config,
        tableAlias,
        nestedQueryRelation,
        joinOn
      }) {
        let selection = [];
        let limit, offset, orderBy = [], where;
        if (config === true) {
          const selectionEntries = Object.entries(tableConfig.columns);
          selection = selectionEntries.map(([key, value]) => ({
            dbKey: value.name,
            tsKey: key,
            field: aliasedTableColumn(value, tableAlias),
            relationTableTsKey: void 0,
            isJson: false,
            selection: []
          }));
        } else {
          const aliasedColumns = Object.fromEntries(
            Object.entries(tableConfig.columns).map(([key, value]) => [key, aliasedTableColumn(value, tableAlias)])
          );
          if (config.where) {
            const whereSql = typeof config.where === "function" ? config.where(aliasedColumns, getOperators()) : config.where;
            where = whereSql && mapColumnsInSQLToAlias(whereSql, tableAlias);
          }
          const fieldsSelection = [];
          let selectedColumns = [];
          if (config.columns) {
            let isIncludeMode = false;
            for (const [field, value] of Object.entries(config.columns)) {
              if (value === void 0) {
                continue;
              }
              if (field in tableConfig.columns) {
                if (!isIncludeMode && value === true) {
                  isIncludeMode = true;
                }
                selectedColumns.push(field);
              }
            }
            if (selectedColumns.length > 0) {
              selectedColumns = isIncludeMode ? selectedColumns.filter((c6) => config.columns?.[c6] === true) : Object.keys(tableConfig.columns).filter((key) => !selectedColumns.includes(key));
            }
          } else {
            selectedColumns = Object.keys(tableConfig.columns);
          }
          for (const field of selectedColumns) {
            const column6 = tableConfig.columns[field];
            fieldsSelection.push({ tsKey: field, value: column6 });
          }
          let selectedRelations = [];
          if (config.with) {
            selectedRelations = Object.entries(config.with).filter((entry) => !!entry[1]).map(([tsKey, queryConfig]) => ({ tsKey, queryConfig, relation: tableConfig.relations[tsKey] }));
          }
          let extras;
          if (config.extras) {
            extras = typeof config.extras === "function" ? config.extras(aliasedColumns, { sql }) : config.extras;
            for (const [tsKey, value] of Object.entries(extras)) {
              fieldsSelection.push({
                tsKey,
                value: mapColumnsInAliasedSQLToAlias(value, tableAlias)
              });
            }
          }
          for (const { tsKey, value } of fieldsSelection) {
            selection.push({
              dbKey: is(value, SQL.Aliased) ? value.fieldAlias : tableConfig.columns[tsKey].name,
              tsKey,
              field: is(value, Column) ? aliasedTableColumn(value, tableAlias) : value,
              relationTableTsKey: void 0,
              isJson: false,
              selection: []
            });
          }
          let orderByOrig = typeof config.orderBy === "function" ? config.orderBy(aliasedColumns, getOrderByOperators()) : config.orderBy ?? [];
          if (!Array.isArray(orderByOrig)) {
            orderByOrig = [orderByOrig];
          }
          orderBy = orderByOrig.map((orderByValue) => {
            if (is(orderByValue, Column)) {
              return aliasedTableColumn(orderByValue, tableAlias);
            }
            return mapColumnsInSQLToAlias(orderByValue, tableAlias);
          });
          limit = config.limit;
          offset = config.offset;
          for (const {
            tsKey: selectedRelationTsKey,
            queryConfig: selectedRelationConfigValue,
            relation
          } of selectedRelations) {
            const normalizedRelation = normalizeRelation(schema6, tableNamesMap, relation);
            const relationTableName = getTableUniqueName(relation.referencedTable);
            const relationTableTsName = tableNamesMap[relationTableName];
            const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
            const joinOn2 = and(
              ...normalizedRelation.fields.map(
                (field2, i8) => eq(
                  aliasedTableColumn(normalizedRelation.references[i8], relationTableAlias),
                  aliasedTableColumn(field2, tableAlias)
                )
              )
            );
            const builtRelation = this.buildRelationalQueryWithoutLateralSubqueries({
              fullSchema,
              schema: schema6,
              tableNamesMap,
              table: fullSchema[relationTableTsName],
              tableConfig: schema6[relationTableTsName],
              queryConfig: is(relation, One) ? selectedRelationConfigValue === true ? { limit: 1 } : { ...selectedRelationConfigValue, limit: 1 } : selectedRelationConfigValue,
              tableAlias: relationTableAlias,
              joinOn: joinOn2,
              nestedQueryRelation: relation
            });
            let fieldSql = sql`(${builtRelation.sql})`;
            if (is(relation, Many)) {
              fieldSql = sql`coalesce(${fieldSql}, json_array())`;
            }
            const field = fieldSql.as(selectedRelationTsKey);
            selection.push({
              dbKey: selectedRelationTsKey,
              tsKey: selectedRelationTsKey,
              field,
              relationTableTsKey: relationTableTsName,
              isJson: true,
              selection: builtRelation.selection
            });
          }
        }
        if (selection.length === 0) {
          throw new DrizzleError({
            message: `No fields selected for table "${tableConfig.tsName}" ("${tableAlias}"). You need to have at least one item in "columns", "with" or "extras". If you need to select all columns, omit the "columns" key or set it to undefined.`
          });
        }
        let result;
        where = and(joinOn, where);
        if (nestedQueryRelation) {
          let field = sql`json_array(${sql.join(
            selection.map(
              ({ field: field2 }) => is(field2, MySqlColumn) ? sql.identifier(this.casing.getColumnCasing(field2)) : is(field2, SQL.Aliased) ? field2.sql : field2
            ),
            sql`, `
          )})`;
          if (is(nestedQueryRelation, Many)) {
            field = sql`json_arrayagg(${field})`;
          }
          const nestedSelection = [{
            dbKey: "data",
            tsKey: "data",
            field,
            isJson: true,
            relationTableTsKey: tableConfig.tsName,
            selection
          }];
          const needsSubquery = limit !== void 0 || offset !== void 0 || orderBy.length > 0;
          if (needsSubquery) {
            result = this.buildSelectQuery({
              table: aliasedTable(table6, tableAlias),
              fields: {},
              fieldsFlat: [
                {
                  path: [],
                  field: sql.raw("*")
                },
                ...orderBy.length > 0 ? [{
                  path: [],
                  field: sql`row_number() over (order by ${sql.join(orderBy, sql`, `)})`
                }] : []
              ],
              where,
              limit,
              offset,
              setOperators: []
            });
            where = void 0;
            limit = void 0;
            offset = void 0;
            orderBy = void 0;
          } else {
            result = aliasedTable(table6, tableAlias);
          }
          result = this.buildSelectQuery({
            table: is(result, MySqlTable) ? result : new Subquery(result, {}, tableAlias),
            fields: {},
            fieldsFlat: nestedSelection.map(({ field: field2 }) => ({
              path: [],
              field: is(field2, Column) ? aliasedTableColumn(field2, tableAlias) : field2
            })),
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        } else {
          result = this.buildSelectQuery({
            table: aliasedTable(table6, tableAlias),
            fields: {},
            fieldsFlat: selection.map(({ field }) => ({
              path: [],
              field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field
            })),
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        }
        return {
          tableTsKey: tableConfig.tsName,
          sql: result,
          selection
        };
      }
    };
    __publicField(MySqlDialect, _a214, "MySqlDialect");
  }
});

// ../drizzle-orm/dist/query-builders/query-builder.js
var _a215, TypedQueryBuilder;
var init_query_builder = __esm({
  "../drizzle-orm/dist/query-builders/query-builder.js"() {
    "use strict";
    init_entity();
    _a215 = entityKind;
    TypedQueryBuilder = class {
      /** @internal */
      getSelectedFields() {
        return this._.selectedFields;
      }
    };
    __publicField(TypedQueryBuilder, _a215, "TypedQueryBuilder");
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/select.js
function createSetOperator(type, isAll) {
  return (leftSelect, rightSelect, ...restSelects) => {
    const setOperators = [rightSelect, ...restSelects].map((select2) => ({
      type,
      isAll,
      rightSelect: select2
    }));
    for (const setOperator of setOperators) {
      if (!haveSameKeys(leftSelect.getSelectedFields(), setOperator.rightSelect.getSelectedFields())) {
        throw new Error(
          "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
        );
      }
    }
    return leftSelect.addSetOperators(setOperators);
  };
}
var _a216, MySqlSelectBuilder, _a217, _b175, MySqlSelectQueryBuilderBase, _a218, _b176, MySqlSelectBase, getMySqlSetOperators, union, unionAll, intersect, intersectAll, except, exceptAll;
var init_select2 = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/select.js"() {
    "use strict";
    init_entity();
    init_table3();
    init_query_builder();
    init_query_promise();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_utils3();
    init_view_base();
    _a216 = entityKind;
    MySqlSelectBuilder = class {
      constructor(config) {
        __publicField(this, "fields");
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "withList", []);
        __publicField(this, "distinct");
        this.fields = config.fields;
        this.session = config.session;
        this.dialect = config.dialect;
        if (config.withList) {
          this.withList = config.withList;
        }
        this.distinct = config.distinct;
      }
      from(source, onIndex) {
        const isPartialSelect = !!this.fields;
        let fields;
        if (this.fields) {
          fields = this.fields;
        } else if (is(source, Subquery)) {
          fields = Object.fromEntries(
            Object.keys(source._.selectedFields).map((key) => [key, source[key]])
          );
        } else if (is(source, MySqlViewBase)) {
          fields = source[ViewBaseConfig].selectedFields;
        } else if (is(source, SQL)) {
          fields = {};
        } else {
          fields = getTableColumns(source);
        }
        let useIndex = [];
        let forceIndex = [];
        let ignoreIndex = [];
        if (is(source, MySqlTable) && onIndex && typeof onIndex !== "string") {
          if (onIndex.useIndex) {
            useIndex = convertIndexToString(toArray(onIndex.useIndex));
          }
          if (onIndex.forceIndex) {
            forceIndex = convertIndexToString(toArray(onIndex.forceIndex));
          }
          if (onIndex.ignoreIndex) {
            ignoreIndex = convertIndexToString(toArray(onIndex.ignoreIndex));
          }
        }
        return new MySqlSelectBase(
          {
            table: source,
            fields,
            isPartialSelect,
            session: this.session,
            dialect: this.dialect,
            withList: this.withList,
            distinct: this.distinct,
            useIndex,
            forceIndex,
            ignoreIndex
          }
        );
      }
    };
    __publicField(MySqlSelectBuilder, _a216, "MySqlSelectBuilder");
    MySqlSelectQueryBuilderBase = class extends (_b175 = TypedQueryBuilder, _a217 = entityKind, _b175) {
      constructor({ table: table6, fields, isPartialSelect, session, dialect: dialect6, withList, distinct, useIndex, forceIndex, ignoreIndex }) {
        super();
        __publicField(this, "_");
        __publicField(this, "config");
        __publicField(this, "joinsNotNullableMap");
        __publicField(this, "tableName");
        __publicField(this, "isPartialSelect");
        /** @internal */
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "cacheConfig");
        __publicField(this, "usedTables", /* @__PURE__ */ new Set());
        /**
         * Executes a `left join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         * @param onIndex index hint.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId with use index hint
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId), {
         *     useIndex: ['pets_owner_id_index']
         * })
         * ```
         */
        __publicField(this, "leftJoin", this.createJoin("left", false));
        /**
         * Executes a `left join lateral` operation by adding subquery to the current query.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join-lateral}
         *
         * @param table the subquery to join.
         * @param on the `on` clause.
         */
        __publicField(this, "leftJoinLateral", this.createJoin("left", true));
        /**
         * Executes a `right join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the joined table with the corresponding row from the main table, if a match is found. If no matching row exists, it sets all columns of the main table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#right-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         * @param onIndex index hint.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId with use index hint
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId), {
         *     useIndex: ['pets_owner_id_index']
         * })
         * ```
         */
        __publicField(this, "rightJoin", this.createJoin("right", false));
        /**
         * Executes an `inner join` operation, creating a new table by combining rows from two tables that have matching values.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         * @param onIndex index hint.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId with use index hint
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId), {
         *     useIndex: ['pets_owner_id_index']
         * })
         * ```
         */
        __publicField(this, "innerJoin", this.createJoin("inner", false));
        /**
         * Executes an `inner join lateral` operation, creating a new table by combining rows from two queries that have matching values.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join-lateral}
         *
         * @param table the subquery to join.
         * @param on the `on` clause.
         */
        __publicField(this, "innerJoinLateral", this.createJoin("inner", true));
        /**
         * Executes a `cross join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging all rows from each table.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join}
         *
         * @param table the table to join.
         * @param onIndex index hint.
         *
         * @example
         *
         * ```ts
         * // Select all users, each user with every pet
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .crossJoin(pets)
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .crossJoin(pets)
         *
         * // Select userId and petId with use index hint
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .crossJoin(pets, {
         *     useIndex: ['pets_owner_id_index']
         * })
         * ```
         */
        __publicField(this, "crossJoin", this.createJoin("cross", false));
        /**
         * Executes a `cross join lateral` operation by combining rows from two queries into a new table.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method retrieves all rows from both main and joined queries, merging all rows from each query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join-lateral}
         *
         * @param table the query to join.
         */
        __publicField(this, "crossJoinLateral", this.createJoin("cross", true));
        /**
         * Adds `union` set operator to the query.
         *
         * Calling this method will combine the result sets of the `select` statements and remove any duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union}
         *
         * @example
         *
         * ```ts
         * // Select all unique names from customers and users tables
         * await db.select({ name: users.name })
         *   .from(users)
         *   .union(
         *     db.select({ name: customers.name }).from(customers)
         *   );
         * // or
         * import { union } from 'drizzle-orm/mysql-core'
         *
         * await union(
         *   db.select({ name: users.name }).from(users),
         *   db.select({ name: customers.name }).from(customers)
         * );
         * ```
         */
        __publicField(this, "union", this.createSetOperator("union", false));
        /**
         * Adds `union all` set operator to the query.
         *
         * Calling this method will combine the result-set of the `select` statements and keep all duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union-all}
         *
         * @example
         *
         * ```ts
         * // Select all transaction ids from both online and in-store sales
         * await db.select({ transaction: onlineSales.transactionId })
         *   .from(onlineSales)
         *   .unionAll(
         *     db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         *   );
         * // or
         * import { unionAll } from 'drizzle-orm/mysql-core'
         *
         * await unionAll(
         *   db.select({ transaction: onlineSales.transactionId }).from(onlineSales),
         *   db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         * );
         * ```
         */
        __publicField(this, "unionAll", this.createSetOperator("union", true));
        /**
         * Adds `intersect` set operator to the query.
         *
         * Calling this method will retain only the rows that are present in both result sets and eliminate duplicates.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#intersect}
         *
         * @example
         *
         * ```ts
         * // Select course names that are offered in both departments A and B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .intersect(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { intersect } from 'drizzle-orm/mysql-core'
         *
         * await intersect(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "intersect", this.createSetOperator("intersect", false));
        /**
         * Adds `intersect all` set operator to the query.
         *
         * Calling this method will retain only the rows that are present in both result sets including all duplicates.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#intersect-all}
         *
         * @example
         *
         * ```ts
         * // Select all products and quantities that are ordered by both regular and VIP customers
         * await db.select({
         *   productId: regularCustomerOrders.productId,
         *   quantityOrdered: regularCustomerOrders.quantityOrdered
         * })
         * .from(regularCustomerOrders)
         * .intersectAll(
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered
         *   })
         *   .from(vipCustomerOrders)
         * );
         * // or
         * import { intersectAll } from 'drizzle-orm/mysql-core'
         *
         * await intersectAll(
         *   db.select({
         *     productId: regularCustomerOrders.productId,
         *     quantityOrdered: regularCustomerOrders.quantityOrdered
         *   })
         *   .from(regularCustomerOrders),
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered
         *   })
         *   .from(vipCustomerOrders)
         * );
         * ```
         */
        __publicField(this, "intersectAll", this.createSetOperator("intersect", true));
        /**
         * Adds `except` set operator to the query.
         *
         * Calling this method will retrieve all unique rows from the left query, except for the rows that are present in the result set of the right query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#except}
         *
         * @example
         *
         * ```ts
         * // Select all courses offered in department A but not in department B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .except(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { except } from 'drizzle-orm/mysql-core'
         *
         * await except(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "except", this.createSetOperator("except", false));
        /**
         * Adds `except all` set operator to the query.
         *
         * Calling this method will retrieve all rows from the left query, except for the rows that are present in the result set of the right query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#except-all}
         *
         * @example
         *
         * ```ts
         * // Select all products that are ordered by regular customers but not by VIP customers
         * await db.select({
         *   productId: regularCustomerOrders.productId,
         *   quantityOrdered: regularCustomerOrders.quantityOrdered,
         * })
         * .from(regularCustomerOrders)
         * .exceptAll(
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered,
         *   })
         *   .from(vipCustomerOrders)
         * );
         * // or
         * import { exceptAll } from 'drizzle-orm/mysql-core'
         *
         * await exceptAll(
         *   db.select({
         *     productId: regularCustomerOrders.productId,
         *     quantityOrdered: regularCustomerOrders.quantityOrdered
         *   })
         *   .from(regularCustomerOrders),
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered
         *   })
         *   .from(vipCustomerOrders)
         * );
         * ```
         */
        __publicField(this, "exceptAll", this.createSetOperator("except", true));
        this.config = {
          withList,
          table: table6,
          fields: { ...fields },
          distinct,
          setOperators: [],
          useIndex,
          forceIndex,
          ignoreIndex
        };
        this.isPartialSelect = isPartialSelect;
        this.session = session;
        this.dialect = dialect6;
        this._ = {
          selectedFields: fields,
          config: this.config
        };
        this.tableName = getTableLikeName(table6);
        this.joinsNotNullableMap = typeof this.tableName === "string" ? { [this.tableName]: true } : {};
        for (const item of extractUsedTable(table6)) this.usedTables.add(item);
      }
      /** @internal */
      getUsedTables() {
        return [...this.usedTables];
      }
      createJoin(joinType, lateral) {
        return (table6, a9, b9) => {
          const isCrossJoin = joinType === "cross";
          let on3 = isCrossJoin ? void 0 : a9;
          const onIndex = isCrossJoin ? a9 : b9;
          const baseTableName = this.tableName;
          const tableName = getTableLikeName(table6);
          for (const item of extractUsedTable(table6)) this.usedTables.add(item);
          if (typeof tableName === "string" && this.config.joins?.some((join7) => join7.alias === tableName)) {
            throw new Error(`Alias "${tableName}" is already used in this query`);
          }
          if (!this.isPartialSelect) {
            if (Object.keys(this.joinsNotNullableMap).length === 1 && typeof baseTableName === "string") {
              this.config.fields = {
                [baseTableName]: this.config.fields
              };
            }
            if (typeof tableName === "string" && !is(table6, SQL)) {
              const selection = is(table6, Subquery) ? table6._.selectedFields : is(table6, View) ? table6[ViewBaseConfig].selectedFields : table6[Table.Symbol.Columns];
              this.config.fields[tableName] = selection;
            }
          }
          if (typeof on3 === "function") {
            on3 = on3(
              new Proxy(
                this.config.fields,
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              )
            );
          }
          if (!this.config.joins) {
            this.config.joins = [];
          }
          let useIndex = [];
          let forceIndex = [];
          let ignoreIndex = [];
          if (is(table6, MySqlTable) && onIndex && typeof onIndex !== "string") {
            if (onIndex.useIndex) {
              useIndex = convertIndexToString(toArray(onIndex.useIndex));
            }
            if (onIndex.forceIndex) {
              forceIndex = convertIndexToString(toArray(onIndex.forceIndex));
            }
            if (onIndex.ignoreIndex) {
              ignoreIndex = convertIndexToString(toArray(onIndex.ignoreIndex));
            }
          }
          this.config.joins.push({ on: on3, table: table6, joinType, alias: tableName, useIndex, forceIndex, ignoreIndex, lateral });
          if (typeof tableName === "string") {
            switch (joinType) {
              case "left": {
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
              case "right": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "cross":
              case "inner": {
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
            }
          }
          return this;
        };
      }
      createSetOperator(type, isAll) {
        return (rightSelection) => {
          const rightSelect = typeof rightSelection === "function" ? rightSelection(getMySqlSetOperators()) : rightSelection;
          if (!haveSameKeys(this.getSelectedFields(), rightSelect.getSelectedFields())) {
            throw new Error(
              "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
            );
          }
          this.config.setOperators.push({ type, isAll, rightSelect });
          return this;
        };
      }
      /** @internal */
      addSetOperators(setOperators) {
        this.config.setOperators.push(...setOperators);
        return this;
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#filtering}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be selected.
       *
       * ```ts
       * // Select all cars with green color
       * await db.select().from(cars).where(eq(cars.color, 'green'));
       * // or
       * await db.select().from(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Select all BMW cars with a green color
       * await db.select().from(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Select all cars with the green or blue color
       * await db.select().from(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        if (typeof where === "function") {
          where = where(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.where = where;
        return this;
      }
      /**
       * Adds a `having` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition. It is typically used with aggregate functions to filter the aggregated data based on a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#aggregations}
       *
       * @param having the `having` clause.
       *
       * @example
       *
       * ```ts
       * // Select all brands with more than one car
       * await db.select({
       * 	brand: cars.brand,
       * 	count: sql<number>`cast(count(${cars.id}) as int)`,
       * })
       *   .from(cars)
       *   .groupBy(cars.brand)
       *   .having(({ count }) => gt(count, 1));
       * ```
       */
      having(having) {
        if (typeof having === "function") {
          having = having(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.having = having;
        return this;
      }
      groupBy(...columns) {
        if (typeof columns[0] === "function") {
          const groupBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          this.config.groupBy = Array.isArray(groupBy) ? groupBy : [groupBy];
        } else {
          this.config.groupBy = columns;
        }
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        } else {
          const orderByArray = columns;
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        }
        return this;
      }
      /**
       * Adds a `limit` clause to the query.
       *
       * Calling this method will set the maximum number of rows that will be returned by this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param limit the `limit` clause.
       *
       * @example
       *
       * ```ts
       * // Get the first 10 people from this query.
       * await db.select().from(people).limit(10);
       * ```
       */
      limit(limit) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).limit = limit;
        } else {
          this.config.limit = limit;
        }
        return this;
      }
      /**
       * Adds an `offset` clause to the query.
       *
       * Calling this method will skip a number of rows when returning results from this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param offset the `offset` clause.
       *
       * @example
       *
       * ```ts
       * // Get the 10th-20th people from this query.
       * await db.select().from(people).offset(10).limit(10);
       * ```
       */
      offset(offset) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).offset = offset;
        } else {
          this.config.offset = offset;
        }
        return this;
      }
      /**
       * Adds a `for` clause to the query.
       *
       * Calling this method will specify a lock strength for this query that controls how strictly it acquires exclusive access to the rows being queried.
       *
       * See docs: {@link https://dev.mysql.com/doc/refman/8.0/en/innodb-locking-reads.html}
       *
       * @param strength the lock strength.
       * @param config the lock configuration.
       */
      for(strength, config = {}) {
        this.config.lockingClause = { strength, config };
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildSelectQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      as(alias2) {
        const usedTables = [];
        usedTables.push(...extractUsedTable(this.config.table));
        if (this.config.joins) {
          for (const it2 of this.config.joins) usedTables.push(...extractUsedTable(it2.table));
        }
        return new Proxy(
          new Subquery(this.getSQL(), this.config.fields, alias2, false, [...new Set(usedTables)]),
          new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      /** @internal */
      getSelectedFields() {
        return new Proxy(
          this.config.fields,
          new SelectionProxyHandler({ alias: this.tableName, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      $dynamic() {
        return this;
      }
      $withCache(config) {
        this.cacheConfig = config === void 0 ? { config: {}, enable: true, autoInvalidate: true } : config === false ? { enable: false } : { enable: true, autoInvalidate: true, ...config };
        return this;
      }
    };
    __publicField(MySqlSelectQueryBuilderBase, _a217, "MySqlSelectQueryBuilder");
    MySqlSelectBase = class extends (_b176 = MySqlSelectQueryBuilderBase, _a218 = entityKind, _b176) {
      constructor() {
        super(...arguments);
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
      }
      prepare() {
        if (!this.session) {
          throw new Error("Cannot execute a query on a query builder. Please use a database instance instead.");
        }
        const fieldsList = orderSelectedFields(this.config.fields);
        const query = this.session.prepareQuery(this.dialect.sqlToQuery(this.getSQL()), fieldsList, void 0, void 0, void 0, {
          type: "select",
          tables: [...this.usedTables]
        }, this.cacheConfig);
        query.joinsNotNullableMap = this.joinsNotNullableMap;
        return query;
      }
    };
    __publicField(MySqlSelectBase, _a218, "MySqlSelect");
    applyMixins(MySqlSelectBase, [QueryPromise]);
    getMySqlSetOperators = () => ({
      union,
      unionAll,
      intersect,
      intersectAll,
      except,
      exceptAll
    });
    union = createSetOperator("union", false);
    unionAll = createSetOperator("union", true);
    intersect = createSetOperator("intersect", false);
    intersectAll = createSetOperator("intersect", true);
    except = createSetOperator("except", false);
    exceptAll = createSetOperator("except", true);
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/query-builder.js
var _a219, QueryBuilder;
var init_query_builder2 = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/query-builder.js"() {
    "use strict";
    init_entity();
    init_dialect();
    init_selection_proxy();
    init_subquery();
    init_select2();
    _a219 = entityKind;
    QueryBuilder = class {
      constructor(dialect6) {
        __publicField(this, "dialect");
        __publicField(this, "dialectConfig");
        __publicField(this, "$with", (alias2, selection) => {
          const queryBuilder = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(queryBuilder);
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        this.dialect = is(dialect6, MySqlDialect) ? dialect6 : void 0;
        this.dialectConfig = is(dialect6, MySqlDialect) ? void 0 : dialect6;
      }
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new MySqlSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new MySqlSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries,
            distinct: true
          });
        }
        return { select: select2, selectDistinct };
      }
      select(fields) {
        return new MySqlSelectBuilder({ fields: fields ?? void 0, session: void 0, dialect: this.getDialect() });
      }
      selectDistinct(fields) {
        return new MySqlSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect(),
          distinct: true
        });
      }
      // Lazy load dialect to avoid circular dependency
      getDialect() {
        if (!this.dialect) {
          this.dialect = new MySqlDialect(this.dialectConfig);
        }
        return this.dialect;
      }
    };
    __publicField(QueryBuilder, _a219, "MySqlQueryBuilder");
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/insert.js
var _a220, MySqlInsertBuilder, _a221, _b177, MySqlInsertBase;
var init_insert = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/insert.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_sql();
    init_table();
    init_utils();
    init_utils3();
    init_query_builder2();
    _a220 = entityKind;
    MySqlInsertBuilder = class {
      constructor(table6, session, dialect6) {
        __publicField(this, "shouldIgnore", false);
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
      }
      ignore() {
        this.shouldIgnore = true;
        return this;
      }
      values(values2) {
        values2 = Array.isArray(values2) ? values2 : [values2];
        if (values2.length === 0) {
          throw new Error("values() must be called with at least one value");
        }
        const mappedValues = values2.map((entry) => {
          const result = {};
          const cols = this.table[Table.Symbol.Columns];
          for (const colKey of Object.keys(entry)) {
            const colValue = entry[colKey];
            result[colKey] = is(colValue, SQL) ? colValue : new Param(colValue, cols[colKey]);
          }
          return result;
        });
        return new MySqlInsertBase(this.table, mappedValues, this.shouldIgnore, this.session, this.dialect);
      }
      select(selectQuery) {
        const select2 = typeof selectQuery === "function" ? selectQuery(new QueryBuilder()) : selectQuery;
        if (!is(select2, SQL) && !haveSameKeys(this.table[Columns], select2._.selectedFields)) {
          throw new Error(
            "Insert select error: selected fields are not the same or are in a different order compared to the table definition"
          );
        }
        return new MySqlInsertBase(this.table, select2, this.shouldIgnore, this.session, this.dialect, true);
      }
    };
    __publicField(MySqlInsertBuilder, _a220, "MySqlInsertBuilder");
    MySqlInsertBase = class extends (_b177 = QueryPromise, _a221 = entityKind, _b177) {
      constructor(table6, values2, ignore, session, dialect6, select2) {
        super();
        __publicField(this, "config");
        __publicField(this, "cacheConfig");
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, values: values2, select: select2, ignore };
      }
      /**
       * Adds an `on duplicate key update` clause to the query.
       *
       * Calling this method will update the row if any unique index conflicts. MySQL will automatically determine the conflict target based on the primary key and unique indexes.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert#on-duplicate-key-update}
       *
       * @param config The `set` clause
       *
       * @example
       * ```ts
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW'})
       *   .onDuplicateKeyUpdate({ set: { brand: 'Porsche' }});
       * ```
       *
       * While MySQL does not directly support doing nothing on conflict, you can perform a no-op by setting any column's value to itself and achieve the same effect:
       *
       * ```ts
       * import { sql } from 'drizzle-orm';
       *
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onDuplicateKeyUpdate({ set: { id: sql`id` } });
       * ```
       */
      onDuplicateKeyUpdate(config) {
        const setSql = this.dialect.buildUpdateSet(this.config.table, mapUpdateSet(this.config.table, config.set));
        this.config.onConflict = sql`update ${setSql}`;
        return this;
      }
      $returningId() {
        const returning = [];
        for (const [key, value] of Object.entries(this.config.table[Table.Symbol.Columns])) {
          if (value.primary) {
            returning.push({ field: value, path: [key] });
          }
        }
        this.config.returning = returning;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildInsertQuery(this.config).sql;
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      prepare() {
        const { sql: sql22, generatedIds } = this.dialect.buildInsertQuery(this.config);
        return this.session.prepareQuery(
          this.dialect.sqlToQuery(sql22),
          void 0,
          void 0,
          generatedIds,
          this.config.returning,
          {
            type: "insert",
            tables: extractUsedTable(this.config.table)
          },
          this.cacheConfig
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(MySqlInsertBase, _a221, "MySqlInsert");
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/select.types.js
var init_select_types = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/select.types.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/update.js
var _a222, MySqlUpdateBuilder, _a223, _b178, MySqlUpdateBase;
var init_update = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/update.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table();
    init_utils();
    init_utils3();
    _a222 = entityKind;
    MySqlUpdateBuilder = class {
      constructor(table6, session, dialect6, withList) {
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.withList = withList;
      }
      set(values2) {
        return new MySqlUpdateBase(this.table, mapUpdateSet(this.table, values2), this.session, this.dialect, this.withList);
      }
    };
    __publicField(MySqlUpdateBuilder, _a222, "MySqlUpdateBuilder");
    MySqlUpdateBase = class extends (_b178 = QueryPromise, _a223 = entityKind, _b178) {
      constructor(table6, set, session, dialect6, withList) {
        super();
        __publicField(this, "config");
        __publicField(this, "cacheConfig");
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
        this.session = session;
        this.dialect = dialect6;
        this.config = { set, table: table6, withList };
      }
      /**
       * Adds a 'where' clause to the query.
       *
       * Calling this method will update only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param where the 'where' clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be updated.
       *
       * ```ts
       * // Update all cars with green color
       * db.update(cars).set({ color: 'red' })
       *   .where(eq(cars.color, 'green'));
       * // or
       * db.update(cars).set({ color: 'red' })
       *   .where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Update all BMW cars with a green color
       * db.update(cars).set({ color: 'red' })
       *   .where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Update all cars with the green or blue color
       * db.update(cars).set({ color: 'red' })
       *   .where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.table[Table.Symbol.Columns],
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          this.config.orderBy = orderByArray;
        } else {
          const orderByArray = columns;
          this.config.orderBy = orderByArray;
        }
        return this;
      }
      limit(limit) {
        this.config.limit = limit;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildUpdateQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      prepare() {
        return this.session.prepareQuery(
          this.dialect.sqlToQuery(this.getSQL()),
          void 0,
          void 0,
          void 0,
          this.config.returning,
          {
            type: "insert",
            tables: extractUsedTable(this.config.table)
          },
          this.cacheConfig
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(MySqlUpdateBase, _a223, "MySqlUpdate");
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/index.js
var init_query_builders = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/index.js"() {
    "use strict";
    init_delete();
    init_insert();
    init_query_builder2();
    init_select2();
    init_select_types();
    init_update();
  }
});

// ../drizzle-orm/dist/mysql-core/query-builders/query.js
var _a224, RelationalQueryBuilder, _a225, _b179, MySqlRelationalQuery;
var init_query = __esm({
  "../drizzle-orm/dist/mysql-core/query-builders/query.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_relations();
    _a224 = entityKind;
    RelationalQueryBuilder = class {
      constructor(fullSchema, schema6, tableNamesMap, table6, tableConfig, dialect6, session, mode) {
        this.fullSchema = fullSchema;
        this.schema = schema6;
        this.tableNamesMap = tableNamesMap;
        this.table = table6;
        this.tableConfig = tableConfig;
        this.dialect = dialect6;
        this.session = session;
        this.mode = mode;
      }
      findMany(config) {
        return new MySqlRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? config : {},
          "many",
          this.mode
        );
      }
      findFirst(config) {
        return new MySqlRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? { ...config, limit: 1 } : { limit: 1 },
          "first",
          this.mode
        );
      }
    };
    __publicField(RelationalQueryBuilder, _a224, "MySqlRelationalQueryBuilder");
    MySqlRelationalQuery = class extends (_b179 = QueryPromise, _a225 = entityKind, _b179) {
      constructor(fullSchema, schema6, tableNamesMap, table6, tableConfig, dialect6, session, config, queryMode, mode) {
        super();
        this.fullSchema = fullSchema;
        this.schema = schema6;
        this.tableNamesMap = tableNamesMap;
        this.table = table6;
        this.tableConfig = tableConfig;
        this.dialect = dialect6;
        this.session = session;
        this.config = config;
        this.queryMode = queryMode;
        this.mode = mode;
      }
      prepare() {
        const { query, builtQuery } = this._toSQL();
        return this.session.prepareQuery(
          builtQuery,
          void 0,
          (rawRows) => {
            const rows = rawRows.map((row) => mapRelationalRow(this.schema, this.tableConfig, row, query.selection));
            if (this.queryMode === "first") {
              return rows[0];
            }
            return rows;
          }
        );
      }
      _getQuery() {
        const query = this.mode === "planetscale" ? this.dialect.buildRelationalQueryWithoutLateralSubqueries({
          fullSchema: this.fullSchema,
          schema: this.schema,
          tableNamesMap: this.tableNamesMap,
          table: this.table,
          tableConfig: this.tableConfig,
          queryConfig: this.config,
          tableAlias: this.tableConfig.tsName
        }) : this.dialect.buildRelationalQuery({
          fullSchema: this.fullSchema,
          schema: this.schema,
          tableNamesMap: this.tableNamesMap,
          table: this.table,
          tableConfig: this.tableConfig,
          queryConfig: this.config,
          tableAlias: this.tableConfig.tsName
        });
        return query;
      }
      _toSQL() {
        const query = this._getQuery();
        const builtQuery = this.dialect.sqlToQuery(query.sql);
        return { builtQuery, query };
      }
      /** @internal */
      getSQL() {
        return this._getQuery().sql;
      }
      toSQL() {
        return this._toSQL().builtQuery;
      }
      execute() {
        return this.prepare().execute();
      }
    };
    __publicField(MySqlRelationalQuery, _a225, "MySqlRelationalQuery");
  }
});

// ../drizzle-orm/dist/mysql-core/db.js
var _a226, MySqlDatabase;
var init_db = __esm({
  "../drizzle-orm/dist/mysql-core/db.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_count();
    init_query_builders();
    init_query();
    _a226 = entityKind;
    MySqlDatabase = class {
      constructor(dialect6, session, schema6, mode) {
        __publicField(this, "query");
        /**
         * Creates a subquery that defines a temporary named result set as a CTE.
         *
         * It is useful for breaking down complex queries into simpler parts and for reusing the result set in subsequent parts of the query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
         *
         * @param alias The alias for the subquery.
         *
         * Failure to provide an alias will result in a DrizzleTypeError, preventing the subquery from being referenced in other queries.
         *
         * @example
         *
         * ```ts
         * // Create a subquery with alias 'sq' and use it in the select query
         * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
         *
         * const result = await db.with(sq).select().from(sq);
         * ```
         *
         * To select arbitrary SQL values as fields in a CTE and reference them in other CTEs or in the main query, you need to add aliases to them:
         *
         * ```ts
         * // Select an arbitrary SQL value as a field in a CTE and reference it in the main query
         * const sq = db.$with('sq').as(db.select({
         *   name: sql<string>`upper(${users.name})`.as('name'),
         * })
         * .from(users));
         *
         * const result = await db.with(sq).select({ name: sq.name }).from(sq);
         * ```
         */
        __publicField(this, "$with", (alias2, selection) => {
          const self2 = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(new QueryBuilder(self2.dialect));
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        __publicField(this, "$cache");
        this.dialect = dialect6;
        this.session = session;
        this.mode = mode;
        this._ = schema6 ? {
          schema: schema6.schema,
          fullSchema: schema6.fullSchema,
          tableNamesMap: schema6.tableNamesMap
        } : {
          schema: void 0,
          fullSchema: {},
          tableNamesMap: {}
        };
        this.query = {};
        if (this._.schema) {
          for (const [tableName, columns] of Object.entries(this._.schema)) {
            this.query[tableName] = new RelationalQueryBuilder(
              schema6.fullSchema,
              this._.schema,
              this._.tableNamesMap,
              schema6.fullSchema[tableName],
              columns,
              dialect6,
              session,
              this.mode
            );
          }
        }
        this.$cache = { invalidate: async (_params2) => {
        } };
      }
      $count(source, filters) {
        return new MySqlCountBuilder({ source, filters, session: this.session });
      }
      /**
       * Incorporates a previously defined CTE (using `$with`) into the main query.
       *
       * This method allows the main query to reference a temporary named result set.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
       *
       * @param queries The CTEs to incorporate into the main query.
       *
       * @example
       *
       * ```ts
       * // Define a subquery 'sq' as a CTE using $with
       * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
       *
       * // Incorporate the CTE 'sq' into the main query and select from it
       * const result = await db.with(sq).select().from(sq);
       * ```
       */
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new MySqlSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new MySqlSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries,
            distinct: true
          });
        }
        function update(table6) {
          return new MySqlUpdateBuilder(table6, self2.session, self2.dialect, queries);
        }
        function delete_(table6) {
          return new MySqlDeleteBase(table6, self2.session, self2.dialect, queries);
        }
        return { select: select2, selectDistinct, update, delete: delete_ };
      }
      select(fields) {
        return new MySqlSelectBuilder({ fields: fields ?? void 0, session: this.session, dialect: this.dialect });
      }
      selectDistinct(fields) {
        return new MySqlSelectBuilder({
          fields: fields ?? void 0,
          session: this.session,
          dialect: this.dialect,
          distinct: true
        });
      }
      /**
       * Creates an update query.
       *
       * Calling this method without `.where()` clause will update all rows in a table. The `.where()` clause specifies which rows should be updated.
       *
       * Use `.set()` method to specify which values to update.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param table The table to update.
       *
       * @example
       *
       * ```ts
       * // Update all rows in the 'cars' table
       * await db.update(cars).set({ color: 'red' });
       *
       * // Update rows with filters and conditions
       * await db.update(cars).set({ color: 'red' }).where(eq(cars.brand, 'BMW'));
       * ```
       */
      update(table6) {
        return new MySqlUpdateBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates an insert query.
       *
       * Calling this method will create new rows in a table. Use `.values()` method to specify which values to insert.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert}
       *
       * @param table The table to insert into.
       *
       * @example
       *
       * ```ts
       * // Insert one row
       * await db.insert(cars).values({ brand: 'BMW' });
       *
       * // Insert multiple rows
       * await db.insert(cars).values([{ brand: 'BMW' }, { brand: 'Porsche' }]);
       * ```
       */
      insert(table6) {
        return new MySqlInsertBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates a delete query.
       *
       * Calling this method without `.where()` clause will delete all rows in a table. The `.where()` clause specifies which rows should be deleted.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param table The table to delete from.
       *
       * @example
       *
       * ```ts
       * // Delete all rows in the 'cars' table
       * await db.delete(cars);
       *
       * // Delete rows with filters and conditions
       * await db.delete(cars).where(eq(cars.color, 'green'));
       * ```
       */
      delete(table6) {
        return new MySqlDeleteBase(table6, this.session, this.dialect);
      }
      execute(query) {
        return this.session.execute(typeof query === "string" ? sql.raw(query) : query.getSQL());
      }
      transaction(transaction, config) {
        return this.session.transaction(transaction, config);
      }
    };
    __publicField(MySqlDatabase, _a226, "MySqlDatabase");
  }
});

// ../drizzle-orm/dist/mysql-core/view.js
function mysqlViewWithSchema(name3, selection, schema6) {
  if (selection) {
    return new ManualViewBuilder(name3, selection, schema6);
  }
  return new ViewBuilder(name3, schema6);
}
var _a227, ViewBuilderCore, _a228, _b180, ViewBuilder, _a229, _b181, ManualViewBuilder, _a230, _b182, _c6, MySqlView;
var init_view = __esm({
  "../drizzle-orm/dist/mysql-core/view.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_utils();
    init_query_builder2();
    init_table3();
    init_view_base();
    init_view_common2();
    _a227 = entityKind;
    ViewBuilderCore = class {
      constructor(name3, schema6) {
        __publicField(this, "config", {});
        this.name = name3;
        this.schema = schema6;
      }
      algorithm(algorithm) {
        this.config.algorithm = algorithm;
        return this;
      }
      sqlSecurity(sqlSecurity) {
        this.config.sqlSecurity = sqlSecurity;
        return this;
      }
      withCheckOption(withCheckOption) {
        this.config.withCheckOption = withCheckOption ?? "cascaded";
        return this;
      }
    };
    __publicField(ViewBuilderCore, _a227, "MySqlViewBuilder");
    ViewBuilder = class extends (_b180 = ViewBuilderCore, _a228 = entityKind, _b180) {
      as(qb) {
        if (typeof qb === "function") {
          qb = qb(new QueryBuilder());
        }
        const selectionProxy = new SelectionProxyHandler({
          alias: this.name,
          sqlBehavior: "error",
          sqlAliasedBehavior: "alias",
          replaceOriginalName: true
        });
        const aliasedSelection = new Proxy(qb.getSelectedFields(), selectionProxy);
        return new Proxy(
          new MySqlView({
            mysqlConfig: this.config,
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: aliasedSelection,
              query: qb.getSQL().inlineParams()
            }
          }),
          selectionProxy
        );
      }
    };
    __publicField(ViewBuilder, _a228, "MySqlViewBuilder");
    ManualViewBuilder = class extends (_b181 = ViewBuilderCore, _a229 = entityKind, _b181) {
      constructor(name3, columns, schema6) {
        super(name3, schema6);
        __publicField(this, "columns");
        this.columns = getTableColumns(mysqlTable(name3, columns));
      }
      existing() {
        return new Proxy(
          new MySqlView({
            mysqlConfig: void 0,
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: this.columns,
              query: void 0
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
      as(query) {
        return new Proxy(
          new MySqlView({
            mysqlConfig: this.config,
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: this.columns,
              query: query.inlineParams()
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
    };
    __publicField(ManualViewBuilder, _a229, "MySqlManualViewBuilder");
    MySqlView = class extends (_c6 = MySqlViewBase, _b182 = entityKind, _a230 = MySqlViewConfig, _c6) {
      constructor({ mysqlConfig, config }) {
        super(config);
        __publicField(this, _a230);
        this[MySqlViewConfig] = mysqlConfig;
      }
    };
    __publicField(MySqlView, _b182, "MySqlView");
  }
});

// ../drizzle-orm/dist/mysql-core/schema.js
var _a231, MySqlSchema;
var init_schema = __esm({
  "../drizzle-orm/dist/mysql-core/schema.js"() {
    "use strict";
    init_entity();
    init_table3();
    init_view();
    _a231 = entityKind;
    MySqlSchema = class {
      constructor(schemaName) {
        __publicField(this, "table", (name3, columns, extraConfig) => {
          return mysqlTableWithSchema(name3, columns, extraConfig, this.schemaName);
        });
        __publicField(this, "view", (name3, columns) => {
          return mysqlViewWithSchema(name3, columns, this.schemaName);
        });
        this.schemaName = schemaName;
      }
    };
    __publicField(MySqlSchema, _a231, "MySqlSchema");
  }
});

// ../drizzle-orm/dist/cache/core/cache.js
async function hashQuery(sql3, params) {
  const dataToHash = `${sql3}-${JSON.stringify(params)}`;
  const encoder = new TextEncoder();
  const data = encoder.encode(dataToHash);
  const hashBuffer = await crypto.subtle.digest("SHA-256", data);
  const hashArray = [...new Uint8Array(hashBuffer)];
  const hashHex = hashArray.map((b9) => b9.toString(16).padStart(2, "0")).join("");
  return hashHex;
}
var _a232, Cache, _a233, _b183, NoopCache;
var init_cache = __esm({
  "../drizzle-orm/dist/cache/core/cache.js"() {
    "use strict";
    init_entity();
    _a232 = entityKind;
    Cache = class {
    };
    __publicField(Cache, _a232, "Cache");
    NoopCache = class extends (_b183 = Cache, _a233 = entityKind, _b183) {
      strategy() {
        return "all";
      }
      async get(_key) {
        return void 0;
      }
      async put(_hashedQuery, _response, _tables, _config) {
      }
      async onMutate(_params2) {
      }
    };
    __publicField(NoopCache, _a233, "NoopCache");
  }
});

// ../drizzle-orm/dist/mysql-core/session.js
var _a234, MySqlPreparedQuery, _a235, MySqlSession, _a236, _b184, MySqlTransaction;
var init_session = __esm({
  "../drizzle-orm/dist/mysql-core/session.js"() {
    "use strict";
    init_cache();
    init_entity();
    init_errors();
    init_sql();
    init_db();
    _a234 = entityKind;
    MySqlPreparedQuery = class {
      constructor(cache5, queryMetadata, cacheConfig) {
        /** @internal */
        __publicField(this, "joinsNotNullableMap");
        this.cache = cache5;
        this.queryMetadata = queryMetadata;
        this.cacheConfig = cacheConfig;
        if (cache5 && cache5.strategy() === "all" && cacheConfig === void 0) {
          this.cacheConfig = { enable: true, autoInvalidate: true };
        }
        if (!this.cacheConfig?.enable) {
          this.cacheConfig = void 0;
        }
      }
      /** @internal */
      async queryWithCache(queryString, params, query) {
        if (this.cache === void 0 || is(this.cache, NoopCache) || this.queryMetadata === void 0) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.cacheConfig && !this.cacheConfig.enable) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if ((this.queryMetadata.type === "insert" || this.queryMetadata.type === "update" || this.queryMetadata.type === "delete") && this.queryMetadata.tables.length > 0) {
          try {
            const [res] = await Promise.all([
              query(),
              this.cache.onMutate({ tables: this.queryMetadata.tables })
            ]);
            return res;
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (!this.cacheConfig) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.queryMetadata.type === "select") {
          const fromCache = await this.cache.get(
            this.cacheConfig.tag ?? await hashQuery(queryString, params),
            this.queryMetadata.tables,
            this.cacheConfig.tag !== void 0,
            this.cacheConfig.autoInvalidate
          );
          if (fromCache === void 0) {
            let result;
            try {
              result = await query();
            } catch (e6) {
              throw new DrizzleQueryError(queryString, params, e6);
            }
            await this.cache.put(
              this.cacheConfig.tag ?? await hashQuery(queryString, params),
              result,
              // make sure we send tables that were used in a query only if user wants to invalidate it on each write
              this.cacheConfig.autoInvalidate ? this.queryMetadata.tables : [],
              this.cacheConfig.tag !== void 0,
              this.cacheConfig.config
            );
            return result;
          }
          return fromCache;
        }
        try {
          return await query();
        } catch (e6) {
          throw new DrizzleQueryError(queryString, params, e6);
        }
      }
    };
    __publicField(MySqlPreparedQuery, _a234, "MySqlPreparedQuery");
    _a235 = entityKind;
    MySqlSession = class {
      constructor(dialect6) {
        this.dialect = dialect6;
      }
      execute(query) {
        return this.prepareQuery(
          this.dialect.sqlToQuery(query),
          void 0
        ).execute();
      }
      async count(sql22) {
        const res = await this.execute(sql22);
        return Number(
          res[0][0]["count"]
        );
      }
      getSetTransactionSQL(config) {
        const parts2 = [];
        if (config.isolationLevel) {
          parts2.push(`isolation level ${config.isolationLevel}`);
        }
        return parts2.length ? sql`set transaction ${sql.raw(parts2.join(" "))}` : void 0;
      }
      getStartTransactionSQL(config) {
        const parts2 = [];
        if (config.withConsistentSnapshot) {
          parts2.push("with consistent snapshot");
        }
        if (config.accessMode) {
          parts2.push(config.accessMode);
        }
        return parts2.length ? sql`start transaction ${sql.raw(parts2.join(" "))}` : void 0;
      }
    };
    __publicField(MySqlSession, _a235, "MySqlSession");
    MySqlTransaction = class extends (_b184 = MySqlDatabase, _a236 = entityKind, _b184) {
      constructor(dialect6, session, schema6, nestedIndex, mode) {
        super(dialect6, session, schema6, mode);
        this.schema = schema6;
        this.nestedIndex = nestedIndex;
      }
      rollback() {
        throw new TransactionRollbackError();
      }
    };
    __publicField(MySqlTransaction, _a236, "MySqlTransaction");
  }
});

// ../drizzle-orm/dist/mysql-core/subquery.js
var init_subquery2 = __esm({
  "../drizzle-orm/dist/mysql-core/subquery.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/mysql-core/index.js
var init_mysql_core = __esm({
  "../drizzle-orm/dist/mysql-core/index.js"() {
    "use strict";
    init_alias2();
    init_checks();
    init_columns();
    init_db();
    init_dialect();
    init_foreign_keys2();
    init_indexes();
    init_primary_keys2();
    init_query_builders();
    init_schema();
    init_session();
    init_subquery2();
    init_table3();
    init_unique_constraint2();
    init_utils3();
    init_view_common2();
    init_view();
  }
});

// ../drizzle-orm/dist/pg-core/alias.js
function alias(table6, alias2) {
  return new Proxy(table6, new TableAliasProxyHandler(alias2, false));
}
var init_alias3 = __esm({
  "../drizzle-orm/dist/pg-core/alias.js"() {
    "use strict";
    init_alias();
  }
});

// ../drizzle-orm/dist/pg-core/checks.js
function check(name3, value) {
  return new CheckBuilder2(name3, value);
}
var _a237, CheckBuilder2, _a238, Check2;
var init_checks2 = __esm({
  "../drizzle-orm/dist/pg-core/checks.js"() {
    "use strict";
    init_entity();
    _a237 = entityKind;
    CheckBuilder2 = class {
      constructor(name3, value) {
        __publicField(this, "brand");
        this.name = name3;
        this.value = value;
      }
      /** @internal */
      build(table6) {
        return new Check2(table6, this);
      }
    };
    __publicField(CheckBuilder2, _a237, "PgCheckBuilder");
    _a238 = entityKind;
    Check2 = class {
      constructor(table6, builder) {
        __publicField(this, "name");
        __publicField(this, "value");
        this.table = table6;
        this.name = builder.name;
        this.value = builder.value;
      }
    };
    __publicField(Check2, _a238, "PgCheck");
  }
});

// ../drizzle-orm/dist/pg-core/columns/index.js
var init_columns2 = __esm({
  "../drizzle-orm/dist/pg-core/columns/index.js"() {
    "use strict";
    init_bigint();
    init_bigserial();
    init_boolean();
    init_char();
    init_cidr();
    init_common();
    init_custom();
    init_date();
    init_double_precision();
    init_enum();
    init_inet();
    init_int_common();
    init_integer();
    init_interval();
    init_json();
    init_jsonb();
    init_line();
    init_macaddr();
    init_macaddr8();
    init_numeric();
    init_point();
    init_geometry();
    init_real();
    init_serial();
    init_smallint();
    init_smallserial();
    init_text();
    init_time();
    init_timestamp();
    init_uuid();
    init_varchar();
    init_bit();
    init_halfvec();
    init_sparsevec();
    init_vector();
  }
});

// ../drizzle-orm/dist/pg-core/indexes.js
function index(name3) {
  return new IndexBuilderOn2(false, name3);
}
function uniqueIndex(name3) {
  return new IndexBuilderOn2(true, name3);
}
var _a239, IndexBuilderOn2, _a240, IndexBuilder2, _a241, Index2;
var init_indexes2 = __esm({
  "../drizzle-orm/dist/pg-core/indexes.js"() {
    "use strict";
    init_sql();
    init_entity();
    init_columns2();
    _a239 = entityKind;
    IndexBuilderOn2 = class {
      constructor(unique2, name3) {
        this.unique = unique2;
        this.name = name3;
      }
      on(...columns) {
        return new IndexBuilder2(
          columns.map((it2) => {
            if (is(it2, SQL)) {
              return it2;
            }
            it2 = it2;
            const clonedIndexedColumn = new IndexedColumn(it2.name, !!it2.keyAsName, it2.columnType, it2.indexConfig);
            it2.indexConfig = JSON.parse(JSON.stringify(it2.defaultConfig));
            return clonedIndexedColumn;
          }),
          this.unique,
          false,
          this.name
        );
      }
      onOnly(...columns) {
        return new IndexBuilder2(
          columns.map((it2) => {
            if (is(it2, SQL)) {
              return it2;
            }
            it2 = it2;
            const clonedIndexedColumn = new IndexedColumn(it2.name, !!it2.keyAsName, it2.columnType, it2.indexConfig);
            it2.indexConfig = it2.defaultConfig;
            return clonedIndexedColumn;
          }),
          this.unique,
          true,
          this.name
        );
      }
      /**
       * Specify what index method to use. Choices are `btree`, `hash`, `gist`, `spgist`, `gin`, `brin`, or user-installed access methods like `bloom`. The default method is `btree.
       *
       * If you have the `pg_vector` extension installed in your database, you can use the `hnsw` and `ivfflat` options, which are predefined types.
       *
       * **You can always specify any string you want in the method, in case Drizzle doesn't have it natively in its types**
       *
       * @param method The name of the index method to be used
       * @param columns
       * @returns
       */
      using(method, ...columns) {
        return new IndexBuilder2(
          columns.map((it2) => {
            if (is(it2, SQL)) {
              return it2;
            }
            it2 = it2;
            const clonedIndexedColumn = new IndexedColumn(it2.name, !!it2.keyAsName, it2.columnType, it2.indexConfig);
            it2.indexConfig = JSON.parse(JSON.stringify(it2.defaultConfig));
            return clonedIndexedColumn;
          }),
          this.unique,
          true,
          this.name,
          method
        );
      }
    };
    __publicField(IndexBuilderOn2, _a239, "PgIndexBuilderOn");
    _a240 = entityKind;
    IndexBuilder2 = class {
      constructor(columns, unique2, only, name3, method = "btree") {
        /** @internal */
        __publicField(this, "config");
        this.config = {
          name: name3,
          columns,
          unique: unique2,
          only,
          method
        };
      }
      concurrently() {
        this.config.concurrently = true;
        return this;
      }
      with(obj) {
        this.config.with = obj;
        return this;
      }
      where(condition) {
        this.config.where = condition;
        return this;
      }
      /** @internal */
      build(table6) {
        return new Index2(this.config, table6);
      }
    };
    __publicField(IndexBuilder2, _a240, "PgIndexBuilder");
    _a241 = entityKind;
    Index2 = class {
      constructor(config, table6) {
        __publicField(this, "config");
        this.config = { ...config, table: table6 };
      }
    };
    __publicField(Index2, _a241, "PgIndex");
  }
});

// ../drizzle-orm/dist/pg-core/policies.js
function pgPolicy(name3, config) {
  return new PgPolicy(name3, config);
}
var _a242, PgPolicy;
var init_policies = __esm({
  "../drizzle-orm/dist/pg-core/policies.js"() {
    "use strict";
    init_entity();
    _a242 = entityKind;
    PgPolicy = class {
      constructor(name3, config) {
        __publicField(this, "as");
        __publicField(this, "for");
        __publicField(this, "to");
        __publicField(this, "using");
        __publicField(this, "withCheck");
        /** @internal */
        __publicField(this, "_linkedTable");
        this.name = name3;
        if (config) {
          this.as = config.as;
          this.for = config.for;
          this.to = config.to;
          this.using = config.using;
          this.withCheck = config.withCheck;
        }
      }
      link(table6) {
        this._linkedTable = table6;
        return this;
      }
    };
    __publicField(PgPolicy, _a242, "PgPolicy");
  }
});

// ../drizzle-orm/dist/pg-core/view-common.js
var PgViewConfig;
var init_view_common3 = __esm({
  "../drizzle-orm/dist/pg-core/view-common.js"() {
    "use strict";
    PgViewConfig = Symbol.for("drizzle:PgViewConfig");
  }
});

// ../drizzle-orm/dist/pg-core/view-base.js
var _a243, _b185, PgViewBase;
var init_view_base2 = __esm({
  "../drizzle-orm/dist/pg-core/view-base.js"() {
    "use strict";
    init_entity();
    init_sql();
    PgViewBase = class extends (_b185 = View, _a243 = entityKind, _b185) {
    };
    __publicField(PgViewBase, _a243, "PgViewBase");
  }
});

// ../drizzle-orm/dist/pg-core/dialect.js
var _a244, PgDialect;
var init_dialect2 = __esm({
  "../drizzle-orm/dist/pg-core/dialect.js"() {
    "use strict";
    init_alias();
    init_casing();
    init_column();
    init_entity();
    init_errors();
    init_columns2();
    init_table2();
    init_relations();
    init_sql2();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_view_base2();
    _a244 = entityKind;
    PgDialect = class {
      constructor(config) {
        /** @internal */
        __publicField(this, "casing");
        this.casing = new CasingCache(config?.casing);
      }
      async migrate(migrations, session, config) {
        const migrationsTable = typeof config === "string" ? "__drizzle_migrations" : config.migrationsTable ?? "__drizzle_migrations";
        const migrationsSchema = typeof config === "string" ? "drizzle" : config.migrationsSchema ?? "drizzle";
        const migrationTableCreate = sql`
			CREATE TABLE IF NOT EXISTS ${sql.identifier(migrationsSchema)}.${sql.identifier(migrationsTable)} (
				id SERIAL PRIMARY KEY,
				hash text NOT NULL,
				created_at bigint
			)
		`;
        await session.execute(sql`CREATE SCHEMA IF NOT EXISTS ${sql.identifier(migrationsSchema)}`);
        await session.execute(migrationTableCreate);
        const dbMigrations = await session.all(
          sql`select id, hash, created_at from ${sql.identifier(migrationsSchema)}.${sql.identifier(migrationsTable)} order by created_at desc limit 1`
        );
        const lastDbMigration = dbMigrations[0];
        await session.transaction(async (tx) => {
          for await (const migration of migrations) {
            if (!lastDbMigration || Number(lastDbMigration.created_at) < migration.folderMillis) {
              for (const stmt of migration.sql) {
                await tx.execute(sql.raw(stmt));
              }
              await tx.execute(
                sql`insert into ${sql.identifier(migrationsSchema)}.${sql.identifier(migrationsTable)} ("hash", "created_at") values(${migration.hash}, ${migration.folderMillis})`
              );
            }
          }
        });
      }
      escapeName(name3) {
        return `"${name3}"`;
      }
      escapeParam(num) {
        return `$${num + 1}`;
      }
      escapeString(str) {
        return `'${str.replace(/'/g, "''")}'`;
      }
      buildWithCTE(queries) {
        if (!queries?.length) return void 0;
        const withSqlChunks = [sql`with `];
        for (const [i8, w10] of queries.entries()) {
          withSqlChunks.push(sql`${sql.identifier(w10._.alias)} as (${w10._.sql})`);
          if (i8 < queries.length - 1) {
            withSqlChunks.push(sql`, `);
          }
        }
        withSqlChunks.push(sql` `);
        return sql.join(withSqlChunks);
      }
      buildDeleteQuery({ table: table6, where, returning, withList }) {
        const withSql = this.buildWithCTE(withList);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        return sql`${withSql}delete from ${table6}${whereSql}${returningSql}`;
      }
      buildUpdateSet(table6, set) {
        const tableColumns = table6[Table.Symbol.Columns];
        const columnNames = Object.keys(tableColumns).filter(
          (colName) => set[colName] !== void 0 || tableColumns[colName]?.onUpdateFn !== void 0
        );
        const setSize = columnNames.length;
        return sql.join(columnNames.flatMap((colName, i8) => {
          const col = tableColumns[colName];
          const value = set[colName] ?? sql.param(col.onUpdateFn(), col);
          const res = sql`${sql.identifier(this.casing.getColumnCasing(col))} = ${value}`;
          if (i8 < setSize - 1) {
            return [res, sql.raw(", ")];
          }
          return [res];
        }));
      }
      buildUpdateQuery({ table: table6, set, where, returning, withList, from, joins }) {
        const withSql = this.buildWithCTE(withList);
        const tableName = table6[PgTable.Symbol.Name];
        const tableSchema = table6[PgTable.Symbol.Schema];
        const origTableName = table6[PgTable.Symbol.OriginalName];
        const alias2 = tableName === origTableName ? void 0 : tableName;
        const tableSql = sql`${tableSchema ? sql`${sql.identifier(tableSchema)}.` : void 0}${sql.identifier(origTableName)}${alias2 && sql` ${sql.identifier(alias2)}`}`;
        const setSql = this.buildUpdateSet(table6, set);
        const fromSql = from && sql.join([sql.raw(" from "), this.buildFromTable(from)]);
        const joinsSql = this.buildJoins(joins);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: !from })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        return sql`${withSql}update ${tableSql} set ${setSql}${fromSql}${joinsSql}${whereSql}${returningSql}`;
      }
      /**
       * Builds selection SQL with provided fields/expressions
       *
       * Examples:
       *
       * `select <selection> from`
       *
       * `insert ... returning <selection>`
       *
       * If `isSingleTable` is true, then columns won't be prefixed with table name
       */
      buildSelection(fields, { isSingleTable = false } = {}) {
        const columnsLen = fields.length;
        const chunks = fields.flatMap(({ field }, i8) => {
          const chunk = [];
          if (is(field, SQL.Aliased) && field.isSelectionField) {
            chunk.push(sql.identifier(field.fieldAlias));
          } else if (is(field, SQL.Aliased) || is(field, SQL)) {
            const query = is(field, SQL.Aliased) ? field.sql : field;
            if (isSingleTable) {
              chunk.push(
                new SQL(
                  query.queryChunks.map((c6) => {
                    if (is(c6, PgColumn)) {
                      return sql.identifier(this.casing.getColumnCasing(c6));
                    }
                    return c6;
                  })
                )
              );
            } else {
              chunk.push(query);
            }
            if (is(field, SQL.Aliased)) {
              chunk.push(sql` as ${sql.identifier(field.fieldAlias)}`);
            }
          } else if (is(field, Column)) {
            if (isSingleTable) {
              chunk.push(sql.identifier(this.casing.getColumnCasing(field)));
            } else {
              chunk.push(field);
            }
          }
          if (i8 < columnsLen - 1) {
            chunk.push(sql`, `);
          }
          return chunk;
        });
        return sql.join(chunks);
      }
      buildJoins(joins) {
        if (!joins || joins.length === 0) {
          return void 0;
        }
        const joinsArray = [];
        for (const [index7, joinMeta] of joins.entries()) {
          if (index7 === 0) {
            joinsArray.push(sql` `);
          }
          const table6 = joinMeta.table;
          const lateralSql = joinMeta.lateral ? sql` lateral` : void 0;
          const onSql = joinMeta.on ? sql` on ${joinMeta.on}` : void 0;
          if (is(table6, PgTable)) {
            const tableName = table6[PgTable.Symbol.Name];
            const tableSchema = table6[PgTable.Symbol.Schema];
            const origTableName = table6[PgTable.Symbol.OriginalName];
            const alias2 = tableName === origTableName ? void 0 : joinMeta.alias;
            joinsArray.push(
              sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${tableSchema ? sql`${sql.identifier(tableSchema)}.` : void 0}${sql.identifier(origTableName)}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
            );
          } else if (is(table6, View)) {
            const viewName = table6[ViewBaseConfig].name;
            const viewSchema = table6[ViewBaseConfig].schema;
            const origViewName = table6[ViewBaseConfig].originalName;
            const alias2 = viewName === origViewName ? void 0 : joinMeta.alias;
            joinsArray.push(
              sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${viewSchema ? sql`${sql.identifier(viewSchema)}.` : void 0}${sql.identifier(origViewName)}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
            );
          } else {
            joinsArray.push(
              sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${table6}${onSql}`
            );
          }
          if (index7 < joins.length - 1) {
            joinsArray.push(sql` `);
          }
        }
        return sql.join(joinsArray);
      }
      buildFromTable(table6) {
        if (is(table6, Table) && table6[Table.Symbol.IsAlias]) {
          let fullName = sql`${sql.identifier(table6[Table.Symbol.OriginalName])}`;
          if (table6[Table.Symbol.Schema]) {
            fullName = sql`${sql.identifier(table6[Table.Symbol.Schema])}.${fullName}`;
          }
          return sql`${fullName} ${sql.identifier(table6[Table.Symbol.Name])}`;
        }
        return table6;
      }
      buildSelectQuery({
        withList,
        fields,
        fieldsFlat,
        where,
        having,
        table: table6,
        joins,
        orderBy,
        groupBy,
        limit,
        offset,
        lockingClause,
        distinct,
        setOperators
      }) {
        const fieldsList = fieldsFlat ?? orderSelectedFields(fields);
        for (const f9 of fieldsList) {
          if (is(f9.field, Column) && getTableName(f9.field.table) !== (is(table6, Subquery) ? table6._.alias : is(table6, PgViewBase) ? table6[ViewBaseConfig].name : is(table6, SQL) ? void 0 : getTableName(table6)) && !((table22) => joins?.some(
            ({ alias: alias2 }) => alias2 === (table22[Table.Symbol.IsAlias] ? getTableName(table22) : table22[Table.Symbol.BaseName])
          ))(f9.field.table)) {
            const tableName = getTableName(f9.field.table);
            throw new Error(
              `Your "${f9.path.join("->")}" field references a column "${tableName}"."${f9.field.name}", but the table "${tableName}" is not part of the query! Did you forget to join it?`
            );
          }
        }
        const isSingleTable = !joins || joins.length === 0;
        const withSql = this.buildWithCTE(withList);
        let distinctSql;
        if (distinct) {
          distinctSql = distinct === true ? sql` distinct` : sql` distinct on (${sql.join(distinct.on, sql`, `)})`;
        }
        const selection = this.buildSelection(fieldsList, { isSingleTable });
        const tableSql = this.buildFromTable(table6);
        const joinsSql = this.buildJoins(joins);
        const whereSql = where ? sql` where ${where}` : void 0;
        const havingSql = having ? sql` having ${having}` : void 0;
        let orderBySql;
        if (orderBy && orderBy.length > 0) {
          orderBySql = sql` order by ${sql.join(orderBy, sql`, `)}`;
        }
        let groupBySql;
        if (groupBy && groupBy.length > 0) {
          groupBySql = sql` group by ${sql.join(groupBy, sql`, `)}`;
        }
        const limitSql = typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        const lockingClauseSql = sql.empty();
        if (lockingClause) {
          const clauseSql = sql` for ${sql.raw(lockingClause.strength)}`;
          if (lockingClause.config.of) {
            clauseSql.append(
              sql` of ${sql.join(
                Array.isArray(lockingClause.config.of) ? lockingClause.config.of : [lockingClause.config.of],
                sql`, `
              )}`
            );
          }
          if (lockingClause.config.noWait) {
            clauseSql.append(sql` nowait`);
          } else if (lockingClause.config.skipLocked) {
            clauseSql.append(sql` skip locked`);
          }
          lockingClauseSql.append(clauseSql);
        }
        const finalQuery = sql`${withSql}select${distinctSql} ${selection} from ${tableSql}${joinsSql}${whereSql}${groupBySql}${havingSql}${orderBySql}${limitSql}${offsetSql}${lockingClauseSql}`;
        if (setOperators.length > 0) {
          return this.buildSetOperations(finalQuery, setOperators);
        }
        return finalQuery;
      }
      buildSetOperations(leftSelect, setOperators) {
        const [setOperator, ...rest] = setOperators;
        if (!setOperator) {
          throw new Error("Cannot pass undefined values to any set operator");
        }
        if (rest.length === 0) {
          return this.buildSetOperationQuery({ leftSelect, setOperator });
        }
        return this.buildSetOperations(
          this.buildSetOperationQuery({ leftSelect, setOperator }),
          rest
        );
      }
      buildSetOperationQuery({
        leftSelect,
        setOperator: { type, isAll, rightSelect, limit, orderBy, offset }
      }) {
        const leftChunk = sql`(${leftSelect.getSQL()}) `;
        const rightChunk = sql`(${rightSelect.getSQL()})`;
        let orderBySql;
        if (orderBy && orderBy.length > 0) {
          const orderByValues = [];
          for (const singleOrderBy of orderBy) {
            if (is(singleOrderBy, PgColumn)) {
              orderByValues.push(sql.identifier(singleOrderBy.name));
            } else if (is(singleOrderBy, SQL)) {
              for (let i8 = 0; i8 < singleOrderBy.queryChunks.length; i8++) {
                const chunk = singleOrderBy.queryChunks[i8];
                if (is(chunk, PgColumn)) {
                  singleOrderBy.queryChunks[i8] = sql.identifier(chunk.name);
                }
              }
              orderByValues.push(sql`${singleOrderBy}`);
            } else {
              orderByValues.push(sql`${singleOrderBy}`);
            }
          }
          orderBySql = sql` order by ${sql.join(orderByValues, sql`, `)} `;
        }
        const limitSql = typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
        const operatorChunk = sql.raw(`${type} ${isAll ? "all " : ""}`);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        return sql`${leftChunk}${operatorChunk}${rightChunk}${orderBySql}${limitSql}${offsetSql}`;
      }
      buildInsertQuery({ table: table6, values: valuesOrSelect, onConflict, returning, withList, select: select2, overridingSystemValue_ }) {
        const valuesSqlList = [];
        const columns = table6[Table.Symbol.Columns];
        const colEntries = Object.entries(columns).filter(([_7, col]) => !col.shouldDisableInsert());
        const insertOrder = colEntries.map(
          ([, column6]) => sql.identifier(this.casing.getColumnCasing(column6))
        );
        if (select2) {
          const select22 = valuesOrSelect;
          if (is(select22, SQL)) {
            valuesSqlList.push(select22);
          } else {
            valuesSqlList.push(select22.getSQL());
          }
        } else {
          const values2 = valuesOrSelect;
          valuesSqlList.push(sql.raw("values "));
          for (const [valueIndex, value] of values2.entries()) {
            const valueList = [];
            for (const [fieldName, col] of colEntries) {
              const colValue = value[fieldName];
              if (colValue === void 0 || is(colValue, Param) && colValue.value === void 0) {
                if (col.defaultFn !== void 0) {
                  const defaultFnResult = col.defaultFn();
                  const defaultValue = is(defaultFnResult, SQL) ? defaultFnResult : sql.param(defaultFnResult, col);
                  valueList.push(defaultValue);
                } else if (!col.default && col.onUpdateFn !== void 0) {
                  const onUpdateFnResult = col.onUpdateFn();
                  const newValue = is(onUpdateFnResult, SQL) ? onUpdateFnResult : sql.param(onUpdateFnResult, col);
                  valueList.push(newValue);
                } else {
                  valueList.push(sql`default`);
                }
              } else {
                valueList.push(colValue);
              }
            }
            valuesSqlList.push(valueList);
            if (valueIndex < values2.length - 1) {
              valuesSqlList.push(sql`, `);
            }
          }
        }
        const withSql = this.buildWithCTE(withList);
        const valuesSql = sql.join(valuesSqlList);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const onConflictSql = onConflict ? sql` on conflict ${onConflict}` : void 0;
        const overridingSql = overridingSystemValue_ === true ? sql`overriding system value ` : void 0;
        return sql`${withSql}insert into ${table6} ${insertOrder} ${overridingSql}${valuesSql}${onConflictSql}${returningSql}`;
      }
      buildRefreshMaterializedViewQuery({ view: view5, concurrently, withNoData }) {
        const concurrentlySql = concurrently ? sql` concurrently` : void 0;
        const withNoDataSql = withNoData ? sql` with no data` : void 0;
        return sql`refresh materialized view${concurrentlySql} ${view5}${withNoDataSql}`;
      }
      prepareTyping(encoder) {
        if (is(encoder, PgJsonb) || is(encoder, PgJson)) {
          return "json";
        } else if (is(encoder, PgNumeric)) {
          return "decimal";
        } else if (is(encoder, PgTime)) {
          return "time";
        } else if (is(encoder, PgTimestamp) || is(encoder, PgTimestampString)) {
          return "timestamp";
        } else if (is(encoder, PgDate) || is(encoder, PgDateString)) {
          return "date";
        } else if (is(encoder, PgUUID)) {
          return "uuid";
        } else {
          return "none";
        }
      }
      sqlToQuery(sql22, invokeSource) {
        return sql22.toQuery({
          casing: this.casing,
          escapeName: this.escapeName,
          escapeParam: this.escapeParam,
          escapeString: this.escapeString,
          prepareTyping: this.prepareTyping,
          invokeSource
        });
      }
      // buildRelationalQueryWithPK({
      // 	fullSchema,
      // 	schema,
      // 	tableNamesMap,
      // 	table,
      // 	tableConfig,
      // 	queryConfig: config,
      // 	tableAlias,
      // 	isRoot = false,
      // 	joinOn,
      // }: {
      // 	fullSchema: Record<string, unknown>;
      // 	schema: TablesRelationalConfig;
      // 	tableNamesMap: Record<string, string>;
      // 	table: PgTable;
      // 	tableConfig: TableRelationalConfig;
      // 	queryConfig: true | DBQueryConfig<'many', true>;
      // 	tableAlias: string;
      // 	isRoot?: boolean;
      // 	joinOn?: SQL;
      // }): BuildRelationalQueryResult<PgTable, PgColumn> {
      // 	// For { "<relation>": true }, return a table with selection of all columns
      // 	if (config === true) {
      // 		const selectionEntries = Object.entries(tableConfig.columns);
      // 		const selection: BuildRelationalQueryResult<PgTable, PgColumn>['selection'] = selectionEntries.map((
      // 			[key, value],
      // 		) => ({
      // 			dbKey: value.name,
      // 			tsKey: key,
      // 			field: value as PgColumn,
      // 			relationTableTsKey: undefined,
      // 			isJson: false,
      // 			selection: [],
      // 		}));
      // 		return {
      // 			tableTsKey: tableConfig.tsName,
      // 			sql: table,
      // 			selection,
      // 		};
      // 	}
      // 	// let selection: BuildRelationalQueryResult<PgTable, PgColumn>['selection'] = [];
      // 	// let selectionForBuild = selection;
      // 	const aliasedColumns = Object.fromEntries(
      // 		Object.entries(tableConfig.columns).map(([key, value]) => [key, aliasedTableColumn(value, tableAlias)]),
      // 	);
      // 	const aliasedRelations = Object.fromEntries(
      // 		Object.entries(tableConfig.relations).map(([key, value]) => [key, aliasedRelation(value, tableAlias)]),
      // 	);
      // 	const aliasedFields = Object.assign({}, aliasedColumns, aliasedRelations);
      // 	let where, hasUserDefinedWhere;
      // 	if (config.where) {
      // 		const whereSql = typeof config.where === 'function' ? config.where(aliasedFields, operators) : config.where;
      // 		where = whereSql && mapColumnsInSQLToAlias(whereSql, tableAlias);
      // 		hasUserDefinedWhere = !!where;
      // 	}
      // 	where = and(joinOn, where);
      // 	// const fieldsSelection: { tsKey: string; value: PgColumn | SQL.Aliased; isExtra?: boolean }[] = [];
      // 	let joins: Join[] = [];
      // 	let selectedColumns: string[] = [];
      // 	// Figure out which columns to select
      // 	if (config.columns) {
      // 		let isIncludeMode = false;
      // 		for (const [field, value] of Object.entries(config.columns)) {
      // 			if (value === undefined) {
      // 				continue;
      // 			}
      // 			if (field in tableConfig.columns) {
      // 				if (!isIncludeMode && value === true) {
      // 					isIncludeMode = true;
      // 				}
      // 				selectedColumns.push(field);
      // 			}
      // 		}
      // 		if (selectedColumns.length > 0) {
      // 			selectedColumns = isIncludeMode
      // 				? selectedColumns.filter((c) => config.columns?.[c] === true)
      // 				: Object.keys(tableConfig.columns).filter((key) => !selectedColumns.includes(key));
      // 		}
      // 	} else {
      // 		// Select all columns if selection is not specified
      // 		selectedColumns = Object.keys(tableConfig.columns);
      // 	}
      // 	// for (const field of selectedColumns) {
      // 	// 	const column = tableConfig.columns[field]! as PgColumn;
      // 	// 	fieldsSelection.push({ tsKey: field, value: column });
      // 	// }
      // 	let initiallySelectedRelations: {
      // 		tsKey: string;
      // 		queryConfig: true | DBQueryConfig<'many', false>;
      // 		relation: Relation;
      // 	}[] = [];
      // 	// let selectedRelations: BuildRelationalQueryResult<PgTable, PgColumn>['selection'] = [];
      // 	// Figure out which relations to select
      // 	if (config.with) {
      // 		initiallySelectedRelations = Object.entries(config.with)
      // 			.filter((entry): entry is [typeof entry[0], NonNullable<typeof entry[1]>] => !!entry[1])
      // 			.map(([tsKey, queryConfig]) => ({ tsKey, queryConfig, relation: tableConfig.relations[tsKey]! }));
      // 	}
      // 	const manyRelations = initiallySelectedRelations.filter((r) =>
      // 		is(r.relation, Many)
      // 		&& (schema[tableNamesMap[r.relation.referencedTable[Table.Symbol.Name]]!]?.primaryKey.length ?? 0) > 0
      // 	);
      // 	// If this is the last Many relation (or there are no Many relations), we are on the innermost subquery level
      // 	const isInnermostQuery = manyRelations.length < 2;
      // 	const selectedExtras: {
      // 		tsKey: string;
      // 		value: SQL.Aliased;
      // 	}[] = [];
      // 	// Figure out which extras to select
      // 	if (isInnermostQuery && config.extras) {
      // 		const extras = typeof config.extras === 'function'
      // 			? config.extras(aliasedFields, { sql })
      // 			: config.extras;
      // 		for (const [tsKey, value] of Object.entries(extras)) {
      // 			selectedExtras.push({
      // 				tsKey,
      // 				value: mapColumnsInAliasedSQLToAlias(value, tableAlias),
      // 			});
      // 		}
      // 	}
      // 	// Transform `fieldsSelection` into `selection`
      // 	// `fieldsSelection` shouldn't be used after this point
      // 	// for (const { tsKey, value, isExtra } of fieldsSelection) {
      // 	// 	selection.push({
      // 	// 		dbKey: is(value, SQL.Aliased) ? value.fieldAlias : tableConfig.columns[tsKey]!.name,
      // 	// 		tsKey,
      // 	// 		field: is(value, Column) ? aliasedTableColumn(value, tableAlias) : value,
      // 	// 		relationTableTsKey: undefined,
      // 	// 		isJson: false,
      // 	// 		isExtra,
      // 	// 		selection: [],
      // 	// 	});
      // 	// }
      // 	let orderByOrig = typeof config.orderBy === 'function'
      // 		? config.orderBy(aliasedFields, orderByOperators)
      // 		: config.orderBy ?? [];
      // 	if (!Array.isArray(orderByOrig)) {
      // 		orderByOrig = [orderByOrig];
      // 	}
      // 	const orderBy = orderByOrig.map((orderByValue) => {
      // 		if (is(orderByValue, Column)) {
      // 			return aliasedTableColumn(orderByValue, tableAlias) as PgColumn;
      // 		}
      // 		return mapColumnsInSQLToAlias(orderByValue, tableAlias);
      // 	});
      // 	const limit = isInnermostQuery ? config.limit : undefined;
      // 	const offset = isInnermostQuery ? config.offset : undefined;
      // 	// For non-root queries without additional config except columns, return a table with selection
      // 	if (
      // 		!isRoot
      // 		&& initiallySelectedRelations.length === 0
      // 		&& selectedExtras.length === 0
      // 		&& !where
      // 		&& orderBy.length === 0
      // 		&& limit === undefined
      // 		&& offset === undefined
      // 	) {
      // 		return {
      // 			tableTsKey: tableConfig.tsName,
      // 			sql: table,
      // 			selection: selectedColumns.map((key) => ({
      // 				dbKey: tableConfig.columns[key]!.name,
      // 				tsKey: key,
      // 				field: tableConfig.columns[key] as PgColumn,
      // 				relationTableTsKey: undefined,
      // 				isJson: false,
      // 				selection: [],
      // 			})),
      // 		};
      // 	}
      // 	const selectedRelationsWithoutPK:
      // 	// Process all relations without primary keys, because they need to be joined differently and will all be on the same query level
      // 	for (
      // 		const {
      // 			tsKey: selectedRelationTsKey,
      // 			queryConfig: selectedRelationConfigValue,
      // 			relation,
      // 		} of initiallySelectedRelations
      // 	) {
      // 		const normalizedRelation = normalizeRelation(schema, tableNamesMap, relation);
      // 		const relationTableName = relation.referencedTable[Table.Symbol.Name];
      // 		const relationTableTsName = tableNamesMap[relationTableName]!;
      // 		const relationTable = schema[relationTableTsName]!;
      // 		if (relationTable.primaryKey.length > 0) {
      // 			continue;
      // 		}
      // 		const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
      // 		const joinOn = and(
      // 			...normalizedRelation.fields.map((field, i) =>
      // 				eq(
      // 					aliasedTableColumn(normalizedRelation.references[i]!, relationTableAlias),
      // 					aliasedTableColumn(field, tableAlias),
      // 				)
      // 			),
      // 		);
      // 		const builtRelation = this.buildRelationalQueryWithoutPK({
      // 			fullSchema,
      // 			schema,
      // 			tableNamesMap,
      // 			table: fullSchema[relationTableTsName] as PgTable,
      // 			tableConfig: schema[relationTableTsName]!,
      // 			queryConfig: selectedRelationConfigValue,
      // 			tableAlias: relationTableAlias,
      // 			joinOn,
      // 			nestedQueryRelation: relation,
      // 		});
      // 		const field = sql`${sql.identifier(relationTableAlias)}.${sql.identifier('data')}`.as(selectedRelationTsKey);
      // 		joins.push({
      // 			on: sql`true`,
      // 			table: new Subquery(builtRelation.sql as SQL, {}, relationTableAlias),
      // 			alias: relationTableAlias,
      // 			joinType: 'left',
      // 			lateral: true,
      // 		});
      // 		selectedRelations.push({
      // 			dbKey: selectedRelationTsKey,
      // 			tsKey: selectedRelationTsKey,
      // 			field,
      // 			relationTableTsKey: relationTableTsName,
      // 			isJson: true,
      // 			selection: builtRelation.selection,
      // 		});
      // 	}
      // 	const oneRelations = initiallySelectedRelations.filter((r): r is typeof r & { relation: One } =>
      // 		is(r.relation, One)
      // 	);
      // 	// Process all One relations with PKs, because they can all be joined on the same level
      // 	for (
      // 		const {
      // 			tsKey: selectedRelationTsKey,
      // 			queryConfig: selectedRelationConfigValue,
      // 			relation,
      // 		} of oneRelations
      // 	) {
      // 		const normalizedRelation = normalizeRelation(schema, tableNamesMap, relation);
      // 		const relationTableName = relation.referencedTable[Table.Symbol.Name];
      // 		const relationTableTsName = tableNamesMap[relationTableName]!;
      // 		const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
      // 		const relationTable = schema[relationTableTsName]!;
      // 		if (relationTable.primaryKey.length === 0) {
      // 			continue;
      // 		}
      // 		const joinOn = and(
      // 			...normalizedRelation.fields.map((field, i) =>
      // 				eq(
      // 					aliasedTableColumn(normalizedRelation.references[i]!, relationTableAlias),
      // 					aliasedTableColumn(field, tableAlias),
      // 				)
      // 			),
      // 		);
      // 		const builtRelation = this.buildRelationalQueryWithPK({
      // 			fullSchema,
      // 			schema,
      // 			tableNamesMap,
      // 			table: fullSchema[relationTableTsName] as PgTable,
      // 			tableConfig: schema[relationTableTsName]!,
      // 			queryConfig: selectedRelationConfigValue,
      // 			tableAlias: relationTableAlias,
      // 			joinOn,
      // 		});
      // 		const field = sql`case when ${sql.identifier(relationTableAlias)} is null then null else json_build_array(${
      // 			sql.join(
      // 				builtRelation.selection.map(({ field }) =>
      // 					is(field, SQL.Aliased)
      // 						? sql`${sql.identifier(relationTableAlias)}.${sql.identifier(field.fieldAlias)}`
      // 						: is(field, Column)
      // 						? aliasedTableColumn(field, relationTableAlias)
      // 						: field
      // 				),
      // 				sql`, `,
      // 			)
      // 		}) end`.as(selectedRelationTsKey);
      // 		const isLateralJoin = is(builtRelation.sql, SQL);
      // 		joins.push({
      // 			on: isLateralJoin ? sql`true` : joinOn,
      // 			table: is(builtRelation.sql, SQL)
      // 				? new Subquery(builtRelation.sql, {}, relationTableAlias)
      // 				: aliasedTable(builtRelation.sql, relationTableAlias),
      // 			alias: relationTableAlias,
      // 			joinType: 'left',
      // 			lateral: is(builtRelation.sql, SQL),
      // 		});
      // 		selectedRelations.push({
      // 			dbKey: selectedRelationTsKey,
      // 			tsKey: selectedRelationTsKey,
      // 			field,
      // 			relationTableTsKey: relationTableTsName,
      // 			isJson: true,
      // 			selection: builtRelation.selection,
      // 		});
      // 	}
      // 	let distinct: PgSelectConfig['distinct'];
      // 	let tableFrom: PgTable | Subquery = table;
      // 	// Process first Many relation - each one requires a nested subquery
      // 	const manyRelation = manyRelations[0];
      // 	if (manyRelation) {
      // 		const {
      // 			tsKey: selectedRelationTsKey,
      // 			queryConfig: selectedRelationQueryConfig,
      // 			relation,
      // 		} = manyRelation;
      // 		distinct = {
      // 			on: tableConfig.primaryKey.map((c) => aliasedTableColumn(c as PgColumn, tableAlias)),
      // 		};
      // 		const normalizedRelation = normalizeRelation(schema, tableNamesMap, relation);
      // 		const relationTableName = relation.referencedTable[Table.Symbol.Name];
      // 		const relationTableTsName = tableNamesMap[relationTableName]!;
      // 		const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
      // 		const joinOn = and(
      // 			...normalizedRelation.fields.map((field, i) =>
      // 				eq(
      // 					aliasedTableColumn(normalizedRelation.references[i]!, relationTableAlias),
      // 					aliasedTableColumn(field, tableAlias),
      // 				)
      // 			),
      // 		);
      // 		const builtRelationJoin = this.buildRelationalQueryWithPK({
      // 			fullSchema,
      // 			schema,
      // 			tableNamesMap,
      // 			table: fullSchema[relationTableTsName] as PgTable,
      // 			tableConfig: schema[relationTableTsName]!,
      // 			queryConfig: selectedRelationQueryConfig,
      // 			tableAlias: relationTableAlias,
      // 			joinOn,
      // 		});
      // 		const builtRelationSelectionField = sql`case when ${
      // 			sql.identifier(relationTableAlias)
      // 		} is null then '[]' else json_agg(json_build_array(${
      // 			sql.join(
      // 				builtRelationJoin.selection.map(({ field }) =>
      // 					is(field, SQL.Aliased)
      // 						? sql`${sql.identifier(relationTableAlias)}.${sql.identifier(field.fieldAlias)}`
      // 						: is(field, Column)
      // 						? aliasedTableColumn(field, relationTableAlias)
      // 						: field
      // 				),
      // 				sql`, `,
      // 			)
      // 		})) over (partition by ${sql.join(distinct.on, sql`, `)}) end`.as(selectedRelationTsKey);
      // 		const isLateralJoin = is(builtRelationJoin.sql, SQL);
      // 		joins.push({
      // 			on: isLateralJoin ? sql`true` : joinOn,
      // 			table: isLateralJoin
      // 				? new Subquery(builtRelationJoin.sql as SQL, {}, relationTableAlias)
      // 				: aliasedTable(builtRelationJoin.sql as PgTable, relationTableAlias),
      // 			alias: relationTableAlias,
      // 			joinType: 'left',
      // 			lateral: isLateralJoin,
      // 		});
      // 		// Build the "from" subquery with the remaining Many relations
      // 		const builtTableFrom = this.buildRelationalQueryWithPK({
      // 			fullSchema,
      // 			schema,
      // 			tableNamesMap,
      // 			table,
      // 			tableConfig,
      // 			queryConfig: {
      // 				...config,
      // 				where: undefined,
      // 				orderBy: undefined,
      // 				limit: undefined,
      // 				offset: undefined,
      // 				with: manyRelations.slice(1).reduce<NonNullable<typeof config['with']>>(
      // 					(result, { tsKey, queryConfig: configValue }) => {
      // 						result[tsKey] = configValue;
      // 						return result;
      // 					},
      // 					{},
      // 				),
      // 			},
      // 			tableAlias,
      // 		});
      // 		selectedRelations.push({
      // 			dbKey: selectedRelationTsKey,
      // 			tsKey: selectedRelationTsKey,
      // 			field: builtRelationSelectionField,
      // 			relationTableTsKey: relationTableTsName,
      // 			isJson: true,
      // 			selection: builtRelationJoin.selection,
      // 		});
      // 		// selection = builtTableFrom.selection.map((item) =>
      // 		// 	is(item.field, SQL.Aliased)
      // 		// 		? { ...item, field: sql`${sql.identifier(tableAlias)}.${sql.identifier(item.field.fieldAlias)}` }
      // 		// 		: item
      // 		// );
      // 		// selectionForBuild = [{
      // 		// 	dbKey: '*',
      // 		// 	tsKey: '*',
      // 		// 	field: sql`${sql.identifier(tableAlias)}.*`,
      // 		// 	selection: [],
      // 		// 	isJson: false,
      // 		// 	relationTableTsKey: undefined,
      // 		// }];
      // 		// const newSelectionItem: (typeof selection)[number] = {
      // 		// 	dbKey: selectedRelationTsKey,
      // 		// 	tsKey: selectedRelationTsKey,
      // 		// 	field,
      // 		// 	relationTableTsKey: relationTableTsName,
      // 		// 	isJson: true,
      // 		// 	selection: builtRelationJoin.selection,
      // 		// };
      // 		// selection.push(newSelectionItem);
      // 		// selectionForBuild.push(newSelectionItem);
      // 		tableFrom = is(builtTableFrom.sql, PgTable)
      // 			? builtTableFrom.sql
      // 			: new Subquery(builtTableFrom.sql, {}, tableAlias);
      // 	}
      // 	if (selectedColumns.length === 0 && selectedRelations.length === 0 && selectedExtras.length === 0) {
      // 		throw new DrizzleError(`No fields selected for table "${tableConfig.tsName}" ("${tableAlias}")`);
      // 	}
      // 	let selection: BuildRelationalQueryResult<PgTable, PgColumn>['selection'];
      // 	function prepareSelectedColumns() {
      // 		return selectedColumns.map((key) => ({
      // 			dbKey: tableConfig.columns[key]!.name,
      // 			tsKey: key,
      // 			field: tableConfig.columns[key] as PgColumn,
      // 			relationTableTsKey: undefined,
      // 			isJson: false,
      // 			selection: [],
      // 		}));
      // 	}
      // 	function prepareSelectedExtras() {
      // 		return selectedExtras.map((item) => ({
      // 			dbKey: item.value.fieldAlias,
      // 			tsKey: item.tsKey,
      // 			field: item.value,
      // 			relationTableTsKey: undefined,
      // 			isJson: false,
      // 			selection: [],
      // 		}));
      // 	}
      // 	if (isRoot) {
      // 		selection = [
      // 			...prepareSelectedColumns(),
      // 			...prepareSelectedExtras(),
      // 		];
      // 	}
      // 	if (hasUserDefinedWhere || orderBy.length > 0) {
      // 		tableFrom = new Subquery(
      // 			this.buildSelectQuery({
      // 				table: is(tableFrom, PgTable) ? aliasedTable(tableFrom, tableAlias) : tableFrom,
      // 				fields: {},
      // 				fieldsFlat: selectionForBuild.map(({ field }) => ({
      // 					path: [],
      // 					field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field,
      // 				})),
      // 				joins,
      // 				distinct,
      // 			}),
      // 			{},
      // 			tableAlias,
      // 		);
      // 		selectionForBuild = selection.map((item) =>
      // 			is(item.field, SQL.Aliased)
      // 				? { ...item, field: sql`${sql.identifier(tableAlias)}.${sql.identifier(item.field.fieldAlias)}` }
      // 				: item
      // 		);
      // 		joins = [];
      // 		distinct = undefined;
      // 	}
      // 	const result = this.buildSelectQuery({
      // 		table: is(tableFrom, PgTable) ? aliasedTable(tableFrom, tableAlias) : tableFrom,
      // 		fields: {},
      // 		fieldsFlat: selectionForBuild.map(({ field }) => ({
      // 			path: [],
      // 			field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field,
      // 		})),
      // 		where,
      // 		limit,
      // 		offset,
      // 		joins,
      // 		orderBy,
      // 		distinct,
      // 	});
      // 	return {
      // 		tableTsKey: tableConfig.tsName,
      // 		sql: result,
      // 		selection,
      // 	};
      // }
      buildRelationalQueryWithoutPK({
        fullSchema,
        schema: schema6,
        tableNamesMap,
        table: table6,
        tableConfig,
        queryConfig: config,
        tableAlias,
        nestedQueryRelation,
        joinOn
      }) {
        let selection = [];
        let limit, offset, orderBy = [], where;
        const joins = [];
        if (config === true) {
          const selectionEntries = Object.entries(tableConfig.columns);
          selection = selectionEntries.map(([key, value]) => ({
            dbKey: value.name,
            tsKey: key,
            field: aliasedTableColumn(value, tableAlias),
            relationTableTsKey: void 0,
            isJson: false,
            selection: []
          }));
        } else {
          const aliasedColumns = Object.fromEntries(
            Object.entries(tableConfig.columns).map(([key, value]) => [key, aliasedTableColumn(value, tableAlias)])
          );
          if (config.where) {
            const whereSql = typeof config.where === "function" ? config.where(aliasedColumns, getOperators()) : config.where;
            where = whereSql && mapColumnsInSQLToAlias(whereSql, tableAlias);
          }
          const fieldsSelection = [];
          let selectedColumns = [];
          if (config.columns) {
            let isIncludeMode = false;
            for (const [field, value] of Object.entries(config.columns)) {
              if (value === void 0) {
                continue;
              }
              if (field in tableConfig.columns) {
                if (!isIncludeMode && value === true) {
                  isIncludeMode = true;
                }
                selectedColumns.push(field);
              }
            }
            if (selectedColumns.length > 0) {
              selectedColumns = isIncludeMode ? selectedColumns.filter((c6) => config.columns?.[c6] === true) : Object.keys(tableConfig.columns).filter((key) => !selectedColumns.includes(key));
            }
          } else {
            selectedColumns = Object.keys(tableConfig.columns);
          }
          for (const field of selectedColumns) {
            const column6 = tableConfig.columns[field];
            fieldsSelection.push({ tsKey: field, value: column6 });
          }
          let selectedRelations = [];
          if (config.with) {
            selectedRelations = Object.entries(config.with).filter((entry) => !!entry[1]).map(([tsKey, queryConfig]) => ({ tsKey, queryConfig, relation: tableConfig.relations[tsKey] }));
          }
          let extras;
          if (config.extras) {
            extras = typeof config.extras === "function" ? config.extras(aliasedColumns, { sql }) : config.extras;
            for (const [tsKey, value] of Object.entries(extras)) {
              fieldsSelection.push({
                tsKey,
                value: mapColumnsInAliasedSQLToAlias(value, tableAlias)
              });
            }
          }
          for (const { tsKey, value } of fieldsSelection) {
            selection.push({
              dbKey: is(value, SQL.Aliased) ? value.fieldAlias : tableConfig.columns[tsKey].name,
              tsKey,
              field: is(value, Column) ? aliasedTableColumn(value, tableAlias) : value,
              relationTableTsKey: void 0,
              isJson: false,
              selection: []
            });
          }
          let orderByOrig = typeof config.orderBy === "function" ? config.orderBy(aliasedColumns, getOrderByOperators()) : config.orderBy ?? [];
          if (!Array.isArray(orderByOrig)) {
            orderByOrig = [orderByOrig];
          }
          orderBy = orderByOrig.map((orderByValue) => {
            if (is(orderByValue, Column)) {
              return aliasedTableColumn(orderByValue, tableAlias);
            }
            return mapColumnsInSQLToAlias(orderByValue, tableAlias);
          });
          limit = config.limit;
          offset = config.offset;
          for (const {
            tsKey: selectedRelationTsKey,
            queryConfig: selectedRelationConfigValue,
            relation
          } of selectedRelations) {
            const normalizedRelation = normalizeRelation(schema6, tableNamesMap, relation);
            const relationTableName = getTableUniqueName(relation.referencedTable);
            const relationTableTsName = tableNamesMap[relationTableName];
            const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
            const joinOn2 = and(
              ...normalizedRelation.fields.map(
                (field2, i8) => eq(
                  aliasedTableColumn(normalizedRelation.references[i8], relationTableAlias),
                  aliasedTableColumn(field2, tableAlias)
                )
              )
            );
            const builtRelation = this.buildRelationalQueryWithoutPK({
              fullSchema,
              schema: schema6,
              tableNamesMap,
              table: fullSchema[relationTableTsName],
              tableConfig: schema6[relationTableTsName],
              queryConfig: is(relation, One) ? selectedRelationConfigValue === true ? { limit: 1 } : { ...selectedRelationConfigValue, limit: 1 } : selectedRelationConfigValue,
              tableAlias: relationTableAlias,
              joinOn: joinOn2,
              nestedQueryRelation: relation
            });
            const field = sql`${sql.identifier(relationTableAlias)}.${sql.identifier("data")}`.as(selectedRelationTsKey);
            joins.push({
              on: sql`true`,
              table: new Subquery(builtRelation.sql, {}, relationTableAlias),
              alias: relationTableAlias,
              joinType: "left",
              lateral: true
            });
            selection.push({
              dbKey: selectedRelationTsKey,
              tsKey: selectedRelationTsKey,
              field,
              relationTableTsKey: relationTableTsName,
              isJson: true,
              selection: builtRelation.selection
            });
          }
        }
        if (selection.length === 0) {
          throw new DrizzleError({ message: `No fields selected for table "${tableConfig.tsName}" ("${tableAlias}")` });
        }
        let result;
        where = and(joinOn, where);
        if (nestedQueryRelation) {
          let field = sql`json_build_array(${sql.join(
            selection.map(
              ({ field: field2, tsKey, isJson: isJson2 }) => isJson2 ? sql`${sql.identifier(`${tableAlias}_${tsKey}`)}.${sql.identifier("data")}` : is(field2, SQL.Aliased) ? field2.sql : field2
            ),
            sql`, `
          )})`;
          if (is(nestedQueryRelation, Many)) {
            field = sql`coalesce(json_agg(${field}${orderBy.length > 0 ? sql` order by ${sql.join(orderBy, sql`, `)}` : void 0}), '[]'::json)`;
          }
          const nestedSelection = [{
            dbKey: "data",
            tsKey: "data",
            field: field.as("data"),
            isJson: true,
            relationTableTsKey: tableConfig.tsName,
            selection
          }];
          const needsSubquery = limit !== void 0 || offset !== void 0 || orderBy.length > 0;
          if (needsSubquery) {
            result = this.buildSelectQuery({
              table: aliasedTable(table6, tableAlias),
              fields: {},
              fieldsFlat: [{
                path: [],
                field: sql.raw("*")
              }],
              where,
              limit,
              offset,
              orderBy,
              setOperators: []
            });
            where = void 0;
            limit = void 0;
            offset = void 0;
            orderBy = [];
          } else {
            result = aliasedTable(table6, tableAlias);
          }
          result = this.buildSelectQuery({
            table: is(result, PgTable) ? result : new Subquery(result, {}, tableAlias),
            fields: {},
            fieldsFlat: nestedSelection.map(({ field: field2 }) => ({
              path: [],
              field: is(field2, Column) ? aliasedTableColumn(field2, tableAlias) : field2
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        } else {
          result = this.buildSelectQuery({
            table: aliasedTable(table6, tableAlias),
            fields: {},
            fieldsFlat: selection.map(({ field }) => ({
              path: [],
              field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        }
        return {
          tableTsKey: tableConfig.tsName,
          sql: result,
          selection
        };
      }
    };
    __publicField(PgDialect, _a244, "PgDialect");
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/select.js
function createSetOperator2(type, isAll) {
  return (leftSelect, rightSelect, ...restSelects) => {
    const setOperators = [rightSelect, ...restSelects].map((select2) => ({
      type,
      isAll,
      rightSelect: select2
    }));
    for (const setOperator of setOperators) {
      if (!haveSameKeys(leftSelect.getSelectedFields(), setOperator.rightSelect.getSelectedFields())) {
        throw new Error(
          "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
        );
      }
    }
    return leftSelect.addSetOperators(setOperators);
  };
}
var _a245, PgSelectBuilder, _a246, _b186, PgSelectQueryBuilderBase, _a247, _b187, PgSelectBase, getPgSetOperators, union2, unionAll2, intersect2, intersectAll2, except2, exceptAll2;
var init_select3 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/select.js"() {
    "use strict";
    init_entity();
    init_view_base2();
    init_query_builder();
    init_query_promise();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_table();
    init_tracing();
    init_utils();
    init_utils();
    init_view_common();
    init_utils4();
    _a245 = entityKind;
    PgSelectBuilder = class {
      constructor(config) {
        __publicField(this, "fields");
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "withList", []);
        __publicField(this, "distinct");
        __publicField(this, "authToken");
        this.fields = config.fields;
        this.session = config.session;
        this.dialect = config.dialect;
        if (config.withList) {
          this.withList = config.withList;
        }
        this.distinct = config.distinct;
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      /**
       * Specify the table, subquery, or other target that you're
       * building a select query against.
       *
       * {@link https://www.postgresql.org/docs/current/sql-select.html#SQL-FROM | Postgres from documentation}
       */
      from(source) {
        const isPartialSelect = !!this.fields;
        const src = source;
        let fields;
        if (this.fields) {
          fields = this.fields;
        } else if (is(src, Subquery)) {
          fields = Object.fromEntries(
            Object.keys(src._.selectedFields).map((key) => [key, src[key]])
          );
        } else if (is(src, PgViewBase)) {
          fields = src[ViewBaseConfig].selectedFields;
        } else if (is(src, SQL)) {
          fields = {};
        } else {
          fields = getTableColumns(src);
        }
        return new PgSelectBase({
          table: src,
          fields,
          isPartialSelect,
          session: this.session,
          dialect: this.dialect,
          withList: this.withList,
          distinct: this.distinct
        }).setToken(this.authToken);
      }
    };
    __publicField(PgSelectBuilder, _a245, "PgSelectBuilder");
    PgSelectQueryBuilderBase = class extends (_b186 = TypedQueryBuilder, _a246 = entityKind, _b186) {
      constructor({ table: table6, fields, isPartialSelect, session, dialect: dialect6, withList, distinct }) {
        super();
        __publicField(this, "_");
        __publicField(this, "config");
        __publicField(this, "joinsNotNullableMap");
        __publicField(this, "tableName");
        __publicField(this, "isPartialSelect");
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "cacheConfig");
        __publicField(this, "usedTables", /* @__PURE__ */ new Set());
        /**
         * Executes a `left join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "leftJoin", this.createJoin("left", false));
        /**
         * Executes a `left join lateral` operation by adding subquery to the current query.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join-lateral}
         *
         * @param table the subquery to join.
         * @param on the `on` clause.
         */
        __publicField(this, "leftJoinLateral", this.createJoin("left", true));
        /**
         * Executes a `right join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the joined table with the corresponding row from the main table, if a match is found. If no matching row exists, it sets all columns of the main table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#right-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "rightJoin", this.createJoin("right", false));
        /**
         * Executes an `inner join` operation, creating a new table by combining rows from two tables that have matching values.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "innerJoin", this.createJoin("inner", false));
        /**
         * Executes an `inner join lateral` operation, creating a new table by combining rows from two queries that have matching values.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join-lateral}
         *
         * @param table the subquery to join.
         * @param on the `on` clause.
         */
        __publicField(this, "innerJoinLateral", this.createJoin("inner", true));
        /**
         * Executes a `full join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging rows with matching values and filling in `null` for non-matching columns.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#full-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .fullJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .fullJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "fullJoin", this.createJoin("full", false));
        /**
         * Executes a `cross join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging all rows from each table.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join}
         *
         * @param table the table to join.
         *
         * @example
         *
         * ```ts
         * // Select all users, each user with every pet
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .crossJoin(pets)
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .crossJoin(pets)
         * ```
         */
        __publicField(this, "crossJoin", this.createJoin("cross", false));
        /**
         * Executes a `cross join lateral` operation by combining rows from two queries into a new table.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method retrieves all rows from both main and joined queries, merging all rows from each query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join-lateral}
         *
         * @param table the query to join.
         */
        __publicField(this, "crossJoinLateral", this.createJoin("cross", true));
        /**
         * Adds `union` set operator to the query.
         *
         * Calling this method will combine the result sets of the `select` statements and remove any duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union}
         *
         * @example
         *
         * ```ts
         * // Select all unique names from customers and users tables
         * await db.select({ name: users.name })
         *   .from(users)
         *   .union(
         *     db.select({ name: customers.name }).from(customers)
         *   );
         * // or
         * import { union } from 'drizzle-orm/pg-core'
         *
         * await union(
         *   db.select({ name: users.name }).from(users),
         *   db.select({ name: customers.name }).from(customers)
         * );
         * ```
         */
        __publicField(this, "union", this.createSetOperator("union", false));
        /**
         * Adds `union all` set operator to the query.
         *
         * Calling this method will combine the result-set of the `select` statements and keep all duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union-all}
         *
         * @example
         *
         * ```ts
         * // Select all transaction ids from both online and in-store sales
         * await db.select({ transaction: onlineSales.transactionId })
         *   .from(onlineSales)
         *   .unionAll(
         *     db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         *   );
         * // or
         * import { unionAll } from 'drizzle-orm/pg-core'
         *
         * await unionAll(
         *   db.select({ transaction: onlineSales.transactionId }).from(onlineSales),
         *   db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         * );
         * ```
         */
        __publicField(this, "unionAll", this.createSetOperator("union", true));
        /**
         * Adds `intersect` set operator to the query.
         *
         * Calling this method will retain only the rows that are present in both result sets and eliminate duplicates.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#intersect}
         *
         * @example
         *
         * ```ts
         * // Select course names that are offered in both departments A and B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .intersect(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { intersect } from 'drizzle-orm/pg-core'
         *
         * await intersect(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "intersect", this.createSetOperator("intersect", false));
        /**
         * Adds `intersect all` set operator to the query.
         *
         * Calling this method will retain only the rows that are present in both result sets including all duplicates.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#intersect-all}
         *
         * @example
         *
         * ```ts
         * // Select all products and quantities that are ordered by both regular and VIP customers
         * await db.select({
         *   productId: regularCustomerOrders.productId,
         *   quantityOrdered: regularCustomerOrders.quantityOrdered
         * })
         * .from(regularCustomerOrders)
         * .intersectAll(
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered
         *   })
         *   .from(vipCustomerOrders)
         * );
         * // or
         * import { intersectAll } from 'drizzle-orm/pg-core'
         *
         * await intersectAll(
         *   db.select({
         *     productId: regularCustomerOrders.productId,
         *     quantityOrdered: regularCustomerOrders.quantityOrdered
         *   })
         *   .from(regularCustomerOrders),
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered
         *   })
         *   .from(vipCustomerOrders)
         * );
         * ```
         */
        __publicField(this, "intersectAll", this.createSetOperator("intersect", true));
        /**
         * Adds `except` set operator to the query.
         *
         * Calling this method will retrieve all unique rows from the left query, except for the rows that are present in the result set of the right query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#except}
         *
         * @example
         *
         * ```ts
         * // Select all courses offered in department A but not in department B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .except(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { except } from 'drizzle-orm/pg-core'
         *
         * await except(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "except", this.createSetOperator("except", false));
        /**
         * Adds `except all` set operator to the query.
         *
         * Calling this method will retrieve all rows from the left query, except for the rows that are present in the result set of the right query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#except-all}
         *
         * @example
         *
         * ```ts
         * // Select all products that are ordered by regular customers but not by VIP customers
         * await db.select({
         *   productId: regularCustomerOrders.productId,
         *   quantityOrdered: regularCustomerOrders.quantityOrdered,
         * })
         * .from(regularCustomerOrders)
         * .exceptAll(
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered,
         *   })
         *   .from(vipCustomerOrders)
         * );
         * // or
         * import { exceptAll } from 'drizzle-orm/pg-core'
         *
         * await exceptAll(
         *   db.select({
         *     productId: regularCustomerOrders.productId,
         *     quantityOrdered: regularCustomerOrders.quantityOrdered
         *   })
         *   .from(regularCustomerOrders),
         *   db.select({
         *     productId: vipCustomerOrders.productId,
         *     quantityOrdered: vipCustomerOrders.quantityOrdered
         *   })
         *   .from(vipCustomerOrders)
         * );
         * ```
         */
        __publicField(this, "exceptAll", this.createSetOperator("except", true));
        this.config = {
          withList,
          table: table6,
          fields: { ...fields },
          distinct,
          setOperators: []
        };
        this.isPartialSelect = isPartialSelect;
        this.session = session;
        this.dialect = dialect6;
        this._ = {
          selectedFields: fields,
          config: this.config
        };
        this.tableName = getTableLikeName(table6);
        this.joinsNotNullableMap = typeof this.tableName === "string" ? { [this.tableName]: true } : {};
        for (const item of extractUsedTable2(table6)) this.usedTables.add(item);
      }
      /** @internal */
      getUsedTables() {
        return [...this.usedTables];
      }
      createJoin(joinType, lateral) {
        return (table6, on3) => {
          const baseTableName = this.tableName;
          const tableName = getTableLikeName(table6);
          for (const item of extractUsedTable2(table6)) this.usedTables.add(item);
          if (typeof tableName === "string" && this.config.joins?.some((join7) => join7.alias === tableName)) {
            throw new Error(`Alias "${tableName}" is already used in this query`);
          }
          if (!this.isPartialSelect) {
            if (Object.keys(this.joinsNotNullableMap).length === 1 && typeof baseTableName === "string") {
              this.config.fields = {
                [baseTableName]: this.config.fields
              };
            }
            if (typeof tableName === "string" && !is(table6, SQL)) {
              const selection = is(table6, Subquery) ? table6._.selectedFields : is(table6, View) ? table6[ViewBaseConfig].selectedFields : table6[Table.Symbol.Columns];
              this.config.fields[tableName] = selection;
            }
          }
          if (typeof on3 === "function") {
            on3 = on3(
              new Proxy(
                this.config.fields,
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              )
            );
          }
          if (!this.config.joins) {
            this.config.joins = [];
          }
          this.config.joins.push({ on: on3, table: table6, joinType, alias: tableName, lateral });
          if (typeof tableName === "string") {
            switch (joinType) {
              case "left": {
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
              case "right": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "cross":
              case "inner": {
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "full": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
            }
          }
          return this;
        };
      }
      createSetOperator(type, isAll) {
        return (rightSelection) => {
          const rightSelect = typeof rightSelection === "function" ? rightSelection(getPgSetOperators()) : rightSelection;
          if (!haveSameKeys(this.getSelectedFields(), rightSelect.getSelectedFields())) {
            throw new Error(
              "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
            );
          }
          this.config.setOperators.push({ type, isAll, rightSelect });
          return this;
        };
      }
      /** @internal */
      addSetOperators(setOperators) {
        this.config.setOperators.push(...setOperators);
        return this;
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#filtering}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be selected.
       *
       * ```ts
       * // Select all cars with green color
       * await db.select().from(cars).where(eq(cars.color, 'green'));
       * // or
       * await db.select().from(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Select all BMW cars with a green color
       * await db.select().from(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Select all cars with the green or blue color
       * await db.select().from(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        if (typeof where === "function") {
          where = where(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.where = where;
        return this;
      }
      /**
       * Adds a `having` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition. It is typically used with aggregate functions to filter the aggregated data based on a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#aggregations}
       *
       * @param having the `having` clause.
       *
       * @example
       *
       * ```ts
       * // Select all brands with more than one car
       * await db.select({
       * 	brand: cars.brand,
       * 	count: sql<number>`cast(count(${cars.id}) as int)`,
       * })
       *   .from(cars)
       *   .groupBy(cars.brand)
       *   .having(({ count }) => gt(count, 1));
       * ```
       */
      having(having) {
        if (typeof having === "function") {
          having = having(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.having = having;
        return this;
      }
      groupBy(...columns) {
        if (typeof columns[0] === "function") {
          const groupBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          this.config.groupBy = Array.isArray(groupBy) ? groupBy : [groupBy];
        } else {
          this.config.groupBy = columns;
        }
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        } else {
          const orderByArray = columns;
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        }
        return this;
      }
      /**
       * Adds a `limit` clause to the query.
       *
       * Calling this method will set the maximum number of rows that will be returned by this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param limit the `limit` clause.
       *
       * @example
       *
       * ```ts
       * // Get the first 10 people from this query.
       * await db.select().from(people).limit(10);
       * ```
       */
      limit(limit) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).limit = limit;
        } else {
          this.config.limit = limit;
        }
        return this;
      }
      /**
       * Adds an `offset` clause to the query.
       *
       * Calling this method will skip a number of rows when returning results from this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param offset the `offset` clause.
       *
       * @example
       *
       * ```ts
       * // Get the 10th-20th people from this query.
       * await db.select().from(people).offset(10).limit(10);
       * ```
       */
      offset(offset) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).offset = offset;
        } else {
          this.config.offset = offset;
        }
        return this;
      }
      /**
       * Adds a `for` clause to the query.
       *
       * Calling this method will specify a lock strength for this query that controls how strictly it acquires exclusive access to the rows being queried.
       *
       * See docs: {@link https://www.postgresql.org/docs/current/sql-select.html#SQL-FOR-UPDATE-SHARE}
       *
       * @param strength the lock strength.
       * @param config the lock configuration.
       */
      for(strength, config = {}) {
        this.config.lockingClause = { strength, config };
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildSelectQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      as(alias2) {
        const usedTables = [];
        usedTables.push(...extractUsedTable2(this.config.table));
        if (this.config.joins) {
          for (const it2 of this.config.joins) usedTables.push(...extractUsedTable2(it2.table));
        }
        return new Proxy(
          new Subquery(this.getSQL(), this.config.fields, alias2, false, [...new Set(usedTables)]),
          new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      /** @internal */
      getSelectedFields() {
        return new Proxy(
          this.config.fields,
          new SelectionProxyHandler({ alias: this.tableName, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      $dynamic() {
        return this;
      }
      $withCache(config) {
        this.cacheConfig = config === void 0 ? { config: {}, enable: true, autoInvalidate: true } : config === false ? { enable: false } : { enable: true, autoInvalidate: true, ...config };
        return this;
      }
    };
    __publicField(PgSelectQueryBuilderBase, _a246, "PgSelectQueryBuilder");
    PgSelectBase = class extends (_b187 = PgSelectQueryBuilderBase, _a247 = entityKind, _b187) {
      constructor() {
        super(...arguments);
        __publicField(this, "authToken");
        __publicField(this, "execute", (placeholderValues) => {
          return tracer.startActiveSpan("drizzle.operation", () => {
            return this._prepare().execute(placeholderValues, this.authToken);
          });
        });
      }
      /** @internal */
      _prepare(name3) {
        const { session, config, dialect: dialect6, joinsNotNullableMap, authToken, cacheConfig, usedTables } = this;
        if (!session) {
          throw new Error("Cannot execute a query on a query builder. Please use a database instance instead.");
        }
        const { fields } = config;
        return tracer.startActiveSpan("drizzle.prepareQuery", () => {
          const fieldsList = orderSelectedFields(fields);
          const query = session.prepareQuery(dialect6.sqlToQuery(this.getSQL()), fieldsList, name3, true, void 0, {
            type: "select",
            tables: [...usedTables]
          }, cacheConfig);
          query.joinsNotNullableMap = joinsNotNullableMap;
          return query.setToken(authToken);
        });
      }
      /**
       * Create a prepared statement for this query. This allows
       * the database to remember this query for the given session
       * and call it by name, rather than specifying the full query.
       *
       * {@link https://www.postgresql.org/docs/current/sql-prepare.html | Postgres prepare documentation}
       */
      prepare(name3) {
        return this._prepare(name3);
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
    };
    __publicField(PgSelectBase, _a247, "PgSelect");
    applyMixins(PgSelectBase, [QueryPromise]);
    getPgSetOperators = () => ({
      union: union2,
      unionAll: unionAll2,
      intersect: intersect2,
      intersectAll: intersectAll2,
      except: except2,
      exceptAll: exceptAll2
    });
    union2 = createSetOperator2("union", false);
    unionAll2 = createSetOperator2("union", true);
    intersect2 = createSetOperator2("intersect", false);
    intersectAll2 = createSetOperator2("intersect", true);
    except2 = createSetOperator2("except", false);
    exceptAll2 = createSetOperator2("except", true);
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/query-builder.js
var _a248, QueryBuilder2;
var init_query_builder3 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/query-builder.js"() {
    "use strict";
    init_entity();
    init_dialect2();
    init_selection_proxy();
    init_subquery();
    init_select3();
    _a248 = entityKind;
    QueryBuilder2 = class {
      constructor(dialect6) {
        __publicField(this, "dialect");
        __publicField(this, "dialectConfig");
        __publicField(this, "$with", (alias2, selection) => {
          const queryBuilder = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(queryBuilder);
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        this.dialect = is(dialect6, PgDialect) ? dialect6 : void 0;
        this.dialectConfig = is(dialect6, PgDialect) ? void 0 : dialect6;
      }
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new PgSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new PgSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            distinct: true
          });
        }
        function selectDistinctOn(on3, fields) {
          return new PgSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            distinct: { on: on3 }
          });
        }
        return { select: select2, selectDistinct, selectDistinctOn };
      }
      select(fields) {
        return new PgSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect()
        });
      }
      selectDistinct(fields) {
        return new PgSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect(),
          distinct: true
        });
      }
      selectDistinctOn(on3, fields) {
        return new PgSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect(),
          distinct: { on: on3 }
        });
      }
      // Lazy load dialect to avoid circular dependency
      getDialect() {
        if (!this.dialect) {
          this.dialect = new PgDialect(this.dialectConfig);
        }
        return this.dialect;
      }
    };
    __publicField(QueryBuilder2, _a248, "PgQueryBuilder");
  }
});

// ../drizzle-orm/dist/pg-core/view.js
function pgViewWithSchema(name3, selection, schema6) {
  if (selection) {
    return new ManualViewBuilder2(name3, selection, schema6);
  }
  return new ViewBuilder2(name3, schema6);
}
function pgMaterializedViewWithSchema(name3, selection, schema6) {
  if (selection) {
    return new ManualMaterializedViewBuilder(name3, selection, schema6);
  }
  return new MaterializedViewBuilder(name3, schema6);
}
function pgView(name3, columns) {
  return pgViewWithSchema(name3, columns, void 0);
}
function pgMaterializedView(name3, columns) {
  return pgMaterializedViewWithSchema(name3, columns, void 0);
}
function isPgView(obj) {
  return is(obj, PgView);
}
function isPgMaterializedView(obj) {
  return is(obj, PgMaterializedView);
}
var _a249, DefaultViewBuilderCore, _a250, _b188, ViewBuilder2, _a251, _b189, ManualViewBuilder2, _a252, MaterializedViewBuilderCore, _a253, _b190, MaterializedViewBuilder, _a254, _b191, ManualMaterializedViewBuilder, _a255, _b192, _c7, PgView, PgMaterializedViewConfig, _a256, _b193, _c8, PgMaterializedView;
var init_view2 = __esm({
  "../drizzle-orm/dist/pg-core/view.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_utils();
    init_query_builder3();
    init_table2();
    init_view_base2();
    init_view_common3();
    _a249 = entityKind;
    DefaultViewBuilderCore = class {
      constructor(name3, schema6) {
        __publicField(this, "config", {});
        this.name = name3;
        this.schema = schema6;
      }
      with(config) {
        this.config.with = config;
        return this;
      }
    };
    __publicField(DefaultViewBuilderCore, _a249, "PgDefaultViewBuilderCore");
    ViewBuilder2 = class extends (_b188 = DefaultViewBuilderCore, _a250 = entityKind, _b188) {
      as(qb) {
        if (typeof qb === "function") {
          qb = qb(new QueryBuilder2());
        }
        const selectionProxy = new SelectionProxyHandler({
          alias: this.name,
          sqlBehavior: "error",
          sqlAliasedBehavior: "alias",
          replaceOriginalName: true
        });
        const aliasedSelection = new Proxy(qb.getSelectedFields(), selectionProxy);
        return new Proxy(
          new PgView({
            pgConfig: this.config,
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: aliasedSelection,
              query: qb.getSQL().inlineParams()
            }
          }),
          selectionProxy
        );
      }
    };
    __publicField(ViewBuilder2, _a250, "PgViewBuilder");
    ManualViewBuilder2 = class extends (_b189 = DefaultViewBuilderCore, _a251 = entityKind, _b189) {
      constructor(name3, columns, schema6) {
        super(name3, schema6);
        __publicField(this, "columns");
        this.columns = getTableColumns(pgTable(name3, columns));
      }
      existing() {
        return new Proxy(
          new PgView({
            pgConfig: void 0,
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: this.columns,
              query: void 0
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
      as(query) {
        return new Proxy(
          new PgView({
            pgConfig: this.config,
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: this.columns,
              query: query.inlineParams()
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
    };
    __publicField(ManualViewBuilder2, _a251, "PgManualViewBuilder");
    _a252 = entityKind;
    MaterializedViewBuilderCore = class {
      constructor(name3, schema6) {
        __publicField(this, "config", {});
        this.name = name3;
        this.schema = schema6;
      }
      using(using) {
        this.config.using = using;
        return this;
      }
      with(config) {
        this.config.with = config;
        return this;
      }
      tablespace(tablespace) {
        this.config.tablespace = tablespace;
        return this;
      }
      withNoData() {
        this.config.withNoData = true;
        return this;
      }
    };
    __publicField(MaterializedViewBuilderCore, _a252, "PgMaterializedViewBuilderCore");
    MaterializedViewBuilder = class extends (_b190 = MaterializedViewBuilderCore, _a253 = entityKind, _b190) {
      as(qb) {
        if (typeof qb === "function") {
          qb = qb(new QueryBuilder2());
        }
        const selectionProxy = new SelectionProxyHandler({
          alias: this.name,
          sqlBehavior: "error",
          sqlAliasedBehavior: "alias",
          replaceOriginalName: true
        });
        const aliasedSelection = new Proxy(qb.getSelectedFields(), selectionProxy);
        return new Proxy(
          new PgMaterializedView({
            pgConfig: {
              with: this.config.with,
              using: this.config.using,
              tablespace: this.config.tablespace,
              withNoData: this.config.withNoData
            },
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: aliasedSelection,
              query: qb.getSQL().inlineParams()
            }
          }),
          selectionProxy
        );
      }
    };
    __publicField(MaterializedViewBuilder, _a253, "PgMaterializedViewBuilder");
    ManualMaterializedViewBuilder = class extends (_b191 = MaterializedViewBuilderCore, _a254 = entityKind, _b191) {
      constructor(name3, columns, schema6) {
        super(name3, schema6);
        __publicField(this, "columns");
        this.columns = getTableColumns(pgTable(name3, columns));
      }
      existing() {
        return new Proxy(
          new PgMaterializedView({
            pgConfig: {
              tablespace: this.config.tablespace,
              using: this.config.using,
              with: this.config.with,
              withNoData: this.config.withNoData
            },
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: this.columns,
              query: void 0
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
      as(query) {
        return new Proxy(
          new PgMaterializedView({
            pgConfig: {
              tablespace: this.config.tablespace,
              using: this.config.using,
              with: this.config.with,
              withNoData: this.config.withNoData
            },
            config: {
              name: this.name,
              schema: this.schema,
              selectedFields: this.columns,
              query: query.inlineParams()
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
    };
    __publicField(ManualMaterializedViewBuilder, _a254, "PgManualMaterializedViewBuilder");
    PgView = class extends (_c7 = PgViewBase, _b192 = entityKind, _a255 = PgViewConfig, _c7) {
      constructor({ pgConfig, config }) {
        super(config);
        __publicField(this, _a255);
        if (pgConfig) {
          this[PgViewConfig] = {
            with: pgConfig.with
          };
        }
      }
    };
    __publicField(PgView, _b192, "PgView");
    PgMaterializedViewConfig = Symbol.for("drizzle:PgMaterializedViewConfig");
    PgMaterializedView = class extends (_c8 = PgViewBase, _b193 = entityKind, _a256 = PgMaterializedViewConfig, _c8) {
      constructor({ pgConfig, config }) {
        super(config);
        __publicField(this, _a256);
        this[PgMaterializedViewConfig] = {
          with: pgConfig?.with,
          using: pgConfig?.using,
          tablespace: pgConfig?.tablespace,
          withNoData: pgConfig?.withNoData
        };
      }
    };
    __publicField(PgMaterializedView, _b193, "PgMaterializedView");
  }
});

// ../drizzle-orm/dist/pg-core/utils.js
function getTableConfig2(table6) {
  const columns = Object.values(table6[Table.Symbol.Columns]);
  const indexes = [];
  const checks = [];
  const primaryKeys = [];
  const foreignKeys = Object.values(table6[PgTable.Symbol.InlineForeignKeys]);
  const uniqueConstraints = [];
  const name3 = table6[Table.Symbol.Name];
  const schema6 = table6[Table.Symbol.Schema];
  const policies = [];
  const enableRLS = table6[PgTable.Symbol.EnableRLS];
  const extraConfigBuilder = table6[PgTable.Symbol.ExtraConfigBuilder];
  if (extraConfigBuilder !== void 0) {
    const extraConfig = extraConfigBuilder(table6[Table.Symbol.ExtraConfigColumns]);
    const extraValues = Array.isArray(extraConfig) ? extraConfig.flat(1) : Object.values(extraConfig);
    for (const builder of extraValues) {
      if (is(builder, IndexBuilder2)) {
        indexes.push(builder.build(table6));
      } else if (is(builder, CheckBuilder2)) {
        checks.push(builder.build(table6));
      } else if (is(builder, UniqueConstraintBuilder)) {
        uniqueConstraints.push(builder.build(table6));
      } else if (is(builder, PrimaryKeyBuilder)) {
        primaryKeys.push(builder.build(table6));
      } else if (is(builder, ForeignKeyBuilder)) {
        foreignKeys.push(builder.build(table6));
      } else if (is(builder, PgPolicy)) {
        policies.push(builder);
      }
    }
  }
  return {
    columns,
    indexes,
    foreignKeys,
    checks,
    primaryKeys,
    uniqueConstraints,
    name: name3,
    schema: schema6,
    policies,
    enableRLS
  };
}
function extractUsedTable2(table6) {
  if (is(table6, PgTable)) {
    return [table6[Schema] ? `${table6[Schema]}.${table6[Table.Symbol.BaseName]}` : table6[Table.Symbol.BaseName]];
  }
  if (is(table6, Subquery)) {
    return table6._.usedTables ?? [];
  }
  if (is(table6, SQL)) {
    return table6.usedTables ?? [];
  }
  return [];
}
function getViewConfig2(view5) {
  return {
    ...view5[ViewBaseConfig],
    ...view5[PgViewConfig]
  };
}
function getMaterializedViewConfig(view5) {
  return {
    ...view5[ViewBaseConfig],
    ...view5[PgMaterializedViewConfig]
  };
}
var init_utils4 = __esm({
  "../drizzle-orm/dist/pg-core/utils.js"() {
    "use strict";
    init_entity();
    init_table2();
    init_sql();
    init_subquery();
    init_table();
    init_view_common();
    init_checks2();
    init_foreign_keys();
    init_indexes2();
    init_policies();
    init_primary_keys();
    init_unique_constraint();
    init_view_common3();
    init_view2();
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/delete.js
var _a257, _b194, PgDeleteBase;
var init_delete2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/delete.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table();
    init_tracing();
    init_utils();
    init_utils4();
    PgDeleteBase = class extends (_b194 = QueryPromise, _a257 = entityKind, _b194) {
      constructor(table6, session, dialect6, withList) {
        super();
        __publicField(this, "config");
        __publicField(this, "cacheConfig");
        __publicField(this, "authToken");
        __publicField(this, "execute", (placeholderValues) => {
          return tracer.startActiveSpan("drizzle.operation", () => {
            return this._prepare().execute(placeholderValues, this.authToken);
          });
        });
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, withList };
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will delete only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be deleted.
       *
       * ```ts
       * // Delete all cars with green color
       * await db.delete(cars).where(eq(cars.color, 'green'));
       * // or
       * await db.delete(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Delete all BMW cars with a green color
       * await db.delete(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Delete all cars with the green or blue color
       * await db.delete(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      returning(fields = this.config.table[Table.Symbol.Columns]) {
        this.config.returningFields = fields;
        this.config.returning = orderSelectedFields(fields);
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildDeleteQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(name3) {
        return tracer.startActiveSpan("drizzle.prepareQuery", () => {
          return this.session.prepareQuery(this.dialect.sqlToQuery(this.getSQL()), this.config.returning, name3, true, void 0, {
            type: "delete",
            tables: extractUsedTable2(this.config.table)
          }, this.cacheConfig);
        });
      }
      prepare(name3) {
        return this._prepare(name3);
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      /** @internal */
      getSelectedFields() {
        return this.config.returningFields ? new Proxy(
          this.config.returningFields,
          new SelectionProxyHandler({
            alias: getTableName(this.config.table),
            sqlAliasedBehavior: "alias",
            sqlBehavior: "error"
          })
        ) : void 0;
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(PgDeleteBase, _a257, "PgDelete");
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/insert.js
var _a258, PgInsertBuilder, _a259, _b195, PgInsertBase;
var init_insert2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/insert.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_sql();
    init_table();
    init_tracing();
    init_utils();
    init_utils4();
    init_query_builder3();
    _a258 = entityKind;
    PgInsertBuilder = class {
      constructor(table6, session, dialect6, withList, overridingSystemValue_) {
        __publicField(this, "authToken");
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.withList = withList;
        this.overridingSystemValue_ = overridingSystemValue_;
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      overridingSystemValue() {
        this.overridingSystemValue_ = true;
        return this;
      }
      values(values2) {
        values2 = Array.isArray(values2) ? values2 : [values2];
        if (values2.length === 0) {
          throw new Error("values() must be called with at least one value");
        }
        const mappedValues = values2.map((entry) => {
          const result = {};
          const cols = this.table[Table.Symbol.Columns];
          for (const colKey of Object.keys(entry)) {
            const colValue = entry[colKey];
            result[colKey] = is(colValue, SQL) ? colValue : new Param(colValue, cols[colKey]);
          }
          return result;
        });
        return new PgInsertBase(
          this.table,
          mappedValues,
          this.session,
          this.dialect,
          this.withList,
          false,
          this.overridingSystemValue_
        ).setToken(this.authToken);
      }
      select(selectQuery) {
        const select2 = typeof selectQuery === "function" ? selectQuery(new QueryBuilder2()) : selectQuery;
        if (!is(select2, SQL) && !haveSameKeys(this.table[Columns], select2._.selectedFields)) {
          throw new Error(
            "Insert select error: selected fields are not the same or are in a different order compared to the table definition"
          );
        }
        return new PgInsertBase(this.table, select2, this.session, this.dialect, this.withList, true);
      }
    };
    __publicField(PgInsertBuilder, _a258, "PgInsertBuilder");
    PgInsertBase = class extends (_b195 = QueryPromise, _a259 = entityKind, _b195) {
      constructor(table6, values2, session, dialect6, withList, select2, overridingSystemValue_) {
        super();
        __publicField(this, "config");
        __publicField(this, "cacheConfig");
        __publicField(this, "authToken");
        __publicField(this, "execute", (placeholderValues) => {
          return tracer.startActiveSpan("drizzle.operation", () => {
            return this._prepare().execute(placeholderValues, this.authToken);
          });
        });
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, values: values2, withList, select: select2, overridingSystemValue_ };
      }
      returning(fields = this.config.table[Table.Symbol.Columns]) {
        this.config.returningFields = fields;
        this.config.returning = orderSelectedFields(fields);
        return this;
      }
      /**
       * Adds an `on conflict do nothing` clause to the query.
       *
       * Calling this method simply avoids inserting a row as its alternative action.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert#on-conflict-do-nothing}
       *
       * @param config The `target` and `where` clauses.
       *
       * @example
       * ```ts
       * // Insert one row and cancel the insert if there's a conflict
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoNothing();
       *
       * // Explicitly specify conflict target
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoNothing({ target: cars.id });
       * ```
       */
      onConflictDoNothing(config = {}) {
        if (config.target === void 0) {
          this.config.onConflict = sql`do nothing`;
        } else {
          let targetColumn = "";
          targetColumn = Array.isArray(config.target) ? config.target.map((it2) => this.dialect.escapeName(this.dialect.casing.getColumnCasing(it2))).join(",") : this.dialect.escapeName(this.dialect.casing.getColumnCasing(config.target));
          const whereSql = config.where ? sql` where ${config.where}` : void 0;
          this.config.onConflict = sql`(${sql.raw(targetColumn)})${whereSql} do nothing`;
        }
        return this;
      }
      /**
       * Adds an `on conflict do update` clause to the query.
       *
       * Calling this method will update the existing row that conflicts with the row proposed for insertion as its alternative action.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert#upserts-and-conflicts}
       *
       * @param config The `target`, `set` and `where` clauses.
       *
       * @example
       * ```ts
       * // Update the row if there's a conflict
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoUpdate({
       *     target: cars.id,
       *     set: { brand: 'Porsche' }
       *   });
       *
       * // Upsert with 'where' clause
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoUpdate({
       *     target: cars.id,
       *     set: { brand: 'newBMW' },
       *     targetWhere: sql`${cars.createdAt} > '2023-01-01'::date`,
       *   });
       * ```
       */
      onConflictDoUpdate(config) {
        if (config.where && (config.targetWhere || config.setWhere)) {
          throw new Error(
            'You cannot use both "where" and "targetWhere"/"setWhere" at the same time - "where" is deprecated, use "targetWhere" or "setWhere" instead.'
          );
        }
        const whereSql = config.where ? sql` where ${config.where}` : void 0;
        const targetWhereSql = config.targetWhere ? sql` where ${config.targetWhere}` : void 0;
        const setWhereSql = config.setWhere ? sql` where ${config.setWhere}` : void 0;
        const setSql = this.dialect.buildUpdateSet(this.config.table, mapUpdateSet(this.config.table, config.set));
        let targetColumn = "";
        targetColumn = Array.isArray(config.target) ? config.target.map((it2) => this.dialect.escapeName(this.dialect.casing.getColumnCasing(it2))).join(",") : this.dialect.escapeName(this.dialect.casing.getColumnCasing(config.target));
        this.config.onConflict = sql`(${sql.raw(targetColumn)})${targetWhereSql} do update set ${setSql}${whereSql}${setWhereSql}`;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildInsertQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(name3) {
        return tracer.startActiveSpan("drizzle.prepareQuery", () => {
          return this.session.prepareQuery(this.dialect.sqlToQuery(this.getSQL()), this.config.returning, name3, true, void 0, {
            type: "insert",
            tables: extractUsedTable2(this.config.table)
          }, this.cacheConfig);
        });
      }
      prepare(name3) {
        return this._prepare(name3);
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      /** @internal */
      getSelectedFields() {
        return this.config.returningFields ? new Proxy(
          this.config.returningFields,
          new SelectionProxyHandler({
            alias: getTableName(this.config.table),
            sqlAliasedBehavior: "alias",
            sqlBehavior: "error"
          })
        ) : void 0;
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(PgInsertBase, _a259, "PgInsert");
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/refresh-materialized-view.js
var _a260, _b196, PgRefreshMaterializedView;
var init_refresh_materialized_view = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/refresh-materialized-view.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_tracing();
    PgRefreshMaterializedView = class extends (_b196 = QueryPromise, _a260 = entityKind, _b196) {
      constructor(view5, session, dialect6) {
        super();
        __publicField(this, "config");
        __publicField(this, "authToken");
        __publicField(this, "execute", (placeholderValues) => {
          return tracer.startActiveSpan("drizzle.operation", () => {
            return this._prepare().execute(placeholderValues, this.authToken);
          });
        });
        this.session = session;
        this.dialect = dialect6;
        this.config = { view: view5 };
      }
      concurrently() {
        if (this.config.withNoData !== void 0) {
          throw new Error("Cannot use concurrently and withNoData together");
        }
        this.config.concurrently = true;
        return this;
      }
      withNoData() {
        if (this.config.concurrently !== void 0) {
          throw new Error("Cannot use concurrently and withNoData together");
        }
        this.config.withNoData = true;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildRefreshMaterializedViewQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(name3) {
        return tracer.startActiveSpan("drizzle.prepareQuery", () => {
          return this.session.prepareQuery(this.dialect.sqlToQuery(this.getSQL()), void 0, name3, true);
        });
      }
      prepare(name3) {
        return this._prepare(name3);
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
    };
    __publicField(PgRefreshMaterializedView, _a260, "PgRefreshMaterializedView");
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/select.types.js
var init_select_types2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/select.types.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/update.js
var _a261, PgUpdateBuilder, _a262, _b197, PgUpdateBase;
var init_update2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/update.js"() {
    "use strict";
    init_entity();
    init_table2();
    init_query_promise();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_utils4();
    _a261 = entityKind;
    PgUpdateBuilder = class {
      constructor(table6, session, dialect6, withList) {
        __publicField(this, "authToken");
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.withList = withList;
      }
      setToken(token) {
        this.authToken = token;
        return this;
      }
      set(values2) {
        return new PgUpdateBase(
          this.table,
          mapUpdateSet(this.table, values2),
          this.session,
          this.dialect,
          this.withList
        ).setToken(this.authToken);
      }
    };
    __publicField(PgUpdateBuilder, _a261, "PgUpdateBuilder");
    PgUpdateBase = class extends (_b197 = QueryPromise, _a262 = entityKind, _b197) {
      constructor(table6, set, session, dialect6, withList) {
        super();
        __publicField(this, "config");
        __publicField(this, "tableName");
        __publicField(this, "joinsNotNullableMap");
        __publicField(this, "cacheConfig");
        __publicField(this, "leftJoin", this.createJoin("left"));
        __publicField(this, "rightJoin", this.createJoin("right"));
        __publicField(this, "innerJoin", this.createJoin("inner"));
        __publicField(this, "fullJoin", this.createJoin("full"));
        __publicField(this, "authToken");
        __publicField(this, "execute", (placeholderValues) => {
          return this._prepare().execute(placeholderValues, this.authToken);
        });
        this.session = session;
        this.dialect = dialect6;
        this.config = { set, table: table6, withList, joins: [] };
        this.tableName = getTableLikeName(table6);
        this.joinsNotNullableMap = typeof this.tableName === "string" ? { [this.tableName]: true } : {};
      }
      from(source) {
        const src = source;
        const tableName = getTableLikeName(src);
        if (typeof tableName === "string") {
          this.joinsNotNullableMap[tableName] = true;
        }
        this.config.from = src;
        return this;
      }
      getTableLikeFields(table6) {
        if (is(table6, PgTable)) {
          return table6[Table.Symbol.Columns];
        } else if (is(table6, Subquery)) {
          return table6._.selectedFields;
        }
        return table6[ViewBaseConfig].selectedFields;
      }
      createJoin(joinType) {
        return (table6, on3) => {
          const tableName = getTableLikeName(table6);
          if (typeof tableName === "string" && this.config.joins.some((join7) => join7.alias === tableName)) {
            throw new Error(`Alias "${tableName}" is already used in this query`);
          }
          if (typeof on3 === "function") {
            const from = this.config.from && !is(this.config.from, SQL) ? this.getTableLikeFields(this.config.from) : void 0;
            on3 = on3(
              new Proxy(
                this.config.table[Table.Symbol.Columns],
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              ),
              from && new Proxy(
                from,
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              )
            );
          }
          this.config.joins.push({ on: on3, table: table6, joinType, alias: tableName });
          if (typeof tableName === "string") {
            switch (joinType) {
              case "left": {
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
              case "right": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "inner": {
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "full": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
            }
          }
          return this;
        };
      }
      /**
       * Adds a 'where' clause to the query.
       *
       * Calling this method will update only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param where the 'where' clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be updated.
       *
       * ```ts
       * // Update all cars with green color
       * await db.update(cars).set({ color: 'red' })
       *   .where(eq(cars.color, 'green'));
       * // or
       * await db.update(cars).set({ color: 'red' })
       *   .where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Update all BMW cars with a green color
       * await db.update(cars).set({ color: 'red' })
       *   .where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Update all cars with the green or blue color
       * await db.update(cars).set({ color: 'red' })
       *   .where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      returning(fields) {
        if (!fields) {
          fields = Object.assign({}, this.config.table[Table.Symbol.Columns]);
          if (this.config.from) {
            const tableName = getTableLikeName(this.config.from);
            if (typeof tableName === "string" && this.config.from && !is(this.config.from, SQL)) {
              const fromFields = this.getTableLikeFields(this.config.from);
              fields[tableName] = fromFields;
            }
            for (const join7 of this.config.joins) {
              const tableName2 = getTableLikeName(join7.table);
              if (typeof tableName2 === "string" && !is(join7.table, SQL)) {
                const fromFields = this.getTableLikeFields(join7.table);
                fields[tableName2] = fromFields;
              }
            }
          }
        }
        this.config.returningFields = fields;
        this.config.returning = orderSelectedFields(fields);
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildUpdateQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(name3) {
        const query = this.session.prepareQuery(this.dialect.sqlToQuery(this.getSQL()), this.config.returning, name3, true, void 0, {
          type: "insert",
          tables: extractUsedTable2(this.config.table)
        }, this.cacheConfig);
        query.joinsNotNullableMap = this.joinsNotNullableMap;
        return query;
      }
      prepare(name3) {
        return this._prepare(name3);
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      /** @internal */
      getSelectedFields() {
        return this.config.returningFields ? new Proxy(
          this.config.returningFields,
          new SelectionProxyHandler({
            alias: getTableName(this.config.table),
            sqlAliasedBehavior: "alias",
            sqlBehavior: "error"
          })
        ) : void 0;
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(PgUpdateBase, _a262, "PgUpdate");
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/index.js
var init_query_builders2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/index.js"() {
    "use strict";
    init_delete2();
    init_insert2();
    init_query_builder3();
    init_refresh_materialized_view();
    init_select3();
    init_select_types2();
    init_update2();
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/count.js
var _a263, _b198, _c9, _PgCountBuilder, PgCountBuilder;
var init_count2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/count.js"() {
    "use strict";
    init_entity();
    init_sql();
    _PgCountBuilder = class _PgCountBuilder extends (_c9 = SQL, _b198 = entityKind, _a263 = Symbol.toStringTag, _c9) {
      constructor(params) {
        super(_PgCountBuilder.buildEmbeddedCount(params.source, params.filters).queryChunks);
        __publicField(this, "sql");
        __publicField(this, "token");
        __publicField(this, _a263, "PgCountBuilder");
        __publicField(this, "session");
        this.params = params;
        this.mapWith(Number);
        this.session = params.session;
        this.sql = _PgCountBuilder.buildCount(
          params.source,
          params.filters
        );
      }
      static buildEmbeddedCount(source, filters) {
        return sql`(select count(*) from ${source}${sql.raw(" where ").if(filters)}${filters})`;
      }
      static buildCount(source, filters) {
        return sql`select count(*) as count from ${source}${sql.raw(" where ").if(filters)}${filters};`;
      }
      /** @intrnal */
      setToken(token) {
        this.token = token;
        return this;
      }
      then(onfulfilled, onrejected) {
        return Promise.resolve(this.session.count(this.sql, this.token)).then(
          onfulfilled,
          onrejected
        );
      }
      catch(onRejected) {
        return this.then(void 0, onRejected);
      }
      finally(onFinally) {
        return this.then(
          (value) => {
            onFinally?.();
            return value;
          },
          (reason) => {
            onFinally?.();
            throw reason;
          }
        );
      }
    };
    __publicField(_PgCountBuilder, _b198, "PgCountBuilder");
    PgCountBuilder = _PgCountBuilder;
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/query.js
var _a264, RelationalQueryBuilder2, _a265, _b199, PgRelationalQuery;
var init_query2 = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/query.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_relations();
    init_tracing();
    _a264 = entityKind;
    RelationalQueryBuilder2 = class {
      constructor(fullSchema, schema6, tableNamesMap, table6, tableConfig, dialect6, session) {
        this.fullSchema = fullSchema;
        this.schema = schema6;
        this.tableNamesMap = tableNamesMap;
        this.table = table6;
        this.tableConfig = tableConfig;
        this.dialect = dialect6;
        this.session = session;
      }
      findMany(config) {
        return new PgRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? config : {},
          "many"
        );
      }
      findFirst(config) {
        return new PgRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? { ...config, limit: 1 } : { limit: 1 },
          "first"
        );
      }
    };
    __publicField(RelationalQueryBuilder2, _a264, "PgRelationalQueryBuilder");
    PgRelationalQuery = class extends (_b199 = QueryPromise, _a265 = entityKind, _b199) {
      constructor(fullSchema, schema6, tableNamesMap, table6, tableConfig, dialect6, session, config, mode) {
        super();
        __publicField(this, "authToken");
        this.fullSchema = fullSchema;
        this.schema = schema6;
        this.tableNamesMap = tableNamesMap;
        this.table = table6;
        this.tableConfig = tableConfig;
        this.dialect = dialect6;
        this.session = session;
        this.config = config;
        this.mode = mode;
      }
      /** @internal */
      _prepare(name3) {
        return tracer.startActiveSpan("drizzle.prepareQuery", () => {
          const { query, builtQuery } = this._toSQL();
          return this.session.prepareQuery(
            builtQuery,
            void 0,
            name3,
            true,
            (rawRows, mapColumnValue) => {
              const rows = rawRows.map(
                (row) => mapRelationalRow(this.schema, this.tableConfig, row, query.selection, mapColumnValue)
              );
              if (this.mode === "first") {
                return rows[0];
              }
              return rows;
            }
          );
        });
      }
      prepare(name3) {
        return this._prepare(name3);
      }
      _getQuery() {
        return this.dialect.buildRelationalQueryWithoutPK({
          fullSchema: this.fullSchema,
          schema: this.schema,
          tableNamesMap: this.tableNamesMap,
          table: this.table,
          tableConfig: this.tableConfig,
          queryConfig: this.config,
          tableAlias: this.tableConfig.tsName
        });
      }
      /** @internal */
      getSQL() {
        return this._getQuery().sql;
      }
      _toSQL() {
        const query = this._getQuery();
        const builtQuery = this.dialect.sqlToQuery(query.sql);
        return { query, builtQuery };
      }
      toSQL() {
        return this._toSQL().builtQuery;
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      execute() {
        return tracer.startActiveSpan("drizzle.operation", () => {
          return this._prepare().execute(void 0, this.authToken);
        });
      }
    };
    __publicField(PgRelationalQuery, _a265, "PgRelationalQuery");
  }
});

// ../drizzle-orm/dist/pg-core/query-builders/raw.js
var _a266, _b200, PgRaw;
var init_raw = __esm({
  "../drizzle-orm/dist/pg-core/query-builders/raw.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    PgRaw = class extends (_b200 = QueryPromise, _a266 = entityKind, _b200) {
      constructor(execute, sql3, query, mapBatchResult) {
        super();
        this.execute = execute;
        this.sql = sql3;
        this.query = query;
        this.mapBatchResult = mapBatchResult;
      }
      /** @internal */
      getSQL() {
        return this.sql;
      }
      getQuery() {
        return this.query;
      }
      mapResult(result, isFromBatch) {
        return isFromBatch ? this.mapBatchResult(result) : result;
      }
      _prepare() {
        return this;
      }
      /** @internal */
      isResponseInArrayMode() {
        return false;
      }
    };
    __publicField(PgRaw, _a266, "PgRaw");
  }
});

// ../drizzle-orm/dist/pg-core/db.js
var _a267, PgDatabase, withReplicas;
var init_db2 = __esm({
  "../drizzle-orm/dist/pg-core/db.js"() {
    "use strict";
    init_entity();
    init_query_builders2();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_count2();
    init_query2();
    init_raw();
    init_refresh_materialized_view();
    _a267 = entityKind;
    PgDatabase = class {
      constructor(dialect6, session, schema6) {
        __publicField(this, "query");
        /**
         * Creates a subquery that defines a temporary named result set as a CTE.
         *
         * It is useful for breaking down complex queries into simpler parts and for reusing the result set in subsequent parts of the query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
         *
         * @param alias The alias for the subquery.
         *
         * Failure to provide an alias will result in a DrizzleTypeError, preventing the subquery from being referenced in other queries.
         *
         * @example
         *
         * ```ts
         * // Create a subquery with alias 'sq' and use it in the select query
         * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
         *
         * const result = await db.with(sq).select().from(sq);
         * ```
         *
         * To select arbitrary SQL values as fields in a CTE and reference them in other CTEs or in the main query, you need to add aliases to them:
         *
         * ```ts
         * // Select an arbitrary SQL value as a field in a CTE and reference it in the main query
         * const sq = db.$with('sq').as(db.select({
         *   name: sql<string>`upper(${users.name})`.as('name'),
         * })
         * .from(users));
         *
         * const result = await db.with(sq).select({ name: sq.name }).from(sq);
         * ```
         */
        __publicField(this, "$with", (alias2, selection) => {
          const self2 = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(new QueryBuilder2(self2.dialect));
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        __publicField(this, "$cache");
        __publicField(this, "authToken");
        this.dialect = dialect6;
        this.session = session;
        this._ = schema6 ? {
          schema: schema6.schema,
          fullSchema: schema6.fullSchema,
          tableNamesMap: schema6.tableNamesMap,
          session
        } : {
          schema: void 0,
          fullSchema: {},
          tableNamesMap: {},
          session
        };
        this.query = {};
        if (this._.schema) {
          for (const [tableName, columns] of Object.entries(this._.schema)) {
            this.query[tableName] = new RelationalQueryBuilder2(
              schema6.fullSchema,
              this._.schema,
              this._.tableNamesMap,
              schema6.fullSchema[tableName],
              columns,
              dialect6,
              session
            );
          }
        }
        this.$cache = { invalidate: async (_params2) => {
        } };
      }
      $count(source, filters) {
        return new PgCountBuilder({ source, filters, session: this.session });
      }
      /**
       * Incorporates a previously defined CTE (using `$with`) into the main query.
       *
       * This method allows the main query to reference a temporary named result set.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
       *
       * @param queries The CTEs to incorporate into the main query.
       *
       * @example
       *
       * ```ts
       * // Define a subquery 'sq' as a CTE using $with
       * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
       *
       * // Incorporate the CTE 'sq' into the main query and select from it
       * const result = await db.with(sq).select().from(sq);
       * ```
       */
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new PgSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new PgSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries,
            distinct: true
          });
        }
        function selectDistinctOn(on3, fields) {
          return new PgSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries,
            distinct: { on: on3 }
          });
        }
        function update(table6) {
          return new PgUpdateBuilder(table6, self2.session, self2.dialect, queries);
        }
        function insert(table6) {
          return new PgInsertBuilder(table6, self2.session, self2.dialect, queries);
        }
        function delete_(table6) {
          return new PgDeleteBase(table6, self2.session, self2.dialect, queries);
        }
        return { select: select2, selectDistinct, selectDistinctOn, update, insert, delete: delete_ };
      }
      select(fields) {
        return new PgSelectBuilder({
          fields: fields ?? void 0,
          session: this.session,
          dialect: this.dialect
        });
      }
      selectDistinct(fields) {
        return new PgSelectBuilder({
          fields: fields ?? void 0,
          session: this.session,
          dialect: this.dialect,
          distinct: true
        });
      }
      selectDistinctOn(on3, fields) {
        return new PgSelectBuilder({
          fields: fields ?? void 0,
          session: this.session,
          dialect: this.dialect,
          distinct: { on: on3 }
        });
      }
      /**
       * Creates an update query.
       *
       * Calling this method without `.where()` clause will update all rows in a table. The `.where()` clause specifies which rows should be updated.
       *
       * Use `.set()` method to specify which values to update.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param table The table to update.
       *
       * @example
       *
       * ```ts
       * // Update all rows in the 'cars' table
       * await db.update(cars).set({ color: 'red' });
       *
       * // Update rows with filters and conditions
       * await db.update(cars).set({ color: 'red' }).where(eq(cars.brand, 'BMW'));
       *
       * // Update with returning clause
       * const updatedCar: Car[] = await db.update(cars)
       *   .set({ color: 'red' })
       *   .where(eq(cars.id, 1))
       *   .returning();
       * ```
       */
      update(table6) {
        return new PgUpdateBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates an insert query.
       *
       * Calling this method will create new rows in a table. Use `.values()` method to specify which values to insert.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert}
       *
       * @param table The table to insert into.
       *
       * @example
       *
       * ```ts
       * // Insert one row
       * await db.insert(cars).values({ brand: 'BMW' });
       *
       * // Insert multiple rows
       * await db.insert(cars).values([{ brand: 'BMW' }, { brand: 'Porsche' }]);
       *
       * // Insert with returning clause
       * const insertedCar: Car[] = await db.insert(cars)
       *   .values({ brand: 'BMW' })
       *   .returning();
       * ```
       */
      insert(table6) {
        return new PgInsertBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates a delete query.
       *
       * Calling this method without `.where()` clause will delete all rows in a table. The `.where()` clause specifies which rows should be deleted.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param table The table to delete from.
       *
       * @example
       *
       * ```ts
       * // Delete all rows in the 'cars' table
       * await db.delete(cars);
       *
       * // Delete rows with filters and conditions
       * await db.delete(cars).where(eq(cars.color, 'green'));
       *
       * // Delete with returning clause
       * const deletedCar: Car[] = await db.delete(cars)
       *   .where(eq(cars.id, 1))
       *   .returning();
       * ```
       */
      delete(table6) {
        return new PgDeleteBase(table6, this.session, this.dialect);
      }
      refreshMaterializedView(view5) {
        return new PgRefreshMaterializedView(view5, this.session, this.dialect);
      }
      execute(query) {
        const sequel = typeof query === "string" ? sql.raw(query) : query.getSQL();
        const builtQuery = this.dialect.sqlToQuery(sequel);
        const prepared = this.session.prepareQuery(
          builtQuery,
          void 0,
          void 0,
          false
        );
        return new PgRaw(
          () => prepared.execute(void 0, this.authToken),
          sequel,
          builtQuery,
          (result) => prepared.mapResult(result, true)
        );
      }
      transaction(transaction, config) {
        return this.session.transaction(transaction, config);
      }
    };
    __publicField(PgDatabase, _a267, "PgDatabase");
    withReplicas = (primary, replicas, getReplica = () => replicas[Math.floor(Math.random() * replicas.length)]) => {
      const select2 = (...args2) => getReplica(replicas).select(...args2);
      const selectDistinct = (...args2) => getReplica(replicas).selectDistinct(...args2);
      const selectDistinctOn = (...args2) => getReplica(replicas).selectDistinctOn(...args2);
      const $count = (...args2) => getReplica(replicas).$count(...args2);
      const _with = (...args2) => getReplica(replicas).with(...args2);
      const $with = (arg) => getReplica(replicas).$with(arg);
      const update = (...args2) => primary.update(...args2);
      const insert = (...args2) => primary.insert(...args2);
      const $delete = (...args2) => primary.delete(...args2);
      const execute = (...args2) => primary.execute(...args2);
      const transaction = (...args2) => primary.transaction(...args2);
      const refreshMaterializedView = (...args2) => primary.refreshMaterializedView(...args2);
      return {
        ...primary,
        update,
        insert,
        delete: $delete,
        execute,
        transaction,
        refreshMaterializedView,
        $primary: primary,
        $replicas: replicas,
        select: select2,
        selectDistinct,
        selectDistinctOn,
        $count,
        $with,
        with: _with,
        get query() {
          return getReplica(replicas).query;
        }
      };
    };
  }
});

// ../drizzle-orm/dist/pg-core/roles.js
function pgRole(name3, config) {
  return new PgRole(name3, config);
}
var _a268, PgRole;
var init_roles = __esm({
  "../drizzle-orm/dist/pg-core/roles.js"() {
    "use strict";
    init_entity();
    _a268 = entityKind;
    PgRole = class {
      constructor(name3, config) {
        /** @internal */
        __publicField(this, "_existing");
        /** @internal */
        __publicField(this, "createDb");
        /** @internal */
        __publicField(this, "createRole");
        /** @internal */
        __publicField(this, "inherit");
        this.name = name3;
        if (config) {
          this.createDb = config.createDb;
          this.createRole = config.createRole;
          this.inherit = config.inherit;
        }
      }
      existing() {
        this._existing = true;
        return this;
      }
    };
    __publicField(PgRole, _a268, "PgRole");
  }
});

// ../drizzle-orm/dist/pg-core/sequence.js
function pgSequence(name3, options) {
  return pgSequenceWithSchema(name3, options, void 0);
}
function pgSequenceWithSchema(name3, options, schema6) {
  return new PgSequence(name3, options, schema6);
}
function isPgSequence(obj) {
  return is(obj, PgSequence);
}
var _a269, PgSequence;
var init_sequence = __esm({
  "../drizzle-orm/dist/pg-core/sequence.js"() {
    "use strict";
    init_entity();
    _a269 = entityKind;
    PgSequence = class {
      constructor(seqName, seqOptions, schema6) {
        this.seqName = seqName;
        this.seqOptions = seqOptions;
        this.schema = schema6;
      }
    };
    __publicField(PgSequence, _a269, "PgSequence");
  }
});

// ../drizzle-orm/dist/pg-core/schema.js
function isPgSchema(obj) {
  return is(obj, PgSchema);
}
function pgSchema(name3) {
  if (name3 === "public") {
    throw new Error(
      `You can't specify 'public' as schema name. Postgres is using public schema by default. If you want to use 'public' schema, just use pgTable() instead of creating a schema`
    );
  }
  return new PgSchema(name3);
}
var _a270, PgSchema;
var init_schema2 = __esm({
  "../drizzle-orm/dist/pg-core/schema.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_enum();
    init_sequence();
    init_table2();
    init_view2();
    _a270 = entityKind;
    PgSchema = class {
      constructor(schemaName) {
        __publicField(this, "table", (name3, columns, extraConfig) => {
          return pgTableWithSchema(name3, columns, extraConfig, this.schemaName);
        });
        __publicField(this, "view", (name3, columns) => {
          return pgViewWithSchema(name3, columns, this.schemaName);
        });
        __publicField(this, "materializedView", (name3, columns) => {
          return pgMaterializedViewWithSchema(name3, columns, this.schemaName);
        });
        __publicField(this, "sequence", (name3, options) => {
          return pgSequenceWithSchema(name3, options, this.schemaName);
        });
        this.schemaName = schemaName;
      }
      enum(enumName, input) {
        return Array.isArray(input) ? pgEnumWithSchema(
          enumName,
          [...input],
          this.schemaName
        ) : pgEnumObjectWithSchema(enumName, input, this.schemaName);
      }
      getSQL() {
        return new SQL([sql.identifier(this.schemaName)]);
      }
      shouldOmitSQLParens() {
        return true;
      }
    };
    __publicField(PgSchema, _a270, "PgSchema");
  }
});

// ../drizzle-orm/dist/pg-core/session.js
var _a271, PgPreparedQuery, _a272, PgSession, _a273, _b201, PgTransaction;
var init_session2 = __esm({
  "../drizzle-orm/dist/pg-core/session.js"() {
    "use strict";
    init_cache();
    init_entity();
    init_errors();
    init_sql2();
    init_tracing();
    init_db2();
    _a271 = entityKind;
    PgPreparedQuery = class {
      constructor(query, cache5, queryMetadata, cacheConfig) {
        __publicField(this, "authToken");
        /** @internal */
        __publicField(this, "joinsNotNullableMap");
        this.query = query;
        this.cache = cache5;
        this.queryMetadata = queryMetadata;
        this.cacheConfig = cacheConfig;
        if (cache5 && cache5.strategy() === "all" && cacheConfig === void 0) {
          this.cacheConfig = { enable: true, autoInvalidate: true };
        }
        if (!this.cacheConfig?.enable) {
          this.cacheConfig = void 0;
        }
      }
      getQuery() {
        return this.query;
      }
      mapResult(response, _isFromBatch) {
        return response;
      }
      /** @internal */
      setToken(token) {
        this.authToken = token;
        return this;
      }
      /** @internal */
      async queryWithCache(queryString, params, query) {
        if (this.cache === void 0 || is(this.cache, NoopCache) || this.queryMetadata === void 0) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.cacheConfig && !this.cacheConfig.enable) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if ((this.queryMetadata.type === "insert" || this.queryMetadata.type === "update" || this.queryMetadata.type === "delete") && this.queryMetadata.tables.length > 0) {
          try {
            const [res] = await Promise.all([
              query(),
              this.cache.onMutate({ tables: this.queryMetadata.tables })
            ]);
            return res;
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (!this.cacheConfig) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.queryMetadata.type === "select") {
          const fromCache = await this.cache.get(
            this.cacheConfig.tag ?? await hashQuery(queryString, params),
            this.queryMetadata.tables,
            this.cacheConfig.tag !== void 0,
            this.cacheConfig.autoInvalidate
          );
          if (fromCache === void 0) {
            let result;
            try {
              result = await query();
            } catch (e6) {
              throw new DrizzleQueryError(queryString, params, e6);
            }
            await this.cache.put(
              this.cacheConfig.tag ?? await hashQuery(queryString, params),
              result,
              // make sure we send tables that were used in a query only if user wants to invalidate it on each write
              this.cacheConfig.autoInvalidate ? this.queryMetadata.tables : [],
              this.cacheConfig.tag !== void 0,
              this.cacheConfig.config
            );
            return result;
          }
          return fromCache;
        }
        try {
          return await query();
        } catch (e6) {
          throw new DrizzleQueryError(queryString, params, e6);
        }
      }
    };
    __publicField(PgPreparedQuery, _a271, "PgPreparedQuery");
    _a272 = entityKind;
    PgSession = class {
      constructor(dialect6) {
        this.dialect = dialect6;
      }
      /** @internal */
      execute(query, token) {
        return tracer.startActiveSpan("drizzle.operation", () => {
          const prepared = tracer.startActiveSpan("drizzle.prepareQuery", () => {
            return this.prepareQuery(
              this.dialect.sqlToQuery(query),
              void 0,
              void 0,
              false
            );
          });
          return prepared.setToken(token).execute(void 0, token);
        });
      }
      all(query) {
        return this.prepareQuery(
          this.dialect.sqlToQuery(query),
          void 0,
          void 0,
          false
        ).all();
      }
      /** @internal */
      async count(sql22, token) {
        const res = await this.execute(sql22, token);
        return Number(
          res[0]["count"]
        );
      }
    };
    __publicField(PgSession, _a272, "PgSession");
    PgTransaction = class extends (_b201 = PgDatabase, _a273 = entityKind, _b201) {
      constructor(dialect6, session, schema6, nestedIndex = 0) {
        super(dialect6, session, schema6);
        this.schema = schema6;
        this.nestedIndex = nestedIndex;
      }
      rollback() {
        throw new TransactionRollbackError();
      }
      /** @internal */
      getTransactionConfigSQL(config) {
        const chunks = [];
        if (config.isolationLevel) {
          chunks.push(`isolation level ${config.isolationLevel}`);
        }
        if (config.accessMode) {
          chunks.push(config.accessMode);
        }
        if (typeof config.deferrable === "boolean") {
          chunks.push(config.deferrable ? "deferrable" : "not deferrable");
        }
        return sql.raw(chunks.join(" "));
      }
      setTransaction(config) {
        return this.session.execute(sql`set transaction ${this.getTransactionConfigSQL(config)}`);
      }
    };
    __publicField(PgTransaction, _a273, "PgTransaction");
  }
});

// ../drizzle-orm/dist/pg-core/subquery.js
var init_subquery3 = __esm({
  "../drizzle-orm/dist/pg-core/subquery.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/pg-core/utils/index.js
var init_utils5 = __esm({
  "../drizzle-orm/dist/pg-core/utils/index.js"() {
    "use strict";
    init_array();
  }
});

// ../drizzle-orm/dist/pg-core/index.js
var pg_core_exports = {};
__export(pg_core_exports, {
  Check: () => Check2,
  CheckBuilder: () => CheckBuilder2,
  DefaultViewBuilderCore: () => DefaultViewBuilderCore,
  EnableRLS: () => EnableRLS,
  ExtraConfigColumn: () => ExtraConfigColumn,
  ForeignKey: () => ForeignKey,
  ForeignKeyBuilder: () => ForeignKeyBuilder,
  Index: () => Index2,
  IndexBuilder: () => IndexBuilder2,
  IndexBuilderOn: () => IndexBuilderOn2,
  IndexedColumn: () => IndexedColumn,
  InlineForeignKeys: () => InlineForeignKeys,
  ManualMaterializedViewBuilder: () => ManualMaterializedViewBuilder,
  ManualViewBuilder: () => ManualViewBuilder2,
  MaterializedViewBuilder: () => MaterializedViewBuilder,
  MaterializedViewBuilderCore: () => MaterializedViewBuilderCore,
  PgArray: () => PgArray,
  PgArrayBuilder: () => PgArrayBuilder,
  PgBigInt53: () => PgBigInt53,
  PgBigInt53Builder: () => PgBigInt53Builder,
  PgBigInt64: () => PgBigInt64,
  PgBigInt64Builder: () => PgBigInt64Builder,
  PgBigSerial53: () => PgBigSerial53,
  PgBigSerial53Builder: () => PgBigSerial53Builder,
  PgBigSerial64: () => PgBigSerial64,
  PgBigSerial64Builder: () => PgBigSerial64Builder,
  PgBinaryVector: () => PgBinaryVector,
  PgBinaryVectorBuilder: () => PgBinaryVectorBuilder,
  PgBoolean: () => PgBoolean,
  PgBooleanBuilder: () => PgBooleanBuilder,
  PgChar: () => PgChar,
  PgCharBuilder: () => PgCharBuilder,
  PgCidr: () => PgCidr,
  PgCidrBuilder: () => PgCidrBuilder,
  PgColumn: () => PgColumn,
  PgColumnBuilder: () => PgColumnBuilder,
  PgCustomColumn: () => PgCustomColumn,
  PgCustomColumnBuilder: () => PgCustomColumnBuilder,
  PgDatabase: () => PgDatabase,
  PgDate: () => PgDate,
  PgDateBuilder: () => PgDateBuilder,
  PgDateString: () => PgDateString,
  PgDateStringBuilder: () => PgDateStringBuilder,
  PgDeleteBase: () => PgDeleteBase,
  PgDialect: () => PgDialect,
  PgDoublePrecision: () => PgDoublePrecision,
  PgDoublePrecisionBuilder: () => PgDoublePrecisionBuilder,
  PgEnumColumn: () => PgEnumColumn,
  PgEnumColumnBuilder: () => PgEnumColumnBuilder,
  PgEnumObjectColumn: () => PgEnumObjectColumn,
  PgEnumObjectColumnBuilder: () => PgEnumObjectColumnBuilder,
  PgGeometry: () => PgGeometry,
  PgGeometryBuilder: () => PgGeometryBuilder,
  PgGeometryObject: () => PgGeometryObject,
  PgGeometryObjectBuilder: () => PgGeometryObjectBuilder,
  PgHalfVector: () => PgHalfVector,
  PgHalfVectorBuilder: () => PgHalfVectorBuilder,
  PgInet: () => PgInet,
  PgInetBuilder: () => PgInetBuilder,
  PgInsertBase: () => PgInsertBase,
  PgInsertBuilder: () => PgInsertBuilder,
  PgIntColumnBaseBuilder: () => PgIntColumnBaseBuilder,
  PgInteger: () => PgInteger,
  PgIntegerBuilder: () => PgIntegerBuilder,
  PgInterval: () => PgInterval,
  PgIntervalBuilder: () => PgIntervalBuilder,
  PgJson: () => PgJson,
  PgJsonBuilder: () => PgJsonBuilder,
  PgJsonb: () => PgJsonb,
  PgJsonbBuilder: () => PgJsonbBuilder,
  PgLineABC: () => PgLineABC,
  PgLineABCBuilder: () => PgLineABCBuilder,
  PgLineBuilder: () => PgLineBuilder,
  PgLineTuple: () => PgLineTuple,
  PgMacaddr: () => PgMacaddr,
  PgMacaddr8: () => PgMacaddr8,
  PgMacaddr8Builder: () => PgMacaddr8Builder,
  PgMacaddrBuilder: () => PgMacaddrBuilder,
  PgMaterializedView: () => PgMaterializedView,
  PgMaterializedViewConfig: () => PgMaterializedViewConfig,
  PgNumeric: () => PgNumeric,
  PgNumericBigInt: () => PgNumericBigInt,
  PgNumericBigIntBuilder: () => PgNumericBigIntBuilder,
  PgNumericBuilder: () => PgNumericBuilder,
  PgNumericNumber: () => PgNumericNumber,
  PgNumericNumberBuilder: () => PgNumericNumberBuilder,
  PgPointObject: () => PgPointObject,
  PgPointObjectBuilder: () => PgPointObjectBuilder,
  PgPointTuple: () => PgPointTuple,
  PgPointTupleBuilder: () => PgPointTupleBuilder,
  PgPolicy: () => PgPolicy,
  PgPreparedQuery: () => PgPreparedQuery,
  PgReal: () => PgReal,
  PgRealBuilder: () => PgRealBuilder,
  PgRefreshMaterializedView: () => PgRefreshMaterializedView,
  PgRole: () => PgRole,
  PgSchema: () => PgSchema,
  PgSelectBase: () => PgSelectBase,
  PgSelectBuilder: () => PgSelectBuilder,
  PgSelectQueryBuilderBase: () => PgSelectQueryBuilderBase,
  PgSequence: () => PgSequence,
  PgSerial: () => PgSerial,
  PgSerialBuilder: () => PgSerialBuilder,
  PgSession: () => PgSession,
  PgSmallInt: () => PgSmallInt,
  PgSmallIntBuilder: () => PgSmallIntBuilder,
  PgSmallSerial: () => PgSmallSerial,
  PgSmallSerialBuilder: () => PgSmallSerialBuilder,
  PgSparseVector: () => PgSparseVector,
  PgSparseVectorBuilder: () => PgSparseVectorBuilder,
  PgTable: () => PgTable,
  PgText: () => PgText,
  PgTextBuilder: () => PgTextBuilder,
  PgTime: () => PgTime,
  PgTimeBuilder: () => PgTimeBuilder,
  PgTimestamp: () => PgTimestamp,
  PgTimestampBuilder: () => PgTimestampBuilder,
  PgTimestampString: () => PgTimestampString,
  PgTimestampStringBuilder: () => PgTimestampStringBuilder,
  PgTransaction: () => PgTransaction,
  PgUUID: () => PgUUID,
  PgUUIDBuilder: () => PgUUIDBuilder,
  PgUpdateBase: () => PgUpdateBase,
  PgUpdateBuilder: () => PgUpdateBuilder,
  PgVarchar: () => PgVarchar,
  PgVarcharBuilder: () => PgVarcharBuilder,
  PgVector: () => PgVector,
  PgVectorBuilder: () => PgVectorBuilder,
  PgView: () => PgView,
  PgViewConfig: () => PgViewConfig,
  PrimaryKey: () => PrimaryKey,
  PrimaryKeyBuilder: () => PrimaryKeyBuilder,
  QueryBuilder: () => QueryBuilder2,
  UniqueConstraint: () => UniqueConstraint,
  UniqueConstraintBuilder: () => UniqueConstraintBuilder,
  UniqueOnConstraintBuilder: () => UniqueOnConstraintBuilder,
  ViewBuilder: () => ViewBuilder2,
  alias: () => alias,
  bigint: () => bigint,
  bigserial: () => bigserial,
  bit: () => bit,
  boolean: () => boolean,
  char: () => char,
  check: () => check,
  cidr: () => cidr,
  customType: () => customType,
  date: () => date,
  decimal: () => decimal,
  doublePrecision: () => doublePrecision,
  except: () => except2,
  exceptAll: () => exceptAll2,
  extractUsedTable: () => extractUsedTable2,
  foreignKey: () => foreignKey,
  geometry: () => geometry,
  getMaterializedViewConfig: () => getMaterializedViewConfig,
  getTableConfig: () => getTableConfig2,
  getViewConfig: () => getViewConfig2,
  halfvec: () => halfvec,
  index: () => index,
  inet: () => inet,
  integer: () => integer,
  intersect: () => intersect2,
  intersectAll: () => intersectAll2,
  interval: () => interval,
  isPgEnum: () => isPgEnum,
  isPgMaterializedView: () => isPgMaterializedView,
  isPgSchema: () => isPgSchema,
  isPgSequence: () => isPgSequence,
  isPgView: () => isPgView,
  json: () => json,
  jsonb: () => jsonb,
  line: () => line,
  macaddr: () => macaddr,
  macaddr8: () => macaddr8,
  makePgArray: () => makePgArray,
  numeric: () => numeric,
  parsePgArray: () => parsePgArray,
  parsePgNestedArray: () => parsePgNestedArray,
  pgEnum: () => pgEnum,
  pgEnumObjectWithSchema: () => pgEnumObjectWithSchema,
  pgEnumWithSchema: () => pgEnumWithSchema,
  pgMaterializedView: () => pgMaterializedView,
  pgMaterializedViewWithSchema: () => pgMaterializedViewWithSchema,
  pgPolicy: () => pgPolicy,
  pgRole: () => pgRole,
  pgSchema: () => pgSchema,
  pgSequence: () => pgSequence,
  pgSequenceWithSchema: () => pgSequenceWithSchema,
  pgTable: () => pgTable,
  pgTableCreator: () => pgTableCreator,
  pgTableWithSchema: () => pgTableWithSchema,
  pgView: () => pgView,
  pgViewWithSchema: () => pgViewWithSchema,
  point: () => point,
  primaryKey: () => primaryKey,
  real: () => real,
  serial: () => serial,
  smallint: () => smallint,
  smallserial: () => smallserial,
  sparsevec: () => sparsevec,
  text: () => text,
  time: () => time,
  timestamp: () => timestamp,
  union: () => union2,
  unionAll: () => unionAll2,
  unique: () => unique,
  uniqueIndex: () => uniqueIndex,
  uniqueKeyName: () => uniqueKeyName,
  uuid: () => uuid,
  varchar: () => varchar,
  vector: () => vector,
  withReplicas: () => withReplicas
});
var init_pg_core = __esm({
  "../drizzle-orm/dist/pg-core/index.js"() {
    "use strict";
    init_alias3();
    init_checks2();
    init_columns2();
    init_db2();
    init_dialect2();
    init_foreign_keys();
    init_indexes2();
    init_policies();
    init_primary_keys();
    init_query_builders2();
    init_roles();
    init_schema2();
    init_sequence();
    init_session2();
    init_subquery3();
    init_table2();
    init_unique_constraint();
    init_utils4();
    init_utils5();
    init_view_common3();
    init_view2();
  }
});

// ../drizzle-orm/dist/singlestore-core/alias.js
var init_alias4 = __esm({
  "../drizzle-orm/dist/singlestore-core/alias.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/singlestore-core/unique-constraint.js
function uniqueKeyName3(table6, columns) {
  return `${table6[TableName]}_${columns.join("_")}_unique`;
}
var _a274, UniqueConstraintBuilder3, _a275, UniqueOnConstraintBuilder3, _a276, UniqueConstraint3;
var init_unique_constraint3 = __esm({
  "../drizzle-orm/dist/singlestore-core/unique-constraint.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a274 = entityKind;
    UniqueConstraintBuilder3 = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        this.name = name3;
        this.columns = columns;
      }
      /** @internal */
      build(table6) {
        return new UniqueConstraint3(table6, this.columns, this.name);
      }
    };
    __publicField(UniqueConstraintBuilder3, _a274, "SingleStoreUniqueConstraintBuilder");
    _a275 = entityKind;
    UniqueOnConstraintBuilder3 = class {
      constructor(name3) {
        /** @internal */
        __publicField(this, "name");
        this.name = name3;
      }
      on(...columns) {
        return new UniqueConstraintBuilder3(columns, this.name);
      }
    };
    __publicField(UniqueOnConstraintBuilder3, _a275, "SingleStoreUniqueOnConstraintBuilder");
    _a276 = entityKind;
    UniqueConstraint3 = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        __publicField(this, "nullsNotDistinct", false);
        this.table = table6;
        this.columns = columns;
        this.name = name3 ?? uniqueKeyName3(this.table, this.columns.map((column6) => column6.name));
      }
      getName() {
        return this.name;
      }
    };
    __publicField(UniqueConstraint3, _a276, "SingleStoreUniqueConstraint");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/common.js
var _a277, _b202, SingleStoreColumnBuilder, _a278, _b203, SingleStoreColumn, _a279, _b204, SingleStoreColumnBuilderWithAutoIncrement, _a280, _b205, SingleStoreColumnWithAutoIncrement;
var init_common3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/common.js"() {
    "use strict";
    init_column_builder();
    init_column();
    init_entity();
    init_unique_constraint3();
    SingleStoreColumnBuilder = class extends (_b202 = ColumnBuilder, _a277 = entityKind, _b202) {
      unique(name3) {
        this.config.isUnique = true;
        this.config.uniqueName = name3;
        return this;
      }
      // TODO: Implement generated columns for SingleStore (https://docs.singlestore.com/cloud/create-a-database/using-persistent-computed-columns/)
      /** @internal */
      generatedAlwaysAs(as, config) {
        this.config.generated = {
          as,
          type: "always",
          mode: config?.mode ?? "virtual"
        };
        return this;
      }
    };
    __publicField(SingleStoreColumnBuilder, _a277, "SingleStoreColumnBuilder");
    SingleStoreColumn = class extends (_b203 = Column, _a278 = entityKind, _b203) {
      constructor(table6, config) {
        if (!config.uniqueName) {
          config.uniqueName = uniqueKeyName3(table6, [config.name]);
        }
        super(table6, config);
        this.table = table6;
      }
    };
    __publicField(SingleStoreColumn, _a278, "SingleStoreColumn");
    SingleStoreColumnBuilderWithAutoIncrement = class extends (_b204 = SingleStoreColumnBuilder, _a279 = entityKind, _b204) {
      constructor(name3, dataType, columnType) {
        super(name3, dataType, columnType);
        this.config.autoIncrement = false;
      }
      autoincrement() {
        this.config.autoIncrement = true;
        this.config.hasDefault = true;
        return this;
      }
    };
    __publicField(SingleStoreColumnBuilderWithAutoIncrement, _a279, "SingleStoreColumnBuilderWithAutoIncrement");
    SingleStoreColumnWithAutoIncrement = class extends (_b205 = SingleStoreColumn, _a280 = entityKind, _b205) {
      constructor() {
        super(...arguments);
        __publicField(this, "autoIncrement", this.config.autoIncrement);
      }
    };
    __publicField(SingleStoreColumnWithAutoIncrement, _a280, "SingleStoreColumnWithAutoIncrement");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/bigint.js
function bigint3(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config.mode === "number") {
    return new SingleStoreBigInt53Builder(name3, config.unsigned);
  }
  return new SingleStoreBigInt64Builder(name3, config.unsigned);
}
var _a281, _b206, SingleStoreBigInt53Builder, _a282, _b207, SingleStoreBigInt53, _a283, _b208, SingleStoreBigInt64Builder, _a284, _b209, SingleStoreBigInt64;
var init_bigint3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/bigint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreBigInt53Builder = class extends (_b206 = SingleStoreColumnBuilderWithAutoIncrement, _a281 = entityKind, _b206) {
      constructor(name3, unsigned = false) {
        super(name3, "number", "SingleStoreBigInt53");
        this.config.unsigned = unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreBigInt53(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreBigInt53Builder, _a281, "SingleStoreBigInt53Builder");
    SingleStoreBigInt53 = class extends (_b207 = SingleStoreColumnWithAutoIncrement, _a282 = entityKind, _b207) {
      getSQLType() {
        return `bigint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") {
          return value;
        }
        return Number(value);
      }
    };
    __publicField(SingleStoreBigInt53, _a282, "SingleStoreBigInt53");
    SingleStoreBigInt64Builder = class extends (_b208 = SingleStoreColumnBuilderWithAutoIncrement, _a283 = entityKind, _b208) {
      constructor(name3, unsigned = false) {
        super(name3, "bigint", "SingleStoreBigInt64");
        this.config.unsigned = unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreBigInt64(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreBigInt64Builder, _a283, "SingleStoreBigInt64Builder");
    SingleStoreBigInt64 = class extends (_b209 = SingleStoreColumnWithAutoIncrement, _a284 = entityKind, _b209) {
      getSQLType() {
        return `bigint${this.config.unsigned ? " unsigned" : ""}`;
      }
      // eslint-disable-next-line unicorn/prefer-native-coercion-functions
      mapFromDriverValue(value) {
        return BigInt(value);
      }
    };
    __publicField(SingleStoreBigInt64, _a284, "SingleStoreBigInt64");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/binary.js
function binary3(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreBinaryBuilder(name3, config.length);
}
var _a285, _b210, SingleStoreBinaryBuilder, _a286, _b211, SingleStoreBinary;
var init_binary2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/binary.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreBinaryBuilder = class extends (_b210 = SingleStoreColumnBuilder, _a285 = entityKind, _b210) {
      constructor(name3, length) {
        super(name3, "string", "SingleStoreBinary");
        this.config.length = length;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreBinary(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreBinaryBuilder, _a285, "SingleStoreBinaryBuilder");
    SingleStoreBinary = class extends (_b211 = SingleStoreColumn, _a286 = entityKind, _b211) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        if (Buffer.isBuffer(value)) return value.toString();
        const str = [];
        for (const v11 of value) {
          str.push(v11 === 49 ? "1" : "0");
        }
        return str.join("");
      }
      getSQLType() {
        return this.length === void 0 ? `binary` : `binary(${this.length})`;
      }
    };
    __publicField(SingleStoreBinary, _a286, "SingleStoreBinary");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/boolean.js
function boolean3(name3) {
  return new SingleStoreBooleanBuilder(name3 ?? "");
}
var _a287, _b212, SingleStoreBooleanBuilder, _a288, _b213, SingleStoreBoolean;
var init_boolean3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/boolean.js"() {
    "use strict";
    init_entity();
    init_common3();
    SingleStoreBooleanBuilder = class extends (_b212 = SingleStoreColumnBuilder, _a287 = entityKind, _b212) {
      constructor(name3) {
        super(name3, "boolean", "SingleStoreBoolean");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreBoolean(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreBooleanBuilder, _a287, "SingleStoreBooleanBuilder");
    SingleStoreBoolean = class extends (_b213 = SingleStoreColumn, _a288 = entityKind, _b213) {
      getSQLType() {
        return "boolean";
      }
      mapFromDriverValue(value) {
        if (typeof value === "boolean") {
          return value;
        }
        return value === 1;
      }
    };
    __publicField(SingleStoreBoolean, _a288, "SingleStoreBoolean");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/char.js
function char3(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreCharBuilder(name3, config);
}
var _a289, _b214, SingleStoreCharBuilder, _a290, _b215, SingleStoreChar;
var init_char3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/char.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreCharBuilder = class extends (_b214 = SingleStoreColumnBuilder, _a289 = entityKind, _b214) {
      constructor(name3, config) {
        super(name3, "string", "SingleStoreChar");
        this.config.length = config.length;
        this.config.enum = config.enum;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreChar(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreCharBuilder, _a289, "SingleStoreCharBuilder");
    SingleStoreChar = class extends (_b215 = SingleStoreColumn, _a290 = entityKind, _b215) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
        __publicField(this, "enumValues", this.config.enum);
      }
      getSQLType() {
        return this.length === void 0 ? `char` : `char(${this.length})`;
      }
    };
    __publicField(SingleStoreChar, _a290, "SingleStoreChar");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/custom.js
function customType3(customTypeParams) {
  return (a9, b9) => {
    const { name: name3, config } = getColumnNameAndConfig(a9, b9);
    return new SingleStoreCustomColumnBuilder(name3, config, customTypeParams);
  };
}
var _a291, _b216, SingleStoreCustomColumnBuilder, _a292, _b217, SingleStoreCustomColumn;
var init_custom3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/custom.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreCustomColumnBuilder = class extends (_b216 = SingleStoreColumnBuilder, _a291 = entityKind, _b216) {
      constructor(name3, fieldConfig, customTypeParams) {
        super(name3, "custom", "SingleStoreCustomColumn");
        this.config.fieldConfig = fieldConfig;
        this.config.customTypeParams = customTypeParams;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreCustomColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreCustomColumnBuilder, _a291, "SingleStoreCustomColumnBuilder");
    SingleStoreCustomColumn = class extends (_b217 = SingleStoreColumn, _a292 = entityKind, _b217) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "sqlName");
        __publicField(this, "mapTo");
        __publicField(this, "mapFrom");
        this.sqlName = config.customTypeParams.dataType(config.fieldConfig);
        this.mapTo = config.customTypeParams.toDriver;
        this.mapFrom = config.customTypeParams.fromDriver;
      }
      getSQLType() {
        return this.sqlName;
      }
      mapFromDriverValue(value) {
        return typeof this.mapFrom === "function" ? this.mapFrom(value) : value;
      }
      mapToDriverValue(value) {
        return typeof this.mapTo === "function" ? this.mapTo(value) : value;
      }
    };
    __publicField(SingleStoreCustomColumn, _a292, "SingleStoreCustomColumn");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/date.js
function date3(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new SingleStoreDateStringBuilder(name3);
  }
  return new SingleStoreDateBuilder(name3);
}
var _a293, _b218, SingleStoreDateBuilder, _a294, _b219, SingleStoreDate, _a295, _b220, SingleStoreDateStringBuilder, _a296, _b221, SingleStoreDateString;
var init_date3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/date.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreDateBuilder = class extends (_b218 = SingleStoreColumnBuilder, _a293 = entityKind, _b218) {
      constructor(name3) {
        super(name3, "date", "SingleStoreDate");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDate(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDateBuilder, _a293, "SingleStoreDateBuilder");
    SingleStoreDate = class extends (_b219 = SingleStoreColumn, _a294 = entityKind, _b219) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return `date`;
      }
      mapFromDriverValue(value) {
        return new Date(value);
      }
    };
    __publicField(SingleStoreDate, _a294, "SingleStoreDate");
    SingleStoreDateStringBuilder = class extends (_b220 = SingleStoreColumnBuilder, _a295 = entityKind, _b220) {
      constructor(name3) {
        super(name3, "string", "SingleStoreDateString");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDateString(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDateStringBuilder, _a295, "SingleStoreDateStringBuilder");
    SingleStoreDateString = class extends (_b221 = SingleStoreColumn, _a296 = entityKind, _b221) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return `date`;
      }
    };
    __publicField(SingleStoreDateString, _a296, "SingleStoreDateString");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/datetime.js
function datetime2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new SingleStoreDateTimeStringBuilder(name3);
  }
  return new SingleStoreDateTimeBuilder(name3);
}
var _a297, _b222, SingleStoreDateTimeBuilder, _a298, _b223, SingleStoreDateTime, _a299, _b224, SingleStoreDateTimeStringBuilder, _a300, _b225, SingleStoreDateTimeString;
var init_datetime2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/datetime.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreDateTimeBuilder = class extends (_b222 = SingleStoreColumnBuilder, _a297 = entityKind, _b222) {
      /** @internal */
      // TODO: we need to add a proper support for SingleStore
      generatedAlwaysAs(_as, _config) {
        throw new Error("Method not implemented.");
      }
      constructor(name3) {
        super(name3, "date", "SingleStoreDateTime");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDateTime(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDateTimeBuilder, _a297, "SingleStoreDateTimeBuilder");
    SingleStoreDateTime = class extends (_b223 = SingleStoreColumn, _a298 = entityKind, _b223) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return `datetime`;
      }
      mapToDriverValue(value) {
        return value.toISOString().replace("T", " ").replace("Z", "");
      }
      mapFromDriverValue(value) {
        return /* @__PURE__ */ new Date(value.replace(" ", "T") + "Z");
      }
    };
    __publicField(SingleStoreDateTime, _a298, "SingleStoreDateTime");
    SingleStoreDateTimeStringBuilder = class extends (_b224 = SingleStoreColumnBuilder, _a299 = entityKind, _b224) {
      /** @internal */
      // TODO: we need to add a proper support for SingleStore
      generatedAlwaysAs(_as, _config) {
        throw new Error("Method not implemented.");
      }
      constructor(name3) {
        super(name3, "string", "SingleStoreDateTimeString");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDateTimeString(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDateTimeStringBuilder, _a299, "SingleStoreDateTimeStringBuilder");
    SingleStoreDateTimeString = class extends (_b225 = SingleStoreColumn, _a300 = entityKind, _b225) {
      constructor(table6, config) {
        super(table6, config);
      }
      getSQLType() {
        return `datetime`;
      }
    };
    __publicField(SingleStoreDateTimeString, _a300, "SingleStoreDateTimeString");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/decimal.js
function decimal3(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  const mode = config?.mode;
  return mode === "number" ? new SingleStoreDecimalNumberBuilder(name3, config) : mode === "bigint" ? new SingleStoreDecimalBigIntBuilder(name3, config) : new SingleStoreDecimalBuilder(name3, config);
}
var _a301, _b226, SingleStoreDecimalBuilder, _a302, _b227, SingleStoreDecimal, _a303, _b228, SingleStoreDecimalNumberBuilder, _a304, _b229, SingleStoreDecimalNumber, _a305, _b230, SingleStoreDecimalBigIntBuilder, _a306, _b231, SingleStoreDecimalBigInt;
var init_decimal2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/decimal.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreDecimalBuilder = class extends (_b226 = SingleStoreColumnBuilderWithAutoIncrement, _a301 = entityKind, _b226) {
      constructor(name3, config) {
        super(name3, "string", "SingleStoreDecimal");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDecimal(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDecimalBuilder, _a301, "SingleStoreDecimalBuilder");
    SingleStoreDecimal = class extends (_b227 = SingleStoreColumnWithAutoIncrement, _a302 = entityKind, _b227) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        return String(value);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `decimal(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "decimal";
        } else {
          type += `decimal(${this.precision})`;
        }
        type = type === "decimal(10,0)" || type === "decimal(10)" ? "decimal" : type;
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(SingleStoreDecimal, _a302, "SingleStoreDecimal");
    SingleStoreDecimalNumberBuilder = class extends (_b228 = SingleStoreColumnBuilderWithAutoIncrement, _a303 = entityKind, _b228) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreDecimalNumber");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDecimalNumber(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDecimalNumberBuilder, _a303, "SingleStoreDecimalNumberBuilder");
    SingleStoreDecimalNumber = class extends (_b229 = SingleStoreColumnWithAutoIncrement, _a304 = entityKind, _b229) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
        __publicField(this, "mapToDriverValue", String);
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") return value;
        return Number(value);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `decimal(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "decimal";
        } else {
          type += `decimal(${this.precision})`;
        }
        type = type === "decimal(10,0)" || type === "decimal(10)" ? "decimal" : type;
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(SingleStoreDecimalNumber, _a304, "SingleStoreDecimalNumber");
    SingleStoreDecimalBigIntBuilder = class extends (_b230 = SingleStoreColumnBuilderWithAutoIncrement, _a305 = entityKind, _b230) {
      constructor(name3, config) {
        super(name3, "bigint", "SingleStoreDecimalBigInt");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDecimalBigInt(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDecimalBigIntBuilder, _a305, "SingleStoreDecimalBigIntBuilder");
    SingleStoreDecimalBigInt = class extends (_b231 = SingleStoreColumnWithAutoIncrement, _a306 = entityKind, _b231) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
        __publicField(this, "mapFromDriverValue", BigInt);
        __publicField(this, "mapToDriverValue", String);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `decimal(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "decimal";
        } else {
          type += `decimal(${this.precision})`;
        }
        type = type === "decimal(10,0)" || type === "decimal(10)" ? "decimal" : type;
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(SingleStoreDecimalBigInt, _a306, "SingleStoreDecimalBigInt");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/double.js
function double2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreDoubleBuilder(name3, config);
}
var _a307, _b232, SingleStoreDoubleBuilder, _a308, _b233, SingleStoreDouble;
var init_double2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/double.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreDoubleBuilder = class extends (_b232 = SingleStoreColumnBuilderWithAutoIncrement, _a307 = entityKind, _b232) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreDouble");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreDouble(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreDoubleBuilder, _a307, "SingleStoreDoubleBuilder");
    SingleStoreDouble = class extends (_b233 = SingleStoreColumnWithAutoIncrement, _a308 = entityKind, _b233) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `double(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "double";
        } else {
          type += `double(${this.precision})`;
        }
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(SingleStoreDouble, _a308, "SingleStoreDouble");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/enum.js
function singlestoreEnum(a9, b9) {
  const { name: name3, config: values2 } = getColumnNameAndConfig(a9, b9);
  if (values2.length === 0) {
    throw new Error(`You have an empty array for "${name3}" enum values`);
  }
  return new SingleStoreEnumColumnBuilder(name3, values2);
}
var _a309, _b234, SingleStoreEnumColumnBuilder, _a310, _b235, SingleStoreEnumColumn;
var init_enum3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/enum.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreEnumColumnBuilder = class extends (_b234 = SingleStoreColumnBuilder, _a309 = entityKind, _b234) {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      generatedAlwaysAs(as, config) {
        throw new Error("Method not implemented.");
      }
      constructor(name3, values2) {
        super(name3, "string", "SingleStoreEnumColumn");
        this.config.enumValues = values2;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreEnumColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreEnumColumnBuilder, _a309, "SingleStoreEnumColumnBuilder");
    SingleStoreEnumColumn = class extends (_b235 = SingleStoreColumn, _a310 = entityKind, _b235) {
      constructor() {
        super(...arguments);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return `enum(${this.enumValues.map((value) => `'${value}'`).join(",")})`;
      }
    };
    __publicField(SingleStoreEnumColumn, _a310, "SingleStoreEnumColumn");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/float.js
function float2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreFloatBuilder(name3, config);
}
var _a311, _b236, SingleStoreFloatBuilder, _a312, _b237, SingleStoreFloat;
var init_float2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/float.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreFloatBuilder = class extends (_b236 = SingleStoreColumnBuilderWithAutoIncrement, _a311 = entityKind, _b236) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreFloat");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
        this.config.unsigned = config?.unsigned;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreFloat(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreFloatBuilder, _a311, "SingleStoreFloatBuilder");
    SingleStoreFloat = class extends (_b237 = SingleStoreColumnWithAutoIncrement, _a312 = entityKind, _b237) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
        __publicField(this, "unsigned", this.config.unsigned);
      }
      getSQLType() {
        let type = "";
        if (this.precision !== void 0 && this.scale !== void 0) {
          type += `float(${this.precision},${this.scale})`;
        } else if (this.precision === void 0) {
          type += "float";
        } else {
          type += `float(${this.precision},0)`;
        }
        return this.unsigned ? `${type} unsigned` : type;
      }
    };
    __publicField(SingleStoreFloat, _a312, "SingleStoreFloat");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/int.js
function int2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreIntBuilder(name3, config);
}
var _a313, _b238, SingleStoreIntBuilder, _a314, _b239, SingleStoreInt;
var init_int2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/int.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreIntBuilder = class extends (_b238 = SingleStoreColumnBuilderWithAutoIncrement, _a313 = entityKind, _b238) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreInt(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreIntBuilder, _a313, "SingleStoreIntBuilder");
    SingleStoreInt = class extends (_b239 = SingleStoreColumnWithAutoIncrement, _a314 = entityKind, _b239) {
      getSQLType() {
        return `int${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(SingleStoreInt, _a314, "SingleStoreInt");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/json.js
function json3(name3) {
  return new SingleStoreJsonBuilder(name3 ?? "");
}
var _a315, _b240, SingleStoreJsonBuilder, _a316, _b241, SingleStoreJson;
var init_json3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/json.js"() {
    "use strict";
    init_entity();
    init_common3();
    SingleStoreJsonBuilder = class extends (_b240 = SingleStoreColumnBuilder, _a315 = entityKind, _b240) {
      constructor(name3) {
        super(name3, "json", "SingleStoreJson");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreJson(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreJsonBuilder, _a315, "SingleStoreJsonBuilder");
    SingleStoreJson = class extends (_b241 = SingleStoreColumn, _a316 = entityKind, _b241) {
      getSQLType() {
        return "json";
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
    };
    __publicField(SingleStoreJson, _a316, "SingleStoreJson");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/mediumint.js
function mediumint2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreMediumIntBuilder(name3, config);
}
var _a317, _b242, SingleStoreMediumIntBuilder, _a318, _b243, SingleStoreMediumInt;
var init_mediumint2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/mediumint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreMediumIntBuilder = class extends (_b242 = SingleStoreColumnBuilderWithAutoIncrement, _a317 = entityKind, _b242) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreMediumInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreMediumInt(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreMediumIntBuilder, _a317, "SingleStoreMediumIntBuilder");
    SingleStoreMediumInt = class extends (_b243 = SingleStoreColumnWithAutoIncrement, _a318 = entityKind, _b243) {
      getSQLType() {
        return `mediumint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(SingleStoreMediumInt, _a318, "SingleStoreMediumInt");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/real.js
function real3(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreRealBuilder(name3, config);
}
var _a319, _b244, SingleStoreRealBuilder, _a320, _b245, SingleStoreReal;
var init_real3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/real.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreRealBuilder = class extends (_b244 = SingleStoreColumnBuilderWithAutoIncrement, _a319 = entityKind, _b244) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreReal");
        this.config.precision = config?.precision;
        this.config.scale = config?.scale;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreReal(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreRealBuilder, _a319, "SingleStoreRealBuilder");
    SingleStoreReal = class extends (_b245 = SingleStoreColumnWithAutoIncrement, _a320 = entityKind, _b245) {
      constructor() {
        super(...arguments);
        __publicField(this, "precision", this.config.precision);
        __publicField(this, "scale", this.config.scale);
      }
      getSQLType() {
        if (this.precision !== void 0 && this.scale !== void 0) {
          return `real(${this.precision}, ${this.scale})`;
        } else if (this.precision === void 0) {
          return "real";
        } else {
          return `real(${this.precision})`;
        }
      }
    };
    __publicField(SingleStoreReal, _a320, "SingleStoreReal");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/serial.js
function serial3(name3) {
  return new SingleStoreSerialBuilder(name3 ?? "");
}
var _a321, _b246, SingleStoreSerialBuilder, _a322, _b247, SingleStoreSerial;
var init_serial3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/serial.js"() {
    "use strict";
    init_entity();
    init_common3();
    SingleStoreSerialBuilder = class extends (_b246 = SingleStoreColumnBuilderWithAutoIncrement, _a321 = entityKind, _b246) {
      constructor(name3) {
        super(name3, "number", "SingleStoreSerial");
        this.config.hasDefault = true;
        this.config.autoIncrement = true;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreSerial(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreSerialBuilder, _a321, "SingleStoreSerialBuilder");
    SingleStoreSerial = class extends (_b247 = SingleStoreColumnWithAutoIncrement, _a322 = entityKind, _b247) {
      getSQLType() {
        return "serial";
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(SingleStoreSerial, _a322, "SingleStoreSerial");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/smallint.js
function smallint3(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreSmallIntBuilder(name3, config);
}
var _a323, _b248, SingleStoreSmallIntBuilder, _a324, _b249, SingleStoreSmallInt;
var init_smallint3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/smallint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreSmallIntBuilder = class extends (_b248 = SingleStoreColumnBuilderWithAutoIncrement, _a323 = entityKind, _b248) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreSmallInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreSmallInt(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreSmallIntBuilder, _a323, "SingleStoreSmallIntBuilder");
    SingleStoreSmallInt = class extends (_b249 = SingleStoreColumnWithAutoIncrement, _a324 = entityKind, _b249) {
      getSQLType() {
        return `smallint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(SingleStoreSmallInt, _a324, "SingleStoreSmallInt");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/text.js
function text3(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreTextBuilder(name3, "text", config);
}
function tinytext2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreTextBuilder(name3, "tinytext", config);
}
function mediumtext2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreTextBuilder(name3, "mediumtext", config);
}
function longtext2(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreTextBuilder(name3, "longtext", config);
}
var _a325, _b250, SingleStoreTextBuilder, _a326, _b251, SingleStoreText;
var init_text3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/text.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreTextBuilder = class extends (_b250 = SingleStoreColumnBuilder, _a325 = entityKind, _b250) {
      constructor(name3, textType, config) {
        super(name3, "string", "SingleStoreText");
        this.config.textType = textType;
        this.config.enumValues = config.enum;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreText(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreTextBuilder, _a325, "SingleStoreTextBuilder");
    SingleStoreText = class extends (_b251 = SingleStoreColumn, _a326 = entityKind, _b251) {
      constructor() {
        super(...arguments);
        __publicField(this, "textType", this.config.textType);
        __publicField(this, "enumValues", this.config.enumValues);
      }
      getSQLType() {
        return this.textType;
      }
    };
    __publicField(SingleStoreText, _a326, "SingleStoreText");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/time.js
function time3(name3) {
  return new SingleStoreTimeBuilder(name3 ?? "");
}
var _a327, _b252, SingleStoreTimeBuilder, _a328, _b253, SingleStoreTime;
var init_time3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/time.js"() {
    "use strict";
    init_entity();
    init_common3();
    SingleStoreTimeBuilder = class extends (_b252 = SingleStoreColumnBuilder, _a327 = entityKind, _b252) {
      constructor(name3) {
        super(name3, "string", "SingleStoreTime");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreTime(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreTimeBuilder, _a327, "SingleStoreTimeBuilder");
    SingleStoreTime = class extends (_b253 = SingleStoreColumn, _a328 = entityKind, _b253) {
      getSQLType() {
        return `time`;
      }
    };
    __publicField(SingleStoreTime, _a328, "SingleStoreTime");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/date.common.js
var _a329, _b254, SingleStoreDateColumnBaseBuilder, _a330, _b255, SingleStoreDateBaseColumn;
var init_date_common3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/date.common.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_common3();
    SingleStoreDateColumnBaseBuilder = class extends (_b254 = SingleStoreColumnBuilder, _a329 = entityKind, _b254) {
      defaultNow() {
        return this.default(sql`now()`);
      }
      onUpdateNow() {
        this.config.hasOnUpdateNow = true;
        this.config.hasDefault = true;
        return this;
      }
    };
    __publicField(SingleStoreDateColumnBaseBuilder, _a329, "SingleStoreDateColumnBuilder");
    SingleStoreDateBaseColumn = class extends (_b255 = SingleStoreColumn, _a330 = entityKind, _b255) {
      constructor() {
        super(...arguments);
        __publicField(this, "hasOnUpdateNow", this.config.hasOnUpdateNow);
      }
    };
    __publicField(SingleStoreDateBaseColumn, _a330, "SingleStoreDateColumn");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/timestamp.js
function timestamp3(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "string") {
    return new SingleStoreTimestampStringBuilder(name3);
  }
  return new SingleStoreTimestampBuilder(name3);
}
var _a331, _b256, SingleStoreTimestampBuilder, _a332, _b257, SingleStoreTimestamp, _a333, _b258, SingleStoreTimestampStringBuilder, _a334, _b259, SingleStoreTimestampString;
var init_timestamp3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/timestamp.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_utils();
    init_date_common3();
    SingleStoreTimestampBuilder = class extends (_b256 = SingleStoreDateColumnBaseBuilder, _a331 = entityKind, _b256) {
      constructor(name3) {
        super(name3, "date", "SingleStoreTimestamp");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreTimestamp(
          table6,
          this.config
        );
      }
      defaultNow() {
        return this.default(sql`CURRENT_TIMESTAMP`);
      }
    };
    __publicField(SingleStoreTimestampBuilder, _a331, "SingleStoreTimestampBuilder");
    SingleStoreTimestamp = class extends (_b257 = SingleStoreDateBaseColumn, _a332 = entityKind, _b257) {
      getSQLType() {
        return `timestamp`;
      }
      mapFromDriverValue(value) {
        return /* @__PURE__ */ new Date(value + "+0000");
      }
      mapToDriverValue(value) {
        return value.toISOString().slice(0, -1).replace("T", " ");
      }
    };
    __publicField(SingleStoreTimestamp, _a332, "SingleStoreTimestamp");
    SingleStoreTimestampStringBuilder = class extends (_b258 = SingleStoreDateColumnBaseBuilder, _a333 = entityKind, _b258) {
      constructor(name3) {
        super(name3, "string", "SingleStoreTimestampString");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreTimestampString(
          table6,
          this.config
        );
      }
      defaultNow() {
        return this.default(sql`CURRENT_TIMESTAMP`);
      }
    };
    __publicField(SingleStoreTimestampStringBuilder, _a333, "SingleStoreTimestampStringBuilder");
    SingleStoreTimestampString = class extends (_b259 = SingleStoreDateBaseColumn, _a334 = entityKind, _b259) {
      getSQLType() {
        return `timestamp`;
      }
    };
    __publicField(SingleStoreTimestampString, _a334, "SingleStoreTimestampString");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/tinyint.js
function tinyint2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreTinyIntBuilder(name3, config);
}
var _a335, _b260, SingleStoreTinyIntBuilder, _a336, _b261, SingleStoreTinyInt;
var init_tinyint2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/tinyint.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreTinyIntBuilder = class extends (_b260 = SingleStoreColumnBuilderWithAutoIncrement, _a335 = entityKind, _b260) {
      constructor(name3, config) {
        super(name3, "number", "SingleStoreTinyInt");
        this.config.unsigned = config ? config.unsigned : false;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreTinyInt(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreTinyIntBuilder, _a335, "SingleStoreTinyIntBuilder");
    SingleStoreTinyInt = class extends (_b261 = SingleStoreColumnWithAutoIncrement, _a336 = entityKind, _b261) {
      getSQLType() {
        return `tinyint${this.config.unsigned ? " unsigned" : ""}`;
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") {
          return Number(value);
        }
        return value;
      }
    };
    __publicField(SingleStoreTinyInt, _a336, "SingleStoreTinyInt");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/varbinary.js
function varbinary2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreVarBinaryBuilder(name3, config);
}
var _a337, _b262, SingleStoreVarBinaryBuilder, _a338, _b263, SingleStoreVarBinary;
var init_varbinary2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/varbinary.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreVarBinaryBuilder = class extends (_b262 = SingleStoreColumnBuilder, _a337 = entityKind, _b262) {
      /** @internal */
      constructor(name3, config) {
        super(name3, "string", "SingleStoreVarBinary");
        this.config.length = config?.length;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreVarBinary(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreVarBinaryBuilder, _a337, "SingleStoreVarBinaryBuilder");
    SingleStoreVarBinary = class extends (_b263 = SingleStoreColumn, _a338 = entityKind, _b263) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
      }
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        if (Buffer.isBuffer(value)) return value.toString();
        const str = [];
        for (const v11 of value) {
          str.push(v11 === 49 ? "1" : "0");
        }
        return str.join("");
      }
      getSQLType() {
        return this.length === void 0 ? `varbinary` : `varbinary(${this.length})`;
      }
    };
    __publicField(SingleStoreVarBinary, _a338, "SingleStoreVarBinary");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/varchar.js
function varchar3(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreVarCharBuilder(name3, config);
}
var _a339, _b264, SingleStoreVarCharBuilder, _a340, _b265, SingleStoreVarChar;
var init_varchar3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/varchar.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreVarCharBuilder = class extends (_b264 = SingleStoreColumnBuilder, _a339 = entityKind, _b264) {
      /** @internal */
      constructor(name3, config) {
        super(name3, "string", "SingleStoreVarChar");
        this.config.length = config.length;
        this.config.enum = config.enum;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreVarChar(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreVarCharBuilder, _a339, "SingleStoreVarCharBuilder");
    SingleStoreVarChar = class extends (_b265 = SingleStoreColumn, _a340 = entityKind, _b265) {
      constructor() {
        super(...arguments);
        __publicField(this, "length", this.config.length);
        __publicField(this, "enumValues", this.config.enum);
      }
      getSQLType() {
        return this.length === void 0 ? `varchar` : `varchar(${this.length})`;
      }
    };
    __publicField(SingleStoreVarChar, _a340, "SingleStoreVarChar");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/vector.js
function vector2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  return new SingleStoreVectorBuilder(name3, config);
}
var _a341, _b266, SingleStoreVectorBuilder, _a342, _b267, SingleStoreVector;
var init_vector3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/vector.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common3();
    SingleStoreVectorBuilder = class extends (_b266 = SingleStoreColumnBuilder, _a341 = entityKind, _b266) {
      constructor(name3, config) {
        super(name3, "array", "SingleStoreVector");
        this.config.dimensions = config.dimensions;
        this.config.elementType = config.elementType;
      }
      /** @internal */
      build(table6) {
        return new SingleStoreVector(
          table6,
          this.config
        );
      }
      /** @internal */
      generatedAlwaysAs(as, config) {
        throw new Error("not implemented");
      }
    };
    __publicField(SingleStoreVectorBuilder, _a341, "SingleStoreVectorBuilder");
    SingleStoreVector = class extends (_b267 = SingleStoreColumn, _a342 = entityKind, _b267) {
      constructor() {
        super(...arguments);
        __publicField(this, "dimensions", this.config.dimensions);
        __publicField(this, "elementType", this.config.elementType);
      }
      getSQLType() {
        return `vector(${this.dimensions}, ${this.elementType || "F32"})`;
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
      mapFromDriverValue(value) {
        return JSON.parse(value);
      }
    };
    __publicField(SingleStoreVector, _a342, "SingleStoreVector");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/year.js
function year2(name3) {
  return new SingleStoreYearBuilder(name3 ?? "");
}
var _a343, _b268, SingleStoreYearBuilder, _a344, _b269, SingleStoreYear;
var init_year2 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/year.js"() {
    "use strict";
    init_entity();
    init_common3();
    SingleStoreYearBuilder = class extends (_b268 = SingleStoreColumnBuilder, _a343 = entityKind, _b268) {
      constructor(name3) {
        super(name3, "number", "SingleStoreYear");
      }
      /** @internal */
      build(table6) {
        return new SingleStoreYear(
          table6,
          this.config
        );
      }
    };
    __publicField(SingleStoreYearBuilder, _a343, "SingleStoreYearBuilder");
    SingleStoreYear = class extends (_b269 = SingleStoreColumn, _a344 = entityKind, _b269) {
      getSQLType() {
        return `year`;
      }
    };
    __publicField(SingleStoreYear, _a344, "SingleStoreYear");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/index.js
var init_columns3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/index.js"() {
    "use strict";
    init_bigint3();
    init_binary2();
    init_boolean3();
    init_char3();
    init_common3();
    init_custom3();
    init_date3();
    init_datetime2();
    init_decimal2();
    init_double2();
    init_enum3();
    init_float2();
    init_int2();
    init_json3();
    init_mediumint2();
    init_real3();
    init_serial3();
    init_smallint3();
    init_text3();
    init_time3();
    init_timestamp3();
    init_tinyint2();
    init_varbinary2();
    init_varchar3();
    init_vector3();
    init_year2();
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/count.js
var _a345, _b270, _c10, _SingleStoreCountBuilder, SingleStoreCountBuilder;
var init_count3 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/count.js"() {
    "use strict";
    init_entity();
    init_sql();
    _SingleStoreCountBuilder = class _SingleStoreCountBuilder extends (_c10 = SQL, _b270 = entityKind, _a345 = Symbol.toStringTag, _c10) {
      constructor(params) {
        super(_SingleStoreCountBuilder.buildEmbeddedCount(params.source, params.filters).queryChunks);
        __publicField(this, "sql");
        __publicField(this, _a345, "SingleStoreCountBuilder");
        __publicField(this, "session");
        this.params = params;
        this.mapWith(Number);
        this.session = params.session;
        this.sql = _SingleStoreCountBuilder.buildCount(
          params.source,
          params.filters
        );
      }
      static buildEmbeddedCount(source, filters) {
        return sql`(select count(*) from ${source}${sql.raw(" where ").if(filters)}${filters})`;
      }
      static buildCount(source, filters) {
        return sql`select count(*) as count from ${source}${sql.raw(" where ").if(filters)}${filters}`;
      }
      then(onfulfilled, onrejected) {
        return Promise.resolve(this.session.count(this.sql)).then(
          onfulfilled,
          onrejected
        );
      }
      catch(onRejected) {
        return this.then(void 0, onRejected);
      }
      finally(onFinally) {
        return this.then(
          (value) => {
            onFinally?.();
            return value;
          },
          (reason) => {
            onFinally?.();
            throw reason;
          }
        );
      }
    };
    __publicField(_SingleStoreCountBuilder, _b270, "SingleStoreCountBuilder");
    SingleStoreCountBuilder = _SingleStoreCountBuilder;
  }
});

// ../drizzle-orm/dist/singlestore-core/indexes.js
var _a346, IndexBuilderOn3, _a347, IndexBuilder3, _a348, Index3;
var init_indexes3 = __esm({
  "../drizzle-orm/dist/singlestore-core/indexes.js"() {
    "use strict";
    init_entity();
    _a346 = entityKind;
    IndexBuilderOn3 = class {
      constructor(name3, unique2) {
        this.name = name3;
        this.unique = unique2;
      }
      on(...columns) {
        return new IndexBuilder3(this.name, columns, this.unique);
      }
    };
    __publicField(IndexBuilderOn3, _a346, "SingleStoreIndexBuilderOn");
    _a347 = entityKind;
    IndexBuilder3 = class {
      constructor(name3, columns, unique2) {
        /** @internal */
        __publicField(this, "config");
        this.config = {
          name: name3,
          columns,
          unique: unique2
        };
      }
      using(using) {
        this.config.using = using;
        return this;
      }
      algorythm(algorythm) {
        this.config.algorythm = algorythm;
        return this;
      }
      lock(lock) {
        this.config.lock = lock;
        return this;
      }
      /** @internal */
      build(table6) {
        return new Index3(this.config, table6);
      }
    };
    __publicField(IndexBuilder3, _a347, "SingleStoreIndexBuilder");
    _a348 = entityKind;
    Index3 = class {
      constructor(config, table6) {
        __publicField(this, "config");
        this.config = { ...config, table: table6 };
      }
    };
    __publicField(Index3, _a348, "SingleStoreIndex");
  }
});

// ../drizzle-orm/dist/singlestore-core/columns/all.js
function getSingleStoreColumnBuilders() {
  return {
    bigint: bigint3,
    binary: binary3,
    boolean: boolean3,
    char: char3,
    customType: customType3,
    date: date3,
    datetime: datetime2,
    decimal: decimal3,
    double: double2,
    singlestoreEnum,
    float: float2,
    int: int2,
    json: json3,
    mediumint: mediumint2,
    real: real3,
    serial: serial3,
    smallint: smallint3,
    longtext: longtext2,
    mediumtext: mediumtext2,
    text: text3,
    tinytext: tinytext2,
    time: time3,
    timestamp: timestamp3,
    tinyint: tinyint2,
    varbinary: varbinary2,
    varchar: varchar3,
    vector: vector2,
    year: year2
  };
}
var init_all3 = __esm({
  "../drizzle-orm/dist/singlestore-core/columns/all.js"() {
    "use strict";
    init_bigint3();
    init_binary2();
    init_boolean3();
    init_char3();
    init_custom3();
    init_date3();
    init_datetime2();
    init_decimal2();
    init_double2();
    init_enum3();
    init_float2();
    init_int2();
    init_json3();
    init_mediumint2();
    init_real3();
    init_serial3();
    init_smallint3();
    init_text3();
    init_time3();
    init_timestamp3();
    init_tinyint2();
    init_varbinary2();
    init_varchar3();
    init_vector3();
    init_year2();
  }
});

// ../drizzle-orm/dist/singlestore-core/table.js
function singlestoreTableWithSchema(name3, columns, extraConfig, schema6, baseName = name3) {
  const rawTable = new SingleStoreTable(name3, schema6, baseName);
  const parsedColumns = typeof columns === "function" ? columns(getSingleStoreColumnBuilders()) : columns;
  const builtColumns = Object.fromEntries(
    Object.entries(parsedColumns).map(([name22, colBuilderBase]) => {
      const colBuilder = colBuilderBase;
      colBuilder.setName(name22);
      const column6 = colBuilder.build(rawTable);
      return [name22, column6];
    })
  );
  const table6 = Object.assign(rawTable, builtColumns);
  table6[Table.Symbol.Columns] = builtColumns;
  table6[Table.Symbol.ExtraConfigColumns] = builtColumns;
  if (extraConfig) {
    table6[SingleStoreTable.Symbol.ExtraConfigBuilder] = extraConfig;
  }
  return table6;
}
var _a349, _b271, _c11, _d4, SingleStoreTable;
var init_table4 = __esm({
  "../drizzle-orm/dist/singlestore-core/table.js"() {
    "use strict";
    init_entity();
    init_table();
    init_all3();
    SingleStoreTable = class extends (_d4 = Table, _c11 = entityKind, _b271 = Table.Symbol.Columns, _a349 = Table.Symbol.ExtraConfigBuilder, _d4) {
      constructor() {
        super(...arguments);
        /** @internal */
        __publicField(this, _b271);
        /** @internal */
        __publicField(this, _a349);
      }
    };
    __publicField(SingleStoreTable, _c11, "SingleStoreTable");
    /** @internal */
    __publicField(SingleStoreTable, "Symbol", Object.assign({}, Table.Symbol, {}));
  }
});

// ../drizzle-orm/dist/singlestore-core/primary-keys.js
var _a350, PrimaryKeyBuilder3, _a351, PrimaryKey3;
var init_primary_keys3 = __esm({
  "../drizzle-orm/dist/singlestore-core/primary-keys.js"() {
    "use strict";
    init_entity();
    init_table4();
    _a350 = entityKind;
    PrimaryKeyBuilder3 = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        /** @internal */
        __publicField(this, "name");
        this.columns = columns;
        this.name = name3;
      }
      /** @internal */
      build(table6) {
        return new PrimaryKey3(table6, this.columns, this.name);
      }
    };
    __publicField(PrimaryKeyBuilder3, _a350, "SingleStorePrimaryKeyBuilder");
    _a351 = entityKind;
    PrimaryKey3 = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        this.table = table6;
        this.columns = columns;
        this.name = name3;
      }
      getName() {
        return this.name ?? `${this.table[SingleStoreTable.Symbol.Name]}_${this.columns.map((column6) => column6.name).join("_")}_pk`;
      }
    };
    __publicField(PrimaryKey3, _a351, "SingleStorePrimaryKey");
  }
});

// ../drizzle-orm/dist/singlestore-core/utils.js
function extractUsedTable3(table6) {
  if (is(table6, SingleStoreTable)) {
    return [`${table6[Table.Symbol.BaseName]}`];
  }
  if (is(table6, Subquery)) {
    return table6._.usedTables ?? [];
  }
  if (is(table6, SQL)) {
    return table6.usedTables ?? [];
  }
  return [];
}
function getTableConfig3(table6) {
  const columns = Object.values(table6[SingleStoreTable.Symbol.Columns]);
  const indexes = [];
  const primaryKeys = [];
  const uniqueConstraints = [];
  const name3 = table6[Table.Symbol.Name];
  const schema6 = table6[Table.Symbol.Schema];
  const baseName = table6[Table.Symbol.BaseName];
  const extraConfigBuilder = table6[SingleStoreTable.Symbol.ExtraConfigBuilder];
  if (extraConfigBuilder !== void 0) {
    const extraConfig = extraConfigBuilder(table6[SingleStoreTable.Symbol.Columns]);
    const extraValues = Array.isArray(extraConfig) ? extraConfig.flat(1) : Object.values(extraConfig);
    for (const builder of Object.values(extraValues)) {
      if (is(builder, IndexBuilder3)) {
        indexes.push(builder.build(table6));
      } else if (is(builder, UniqueConstraintBuilder3)) {
        uniqueConstraints.push(builder.build(table6));
      } else if (is(builder, PrimaryKeyBuilder3)) {
        primaryKeys.push(builder.build(table6));
      }
    }
  }
  return {
    columns,
    indexes,
    primaryKeys,
    uniqueConstraints,
    name: name3,
    schema: schema6,
    baseName
  };
}
var init_utils6 = __esm({
  "../drizzle-orm/dist/singlestore-core/utils.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_subquery();
    init_table();
    init_indexes3();
    init_primary_keys3();
    init_table4();
    init_unique_constraint3();
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/delete.js
var _a352, _b272, SingleStoreDeleteBase;
var init_delete3 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/delete.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table();
    init_utils6();
    SingleStoreDeleteBase = class extends (_b272 = QueryPromise, _a352 = entityKind, _b272) {
      constructor(table6, session, dialect6, withList) {
        super();
        __publicField(this, "config");
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, withList };
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will delete only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be deleted.
       *
       * ```ts
       * // Delete all cars with green color
       * db.delete(cars).where(eq(cars.color, 'green'));
       * // or
       * db.delete(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Delete all BMW cars with a green color
       * db.delete(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Delete all cars with the green or blue color
       * db.delete(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.table[Table.Symbol.Columns],
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          this.config.orderBy = orderByArray;
        } else {
          const orderByArray = columns;
          this.config.orderBy = orderByArray;
        }
        return this;
      }
      limit(limit) {
        this.config.limit = limit;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildDeleteQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      prepare() {
        return this.session.prepareQuery(
          this.dialect.sqlToQuery(this.getSQL()),
          this.config.returning,
          void 0,
          void 0,
          void 0,
          {
            type: "delete",
            tables: extractUsedTable3(this.config.table)
          }
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SingleStoreDeleteBase, _a352, "SingleStoreDelete");
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/insert.js
var _a353, SingleStoreInsertBuilder, _a354, _b273, SingleStoreInsertBase;
var init_insert3 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/insert.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_sql();
    init_table();
    init_utils();
    init_utils6();
    _a353 = entityKind;
    SingleStoreInsertBuilder = class {
      constructor(table6, session, dialect6) {
        __publicField(this, "shouldIgnore", false);
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
      }
      ignore() {
        this.shouldIgnore = true;
        return this;
      }
      values(values2) {
        values2 = Array.isArray(values2) ? values2 : [values2];
        if (values2.length === 0) {
          throw new Error("values() must be called with at least one value");
        }
        const mappedValues = values2.map((entry) => {
          const result = {};
          const cols = this.table[Table.Symbol.Columns];
          for (const colKey of Object.keys(entry)) {
            const colValue = entry[colKey];
            result[colKey] = is(colValue, SQL) ? colValue : new Param(colValue, cols[colKey]);
          }
          return result;
        });
        return new SingleStoreInsertBase(this.table, mappedValues, this.shouldIgnore, this.session, this.dialect);
      }
    };
    __publicField(SingleStoreInsertBuilder, _a353, "SingleStoreInsertBuilder");
    SingleStoreInsertBase = class extends (_b273 = QueryPromise, _a354 = entityKind, _b273) {
      constructor(table6, values2, ignore, session, dialect6) {
        super();
        __publicField(this, "config");
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, values: values2, ignore };
      }
      /**
       * Adds an `on duplicate key update` clause to the query.
       *
       * Calling this method will update update the row if any unique index conflicts. MySQL will automatically determine the conflict target based on the primary key and unique indexes.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert#on-duplicate-key-update}
       *
       * @param config The `set` clause
       *
       * @example
       * ```ts
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW'})
       *   .onDuplicateKeyUpdate({ set: { brand: 'Porsche' }});
       * ```
       *
       * While MySQL does not directly support doing nothing on conflict, you can perform a no-op by setting any column's value to itself and achieve the same effect:
       *
       * ```ts
       * import { sql } from 'drizzle-orm';
       *
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onDuplicateKeyUpdate({ set: { id: sql`id` } });
       * ```
       */
      onDuplicateKeyUpdate(config) {
        const setSql = this.dialect.buildUpdateSet(this.config.table, mapUpdateSet(this.config.table, config.set));
        this.config.onConflict = sql`update ${setSql}`;
        return this;
      }
      $returningId() {
        const returning = [];
        for (const [key, value] of Object.entries(this.config.table[Table.Symbol.Columns])) {
          if (value.primary) {
            returning.push({ field: value, path: [key] });
          }
        }
        this.config.returning = orderSelectedFields(this.config.table[Table.Symbol.Columns]);
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildInsertQuery(this.config).sql;
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      prepare() {
        const { sql: sql22, generatedIds } = this.dialect.buildInsertQuery(this.config);
        return this.session.prepareQuery(
          this.dialect.sqlToQuery(sql22),
          void 0,
          void 0,
          generatedIds,
          this.config.returning,
          {
            type: "delete",
            tables: extractUsedTable3(this.config.table)
          }
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SingleStoreInsertBase, _a354, "SingleStoreInsert");
  }
});

// ../drizzle-orm/dist/singlestore-core/dialect.js
var _a355, SingleStoreDialect;
var init_dialect3 = __esm({
  "../drizzle-orm/dist/singlestore-core/dialect.js"() {
    "use strict";
    init_alias();
    init_casing();
    init_column();
    init_entity();
    init_errors();
    init_relations();
    init_expressions();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_common3();
    init_table4();
    _a355 = entityKind;
    SingleStoreDialect = class {
      constructor(config) {
        /** @internal */
        __publicField(this, "casing");
        this.casing = new CasingCache(config?.casing);
      }
      async migrate(migrations, session, config) {
        const migrationsTable = config.migrationsTable ?? "__drizzle_migrations";
        const migrationTableCreate = sql`
			create table if not exists ${sql.identifier(migrationsTable)} (
				id serial primary key,
				hash text not null,
				created_at bigint
			)
		`;
        await session.execute(migrationTableCreate);
        const dbMigrations = await session.all(
          sql`select id, hash, created_at from ${sql.identifier(migrationsTable)} order by created_at desc limit 1`
        );
        const lastDbMigration = dbMigrations[0];
        await session.transaction(async (tx) => {
          for (const migration of migrations) {
            if (!lastDbMigration || Number(lastDbMigration.created_at) < migration.folderMillis) {
              for (const stmt of migration.sql) {
                await tx.execute(sql.raw(stmt));
              }
              await tx.execute(
                sql`insert into ${sql.identifier(migrationsTable)} (\`hash\`, \`created_at\`) values(${migration.hash}, ${migration.folderMillis})`
              );
            }
          }
        });
      }
      escapeName(name3) {
        return `\`${name3}\``;
      }
      escapeParam(_num) {
        return `?`;
      }
      escapeString(str) {
        return `'${str.replace(/'/g, "''")}'`;
      }
      buildWithCTE(queries) {
        if (!queries?.length) return void 0;
        const withSqlChunks = [sql`with `];
        for (const [i8, w10] of queries.entries()) {
          withSqlChunks.push(sql`${sql.identifier(w10._.alias)} as (${w10._.sql})`);
          if (i8 < queries.length - 1) {
            withSqlChunks.push(sql`, `);
          }
        }
        withSqlChunks.push(sql` `);
        return sql.join(withSqlChunks);
      }
      buildDeleteQuery({ table: table6, where, returning, withList, limit, orderBy }) {
        const withSql = this.buildWithCTE(withList);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        return sql`${withSql}delete from ${table6}${whereSql}${orderBySql}${limitSql}${returningSql}`;
      }
      buildUpdateSet(table6, set) {
        const tableColumns = table6[Table.Symbol.Columns];
        const columnNames = Object.keys(tableColumns).filter(
          (colName) => set[colName] !== void 0 || tableColumns[colName]?.onUpdateFn !== void 0
        );
        const setSize = columnNames.length;
        return sql.join(columnNames.flatMap((colName, i8) => {
          const col = tableColumns[colName];
          const value = set[colName] ?? sql.param(col.onUpdateFn(), col);
          const res = sql`${sql.identifier(this.casing.getColumnCasing(col))} = ${value}`;
          if (i8 < setSize - 1) {
            return [res, sql.raw(", ")];
          }
          return [res];
        }));
      }
      buildUpdateQuery({ table: table6, set, where, returning, withList, limit, orderBy }) {
        const withSql = this.buildWithCTE(withList);
        const setSql = this.buildUpdateSet(table6, set);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        return sql`${withSql}update ${table6} set ${setSql}${whereSql}${orderBySql}${limitSql}${returningSql}`;
      }
      /**
       * Builds selection SQL with provided fields/expressions
       *
       * Examples:
       *
       * `select <selection> from`
       *
       * `insert ... returning <selection>`
       *
       * If `isSingleTable` is true, then columns won't be prefixed with table name
       */
      buildSelection(fields, { isSingleTable = false } = {}) {
        const columnsLen = fields.length;
        const chunks = fields.flatMap(({ field }, i8) => {
          const chunk = [];
          if (is(field, SQL.Aliased) && field.isSelectionField) {
            chunk.push(sql.identifier(field.fieldAlias));
          } else if (is(field, SQL.Aliased) || is(field, SQL)) {
            const query = is(field, SQL.Aliased) ? field.sql : field;
            if (isSingleTable) {
              chunk.push(
                new SQL(
                  query.queryChunks.map((c6) => {
                    if (is(c6, SingleStoreColumn)) {
                      return sql.identifier(this.casing.getColumnCasing(c6));
                    }
                    return c6;
                  })
                )
              );
            } else {
              chunk.push(query);
            }
            if (is(field, SQL.Aliased)) {
              chunk.push(sql` as ${sql.identifier(field.fieldAlias)}`);
            }
          } else if (is(field, Column)) {
            if (isSingleTable) {
              chunk.push(sql.identifier(this.casing.getColumnCasing(field)));
            } else {
              chunk.push(field);
            }
          }
          if (i8 < columnsLen - 1) {
            chunk.push(sql`, `);
          }
          return chunk;
        });
        return sql.join(chunks);
      }
      buildLimit(limit) {
        return typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
      }
      buildOrderBy(orderBy) {
        return orderBy && orderBy.length > 0 ? sql` order by ${sql.join(orderBy, sql`, `)}` : void 0;
      }
      buildSelectQuery({
        withList,
        fields,
        fieldsFlat,
        where,
        having,
        table: table6,
        joins,
        orderBy,
        groupBy,
        limit,
        offset,
        lockingClause,
        distinct,
        setOperators
      }) {
        const fieldsList = fieldsFlat ?? orderSelectedFields(fields);
        for (const f9 of fieldsList) {
          if (is(f9.field, Column) && getTableName(f9.field.table) !== (is(table6, Subquery) ? table6._.alias : is(table6, SQL) ? void 0 : getTableName(table6)) && !((table22) => joins?.some(
            ({ alias: alias2 }) => alias2 === (table22[Table.Symbol.IsAlias] ? getTableName(table22) : table22[Table.Symbol.BaseName])
          ))(f9.field.table)) {
            const tableName = getTableName(f9.field.table);
            throw new Error(
              `Your "${f9.path.join("->")}" field references a column "${tableName}"."${f9.field.name}", but the table "${tableName}" is not part of the query! Did you forget to join it?`
            );
          }
        }
        const isSingleTable = !joins || joins.length === 0;
        const withSql = this.buildWithCTE(withList);
        const distinctSql = distinct ? sql` distinct` : void 0;
        const selection = this.buildSelection(fieldsList, { isSingleTable });
        const tableSql = (() => {
          if (is(table6, Table) && table6[Table.Symbol.IsAlias]) {
            return sql`${sql`${sql.identifier(table6[Table.Symbol.Schema] ?? "")}.`.if(table6[Table.Symbol.Schema])}${sql.identifier(table6[Table.Symbol.OriginalName])} ${sql.identifier(table6[Table.Symbol.Name])}`;
          }
          return table6;
        })();
        const joinsArray = [];
        if (joins) {
          for (const [index7, joinMeta] of joins.entries()) {
            if (index7 === 0) {
              joinsArray.push(sql` `);
            }
            const table22 = joinMeta.table;
            const lateralSql = joinMeta.lateral ? sql` lateral` : void 0;
            const onSql = joinMeta.on ? sql` on ${joinMeta.on}` : void 0;
            if (is(table22, SingleStoreTable)) {
              const tableName = table22[SingleStoreTable.Symbol.Name];
              const tableSchema = table22[SingleStoreTable.Symbol.Schema];
              const origTableName = table22[SingleStoreTable.Symbol.OriginalName];
              const alias2 = tableName === origTableName ? void 0 : joinMeta.alias;
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${tableSchema ? sql`${sql.identifier(tableSchema)}.` : void 0}${sql.identifier(origTableName)}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
              );
            } else if (is(table22, View)) {
              const viewName = table22[ViewBaseConfig].name;
              const viewSchema = table22[ViewBaseConfig].schema;
              const origViewName = table22[ViewBaseConfig].originalName;
              const alias2 = viewName === origViewName ? void 0 : joinMeta.alias;
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${viewSchema ? sql`${sql.identifier(viewSchema)}.` : void 0}${sql.identifier(origViewName)}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
              );
            } else {
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join${lateralSql} ${table22}${onSql}`
              );
            }
            if (index7 < joins.length - 1) {
              joinsArray.push(sql` `);
            }
          }
        }
        const joinsSql = sql.join(joinsArray);
        const whereSql = where ? sql` where ${where}` : void 0;
        const havingSql = having ? sql` having ${having}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const groupBySql = groupBy && groupBy.length > 0 ? sql` group by ${sql.join(groupBy, sql`, `)}` : void 0;
        const limitSql = this.buildLimit(limit);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        let lockingClausesSql;
        if (lockingClause) {
          const { config, strength } = lockingClause;
          lockingClausesSql = sql` for ${sql.raw(strength)}`;
          if (config.noWait) {
            lockingClausesSql.append(sql` nowait`);
          } else if (config.skipLocked) {
            lockingClausesSql.append(sql` skip locked`);
          }
        }
        const finalQuery = sql`${withSql}select${distinctSql} ${selection} from ${tableSql}${joinsSql}${whereSql}${groupBySql}${havingSql}${orderBySql}${limitSql}${offsetSql}${lockingClausesSql}`;
        if (setOperators.length > 0) {
          return this.buildSetOperations(finalQuery, setOperators);
        }
        return finalQuery;
      }
      buildSetOperations(leftSelect, setOperators) {
        const [setOperator, ...rest] = setOperators;
        if (!setOperator) {
          throw new Error("Cannot pass undefined values to any set operator");
        }
        if (rest.length === 0) {
          return this.buildSetOperationQuery({ leftSelect, setOperator });
        }
        return this.buildSetOperations(
          this.buildSetOperationQuery({ leftSelect, setOperator }),
          rest
        );
      }
      buildSetOperationQuery({
        leftSelect,
        setOperator: { type, isAll, rightSelect, limit, orderBy, offset }
      }) {
        const leftChunk = sql`(${leftSelect.getSQL()}) `;
        const rightChunk = sql`(${rightSelect.getSQL()})`;
        let orderBySql;
        if (orderBy && orderBy.length > 0) {
          const orderByValues = [];
          for (const orderByUnit of orderBy) {
            if (is(orderByUnit, SingleStoreColumn)) {
              orderByValues.push(sql.identifier(this.casing.getColumnCasing(orderByUnit)));
            } else if (is(orderByUnit, SQL)) {
              for (let i8 = 0; i8 < orderByUnit.queryChunks.length; i8++) {
                const chunk = orderByUnit.queryChunks[i8];
                if (is(chunk, SingleStoreColumn)) {
                  orderByUnit.queryChunks[i8] = sql.identifier(this.casing.getColumnCasing(chunk));
                }
              }
              orderByValues.push(sql`${orderByUnit}`);
            } else {
              orderByValues.push(sql`${orderByUnit}`);
            }
          }
          orderBySql = sql` order by ${sql.join(orderByValues, sql`, `)} `;
        }
        const limitSql = typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
        const operatorChunk = sql.raw(`${type} ${isAll ? "all " : ""}`);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        return sql`${leftChunk}${operatorChunk}${rightChunk}${orderBySql}${limitSql}${offsetSql}`;
      }
      buildInsertQuery({ table: table6, values: values2, ignore, onConflict }) {
        const valuesSqlList = [];
        const columns = table6[Table.Symbol.Columns];
        const colEntries = Object.entries(columns).filter(
          ([_7, col]) => !col.shouldDisableInsert()
        );
        const insertOrder = colEntries.map(([, column6]) => sql.identifier(this.casing.getColumnCasing(column6)));
        const generatedIdsResponse = [];
        for (const [valueIndex, value] of values2.entries()) {
          const generatedIds = {};
          const valueList = [];
          for (const [fieldName, col] of colEntries) {
            const colValue = value[fieldName];
            if (colValue === void 0 || is(colValue, Param) && colValue.value === void 0) {
              if (col.defaultFn !== void 0) {
                const defaultFnResult = col.defaultFn();
                generatedIds[fieldName] = defaultFnResult;
                const defaultValue = is(defaultFnResult, SQL) ? defaultFnResult : sql.param(defaultFnResult, col);
                valueList.push(defaultValue);
              } else if (!col.default && col.onUpdateFn !== void 0) {
                const onUpdateFnResult = col.onUpdateFn();
                const newValue = is(onUpdateFnResult, SQL) ? onUpdateFnResult : sql.param(onUpdateFnResult, col);
                valueList.push(newValue);
              } else {
                valueList.push(sql`default`);
              }
            } else {
              if (col.defaultFn && is(colValue, Param)) {
                generatedIds[fieldName] = colValue.value;
              }
              valueList.push(colValue);
            }
          }
          generatedIdsResponse.push(generatedIds);
          valuesSqlList.push(valueList);
          if (valueIndex < values2.length - 1) {
            valuesSqlList.push(sql`, `);
          }
        }
        const valuesSql = sql.join(valuesSqlList);
        const ignoreSql = ignore ? sql` ignore` : void 0;
        const onConflictSql = onConflict ? sql` on duplicate key ${onConflict}` : void 0;
        return {
          sql: sql`insert${ignoreSql} into ${table6} ${insertOrder} values ${valuesSql}${onConflictSql}`,
          generatedIds: generatedIdsResponse
        };
      }
      sqlToQuery(sql22, invokeSource) {
        return sql22.toQuery({
          casing: this.casing,
          escapeName: this.escapeName,
          escapeParam: this.escapeParam,
          escapeString: this.escapeString,
          invokeSource
        });
      }
      buildRelationalQuery({
        fullSchema,
        schema: schema6,
        tableNamesMap,
        table: table6,
        tableConfig,
        queryConfig: config,
        tableAlias,
        nestedQueryRelation,
        joinOn
      }) {
        let selection = [];
        let limit, offset, orderBy, where;
        const joins = [];
        if (config === true) {
          const selectionEntries = Object.entries(tableConfig.columns);
          selection = selectionEntries.map(([key, value]) => ({
            dbKey: value.name,
            tsKey: key,
            field: aliasedTableColumn(value, tableAlias),
            relationTableTsKey: void 0,
            isJson: false,
            selection: []
          }));
        } else {
          const aliasedColumns = Object.fromEntries(
            Object.entries(tableConfig.columns).map(([key, value]) => [key, aliasedTableColumn(value, tableAlias)])
          );
          if (config.where) {
            const whereSql = typeof config.where === "function" ? config.where(aliasedColumns, getOperators()) : config.where;
            where = whereSql && mapColumnsInSQLToAlias(whereSql, tableAlias);
          }
          const fieldsSelection = [];
          let selectedColumns = [];
          if (config.columns) {
            let isIncludeMode = false;
            for (const [field, value] of Object.entries(config.columns)) {
              if (value === void 0) {
                continue;
              }
              if (field in tableConfig.columns) {
                if (!isIncludeMode && value === true) {
                  isIncludeMode = true;
                }
                selectedColumns.push(field);
              }
            }
            if (selectedColumns.length > 0) {
              selectedColumns = isIncludeMode ? selectedColumns.filter((c6) => config.columns?.[c6] === true) : Object.keys(tableConfig.columns).filter((key) => !selectedColumns.includes(key));
            }
          } else {
            selectedColumns = Object.keys(tableConfig.columns);
          }
          for (const field of selectedColumns) {
            const column6 = tableConfig.columns[field];
            fieldsSelection.push({ tsKey: field, value: column6 });
          }
          let selectedRelations = [];
          if (config.with) {
            selectedRelations = Object.entries(config.with).filter((entry) => !!entry[1]).map(([tsKey, queryConfig]) => ({ tsKey, queryConfig, relation: tableConfig.relations[tsKey] }));
          }
          let extras;
          if (config.extras) {
            extras = typeof config.extras === "function" ? config.extras(aliasedColumns, { sql }) : config.extras;
            for (const [tsKey, value] of Object.entries(extras)) {
              fieldsSelection.push({
                tsKey,
                value: mapColumnsInAliasedSQLToAlias(value, tableAlias)
              });
            }
          }
          for (const { tsKey, value } of fieldsSelection) {
            selection.push({
              dbKey: is(value, SQL.Aliased) ? value.fieldAlias : tableConfig.columns[tsKey].name,
              tsKey,
              field: is(value, Column) ? aliasedTableColumn(value, tableAlias) : value,
              relationTableTsKey: void 0,
              isJson: false,
              selection: []
            });
          }
          let orderByOrig = typeof config.orderBy === "function" ? config.orderBy(aliasedColumns, getOrderByOperators()) : config.orderBy ?? [];
          if (!Array.isArray(orderByOrig)) {
            orderByOrig = [orderByOrig];
          }
          orderBy = orderByOrig.map((orderByValue) => {
            if (is(orderByValue, Column)) {
              return aliasedTableColumn(orderByValue, tableAlias);
            }
            return mapColumnsInSQLToAlias(orderByValue, tableAlias);
          });
          limit = config.limit;
          offset = config.offset;
          for (const {
            tsKey: selectedRelationTsKey,
            queryConfig: selectedRelationConfigValue,
            relation
          } of selectedRelations) {
            const normalizedRelation = normalizeRelation(schema6, tableNamesMap, relation);
            const relationTableName = getTableUniqueName(relation.referencedTable);
            const relationTableTsName = tableNamesMap[relationTableName];
            const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
            const joinOn2 = and(
              ...normalizedRelation.fields.map(
                (field2, i8) => eq(
                  aliasedTableColumn(normalizedRelation.references[i8], relationTableAlias),
                  aliasedTableColumn(field2, tableAlias)
                )
              )
            );
            const builtRelation = this.buildRelationalQuery({
              fullSchema,
              schema: schema6,
              tableNamesMap,
              table: fullSchema[relationTableTsName],
              tableConfig: schema6[relationTableTsName],
              queryConfig: is(relation, One) ? selectedRelationConfigValue === true ? { limit: 1 } : { ...selectedRelationConfigValue, limit: 1 } : selectedRelationConfigValue,
              tableAlias: relationTableAlias,
              joinOn: joinOn2,
              nestedQueryRelation: relation
            });
            const field = sql`${sql.identifier(relationTableAlias)}.${sql.identifier("data")}`.as(selectedRelationTsKey);
            joins.push({
              on: sql`true`,
              table: new Subquery(builtRelation.sql, {}, relationTableAlias),
              alias: relationTableAlias,
              joinType: "left",
              lateral: true
            });
            selection.push({
              dbKey: selectedRelationTsKey,
              tsKey: selectedRelationTsKey,
              field,
              relationTableTsKey: relationTableTsName,
              isJson: true,
              selection: builtRelation.selection
            });
          }
        }
        if (selection.length === 0) {
          throw new DrizzleError({ message: `No fields selected for table "${tableConfig.tsName}" ("${tableAlias}")` });
        }
        let result;
        where = and(joinOn, where);
        if (nestedQueryRelation) {
          let field = sql`JSON_TO_ARRAY(${sql.join(
            selection.map(
              ({ field: field2, tsKey, isJson: isJson2 }) => isJson2 ? sql`${sql.identifier(`${tableAlias}_${tsKey}`)}.${sql.identifier("data")}` : is(field2, SQL.Aliased) ? field2.sql : field2
            ),
            sql`, `
          )})`;
          if (is(nestedQueryRelation, Many)) {
            field = sql`json_agg(${field})`;
          }
          const nestedSelection = [{
            dbKey: "data",
            tsKey: "data",
            field: field.as("data"),
            isJson: true,
            relationTableTsKey: tableConfig.tsName,
            selection
          }];
          const needsSubquery = limit !== void 0 || offset !== void 0 || (orderBy?.length ?? 0) > 0;
          if (needsSubquery) {
            result = this.buildSelectQuery({
              table: aliasedTable(table6, tableAlias),
              fields: {},
              fieldsFlat: [
                {
                  path: [],
                  field: sql.raw("*")
                },
                ...(orderBy?.length ?? 0) > 0 ? [{
                  path: [],
                  field: sql`row_number() over (order by ${sql.join(orderBy, sql`, `)})`
                }] : []
              ],
              where,
              limit,
              offset,
              setOperators: []
            });
            where = void 0;
            limit = void 0;
            offset = void 0;
            orderBy = void 0;
          } else {
            result = aliasedTable(table6, tableAlias);
          }
          result = this.buildSelectQuery({
            table: is(result, SingleStoreTable) ? result : new Subquery(result, {}, tableAlias),
            fields: {},
            fieldsFlat: nestedSelection.map(({ field: field2 }) => ({
              path: [],
              field: is(field2, Column) ? aliasedTableColumn(field2, tableAlias) : field2
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        } else {
          result = this.buildSelectQuery({
            table: aliasedTable(table6, tableAlias),
            fields: {},
            fieldsFlat: selection.map(({ field }) => ({
              path: [],
              field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        }
        return {
          tableTsKey: tableConfig.tsName,
          sql: result,
          selection
        };
      }
    };
    __publicField(SingleStoreDialect, _a355, "SingleStoreDialect");
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/select.js
function createSetOperator3(type, isAll) {
  return (leftSelect, rightSelect, ...restSelects) => {
    const setOperators = [rightSelect, ...restSelects].map((select2) => ({
      type,
      isAll,
      rightSelect: select2
    }));
    for (const setOperator of setOperators) {
      if (!haveSameKeys(leftSelect.getSelectedFields(), setOperator.rightSelect.getSelectedFields())) {
        throw new Error(
          "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
        );
      }
    }
    return leftSelect.addSetOperators(setOperators);
  };
}
var _a356, SingleStoreSelectBuilder, _a357, _b274, SingleStoreSelectQueryBuilderBase, _a358, _b275, SingleStoreSelectBase, getSingleStoreSetOperators, union3, unionAll3, intersect3, except3, minus;
var init_select4 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/select.js"() {
    "use strict";
    init_entity();
    init_query_builder();
    init_query_promise();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_utils6();
    _a356 = entityKind;
    SingleStoreSelectBuilder = class {
      constructor(config) {
        __publicField(this, "fields");
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "withList", []);
        __publicField(this, "distinct");
        this.fields = config.fields;
        this.session = config.session;
        this.dialect = config.dialect;
        if (config.withList) {
          this.withList = config.withList;
        }
        this.distinct = config.distinct;
      }
      from(source) {
        const isPartialSelect = !!this.fields;
        let fields;
        if (this.fields) {
          fields = this.fields;
        } else if (is(source, Subquery)) {
          fields = Object.fromEntries(
            Object.keys(source._.selectedFields).map((key) => [key, source[key]])
          );
        } else if (is(source, SQL)) {
          fields = {};
        } else {
          fields = getTableColumns(source);
        }
        return new SingleStoreSelectBase(
          {
            table: source,
            fields,
            isPartialSelect,
            session: this.session,
            dialect: this.dialect,
            withList: this.withList,
            distinct: this.distinct
          }
        );
      }
    };
    __publicField(SingleStoreSelectBuilder, _a356, "SingleStoreSelectBuilder");
    SingleStoreSelectQueryBuilderBase = class extends (_b274 = TypedQueryBuilder, _a357 = entityKind, _b274) {
      constructor({ table: table6, fields, isPartialSelect, session, dialect: dialect6, withList, distinct }) {
        super();
        __publicField(this, "_");
        __publicField(this, "config");
        __publicField(this, "joinsNotNullableMap");
        __publicField(this, "tableName");
        __publicField(this, "isPartialSelect");
        /** @internal */
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "cacheConfig");
        __publicField(this, "usedTables", /* @__PURE__ */ new Set());
        /**
         * Executes a `left join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "leftJoin", this.createJoin("left", false));
        /**
         * Executes a `left join lateral` operation by adding subquery to the current query.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join-lateral}
         *
         * @param table the subquery to join.
         * @param on the `on` clause.
         */
        __publicField(this, "leftJoinLateral", this.createJoin("left", true));
        /**
         * Executes a `right join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the joined table with the corresponding row from the main table, if a match is found. If no matching row exists, it sets all columns of the main table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#right-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "rightJoin", this.createJoin("right", false));
        /**
         * Executes an `inner join` operation, creating a new table by combining rows from two tables that have matching values.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "innerJoin", this.createJoin("inner", false));
        /**
         * Executes an `inner join lateral` operation, creating a new table by combining rows from two queries that have matching values.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join-lateral}
         *
         * @param table the subquery to join.
         * @param on the `on` clause.
         */
        __publicField(this, "innerJoinLateral", this.createJoin("inner", true));
        /**
         * Executes a `full join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging rows with matching values and filling in `null` for non-matching columns.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#full-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .fullJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .fullJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "fullJoin", this.createJoin("full", false));
        /**
         * Executes a `cross join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging all rows from each table.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join}
         *
         * @param table the table to join.
         *
         * @example
         *
         * ```ts
         * // Select all users, each user with every pet
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .crossJoin(pets)
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .crossJoin(pets)
         * ```
         */
        __publicField(this, "crossJoin", this.createJoin("cross", false));
        /**
         * Executes a `cross join lateral` operation by combining rows from two queries into a new table.
         *
         * A `lateral` join allows the right-hand expression to refer to columns from the left-hand side.
         *
         * Calling this method retrieves all rows from both main and joined queries, merging all rows from each query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join-lateral}
         *
         * @param table the query to join.
         */
        __publicField(this, "crossJoinLateral", this.createJoin("cross", true));
        /**
         * Adds `union` set operator to the query.
         *
         * Calling this method will combine the result sets of the `select` statements and remove any duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union}
         *
         * @example
         *
         * ```ts
         * // Select all unique names from customers and users tables
         * await db.select({ name: users.name })
         *   .from(users)
         *   .union(
         *     db.select({ name: customers.name }).from(customers)
         *   );
         * // or
         * import { union } from 'drizzle-orm/singlestore-core'
         *
         * await union(
         *   db.select({ name: users.name }).from(users),
         *   db.select({ name: customers.name }).from(customers)
         * );
         * ```
         */
        __publicField(this, "union", this.createSetOperator("union", false));
        /**
         * Adds `union all` set operator to the query.
         *
         * Calling this method will combine the result-set of the `select` statements and keep all duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union-all}
         *
         * @example
         *
         * ```ts
         * // Select all transaction ids from both online and in-store sales
         * await db.select({ transaction: onlineSales.transactionId })
         *   .from(onlineSales)
         *   .unionAll(
         *     db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         *   );
         * // or
         * import { unionAll } from 'drizzle-orm/singlestore-core'
         *
         * await unionAll(
         *   db.select({ transaction: onlineSales.transactionId }).from(onlineSales),
         *   db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         * );
         * ```
         */
        __publicField(this, "unionAll", this.createSetOperator("union", true));
        /**
         * Adds `intersect` set operator to the query.
         *
         * Calling this method will retain only the rows that are present in both result sets and eliminate duplicates.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#intersect}
         *
         * @example
         *
         * ```ts
         * // Select course names that are offered in both departments A and B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .intersect(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { intersect } from 'drizzle-orm/singlestore-core'
         *
         * await intersect(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "intersect", this.createSetOperator("intersect", false));
        /**
         * Adds `except` set operator to the query.
         *
         * Calling this method will retrieve all unique rows from the left query, except for the rows that are present in the result set of the right query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#except}
         *
         * @example
         *
         * ```ts
         * // Select all courses offered in department A but not in department B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .except(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { except } from 'drizzle-orm/singlestore-core'
         *
         * await except(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "except", this.createSetOperator("except", false));
        /**
         * Adds `minus` set operator to the query.
         *
         * This is an alias of `except` supported by SingleStore.
         *
         * @example
         *
         * ```ts
         * // Select all courses offered in department A but not in department B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .minus(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { minus } from 'drizzle-orm/singlestore-core'
         *
         * await minus(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "minus", this.createSetOperator("except", false));
        this.config = {
          withList,
          table: table6,
          fields: { ...fields },
          distinct,
          setOperators: []
        };
        this.isPartialSelect = isPartialSelect;
        this.session = session;
        this.dialect = dialect6;
        this._ = {
          selectedFields: fields,
          config: this.config
        };
        this.tableName = getTableLikeName(table6);
        this.joinsNotNullableMap = typeof this.tableName === "string" ? { [this.tableName]: true } : {};
        for (const item of extractUsedTable3(table6)) this.usedTables.add(item);
      }
      /** @internal */
      getUsedTables() {
        return [...this.usedTables];
      }
      createJoin(joinType, lateral) {
        return (table6, on3) => {
          const baseTableName = this.tableName;
          const tableName = getTableLikeName(table6);
          for (const item of extractUsedTable3(table6)) this.usedTables.add(item);
          if (typeof tableName === "string" && this.config.joins?.some((join7) => join7.alias === tableName)) {
            throw new Error(`Alias "${tableName}" is already used in this query`);
          }
          if (!this.isPartialSelect) {
            if (Object.keys(this.joinsNotNullableMap).length === 1 && typeof baseTableName === "string") {
              this.config.fields = {
                [baseTableName]: this.config.fields
              };
            }
            if (typeof tableName === "string" && !is(table6, SQL)) {
              const selection = is(table6, Subquery) ? table6._.selectedFields : table6[Table.Symbol.Columns];
              this.config.fields[tableName] = selection;
            }
          }
          if (typeof on3 === "function") {
            on3 = on3(
              new Proxy(
                this.config.fields,
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              )
            );
          }
          if (!this.config.joins) {
            this.config.joins = [];
          }
          this.config.joins.push({ on: on3, table: table6, joinType, alias: tableName, lateral });
          if (typeof tableName === "string") {
            switch (joinType) {
              case "left": {
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
              case "right": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "cross":
              case "inner": {
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "full": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
            }
          }
          return this;
        };
      }
      createSetOperator(type, isAll) {
        return (rightSelection) => {
          const rightSelect = typeof rightSelection === "function" ? rightSelection(getSingleStoreSetOperators()) : rightSelection;
          if (!haveSameKeys(this.getSelectedFields(), rightSelect.getSelectedFields())) {
            throw new Error(
              "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
            );
          }
          this.config.setOperators.push({ type, isAll, rightSelect });
          return this;
        };
      }
      /** @internal */
      addSetOperators(setOperators) {
        this.config.setOperators.push(...setOperators);
        return this;
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#filtering}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be selected.
       *
       * ```ts
       * // Select all cars with green color
       * await db.select().from(cars).where(eq(cars.color, 'green'));
       * // or
       * await db.select().from(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Select all BMW cars with a green color
       * await db.select().from(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Select all cars with the green or blue color
       * await db.select().from(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        if (typeof where === "function") {
          where = where(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.where = where;
        return this;
      }
      /**
       * Adds a `having` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition. It is typically used with aggregate functions to filter the aggregated data based on a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#aggregations}
       *
       * @param having the `having` clause.
       *
       * @example
       *
       * ```ts
       * // Select all brands with more than one car
       * await db.select({
       * 	brand: cars.brand,
       * 	count: sql<number>`cast(count(${cars.id}) as int)`,
       * })
       *   .from(cars)
       *   .groupBy(cars.brand)
       *   .having(({ count }) => gt(count, 1));
       * ```
       */
      having(having) {
        if (typeof having === "function") {
          having = having(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.having = having;
        return this;
      }
      groupBy(...columns) {
        if (typeof columns[0] === "function") {
          const groupBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          this.config.groupBy = Array.isArray(groupBy) ? groupBy : [groupBy];
        } else {
          this.config.groupBy = columns;
        }
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        } else {
          const orderByArray = columns;
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        }
        return this;
      }
      /**
       * Adds a `limit` clause to the query.
       *
       * Calling this method will set the maximum number of rows that will be returned by this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param limit the `limit` clause.
       *
       * @example
       *
       * ```ts
       * // Get the first 10 people from this query.
       * await db.select().from(people).limit(10);
       * ```
       */
      limit(limit) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).limit = limit;
        } else {
          this.config.limit = limit;
        }
        return this;
      }
      /**
       * Adds an `offset` clause to the query.
       *
       * Calling this method will skip a number of rows when returning results from this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param offset the `offset` clause.
       *
       * @example
       *
       * ```ts
       * // Get the 10th-20th people from this query.
       * await db.select().from(people).offset(10).limit(10);
       * ```
       */
      offset(offset) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).offset = offset;
        } else {
          this.config.offset = offset;
        }
        return this;
      }
      /**
       * Adds a `for` clause to the query.
       *
       * Calling this method will specify a lock strength for this query that controls how strictly it acquires exclusive access to the rows being queried.
       *
       * @param strength the lock strength.
       * @param config the lock configuration.
       */
      for(strength, config = {}) {
        this.config.lockingClause = { strength, config };
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildSelectQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      as(alias2) {
        const usedTables = [];
        usedTables.push(...extractUsedTable3(this.config.table));
        if (this.config.joins) {
          for (const it2 of this.config.joins) usedTables.push(...extractUsedTable3(it2.table));
        }
        return new Proxy(
          new Subquery(this.getSQL(), this.config.fields, alias2, false, [...new Set(usedTables)]),
          new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      /** @internal */
      getSelectedFields() {
        return new Proxy(
          this.config.fields,
          new SelectionProxyHandler({ alias: this.tableName, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SingleStoreSelectQueryBuilderBase, _a357, "SingleStoreSelectQueryBuilder");
    SingleStoreSelectBase = class extends (_b275 = SingleStoreSelectQueryBuilderBase, _a358 = entityKind, _b275) {
      constructor() {
        super(...arguments);
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
      }
      prepare() {
        if (!this.session) {
          throw new Error("Cannot execute a query on a query builder. Please use a database instance instead.");
        }
        const fieldsList = orderSelectedFields(this.config.fields);
        const query = this.session.prepareQuery(this.dialect.sqlToQuery(this.getSQL()), fieldsList, void 0, void 0, void 0, {
          type: "select",
          tables: [...this.usedTables]
        }, this.cacheConfig);
        query.joinsNotNullableMap = this.joinsNotNullableMap;
        return query;
      }
      $withCache(config) {
        this.cacheConfig = config === void 0 ? { config: {}, enable: true, autoInvalidate: true } : config === false ? { enable: false } : { enable: true, autoInvalidate: true, ...config };
        return this;
      }
    };
    __publicField(SingleStoreSelectBase, _a358, "SingleStoreSelect");
    applyMixins(SingleStoreSelectBase, [QueryPromise]);
    getSingleStoreSetOperators = () => ({
      union: union3,
      unionAll: unionAll3,
      intersect: intersect3,
      except: except3,
      minus
    });
    union3 = createSetOperator3("union", false);
    unionAll3 = createSetOperator3("union", true);
    intersect3 = createSetOperator3("intersect", false);
    except3 = createSetOperator3("except", false);
    minus = createSetOperator3("except", true);
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/query-builder.js
var _a359, QueryBuilder3;
var init_query_builder4 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/query-builder.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_dialect3();
    init_subquery();
    init_select4();
    _a359 = entityKind;
    QueryBuilder3 = class {
      constructor(dialect6) {
        __publicField(this, "dialect");
        __publicField(this, "dialectConfig");
        __publicField(this, "$with", (alias2, selection) => {
          const queryBuilder = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(queryBuilder);
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        this.dialect = is(dialect6, SingleStoreDialect) ? dialect6 : void 0;
        this.dialectConfig = is(dialect6, SingleStoreDialect) ? void 0 : dialect6;
      }
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new SingleStoreSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new SingleStoreSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries,
            distinct: true
          });
        }
        return { select: select2, selectDistinct };
      }
      select(fields) {
        return new SingleStoreSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect()
        });
      }
      selectDistinct(fields) {
        return new SingleStoreSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect(),
          distinct: true
        });
      }
      // Lazy load dialect to avoid circular dependency
      getDialect() {
        if (!this.dialect) {
          this.dialect = new SingleStoreDialect(this.dialectConfig);
        }
        return this.dialect;
      }
    };
    __publicField(QueryBuilder3, _a359, "SingleStoreQueryBuilder");
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/select.types.js
var init_select_types3 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/select.types.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/update.js
var _a360, SingleStoreUpdateBuilder, _a361, _b276, SingleStoreUpdateBase;
var init_update3 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/update.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table();
    init_utils();
    init_utils6();
    _a360 = entityKind;
    SingleStoreUpdateBuilder = class {
      constructor(table6, session, dialect6, withList) {
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.withList = withList;
      }
      set(values2) {
        return new SingleStoreUpdateBase(
          this.table,
          mapUpdateSet(this.table, values2),
          this.session,
          this.dialect,
          this.withList
        );
      }
    };
    __publicField(SingleStoreUpdateBuilder, _a360, "SingleStoreUpdateBuilder");
    SingleStoreUpdateBase = class extends (_b276 = QueryPromise, _a361 = entityKind, _b276) {
      constructor(table6, set, session, dialect6, withList) {
        super();
        __publicField(this, "config");
        __publicField(this, "execute", (placeholderValues) => {
          return this.prepare().execute(placeholderValues);
        });
        __publicField(this, "createIterator", () => {
          const self2 = this;
          return async function* (placeholderValues) {
            yield* self2.prepare().iterator(placeholderValues);
          };
        });
        __publicField(this, "iterator", this.createIterator());
        this.session = session;
        this.dialect = dialect6;
        this.config = { set, table: table6, withList };
      }
      /**
       * Adds a 'where' clause to the query.
       *
       * Calling this method will update only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param where the 'where' clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be updated.
       *
       * ```ts
       * // Update all cars with green color
       * db.update(cars).set({ color: 'red' })
       *   .where(eq(cars.color, 'green'));
       * // or
       * db.update(cars).set({ color: 'red' })
       *   .where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Update all BMW cars with a green color
       * db.update(cars).set({ color: 'red' })
       *   .where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Update all cars with the green or blue color
       * db.update(cars).set({ color: 'red' })
       *   .where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.table[Table.Symbol.Columns],
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          this.config.orderBy = orderByArray;
        } else {
          const orderByArray = columns;
          this.config.orderBy = orderByArray;
        }
        return this;
      }
      limit(limit) {
        this.config.limit = limit;
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildUpdateQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      prepare() {
        return this.session.prepareQuery(
          this.dialect.sqlToQuery(this.getSQL()),
          this.config.returning,
          void 0,
          void 0,
          void 0,
          {
            type: "delete",
            tables: extractUsedTable3(this.config.table)
          }
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SingleStoreUpdateBase, _a361, "SingleStoreUpdate");
  }
});

// ../drizzle-orm/dist/singlestore-core/query-builders/index.js
var init_query_builders3 = __esm({
  "../drizzle-orm/dist/singlestore-core/query-builders/index.js"() {
    "use strict";
    init_delete3();
    init_insert3();
    init_query_builder4();
    init_select4();
    init_select_types3();
    init_update3();
  }
});

// ../drizzle-orm/dist/singlestore-core/db.js
var _a362, SingleStoreDatabase;
var init_db3 = __esm({
  "../drizzle-orm/dist/singlestore-core/db.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_count3();
    init_query_builders3();
    _a362 = entityKind;
    SingleStoreDatabase = class {
      constructor(dialect6, session, schema6) {
        // We are waiting for SingleStore support for `json_array` function
        /**@inrernal */
        __publicField(this, "query");
        /**
         * Creates a subquery that defines a temporary named result set as a CTE.
         *
         * It is useful for breaking down complex queries into simpler parts and for reusing the result set in subsequent parts of the query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
         *
         * @param alias The alias for the subquery.
         *
         * Failure to provide an alias will result in a DrizzleTypeError, preventing the subquery from being referenced in other queries.
         *
         * @example
         *
         * ```ts
         * // Create a subquery with alias 'sq' and use it in the select query
         * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
         *
         * const result = await db.with(sq).select().from(sq);
         * ```
         *
         * To select arbitrary SQL values as fields in a CTE and reference them in other CTEs or in the main query, you need to add aliases to them:
         *
         * ```ts
         * // Select an arbitrary SQL value as a field in a CTE and reference it in the main query
         * const sq = db.$with('sq').as(db.select({
         *   name: sql<string>`upper(${users.name})`.as('name'),
         * })
         * .from(users));
         *
         * const result = await db.with(sq).select({ name: sq.name }).from(sq);
         * ```
         */
        __publicField(this, "$with", (alias2, selection) => {
          const self2 = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(new QueryBuilder3(self2.dialect));
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        __publicField(this, "$cache");
        this.dialect = dialect6;
        this.session = session;
        this._ = schema6 ? {
          schema: schema6.schema,
          fullSchema: schema6.fullSchema,
          tableNamesMap: schema6.tableNamesMap
        } : {
          schema: void 0,
          fullSchema: {},
          tableNamesMap: {}
        };
        this.query = {};
        this.$cache = { invalidate: async (_params2) => {
        } };
      }
      $count(source, filters) {
        return new SingleStoreCountBuilder({ source, filters, session: this.session });
      }
      /**
       * Incorporates a previously defined CTE (using `$with`) into the main query.
       *
       * This method allows the main query to reference a temporary named result set.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
       *
       * @param queries The CTEs to incorporate into the main query.
       *
       * @example
       *
       * ```ts
       * // Define a subquery 'sq' as a CTE using $with
       * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
       *
       * // Incorporate the CTE 'sq' into the main query and select from it
       * const result = await db.with(sq).select().from(sq);
       * ```
       */
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new SingleStoreSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new SingleStoreSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries,
            distinct: true
          });
        }
        function update(table6) {
          return new SingleStoreUpdateBuilder(table6, self2.session, self2.dialect, queries);
        }
        function delete_(table6) {
          return new SingleStoreDeleteBase(table6, self2.session, self2.dialect, queries);
        }
        return { select: select2, selectDistinct, update, delete: delete_ };
      }
      select(fields) {
        return new SingleStoreSelectBuilder({ fields: fields ?? void 0, session: this.session, dialect: this.dialect });
      }
      selectDistinct(fields) {
        return new SingleStoreSelectBuilder({
          fields: fields ?? void 0,
          session: this.session,
          dialect: this.dialect,
          distinct: true
        });
      }
      /**
       * Creates an update query.
       *
       * Calling this method without `.where()` clause will update all rows in a table. The `.where()` clause specifies which rows should be updated.
       *
       * Use `.set()` method to specify which values to update.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param table The table to update.
       *
       * @example
       *
       * ```ts
       * // Update all rows in the 'cars' table
       * await db.update(cars).set({ color: 'red' });
       *
       * // Update rows with filters and conditions
       * await db.update(cars).set({ color: 'red' }).where(eq(cars.brand, 'BMW'));
       * ```
       */
      update(table6) {
        return new SingleStoreUpdateBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates an insert query.
       *
       * Calling this method will create new rows in a table. Use `.values()` method to specify which values to insert.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert}
       *
       * @param table The table to insert into.
       *
       * @example
       *
       * ```ts
       * // Insert one row
       * await db.insert(cars).values({ brand: 'BMW' });
       *
       * // Insert multiple rows
       * await db.insert(cars).values([{ brand: 'BMW' }, { brand: 'Porsche' }]);
       * ```
       */
      insert(table6) {
        return new SingleStoreInsertBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates a delete query.
       *
       * Calling this method without `.where()` clause will delete all rows in a table. The `.where()` clause specifies which rows should be deleted.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param table The table to delete from.
       *
       * @example
       *
       * ```ts
       * // Delete all rows in the 'cars' table
       * await db.delete(cars);
       *
       * // Delete rows with filters and conditions
       * await db.delete(cars).where(eq(cars.color, 'green'));
       * ```
       */
      delete(table6) {
        return new SingleStoreDeleteBase(table6, this.session, this.dialect);
      }
      execute(query) {
        return this.session.execute(typeof query === "string" ? sql.raw(query) : query.getSQL());
      }
      transaction(transaction, config) {
        return this.session.transaction(transaction, config);
      }
    };
    __publicField(SingleStoreDatabase, _a362, "SingleStoreDatabase");
  }
});

// ../drizzle-orm/dist/singlestore-core/schema.js
var _a363, SingleStoreSchema;
var init_schema3 = __esm({
  "../drizzle-orm/dist/singlestore-core/schema.js"() {
    "use strict";
    init_entity();
    init_table4();
    _a363 = entityKind;
    SingleStoreSchema = class {
      constructor(schemaName) {
        __publicField(this, "table", (name3, columns, extraConfig) => {
          return singlestoreTableWithSchema(name3, columns, extraConfig, this.schemaName);
        });
        this.schemaName = schemaName;
      }
      /*
      view = ((name, columns) => {
      	return singlestoreViewWithSchema(name, columns, this.schemaName);
      }) as typeof singlestoreView; */
    };
    __publicField(SingleStoreSchema, _a363, "SingleStoreSchema");
  }
});

// ../drizzle-orm/dist/singlestore-core/session.js
var _a364, SingleStorePreparedQuery, _a365, SingleStoreSession, _a366, _b277, SingleStoreTransaction;
var init_session3 = __esm({
  "../drizzle-orm/dist/singlestore-core/session.js"() {
    "use strict";
    init_cache();
    init_entity();
    init_errors();
    init_sql();
    init_db3();
    _a364 = entityKind;
    SingleStorePreparedQuery = class {
      constructor(cache5, queryMetadata, cacheConfig) {
        /** @internal */
        __publicField(this, "joinsNotNullableMap");
        this.cache = cache5;
        this.queryMetadata = queryMetadata;
        this.cacheConfig = cacheConfig;
        if (cache5 && cache5.strategy() === "all" && cacheConfig === void 0) {
          this.cacheConfig = { enable: true, autoInvalidate: true };
        }
        if (!this.cacheConfig?.enable) {
          this.cacheConfig = void 0;
        }
      }
      /** @internal */
      async queryWithCache(queryString, params, query) {
        if (this.cache === void 0 || is(this.cache, NoopCache) || this.queryMetadata === void 0) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.cacheConfig && !this.cacheConfig.enable) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if ((this.queryMetadata.type === "insert" || this.queryMetadata.type === "update" || this.queryMetadata.type === "delete") && this.queryMetadata.tables.length > 0) {
          try {
            const [res] = await Promise.all([
              query(),
              this.cache.onMutate({ tables: this.queryMetadata.tables })
            ]);
            return res;
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (!this.cacheConfig) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.queryMetadata.type === "select") {
          const fromCache = await this.cache.get(
            this.cacheConfig.tag ?? await hashQuery(queryString, params),
            this.queryMetadata.tables,
            this.cacheConfig.tag !== void 0,
            this.cacheConfig.autoInvalidate
          );
          if (fromCache === void 0) {
            let result;
            try {
              result = await query();
            } catch (e6) {
              throw new DrizzleQueryError(queryString, params, e6);
            }
            await this.cache.put(
              this.cacheConfig.tag ?? await hashQuery(queryString, params),
              result,
              // make sure we send tables that were used in a query only if user wants to invalidate it on each write
              this.cacheConfig.autoInvalidate ? this.queryMetadata.tables : [],
              this.cacheConfig.tag !== void 0,
              this.cacheConfig.config
            );
            return result;
          }
          return fromCache;
        }
        try {
          return await query();
        } catch (e6) {
          throw new DrizzleQueryError(queryString, params, e6);
        }
      }
    };
    __publicField(SingleStorePreparedQuery, _a364, "SingleStorePreparedQuery");
    _a365 = entityKind;
    SingleStoreSession = class {
      constructor(dialect6) {
        this.dialect = dialect6;
      }
      execute(query) {
        return this.prepareQuery(
          this.dialect.sqlToQuery(query),
          void 0
        ).execute();
      }
      async count(sql22) {
        const res = await this.execute(sql22);
        return Number(
          res[0][0]["count"]
        );
      }
      getSetTransactionSQL(config) {
        const parts2 = [];
        if (config.isolationLevel) {
          parts2.push(`isolation level ${config.isolationLevel}`);
        }
        return parts2.length ? sql`set transaction ${sql.raw(parts2.join(" "))}` : void 0;
      }
      getStartTransactionSQL(config) {
        const parts2 = [];
        if (config.withConsistentSnapshot) {
          parts2.push("with consistent snapshot");
        }
        if (config.accessMode) {
          parts2.push(config.accessMode);
        }
        return parts2.length ? sql`start transaction ${sql.raw(parts2.join(" "))}` : void 0;
      }
    };
    __publicField(SingleStoreSession, _a365, "SingleStoreSession");
    SingleStoreTransaction = class extends (_b277 = SingleStoreDatabase, _a366 = entityKind, _b277) {
      constructor(dialect6, session, schema6, nestedIndex) {
        super(dialect6, session, schema6);
        this.schema = schema6;
        this.nestedIndex = nestedIndex;
      }
      rollback() {
        throw new TransactionRollbackError();
      }
    };
    __publicField(SingleStoreTransaction, _a366, "SingleStoreTransaction");
  }
});

// ../drizzle-orm/dist/singlestore-core/subquery.js
var init_subquery4 = __esm({
  "../drizzle-orm/dist/singlestore-core/subquery.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/singlestore-core/index.js
var init_singlestore_core = __esm({
  "../drizzle-orm/dist/singlestore-core/index.js"() {
    "use strict";
    init_alias4();
    init_columns3();
    init_db3();
    init_dialect3();
    init_indexes3();
    init_primary_keys3();
    init_query_builders3();
    init_schema3();
    init_session3();
    init_subquery4();
    init_table4();
    init_unique_constraint3();
    init_utils6();
  }
});

// ../drizzle-orm/dist/sqlite-core/alias.js
var init_alias5 = __esm({
  "../drizzle-orm/dist/sqlite-core/alias.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/sqlite-core/checks.js
var _a367, CheckBuilder3, _a368, Check3;
var init_checks3 = __esm({
  "../drizzle-orm/dist/sqlite-core/checks.js"() {
    "use strict";
    init_entity();
    _a367 = entityKind;
    CheckBuilder3 = class {
      constructor(name3, value) {
        __publicField(this, "brand");
        this.name = name3;
        this.value = value;
      }
      build(table6) {
        return new Check3(table6, this);
      }
    };
    __publicField(CheckBuilder3, _a367, "SQLiteCheckBuilder");
    _a368 = entityKind;
    Check3 = class {
      constructor(table6, builder) {
        __publicField(this, "name");
        __publicField(this, "value");
        this.table = table6;
        this.name = builder.name;
        this.value = builder.value;
      }
    };
    __publicField(Check3, _a368, "SQLiteCheck");
  }
});

// ../drizzle-orm/dist/sqlite-core/foreign-keys.js
var _a369, ForeignKeyBuilder3, _a370, ForeignKey3;
var init_foreign_keys3 = __esm({
  "../drizzle-orm/dist/sqlite-core/foreign-keys.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a369 = entityKind;
    ForeignKeyBuilder3 = class {
      constructor(config, actions) {
        /** @internal */
        __publicField(this, "reference");
        /** @internal */
        __publicField(this, "_onUpdate");
        /** @internal */
        __publicField(this, "_onDelete");
        this.reference = () => {
          const { name: name3, columns, foreignColumns } = config();
          return { name: name3, columns, foreignTable: foreignColumns[0].table, foreignColumns };
        };
        if (actions) {
          this._onUpdate = actions.onUpdate;
          this._onDelete = actions.onDelete;
        }
      }
      onUpdate(action) {
        this._onUpdate = action;
        return this;
      }
      onDelete(action) {
        this._onDelete = action;
        return this;
      }
      /** @internal */
      build(table6) {
        return new ForeignKey3(table6, this);
      }
    };
    __publicField(ForeignKeyBuilder3, _a369, "SQLiteForeignKeyBuilder");
    _a370 = entityKind;
    ForeignKey3 = class {
      constructor(table6, builder) {
        __publicField(this, "reference");
        __publicField(this, "onUpdate");
        __publicField(this, "onDelete");
        this.table = table6;
        this.reference = builder.reference;
        this.onUpdate = builder._onUpdate;
        this.onDelete = builder._onDelete;
      }
      getName() {
        const { name: name3, columns, foreignColumns } = this.reference();
        const columnNames = columns.map((column6) => column6.name);
        const foreignColumnNames = foreignColumns.map((column6) => column6.name);
        const chunks = [
          this.table[TableName],
          ...columnNames,
          foreignColumns[0].table[TableName],
          ...foreignColumnNames
        ];
        return name3 ?? `${chunks.join("_")}_fk`;
      }
    };
    __publicField(ForeignKey3, _a370, "SQLiteForeignKey");
  }
});

// ../drizzle-orm/dist/sqlite-core/unique-constraint.js
function uniqueKeyName4(table6, columns) {
  return `${table6[TableName]}_${columns.join("_")}_unique`;
}
var _a371, UniqueConstraintBuilder4, _a372, UniqueOnConstraintBuilder4, _a373, UniqueConstraint4;
var init_unique_constraint4 = __esm({
  "../drizzle-orm/dist/sqlite-core/unique-constraint.js"() {
    "use strict";
    init_entity();
    init_table_utils();
    _a371 = entityKind;
    UniqueConstraintBuilder4 = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        this.name = name3;
        this.columns = columns;
      }
      /** @internal */
      build(table6) {
        return new UniqueConstraint4(table6, this.columns, this.name);
      }
    };
    __publicField(UniqueConstraintBuilder4, _a371, "SQLiteUniqueConstraintBuilder");
    _a372 = entityKind;
    UniqueOnConstraintBuilder4 = class {
      constructor(name3) {
        /** @internal */
        __publicField(this, "name");
        this.name = name3;
      }
      on(...columns) {
        return new UniqueConstraintBuilder4(columns, this.name);
      }
    };
    __publicField(UniqueOnConstraintBuilder4, _a372, "SQLiteUniqueOnConstraintBuilder");
    _a373 = entityKind;
    UniqueConstraint4 = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        this.table = table6;
        this.columns = columns;
        this.name = name3 ?? uniqueKeyName4(this.table, this.columns.map((column6) => column6.name));
      }
      getName() {
        return this.name;
      }
    };
    __publicField(UniqueConstraint4, _a373, "SQLiteUniqueConstraint");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/common.js
var _a374, _b278, SQLiteColumnBuilder, _a375, _b279, SQLiteColumn;
var init_common4 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/common.js"() {
    "use strict";
    init_column_builder();
    init_column();
    init_entity();
    init_foreign_keys3();
    init_unique_constraint4();
    SQLiteColumnBuilder = class extends (_b278 = ColumnBuilder, _a374 = entityKind, _b278) {
      constructor() {
        super(...arguments);
        __publicField(this, "foreignKeyConfigs", []);
      }
      references(ref, actions = {}) {
        this.foreignKeyConfigs.push({ ref, actions });
        return this;
      }
      unique(name3) {
        this.config.isUnique = true;
        this.config.uniqueName = name3;
        return this;
      }
      generatedAlwaysAs(as, config) {
        this.config.generated = {
          as,
          type: "always",
          mode: config?.mode ?? "virtual"
        };
        return this;
      }
      /** @internal */
      buildForeignKeys(column6, table6) {
        return this.foreignKeyConfigs.map(({ ref, actions }) => {
          return ((ref2, actions2) => {
            const builder = new ForeignKeyBuilder3(() => {
              const foreignColumn = ref2();
              return { columns: [column6], foreignColumns: [foreignColumn] };
            });
            if (actions2.onUpdate) {
              builder.onUpdate(actions2.onUpdate);
            }
            if (actions2.onDelete) {
              builder.onDelete(actions2.onDelete);
            }
            return builder.build(table6);
          })(ref, actions);
        });
      }
    };
    __publicField(SQLiteColumnBuilder, _a374, "SQLiteColumnBuilder");
    SQLiteColumn = class extends (_b279 = Column, _a375 = entityKind, _b279) {
      constructor(table6, config) {
        if (!config.uniqueName) {
          config.uniqueName = uniqueKeyName4(table6, [config.name]);
        }
        super(table6, config);
        this.table = table6;
      }
    };
    __publicField(SQLiteColumn, _a375, "SQLiteColumn");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/blob.js
function blob(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "json") {
    return new SQLiteBlobJsonBuilder(name3);
  }
  if (config?.mode === "bigint") {
    return new SQLiteBigIntBuilder(name3);
  }
  return new SQLiteBlobBufferBuilder(name3);
}
var _a376, _b280, SQLiteBigIntBuilder, _a377, _b281, SQLiteBigInt, _a378, _b282, SQLiteBlobJsonBuilder, _a379, _b283, SQLiteBlobJson, _a380, _b284, SQLiteBlobBufferBuilder, _a381, _b285, SQLiteBlobBuffer;
var init_blob = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/blob.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common4();
    SQLiteBigIntBuilder = class extends (_b280 = SQLiteColumnBuilder, _a376 = entityKind, _b280) {
      constructor(name3) {
        super(name3, "bigint", "SQLiteBigInt");
      }
      /** @internal */
      build(table6) {
        return new SQLiteBigInt(table6, this.config);
      }
    };
    __publicField(SQLiteBigIntBuilder, _a376, "SQLiteBigIntBuilder");
    SQLiteBigInt = class extends (_b281 = SQLiteColumn, _a377 = entityKind, _b281) {
      getSQLType() {
        return "blob";
      }
      mapFromDriverValue(value) {
        if (typeof Buffer !== "undefined" && Buffer.from) {
          const buf = Buffer.isBuffer(value) ? value : value instanceof ArrayBuffer ? Buffer.from(value) : value.buffer ? Buffer.from(value.buffer, value.byteOffset, value.byteLength) : Buffer.from(value);
          return BigInt(buf.toString("utf8"));
        }
        return BigInt(textDecoder.decode(value));
      }
      mapToDriverValue(value) {
        return Buffer.from(value.toString());
      }
    };
    __publicField(SQLiteBigInt, _a377, "SQLiteBigInt");
    SQLiteBlobJsonBuilder = class extends (_b282 = SQLiteColumnBuilder, _a378 = entityKind, _b282) {
      constructor(name3) {
        super(name3, "json", "SQLiteBlobJson");
      }
      /** @internal */
      build(table6) {
        return new SQLiteBlobJson(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteBlobJsonBuilder, _a378, "SQLiteBlobJsonBuilder");
    SQLiteBlobJson = class extends (_b283 = SQLiteColumn, _a379 = entityKind, _b283) {
      getSQLType() {
        return "blob";
      }
      mapFromDriverValue(value) {
        if (typeof Buffer !== "undefined" && Buffer.from) {
          const buf = Buffer.isBuffer(value) ? value : value instanceof ArrayBuffer ? Buffer.from(value) : value.buffer ? Buffer.from(value.buffer, value.byteOffset, value.byteLength) : Buffer.from(value);
          return JSON.parse(buf.toString("utf8"));
        }
        return JSON.parse(textDecoder.decode(value));
      }
      mapToDriverValue(value) {
        return Buffer.from(JSON.stringify(value));
      }
    };
    __publicField(SQLiteBlobJson, _a379, "SQLiteBlobJson");
    SQLiteBlobBufferBuilder = class extends (_b284 = SQLiteColumnBuilder, _a380 = entityKind, _b284) {
      constructor(name3) {
        super(name3, "buffer", "SQLiteBlobBuffer");
      }
      /** @internal */
      build(table6) {
        return new SQLiteBlobBuffer(table6, this.config);
      }
    };
    __publicField(SQLiteBlobBufferBuilder, _a380, "SQLiteBlobBufferBuilder");
    SQLiteBlobBuffer = class extends (_b285 = SQLiteColumn, _a381 = entityKind, _b285) {
      mapFromDriverValue(value) {
        if (Buffer.isBuffer(value)) {
          return value;
        }
        return Buffer.from(value);
      }
      getSQLType() {
        return "blob";
      }
    };
    __publicField(SQLiteBlobBuffer, _a381, "SQLiteBlobBuffer");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/custom.js
function customType4(customTypeParams) {
  return (a9, b9) => {
    const { name: name3, config } = getColumnNameAndConfig(a9, b9);
    return new SQLiteCustomColumnBuilder(
      name3,
      config,
      customTypeParams
    );
  };
}
var _a382, _b286, SQLiteCustomColumnBuilder, _a383, _b287, SQLiteCustomColumn;
var init_custom4 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/custom.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common4();
    SQLiteCustomColumnBuilder = class extends (_b286 = SQLiteColumnBuilder, _a382 = entityKind, _b286) {
      constructor(name3, fieldConfig, customTypeParams) {
        super(name3, "custom", "SQLiteCustomColumn");
        this.config.fieldConfig = fieldConfig;
        this.config.customTypeParams = customTypeParams;
      }
      /** @internal */
      build(table6) {
        return new SQLiteCustomColumn(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteCustomColumnBuilder, _a382, "SQLiteCustomColumnBuilder");
    SQLiteCustomColumn = class extends (_b287 = SQLiteColumn, _a383 = entityKind, _b287) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "sqlName");
        __publicField(this, "mapTo");
        __publicField(this, "mapFrom");
        this.sqlName = config.customTypeParams.dataType(config.fieldConfig);
        this.mapTo = config.customTypeParams.toDriver;
        this.mapFrom = config.customTypeParams.fromDriver;
      }
      getSQLType() {
        return this.sqlName;
      }
      mapFromDriverValue(value) {
        return typeof this.mapFrom === "function" ? this.mapFrom(value) : value;
      }
      mapToDriverValue(value) {
        return typeof this.mapTo === "function" ? this.mapTo(value) : value;
      }
    };
    __publicField(SQLiteCustomColumn, _a383, "SQLiteCustomColumn");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/integer.js
function integer2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config?.mode === "timestamp" || config?.mode === "timestamp_ms") {
    return new SQLiteTimestampBuilder(name3, config.mode);
  }
  if (config?.mode === "boolean") {
    return new SQLiteBooleanBuilder(name3, config.mode);
  }
  return new SQLiteIntegerBuilder(name3);
}
var _a384, _b288, SQLiteBaseIntegerBuilder, _a385, _b289, SQLiteBaseInteger, _a386, _b290, SQLiteIntegerBuilder, _a387, _b291, SQLiteInteger, _a388, _b292, SQLiteTimestampBuilder, _a389, _b293, SQLiteTimestamp, _a390, _b294, SQLiteBooleanBuilder, _a391, _b295, SQLiteBoolean;
var init_integer2 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/integer.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_utils();
    init_common4();
    SQLiteBaseIntegerBuilder = class extends (_b288 = SQLiteColumnBuilder, _a384 = entityKind, _b288) {
      constructor(name3, dataType, columnType) {
        super(name3, dataType, columnType);
        this.config.autoIncrement = false;
      }
      primaryKey(config) {
        if (config?.autoIncrement) {
          this.config.autoIncrement = true;
        }
        this.config.hasDefault = true;
        return super.primaryKey();
      }
    };
    __publicField(SQLiteBaseIntegerBuilder, _a384, "SQLiteBaseIntegerBuilder");
    SQLiteBaseInteger = class extends (_b289 = SQLiteColumn, _a385 = entityKind, _b289) {
      constructor() {
        super(...arguments);
        __publicField(this, "autoIncrement", this.config.autoIncrement);
      }
      getSQLType() {
        return "integer";
      }
    };
    __publicField(SQLiteBaseInteger, _a385, "SQLiteBaseInteger");
    SQLiteIntegerBuilder = class extends (_b290 = SQLiteBaseIntegerBuilder, _a386 = entityKind, _b290) {
      constructor(name3) {
        super(name3, "number", "SQLiteInteger");
      }
      build(table6) {
        return new SQLiteInteger(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteIntegerBuilder, _a386, "SQLiteIntegerBuilder");
    SQLiteInteger = class extends (_b291 = SQLiteBaseInteger, _a387 = entityKind, _b291) {
    };
    __publicField(SQLiteInteger, _a387, "SQLiteInteger");
    SQLiteTimestampBuilder = class extends (_b292 = SQLiteBaseIntegerBuilder, _a388 = entityKind, _b292) {
      constructor(name3, mode) {
        super(name3, "date", "SQLiteTimestamp");
        this.config.mode = mode;
      }
      /**
       * @deprecated Use `default()` with your own expression instead.
       *
       * Adds `DEFAULT (cast((julianday('now') - 2440587.5)*86400000 as integer))` to the column, which is the current epoch timestamp in milliseconds.
       */
      defaultNow() {
        return this.default(sql`(cast((julianday('now') - 2440587.5)*86400000 as integer))`);
      }
      build(table6) {
        return new SQLiteTimestamp(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteTimestampBuilder, _a388, "SQLiteTimestampBuilder");
    SQLiteTimestamp = class extends (_b293 = SQLiteBaseInteger, _a389 = entityKind, _b293) {
      constructor() {
        super(...arguments);
        __publicField(this, "mode", this.config.mode);
      }
      mapFromDriverValue(value) {
        if (this.config.mode === "timestamp") {
          return new Date(value * 1e3);
        }
        return new Date(value);
      }
      mapToDriverValue(value) {
        const unix = value.getTime();
        if (this.config.mode === "timestamp") {
          return Math.floor(unix / 1e3);
        }
        return unix;
      }
    };
    __publicField(SQLiteTimestamp, _a389, "SQLiteTimestamp");
    SQLiteBooleanBuilder = class extends (_b294 = SQLiteBaseIntegerBuilder, _a390 = entityKind, _b294) {
      constructor(name3, mode) {
        super(name3, "boolean", "SQLiteBoolean");
        this.config.mode = mode;
      }
      build(table6) {
        return new SQLiteBoolean(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteBooleanBuilder, _a390, "SQLiteBooleanBuilder");
    SQLiteBoolean = class extends (_b295 = SQLiteBaseInteger, _a391 = entityKind, _b295) {
      constructor() {
        super(...arguments);
        __publicField(this, "mode", this.config.mode);
      }
      mapFromDriverValue(value) {
        return Number(value) === 1;
      }
      mapToDriverValue(value) {
        return value ? 1 : 0;
      }
    };
    __publicField(SQLiteBoolean, _a391, "SQLiteBoolean");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/numeric.js
function numeric2(a9, b9) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  const mode = config?.mode;
  return mode === "number" ? new SQLiteNumericNumberBuilder(name3) : mode === "bigint" ? new SQLiteNumericBigIntBuilder(name3) : new SQLiteNumericBuilder(name3);
}
var _a392, _b296, SQLiteNumericBuilder, _a393, _b297, SQLiteNumeric, _a394, _b298, SQLiteNumericNumberBuilder, _a395, _b299, SQLiteNumericNumber, _a396, _b300, SQLiteNumericBigIntBuilder, _a397, _b301, SQLiteNumericBigInt;
var init_numeric2 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/numeric.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common4();
    SQLiteNumericBuilder = class extends (_b296 = SQLiteColumnBuilder, _a392 = entityKind, _b296) {
      constructor(name3) {
        super(name3, "string", "SQLiteNumeric");
      }
      /** @internal */
      build(table6) {
        return new SQLiteNumeric(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteNumericBuilder, _a392, "SQLiteNumericBuilder");
    SQLiteNumeric = class extends (_b297 = SQLiteColumn, _a393 = entityKind, _b297) {
      mapFromDriverValue(value) {
        if (typeof value === "string") return value;
        return String(value);
      }
      getSQLType() {
        return "numeric";
      }
    };
    __publicField(SQLiteNumeric, _a393, "SQLiteNumeric");
    SQLiteNumericNumberBuilder = class extends (_b298 = SQLiteColumnBuilder, _a394 = entityKind, _b298) {
      constructor(name3) {
        super(name3, "number", "SQLiteNumericNumber");
      }
      /** @internal */
      build(table6) {
        return new SQLiteNumericNumber(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteNumericNumberBuilder, _a394, "SQLiteNumericNumberBuilder");
    SQLiteNumericNumber = class extends (_b299 = SQLiteColumn, _a395 = entityKind, _b299) {
      constructor() {
        super(...arguments);
        __publicField(this, "mapToDriverValue", String);
      }
      mapFromDriverValue(value) {
        if (typeof value === "number") return value;
        return Number(value);
      }
      getSQLType() {
        return "numeric";
      }
    };
    __publicField(SQLiteNumericNumber, _a395, "SQLiteNumericNumber");
    SQLiteNumericBigIntBuilder = class extends (_b300 = SQLiteColumnBuilder, _a396 = entityKind, _b300) {
      constructor(name3) {
        super(name3, "bigint", "SQLiteNumericBigInt");
      }
      /** @internal */
      build(table6) {
        return new SQLiteNumericBigInt(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteNumericBigIntBuilder, _a396, "SQLiteNumericBigIntBuilder");
    SQLiteNumericBigInt = class extends (_b301 = SQLiteColumn, _a397 = entityKind, _b301) {
      constructor() {
        super(...arguments);
        __publicField(this, "mapFromDriverValue", BigInt);
        __publicField(this, "mapToDriverValue", String);
      }
      getSQLType() {
        return "numeric";
      }
    };
    __publicField(SQLiteNumericBigInt, _a397, "SQLiteNumericBigInt");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/real.js
function real4(name3) {
  return new SQLiteRealBuilder(name3 ?? "");
}
var _a398, _b302, SQLiteRealBuilder, _a399, _b303, SQLiteReal;
var init_real4 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/real.js"() {
    "use strict";
    init_entity();
    init_common4();
    SQLiteRealBuilder = class extends (_b302 = SQLiteColumnBuilder, _a398 = entityKind, _b302) {
      constructor(name3) {
        super(name3, "number", "SQLiteReal");
      }
      /** @internal */
      build(table6) {
        return new SQLiteReal(table6, this.config);
      }
    };
    __publicField(SQLiteRealBuilder, _a398, "SQLiteRealBuilder");
    SQLiteReal = class extends (_b303 = SQLiteColumn, _a399 = entityKind, _b303) {
      getSQLType() {
        return "real";
      }
    };
    __publicField(SQLiteReal, _a399, "SQLiteReal");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/text.js
function text4(a9, b9 = {}) {
  const { name: name3, config } = getColumnNameAndConfig(a9, b9);
  if (config.mode === "json") {
    return new SQLiteTextJsonBuilder(name3);
  }
  return new SQLiteTextBuilder(name3, config);
}
var _a400, _b304, SQLiteTextBuilder, _a401, _b305, SQLiteText, _a402, _b306, SQLiteTextJsonBuilder, _a403, _b307, SQLiteTextJson;
var init_text4 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/text.js"() {
    "use strict";
    init_entity();
    init_utils();
    init_common4();
    SQLiteTextBuilder = class extends (_b304 = SQLiteColumnBuilder, _a400 = entityKind, _b304) {
      constructor(name3, config) {
        super(name3, "string", "SQLiteText");
        this.config.enumValues = config.enum;
        this.config.length = config.length;
      }
      /** @internal */
      build(table6) {
        return new SQLiteText(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteTextBuilder, _a400, "SQLiteTextBuilder");
    SQLiteText = class extends (_b305 = SQLiteColumn, _a401 = entityKind, _b305) {
      constructor(table6, config) {
        super(table6, config);
        __publicField(this, "enumValues", this.config.enumValues);
        __publicField(this, "length", this.config.length);
      }
      getSQLType() {
        return `text${this.config.length ? `(${this.config.length})` : ""}`;
      }
    };
    __publicField(SQLiteText, _a401, "SQLiteText");
    SQLiteTextJsonBuilder = class extends (_b306 = SQLiteColumnBuilder, _a402 = entityKind, _b306) {
      constructor(name3) {
        super(name3, "json", "SQLiteTextJson");
      }
      /** @internal */
      build(table6) {
        return new SQLiteTextJson(
          table6,
          this.config
        );
      }
    };
    __publicField(SQLiteTextJsonBuilder, _a402, "SQLiteTextJsonBuilder");
    SQLiteTextJson = class extends (_b307 = SQLiteColumn, _a403 = entityKind, _b307) {
      getSQLType() {
        return "text";
      }
      mapFromDriverValue(value) {
        return JSON.parse(value);
      }
      mapToDriverValue(value) {
        return JSON.stringify(value);
      }
    };
    __publicField(SQLiteTextJson, _a403, "SQLiteTextJson");
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/index.js
var init_columns4 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/index.js"() {
    "use strict";
    init_blob();
    init_common4();
    init_custom4();
    init_integer2();
    init_numeric2();
    init_real4();
    init_text4();
  }
});

// ../drizzle-orm/dist/sqlite-core/columns/all.js
function getSQLiteColumnBuilders() {
  return {
    blob,
    customType: customType4,
    integer: integer2,
    numeric: numeric2,
    real: real4,
    text: text4
  };
}
var init_all4 = __esm({
  "../drizzle-orm/dist/sqlite-core/columns/all.js"() {
    "use strict";
    init_blob();
    init_custom4();
    init_integer2();
    init_numeric2();
    init_real4();
    init_text4();
  }
});

// ../drizzle-orm/dist/sqlite-core/table.js
function sqliteTableBase(name3, columns, extraConfig, schema6, baseName = name3) {
  const rawTable = new SQLiteTable(name3, schema6, baseName);
  const parsedColumns = typeof columns === "function" ? columns(getSQLiteColumnBuilders()) : columns;
  const builtColumns = Object.fromEntries(
    Object.entries(parsedColumns).map(([name22, colBuilderBase]) => {
      const colBuilder = colBuilderBase;
      colBuilder.setName(name22);
      const column6 = colBuilder.build(rawTable);
      rawTable[InlineForeignKeys3].push(...colBuilder.buildForeignKeys(column6, rawTable));
      return [name22, column6];
    })
  );
  const table6 = Object.assign(rawTable, builtColumns);
  table6[Table.Symbol.Columns] = builtColumns;
  table6[Table.Symbol.ExtraConfigColumns] = builtColumns;
  if (extraConfig) {
    table6[SQLiteTable.Symbol.ExtraConfigBuilder] = extraConfig;
  }
  return table6;
}
var InlineForeignKeys3, _a404, _b308, _c12, _d5, _e4, SQLiteTable, sqliteTable;
var init_table5 = __esm({
  "../drizzle-orm/dist/sqlite-core/table.js"() {
    "use strict";
    init_entity();
    init_table();
    init_all4();
    InlineForeignKeys3 = Symbol.for("drizzle:SQLiteInlineForeignKeys");
    SQLiteTable = class extends (_e4 = Table, _d5 = entityKind, _c12 = Table.Symbol.Columns, _b308 = InlineForeignKeys3, _a404 = Table.Symbol.ExtraConfigBuilder, _e4) {
      constructor() {
        super(...arguments);
        /** @internal */
        __publicField(this, _c12);
        /** @internal */
        __publicField(this, _b308, []);
        /** @internal */
        __publicField(this, _a404);
      }
    };
    __publicField(SQLiteTable, _d5, "SQLiteTable");
    /** @internal */
    __publicField(SQLiteTable, "Symbol", Object.assign({}, Table.Symbol, {
      InlineForeignKeys: InlineForeignKeys3
    }));
    sqliteTable = (name3, columns, extraConfig) => {
      return sqliteTableBase(name3, columns, extraConfig);
    };
  }
});

// ../drizzle-orm/dist/sqlite-core/indexes.js
var _a405, IndexBuilderOn4, _a406, IndexBuilder4, _a407, Index4;
var init_indexes4 = __esm({
  "../drizzle-orm/dist/sqlite-core/indexes.js"() {
    "use strict";
    init_entity();
    _a405 = entityKind;
    IndexBuilderOn4 = class {
      constructor(name3, unique2) {
        this.name = name3;
        this.unique = unique2;
      }
      on(...columns) {
        return new IndexBuilder4(this.name, columns, this.unique);
      }
    };
    __publicField(IndexBuilderOn4, _a405, "SQLiteIndexBuilderOn");
    _a406 = entityKind;
    IndexBuilder4 = class {
      constructor(name3, columns, unique2) {
        /** @internal */
        __publicField(this, "config");
        this.config = {
          name: name3,
          columns,
          unique: unique2,
          where: void 0
        };
      }
      /**
       * Condition for partial index.
       */
      where(condition) {
        this.config.where = condition;
        return this;
      }
      /** @internal */
      build(table6) {
        return new Index4(this.config, table6);
      }
    };
    __publicField(IndexBuilder4, _a406, "SQLiteIndexBuilder");
    _a407 = entityKind;
    Index4 = class {
      constructor(config, table6) {
        __publicField(this, "config");
        this.config = { ...config, table: table6 };
      }
    };
    __publicField(Index4, _a407, "SQLiteIndex");
  }
});

// ../drizzle-orm/dist/sqlite-core/primary-keys.js
var _a408, PrimaryKeyBuilder4, _a409, PrimaryKey4;
var init_primary_keys4 = __esm({
  "../drizzle-orm/dist/sqlite-core/primary-keys.js"() {
    "use strict";
    init_entity();
    init_table5();
    _a408 = entityKind;
    PrimaryKeyBuilder4 = class {
      constructor(columns, name3) {
        /** @internal */
        __publicField(this, "columns");
        /** @internal */
        __publicField(this, "name");
        this.columns = columns;
        this.name = name3;
      }
      /** @internal */
      build(table6) {
        return new PrimaryKey4(table6, this.columns, this.name);
      }
    };
    __publicField(PrimaryKeyBuilder4, _a408, "SQLitePrimaryKeyBuilder");
    _a409 = entityKind;
    PrimaryKey4 = class {
      constructor(table6, columns, name3) {
        __publicField(this, "columns");
        __publicField(this, "name");
        this.table = table6;
        this.columns = columns;
        this.name = name3;
      }
      getName() {
        return this.name ?? `${this.table[SQLiteTable.Symbol.Name]}_${this.columns.map((column6) => column6.name).join("_")}_pk`;
      }
    };
    __publicField(PrimaryKey4, _a409, "SQLitePrimaryKey");
  }
});

// ../drizzle-orm/dist/sqlite-core/utils.js
function getTableConfig4(table6) {
  const columns = Object.values(table6[SQLiteTable.Symbol.Columns]);
  const indexes = [];
  const checks = [];
  const primaryKeys = [];
  const uniqueConstraints = [];
  const foreignKeys = Object.values(table6[SQLiteTable.Symbol.InlineForeignKeys]);
  const name3 = table6[Table.Symbol.Name];
  const extraConfigBuilder = table6[SQLiteTable.Symbol.ExtraConfigBuilder];
  if (extraConfigBuilder !== void 0) {
    const extraConfig = extraConfigBuilder(table6[SQLiteTable.Symbol.Columns]);
    const extraValues = Array.isArray(extraConfig) ? extraConfig.flat(1) : Object.values(extraConfig);
    for (const builder of Object.values(extraValues)) {
      if (is(builder, IndexBuilder4)) {
        indexes.push(builder.build(table6));
      } else if (is(builder, CheckBuilder3)) {
        checks.push(builder.build(table6));
      } else if (is(builder, UniqueConstraintBuilder4)) {
        uniqueConstraints.push(builder.build(table6));
      } else if (is(builder, PrimaryKeyBuilder4)) {
        primaryKeys.push(builder.build(table6));
      } else if (is(builder, ForeignKeyBuilder3)) {
        foreignKeys.push(builder.build(table6));
      }
    }
  }
  return {
    columns,
    indexes,
    foreignKeys,
    checks,
    primaryKeys,
    uniqueConstraints,
    name: name3
  };
}
function extractUsedTable4(table6) {
  if (is(table6, SQLiteTable)) {
    return [`${table6[Table.Symbol.BaseName]}`];
  }
  if (is(table6, Subquery)) {
    return table6._.usedTables ?? [];
  }
  if (is(table6, SQL)) {
    return table6.usedTables ?? [];
  }
  return [];
}
function getViewConfig3(view5) {
  return {
    ...view5[ViewBaseConfig]
    // ...view[SQLiteViewConfig],
  };
}
var init_utils7 = __esm({
  "../drizzle-orm/dist/sqlite-core/utils.js"() {
    "use strict";
    init_entity();
    init_sql();
    init_subquery();
    init_table();
    init_view_common();
    init_checks3();
    init_foreign_keys3();
    init_indexes4();
    init_primary_keys4();
    init_table5();
    init_unique_constraint4();
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/delete.js
var _a410, _b309, SQLiteDeleteBase;
var init_delete4 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/delete.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table5();
    init_table();
    init_utils();
    init_utils7();
    SQLiteDeleteBase = class extends (_b309 = QueryPromise, _a410 = entityKind, _b309) {
      constructor(table6, session, dialect6, withList) {
        super();
        /** @internal */
        __publicField(this, "config");
        __publicField(this, "run", (placeholderValues) => {
          return this._prepare().run(placeholderValues);
        });
        __publicField(this, "all", (placeholderValues) => {
          return this._prepare().all(placeholderValues);
        });
        __publicField(this, "get", (placeholderValues) => {
          return this._prepare().get(placeholderValues);
        });
        __publicField(this, "values", (placeholderValues) => {
          return this._prepare().values(placeholderValues);
        });
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, withList };
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will delete only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be deleted.
       *
       * ```ts
       * // Delete all cars with green color
       * db.delete(cars).where(eq(cars.color, 'green'));
       * // or
       * db.delete(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Delete all BMW cars with a green color
       * db.delete(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Delete all cars with the green or blue color
       * db.delete(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.table[Table.Symbol.Columns],
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          this.config.orderBy = orderByArray;
        } else {
          const orderByArray = columns;
          this.config.orderBy = orderByArray;
        }
        return this;
      }
      limit(limit) {
        this.config.limit = limit;
        return this;
      }
      returning(fields = this.table[SQLiteTable.Symbol.Columns]) {
        this.config.returning = orderSelectedFields(fields);
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildDeleteQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(isOneTimeQuery = true) {
        return this.session[isOneTimeQuery ? "prepareOneTimeQuery" : "prepareQuery"](
          this.dialect.sqlToQuery(this.getSQL()),
          this.config.returning,
          this.config.returning ? "all" : "run",
          true,
          void 0,
          {
            type: "delete",
            tables: extractUsedTable4(this.config.table)
          }
        );
      }
      prepare() {
        return this._prepare(false);
      }
      async execute(placeholderValues) {
        return this._prepare().execute(placeholderValues);
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SQLiteDeleteBase, _a410, "SQLiteDelete");
  }
});

// ../drizzle-orm/dist/sqlite-core/view-base.js
var _a411, _b310, SQLiteViewBase;
var init_view_base3 = __esm({
  "../drizzle-orm/dist/sqlite-core/view-base.js"() {
    "use strict";
    init_entity();
    init_sql();
    SQLiteViewBase = class extends (_b310 = View, _a411 = entityKind, _b310) {
    };
    __publicField(SQLiteViewBase, _a411, "SQLiteViewBase");
  }
});

// ../drizzle-orm/dist/sqlite-core/dialect.js
var _a412, SQLiteDialect, _a413, _b311, SQLiteSyncDialect, _a414, _b312, SQLiteAsyncDialect;
var init_dialect4 = __esm({
  "../drizzle-orm/dist/sqlite-core/dialect.js"() {
    "use strict";
    init_alias();
    init_casing();
    init_column();
    init_entity();
    init_errors();
    init_relations();
    init_sql2();
    init_sql();
    init_columns4();
    init_table5();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_view_base3();
    _a412 = entityKind;
    SQLiteDialect = class {
      constructor(config) {
        /** @internal */
        __publicField(this, "casing");
        this.casing = new CasingCache(config?.casing);
      }
      escapeName(name3) {
        return `"${name3}"`;
      }
      escapeParam(_num) {
        return "?";
      }
      escapeString(str) {
        return `'${str.replace(/'/g, "''")}'`;
      }
      buildWithCTE(queries) {
        if (!queries?.length) return void 0;
        const withSqlChunks = [sql`with `];
        for (const [i8, w10] of queries.entries()) {
          withSqlChunks.push(sql`${sql.identifier(w10._.alias)} as (${w10._.sql})`);
          if (i8 < queries.length - 1) {
            withSqlChunks.push(sql`, `);
          }
        }
        withSqlChunks.push(sql` `);
        return sql.join(withSqlChunks);
      }
      buildDeleteQuery({ table: table6, where, returning, withList, limit, orderBy }) {
        const withSql = this.buildWithCTE(withList);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        return sql`${withSql}delete from ${table6}${whereSql}${returningSql}${orderBySql}${limitSql}`;
      }
      buildUpdateSet(table6, set) {
        const tableColumns = table6[Table.Symbol.Columns];
        const columnNames = Object.keys(tableColumns).filter(
          (colName) => set[colName] !== void 0 || tableColumns[colName]?.onUpdateFn !== void 0
        );
        const setSize = columnNames.length;
        return sql.join(columnNames.flatMap((colName, i8) => {
          const col = tableColumns[colName];
          const value = set[colName] ?? sql.param(col.onUpdateFn(), col);
          const res = sql`${sql.identifier(this.casing.getColumnCasing(col))} = ${value}`;
          if (i8 < setSize - 1) {
            return [res, sql.raw(", ")];
          }
          return [res];
        }));
      }
      buildUpdateQuery({ table: table6, set, where, returning, withList, joins, from, limit, orderBy }) {
        const withSql = this.buildWithCTE(withList);
        const setSql = this.buildUpdateSet(table6, set);
        const fromSql = from && sql.join([sql.raw(" from "), this.buildFromTable(from)]);
        const joinsSql = this.buildJoins(joins);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const whereSql = where ? sql` where ${where}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        return sql`${withSql}update ${table6} set ${setSql}${fromSql}${joinsSql}${whereSql}${returningSql}${orderBySql}${limitSql}`;
      }
      /**
       * Builds selection SQL with provided fields/expressions
       *
       * Examples:
       *
       * `select <selection> from`
       *
       * `insert ... returning <selection>`
       *
       * If `isSingleTable` is true, then columns won't be prefixed with table name
       */
      buildSelection(fields, { isSingleTable = false } = {}) {
        const columnsLen = fields.length;
        const chunks = fields.flatMap(({ field }, i8) => {
          const chunk = [];
          if (is(field, SQL.Aliased) && field.isSelectionField) {
            chunk.push(sql.identifier(field.fieldAlias));
          } else if (is(field, SQL.Aliased) || is(field, SQL)) {
            const query = is(field, SQL.Aliased) ? field.sql : field;
            if (isSingleTable) {
              chunk.push(
                new SQL(
                  query.queryChunks.map((c6) => {
                    if (is(c6, Column)) {
                      return sql.identifier(this.casing.getColumnCasing(c6));
                    }
                    return c6;
                  })
                )
              );
            } else {
              chunk.push(query);
            }
            if (is(field, SQL.Aliased)) {
              chunk.push(sql` as ${sql.identifier(field.fieldAlias)}`);
            }
          } else if (is(field, Column)) {
            const tableName = field.table[Table.Symbol.Name];
            if (field.columnType === "SQLiteNumericBigInt") {
              if (isSingleTable) {
                chunk.push(sql`cast(${sql.identifier(this.casing.getColumnCasing(field))} as text)`);
              } else {
                chunk.push(
                  sql`cast(${sql.identifier(tableName)}.${sql.identifier(this.casing.getColumnCasing(field))} as text)`
                );
              }
            } else {
              if (isSingleTable) {
                chunk.push(sql.identifier(this.casing.getColumnCasing(field)));
              } else {
                chunk.push(sql`${sql.identifier(tableName)}.${sql.identifier(this.casing.getColumnCasing(field))}`);
              }
            }
          }
          if (i8 < columnsLen - 1) {
            chunk.push(sql`, `);
          }
          return chunk;
        });
        return sql.join(chunks);
      }
      buildJoins(joins) {
        if (!joins || joins.length === 0) {
          return void 0;
        }
        const joinsArray = [];
        if (joins) {
          for (const [index7, joinMeta] of joins.entries()) {
            if (index7 === 0) {
              joinsArray.push(sql` `);
            }
            const table6 = joinMeta.table;
            const onSql = joinMeta.on ? sql` on ${joinMeta.on}` : void 0;
            if (is(table6, SQLiteTable)) {
              const tableName = table6[SQLiteTable.Symbol.Name];
              const tableSchema = table6[SQLiteTable.Symbol.Schema];
              const origTableName = table6[SQLiteTable.Symbol.OriginalName];
              const alias2 = tableName === origTableName ? void 0 : joinMeta.alias;
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join ${tableSchema ? sql`${sql.identifier(tableSchema)}.` : void 0}${sql.identifier(origTableName)}${alias2 && sql` ${sql.identifier(alias2)}`}${onSql}`
              );
            } else {
              joinsArray.push(
                sql`${sql.raw(joinMeta.joinType)} join ${table6}${onSql}`
              );
            }
            if (index7 < joins.length - 1) {
              joinsArray.push(sql` `);
            }
          }
        }
        return sql.join(joinsArray);
      }
      buildLimit(limit) {
        return typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
      }
      buildOrderBy(orderBy) {
        const orderByList = [];
        if (orderBy) {
          for (const [index7, orderByValue] of orderBy.entries()) {
            orderByList.push(orderByValue);
            if (index7 < orderBy.length - 1) {
              orderByList.push(sql`, `);
            }
          }
        }
        return orderByList.length > 0 ? sql` order by ${sql.join(orderByList)}` : void 0;
      }
      buildFromTable(table6) {
        if (is(table6, Table) && table6[Table.Symbol.IsAlias]) {
          return sql`${sql`${sql.identifier(table6[Table.Symbol.Schema] ?? "")}.`.if(table6[Table.Symbol.Schema])}${sql.identifier(table6[Table.Symbol.OriginalName])} ${sql.identifier(table6[Table.Symbol.Name])}`;
        }
        return table6;
      }
      buildSelectQuery({
        withList,
        fields,
        fieldsFlat,
        where,
        having,
        table: table6,
        joins,
        orderBy,
        groupBy,
        limit,
        offset,
        distinct,
        setOperators
      }) {
        const fieldsList = fieldsFlat ?? orderSelectedFields(fields);
        for (const f9 of fieldsList) {
          if (is(f9.field, Column) && getTableName(f9.field.table) !== (is(table6, Subquery) ? table6._.alias : is(table6, SQLiteViewBase) ? table6[ViewBaseConfig].name : is(table6, SQL) ? void 0 : getTableName(table6)) && !((table22) => joins?.some(
            ({ alias: alias2 }) => alias2 === (table22[Table.Symbol.IsAlias] ? getTableName(table22) : table22[Table.Symbol.BaseName])
          ))(f9.field.table)) {
            const tableName = getTableName(f9.field.table);
            throw new Error(
              `Your "${f9.path.join("->")}" field references a column "${tableName}"."${f9.field.name}", but the table "${tableName}" is not part of the query! Did you forget to join it?`
            );
          }
        }
        const isSingleTable = !joins || joins.length === 0;
        const withSql = this.buildWithCTE(withList);
        const distinctSql = distinct ? sql` distinct` : void 0;
        const selection = this.buildSelection(fieldsList, { isSingleTable });
        const tableSql = this.buildFromTable(table6);
        const joinsSql = this.buildJoins(joins);
        const whereSql = where ? sql` where ${where}` : void 0;
        const havingSql = having ? sql` having ${having}` : void 0;
        const groupByList = [];
        if (groupBy) {
          for (const [index7, groupByValue] of groupBy.entries()) {
            groupByList.push(groupByValue);
            if (index7 < groupBy.length - 1) {
              groupByList.push(sql`, `);
            }
          }
        }
        const groupBySql = groupByList.length > 0 ? sql` group by ${sql.join(groupByList)}` : void 0;
        const orderBySql = this.buildOrderBy(orderBy);
        const limitSql = this.buildLimit(limit);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        const finalQuery = sql`${withSql}select${distinctSql} ${selection} from ${tableSql}${joinsSql}${whereSql}${groupBySql}${havingSql}${orderBySql}${limitSql}${offsetSql}`;
        if (setOperators.length > 0) {
          return this.buildSetOperations(finalQuery, setOperators);
        }
        return finalQuery;
      }
      buildSetOperations(leftSelect, setOperators) {
        const [setOperator, ...rest] = setOperators;
        if (!setOperator) {
          throw new Error("Cannot pass undefined values to any set operator");
        }
        if (rest.length === 0) {
          return this.buildSetOperationQuery({ leftSelect, setOperator });
        }
        return this.buildSetOperations(
          this.buildSetOperationQuery({ leftSelect, setOperator }),
          rest
        );
      }
      buildSetOperationQuery({
        leftSelect,
        setOperator: { type, isAll, rightSelect, limit, orderBy, offset }
      }) {
        const leftChunk = sql`${leftSelect.getSQL()} `;
        const rightChunk = sql`${rightSelect.getSQL()}`;
        let orderBySql;
        if (orderBy && orderBy.length > 0) {
          const orderByValues = [];
          for (const singleOrderBy of orderBy) {
            if (is(singleOrderBy, SQLiteColumn)) {
              orderByValues.push(sql.identifier(singleOrderBy.name));
            } else if (is(singleOrderBy, SQL)) {
              for (let i8 = 0; i8 < singleOrderBy.queryChunks.length; i8++) {
                const chunk = singleOrderBy.queryChunks[i8];
                if (is(chunk, SQLiteColumn)) {
                  singleOrderBy.queryChunks[i8] = sql.identifier(this.casing.getColumnCasing(chunk));
                }
              }
              orderByValues.push(sql`${singleOrderBy}`);
            } else {
              orderByValues.push(sql`${singleOrderBy}`);
            }
          }
          orderBySql = sql` order by ${sql.join(orderByValues, sql`, `)}`;
        }
        const limitSql = typeof limit === "object" || typeof limit === "number" && limit >= 0 ? sql` limit ${limit}` : void 0;
        const operatorChunk = sql.raw(`${type} ${isAll ? "all " : ""}`);
        const offsetSql = offset ? sql` offset ${offset}` : void 0;
        return sql`${leftChunk}${operatorChunk}${rightChunk}${orderBySql}${limitSql}${offsetSql}`;
      }
      buildInsertQuery({ table: table6, values: valuesOrSelect, onConflict, returning, withList, select: select2 }) {
        const valuesSqlList = [];
        const columns = table6[Table.Symbol.Columns];
        const colEntries = Object.entries(columns).filter(
          ([_7, col]) => !col.shouldDisableInsert()
        );
        const insertOrder = colEntries.map(([, column6]) => sql.identifier(this.casing.getColumnCasing(column6)));
        if (select2) {
          const select22 = valuesOrSelect;
          if (is(select22, SQL)) {
            valuesSqlList.push(select22);
          } else {
            valuesSqlList.push(select22.getSQL());
          }
        } else {
          const values2 = valuesOrSelect;
          valuesSqlList.push(sql.raw("values "));
          for (const [valueIndex, value] of values2.entries()) {
            const valueList = [];
            for (const [fieldName, col] of colEntries) {
              const colValue = value[fieldName];
              if (colValue === void 0 || is(colValue, Param) && colValue.value === void 0) {
                let defaultValue;
                if (col.default !== null && col.default !== void 0) {
                  defaultValue = is(col.default, SQL) ? col.default : sql.param(col.default, col);
                } else if (col.defaultFn !== void 0) {
                  const defaultFnResult = col.defaultFn();
                  defaultValue = is(defaultFnResult, SQL) ? defaultFnResult : sql.param(defaultFnResult, col);
                } else if (!col.default && col.onUpdateFn !== void 0) {
                  const onUpdateFnResult = col.onUpdateFn();
                  defaultValue = is(onUpdateFnResult, SQL) ? onUpdateFnResult : sql.param(onUpdateFnResult, col);
                } else {
                  defaultValue = sql`null`;
                }
                valueList.push(defaultValue);
              } else {
                valueList.push(colValue);
              }
            }
            valuesSqlList.push(valueList);
            if (valueIndex < values2.length - 1) {
              valuesSqlList.push(sql`, `);
            }
          }
        }
        const withSql = this.buildWithCTE(withList);
        const valuesSql = sql.join(valuesSqlList);
        const returningSql = returning ? sql` returning ${this.buildSelection(returning, { isSingleTable: true })}` : void 0;
        const onConflictSql = onConflict?.length ? sql.join(onConflict) : void 0;
        return sql`${withSql}insert into ${table6} ${insertOrder} ${valuesSql}${onConflictSql}${returningSql}`;
      }
      sqlToQuery(sql22, invokeSource) {
        return sql22.toQuery({
          casing: this.casing,
          escapeName: this.escapeName,
          escapeParam: this.escapeParam,
          escapeString: this.escapeString,
          invokeSource
        });
      }
      buildRelationalQuery({
        fullSchema,
        schema: schema6,
        tableNamesMap,
        table: table6,
        tableConfig,
        queryConfig: config,
        tableAlias,
        nestedQueryRelation,
        joinOn
      }) {
        let selection = [];
        let limit, offset, orderBy = [], where;
        const joins = [];
        if (config === true) {
          const selectionEntries = Object.entries(tableConfig.columns);
          selection = selectionEntries.map(([key, value]) => ({
            dbKey: value.name,
            tsKey: key,
            field: aliasedTableColumn(value, tableAlias),
            relationTableTsKey: void 0,
            isJson: false,
            selection: []
          }));
        } else {
          const aliasedColumns = Object.fromEntries(
            Object.entries(tableConfig.columns).map(([key, value]) => [key, aliasedTableColumn(value, tableAlias)])
          );
          if (config.where) {
            const whereSql = typeof config.where === "function" ? config.where(aliasedColumns, getOperators()) : config.where;
            where = whereSql && mapColumnsInSQLToAlias(whereSql, tableAlias);
          }
          const fieldsSelection = [];
          let selectedColumns = [];
          if (config.columns) {
            let isIncludeMode = false;
            for (const [field, value] of Object.entries(config.columns)) {
              if (value === void 0) {
                continue;
              }
              if (field in tableConfig.columns) {
                if (!isIncludeMode && value === true) {
                  isIncludeMode = true;
                }
                selectedColumns.push(field);
              }
            }
            if (selectedColumns.length > 0) {
              selectedColumns = isIncludeMode ? selectedColumns.filter((c6) => config.columns?.[c6] === true) : Object.keys(tableConfig.columns).filter((key) => !selectedColumns.includes(key));
            }
          } else {
            selectedColumns = Object.keys(tableConfig.columns);
          }
          for (const field of selectedColumns) {
            const column6 = tableConfig.columns[field];
            fieldsSelection.push({ tsKey: field, value: column6 });
          }
          let selectedRelations = [];
          if (config.with) {
            selectedRelations = Object.entries(config.with).filter((entry) => !!entry[1]).map(([tsKey, queryConfig]) => ({ tsKey, queryConfig, relation: tableConfig.relations[tsKey] }));
          }
          let extras;
          if (config.extras) {
            extras = typeof config.extras === "function" ? config.extras(aliasedColumns, { sql }) : config.extras;
            for (const [tsKey, value] of Object.entries(extras)) {
              fieldsSelection.push({
                tsKey,
                value: mapColumnsInAliasedSQLToAlias(value, tableAlias)
              });
            }
          }
          for (const { tsKey, value } of fieldsSelection) {
            selection.push({
              dbKey: is(value, SQL.Aliased) ? value.fieldAlias : tableConfig.columns[tsKey].name,
              tsKey,
              field: is(value, Column) ? aliasedTableColumn(value, tableAlias) : value,
              relationTableTsKey: void 0,
              isJson: false,
              selection: []
            });
          }
          let orderByOrig = typeof config.orderBy === "function" ? config.orderBy(aliasedColumns, getOrderByOperators()) : config.orderBy ?? [];
          if (!Array.isArray(orderByOrig)) {
            orderByOrig = [orderByOrig];
          }
          orderBy = orderByOrig.map((orderByValue) => {
            if (is(orderByValue, Column)) {
              return aliasedTableColumn(orderByValue, tableAlias);
            }
            return mapColumnsInSQLToAlias(orderByValue, tableAlias);
          });
          limit = config.limit;
          offset = config.offset;
          for (const {
            tsKey: selectedRelationTsKey,
            queryConfig: selectedRelationConfigValue,
            relation
          } of selectedRelations) {
            const normalizedRelation = normalizeRelation(schema6, tableNamesMap, relation);
            const relationTableName = getTableUniqueName(relation.referencedTable);
            const relationTableTsName = tableNamesMap[relationTableName];
            const relationTableAlias = `${tableAlias}_${selectedRelationTsKey}`;
            const joinOn2 = and(
              ...normalizedRelation.fields.map(
                (field2, i8) => eq(
                  aliasedTableColumn(normalizedRelation.references[i8], relationTableAlias),
                  aliasedTableColumn(field2, tableAlias)
                )
              )
            );
            const builtRelation = this.buildRelationalQuery({
              fullSchema,
              schema: schema6,
              tableNamesMap,
              table: fullSchema[relationTableTsName],
              tableConfig: schema6[relationTableTsName],
              queryConfig: is(relation, One) ? selectedRelationConfigValue === true ? { limit: 1 } : { ...selectedRelationConfigValue, limit: 1 } : selectedRelationConfigValue,
              tableAlias: relationTableAlias,
              joinOn: joinOn2,
              nestedQueryRelation: relation
            });
            const field = sql`(${builtRelation.sql})`.as(selectedRelationTsKey);
            selection.push({
              dbKey: selectedRelationTsKey,
              tsKey: selectedRelationTsKey,
              field,
              relationTableTsKey: relationTableTsName,
              isJson: true,
              selection: builtRelation.selection
            });
          }
        }
        if (selection.length === 0) {
          throw new DrizzleError({
            message: `No fields selected for table "${tableConfig.tsName}" ("${tableAlias}"). You need to have at least one item in "columns", "with" or "extras". If you need to select all columns, omit the "columns" key or set it to undefined.`
          });
        }
        let result;
        where = and(joinOn, where);
        if (nestedQueryRelation) {
          let field = sql`json_array(${sql.join(
            selection.map(
              ({ field: field2 }) => is(field2, SQLiteColumn) ? sql.identifier(this.casing.getColumnCasing(field2)) : is(field2, SQL.Aliased) ? field2.sql : field2
            ),
            sql`, `
          )})`;
          if (is(nestedQueryRelation, Many)) {
            field = sql`coalesce(json_group_array(${field}), json_array())`;
          }
          const nestedSelection = [{
            dbKey: "data",
            tsKey: "data",
            field: field.as("data"),
            isJson: true,
            relationTableTsKey: tableConfig.tsName,
            selection
          }];
          const needsSubquery = limit !== void 0 || offset !== void 0 || orderBy.length > 0;
          if (needsSubquery) {
            result = this.buildSelectQuery({
              table: aliasedTable(table6, tableAlias),
              fields: {},
              fieldsFlat: [
                {
                  path: [],
                  field: sql.raw("*")
                }
              ],
              where,
              limit,
              offset,
              orderBy,
              setOperators: []
            });
            where = void 0;
            limit = void 0;
            offset = void 0;
            orderBy = void 0;
          } else {
            result = aliasedTable(table6, tableAlias);
          }
          result = this.buildSelectQuery({
            table: is(result, SQLiteTable) ? result : new Subquery(result, {}, tableAlias),
            fields: {},
            fieldsFlat: nestedSelection.map(({ field: field2 }) => ({
              path: [],
              field: is(field2, Column) ? aliasedTableColumn(field2, tableAlias) : field2
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        } else {
          result = this.buildSelectQuery({
            table: aliasedTable(table6, tableAlias),
            fields: {},
            fieldsFlat: selection.map(({ field }) => ({
              path: [],
              field: is(field, Column) ? aliasedTableColumn(field, tableAlias) : field
            })),
            joins,
            where,
            limit,
            offset,
            orderBy,
            setOperators: []
          });
        }
        return {
          tableTsKey: tableConfig.tsName,
          sql: result,
          selection
        };
      }
    };
    __publicField(SQLiteDialect, _a412, "SQLiteDialect");
    SQLiteSyncDialect = class extends (_b311 = SQLiteDialect, _a413 = entityKind, _b311) {
      migrate(migrations, session, config) {
        const migrationsTable = config === void 0 ? "__drizzle_migrations" : typeof config === "string" ? "__drizzle_migrations" : config.migrationsTable ?? "__drizzle_migrations";
        const migrationTableCreate = sql`
			CREATE TABLE IF NOT EXISTS ${sql.identifier(migrationsTable)} (
				id SERIAL PRIMARY KEY,
				hash text NOT NULL,
				created_at numeric
			)
		`;
        session.run(migrationTableCreate);
        const dbMigrations = session.values(
          sql`SELECT id, hash, created_at FROM ${sql.identifier(migrationsTable)} ORDER BY created_at DESC LIMIT 1`
        );
        const lastDbMigration = dbMigrations[0] ?? void 0;
        session.run(sql`BEGIN`);
        try {
          for (const migration of migrations) {
            if (!lastDbMigration || Number(lastDbMigration[2]) < migration.folderMillis) {
              for (const stmt of migration.sql) {
                session.run(sql.raw(stmt));
              }
              session.run(
                sql`INSERT INTO ${sql.identifier(migrationsTable)} ("hash", "created_at") VALUES(${migration.hash}, ${migration.folderMillis})`
              );
            }
          }
          session.run(sql`COMMIT`);
        } catch (e6) {
          session.run(sql`ROLLBACK`);
          throw e6;
        }
      }
    };
    __publicField(SQLiteSyncDialect, _a413, "SQLiteSyncDialect");
    SQLiteAsyncDialect = class extends (_b312 = SQLiteDialect, _a414 = entityKind, _b312) {
      async migrate(migrations, session, config) {
        const migrationsTable = config === void 0 ? "__drizzle_migrations" : typeof config === "string" ? "__drizzle_migrations" : config.migrationsTable ?? "__drizzle_migrations";
        const migrationTableCreate = sql`
			CREATE TABLE IF NOT EXISTS ${sql.identifier(migrationsTable)} (
				id SERIAL PRIMARY KEY,
				hash text NOT NULL,
				created_at numeric
			)
		`;
        await session.run(migrationTableCreate);
        const dbMigrations = await session.values(
          sql`SELECT id, hash, created_at FROM ${sql.identifier(migrationsTable)} ORDER BY created_at DESC LIMIT 1`
        );
        const lastDbMigration = dbMigrations[0] ?? void 0;
        await session.transaction(async (tx) => {
          for (const migration of migrations) {
            if (!lastDbMigration || Number(lastDbMigration[2]) < migration.folderMillis) {
              for (const stmt of migration.sql) {
                await tx.run(sql.raw(stmt));
              }
              await tx.run(
                sql`INSERT INTO ${sql.identifier(migrationsTable)} ("hash", "created_at") VALUES(${migration.hash}, ${migration.folderMillis})`
              );
            }
          }
        });
      }
    };
    __publicField(SQLiteAsyncDialect, _a414, "SQLiteAsyncDialect");
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/select.js
function createSetOperator4(type, isAll) {
  return (leftSelect, rightSelect, ...restSelects) => {
    const setOperators = [rightSelect, ...restSelects].map((select2) => ({
      type,
      isAll,
      rightSelect: select2
    }));
    for (const setOperator of setOperators) {
      if (!haveSameKeys(leftSelect.getSelectedFields(), setOperator.rightSelect.getSelectedFields())) {
        throw new Error(
          "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
        );
      }
    }
    return leftSelect.addSetOperators(setOperators);
  };
}
var _a415, SQLiteSelectBuilder, _a416, _b313, SQLiteSelectQueryBuilderBase, _a417, _b314, SQLiteSelectBase, getSQLiteSetOperators, union4, unionAll4, intersect4, except4;
var init_select5 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/select.js"() {
    "use strict";
    init_entity();
    init_query_builder();
    init_query_promise();
    init_selection_proxy();
    init_sql();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_utils7();
    init_view_base3();
    _a415 = entityKind;
    SQLiteSelectBuilder = class {
      constructor(config) {
        __publicField(this, "fields");
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "withList");
        __publicField(this, "distinct");
        this.fields = config.fields;
        this.session = config.session;
        this.dialect = config.dialect;
        this.withList = config.withList;
        this.distinct = config.distinct;
      }
      from(source) {
        const isPartialSelect = !!this.fields;
        let fields;
        if (this.fields) {
          fields = this.fields;
        } else if (is(source, Subquery)) {
          fields = Object.fromEntries(
            Object.keys(source._.selectedFields).map((key) => [key, source[key]])
          );
        } else if (is(source, SQLiteViewBase)) {
          fields = source[ViewBaseConfig].selectedFields;
        } else if (is(source, SQL)) {
          fields = {};
        } else {
          fields = getTableColumns(source);
        }
        return new SQLiteSelectBase({
          table: source,
          fields,
          isPartialSelect,
          session: this.session,
          dialect: this.dialect,
          withList: this.withList,
          distinct: this.distinct
        });
      }
    };
    __publicField(SQLiteSelectBuilder, _a415, "SQLiteSelectBuilder");
    SQLiteSelectQueryBuilderBase = class extends (_b313 = TypedQueryBuilder, _a416 = entityKind, _b313) {
      constructor({ table: table6, fields, isPartialSelect, session, dialect: dialect6, withList, distinct }) {
        super();
        __publicField(this, "_");
        /** @internal */
        __publicField(this, "config");
        __publicField(this, "joinsNotNullableMap");
        __publicField(this, "tableName");
        __publicField(this, "isPartialSelect");
        __publicField(this, "session");
        __publicField(this, "dialect");
        __publicField(this, "cacheConfig");
        __publicField(this, "usedTables", /* @__PURE__ */ new Set());
        /**
         * Executes a `left join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the table with the corresponding row from the joined table, if a match is found. If no matching row exists, it sets all columns of the joined table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#left-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .leftJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "leftJoin", this.createJoin("left"));
        /**
         * Executes a `right join` operation by adding another table to the current query.
         *
         * Calling this method associates each row of the joined table with the corresponding row from the main table, if a match is found. If no matching row exists, it sets all columns of the main table to null.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#right-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .rightJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "rightJoin", this.createJoin("right"));
        /**
         * Executes an `inner join` operation, creating a new table by combining rows from two tables that have matching values.
         *
         * Calling this method retrieves rows that have corresponding entries in both joined tables. Rows without matching entries in either table are excluded, resulting in a table that includes only matching pairs.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#inner-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .innerJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "innerJoin", this.createJoin("inner"));
        /**
         * Executes a `full join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging rows with matching values and filling in `null` for non-matching columns.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#full-join}
         *
         * @param table the table to join.
         * @param on the `on` clause.
         *
         * @example
         *
         * ```ts
         * // Select all users and their pets
         * const usersWithPets: { user: User | null; pets: Pet | null; }[] = await db.select()
         *   .from(users)
         *   .fullJoin(pets, eq(users.id, pets.ownerId))
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number | null; petId: number | null; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .fullJoin(pets, eq(users.id, pets.ownerId))
         * ```
         */
        __publicField(this, "fullJoin", this.createJoin("full"));
        /**
         * Executes a `cross join` operation by combining rows from two tables into a new table.
         *
         * Calling this method retrieves all rows from both main and joined tables, merging all rows from each table.
         *
         * See docs: {@link https://orm.drizzle.team/docs/joins#cross-join}
         *
         * @param table the table to join.
         *
         * @example
         *
         * ```ts
         * // Select all users, each user with every pet
         * const usersWithPets: { user: User; pets: Pet; }[] = await db.select()
         *   .from(users)
         *   .crossJoin(pets)
         *
         * // Select userId and petId
         * const usersIdsAndPetIds: { userId: number; petId: number; }[] = await db.select({
         *   userId: users.id,
         *   petId: pets.id,
         * })
         *   .from(users)
         *   .crossJoin(pets)
         * ```
         */
        __publicField(this, "crossJoin", this.createJoin("cross"));
        /**
         * Adds `union` set operator to the query.
         *
         * Calling this method will combine the result sets of the `select` statements and remove any duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union}
         *
         * @example
         *
         * ```ts
         * // Select all unique names from customers and users tables
         * await db.select({ name: users.name })
         *   .from(users)
         *   .union(
         *     db.select({ name: customers.name }).from(customers)
         *   );
         * // or
         * import { union } from 'drizzle-orm/sqlite-core'
         *
         * await union(
         *   db.select({ name: users.name }).from(users),
         *   db.select({ name: customers.name }).from(customers)
         * );
         * ```
         */
        __publicField(this, "union", this.createSetOperator("union", false));
        /**
         * Adds `union all` set operator to the query.
         *
         * Calling this method will combine the result-set of the `select` statements and keep all duplicate rows that appear across them.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#union-all}
         *
         * @example
         *
         * ```ts
         * // Select all transaction ids from both online and in-store sales
         * await db.select({ transaction: onlineSales.transactionId })
         *   .from(onlineSales)
         *   .unionAll(
         *     db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         *   );
         * // or
         * import { unionAll } from 'drizzle-orm/sqlite-core'
         *
         * await unionAll(
         *   db.select({ transaction: onlineSales.transactionId }).from(onlineSales),
         *   db.select({ transaction: inStoreSales.transactionId }).from(inStoreSales)
         * );
         * ```
         */
        __publicField(this, "unionAll", this.createSetOperator("union", true));
        /**
         * Adds `intersect` set operator to the query.
         *
         * Calling this method will retain only the rows that are present in both result sets and eliminate duplicates.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#intersect}
         *
         * @example
         *
         * ```ts
         * // Select course names that are offered in both departments A and B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .intersect(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { intersect } from 'drizzle-orm/sqlite-core'
         *
         * await intersect(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "intersect", this.createSetOperator("intersect", false));
        /**
         * Adds `except` set operator to the query.
         *
         * Calling this method will retrieve all unique rows from the left query, except for the rows that are present in the result set of the right query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/set-operations#except}
         *
         * @example
         *
         * ```ts
         * // Select all courses offered in department A but not in department B
         * await db.select({ courseName: depA.courseName })
         *   .from(depA)
         *   .except(
         *     db.select({ courseName: depB.courseName }).from(depB)
         *   );
         * // or
         * import { except } from 'drizzle-orm/sqlite-core'
         *
         * await except(
         *   db.select({ courseName: depA.courseName }).from(depA),
         *   db.select({ courseName: depB.courseName }).from(depB)
         * );
         * ```
         */
        __publicField(this, "except", this.createSetOperator("except", false));
        this.config = {
          withList,
          table: table6,
          fields: { ...fields },
          distinct,
          setOperators: []
        };
        this.isPartialSelect = isPartialSelect;
        this.session = session;
        this.dialect = dialect6;
        this._ = {
          selectedFields: fields,
          config: this.config
        };
        this.tableName = getTableLikeName(table6);
        this.joinsNotNullableMap = typeof this.tableName === "string" ? { [this.tableName]: true } : {};
        for (const item of extractUsedTable4(table6)) this.usedTables.add(item);
      }
      /** @internal */
      getUsedTables() {
        return [...this.usedTables];
      }
      createJoin(joinType) {
        return (table6, on3) => {
          const baseTableName = this.tableName;
          const tableName = getTableLikeName(table6);
          for (const item of extractUsedTable4(table6)) this.usedTables.add(item);
          if (typeof tableName === "string" && this.config.joins?.some((join7) => join7.alias === tableName)) {
            throw new Error(`Alias "${tableName}" is already used in this query`);
          }
          if (!this.isPartialSelect) {
            if (Object.keys(this.joinsNotNullableMap).length === 1 && typeof baseTableName === "string") {
              this.config.fields = {
                [baseTableName]: this.config.fields
              };
            }
            if (typeof tableName === "string" && !is(table6, SQL)) {
              const selection = is(table6, Subquery) ? table6._.selectedFields : is(table6, View) ? table6[ViewBaseConfig].selectedFields : table6[Table.Symbol.Columns];
              this.config.fields[tableName] = selection;
            }
          }
          if (typeof on3 === "function") {
            on3 = on3(
              new Proxy(
                this.config.fields,
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              )
            );
          }
          if (!this.config.joins) {
            this.config.joins = [];
          }
          this.config.joins.push({ on: on3, table: table6, joinType, alias: tableName });
          if (typeof tableName === "string") {
            switch (joinType) {
              case "left": {
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
              case "right": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "cross":
              case "inner": {
                this.joinsNotNullableMap[tableName] = true;
                break;
              }
              case "full": {
                this.joinsNotNullableMap = Object.fromEntries(
                  Object.entries(this.joinsNotNullableMap).map(([key]) => [key, false])
                );
                this.joinsNotNullableMap[tableName] = false;
                break;
              }
            }
          }
          return this;
        };
      }
      createSetOperator(type, isAll) {
        return (rightSelection) => {
          const rightSelect = typeof rightSelection === "function" ? rightSelection(getSQLiteSetOperators()) : rightSelection;
          if (!haveSameKeys(this.getSelectedFields(), rightSelect.getSelectedFields())) {
            throw new Error(
              "Set operator error (union / intersect / except): selected fields are not the same or are in a different order"
            );
          }
          this.config.setOperators.push({ type, isAll, rightSelect });
          return this;
        };
      }
      /** @internal */
      addSetOperators(setOperators) {
        this.config.setOperators.push(...setOperators);
        return this;
      }
      /**
       * Adds a `where` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#filtering}
       *
       * @param where the `where` clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be selected.
       *
       * ```ts
       * // Select all cars with green color
       * await db.select().from(cars).where(eq(cars.color, 'green'));
       * // or
       * await db.select().from(cars).where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Select all BMW cars with a green color
       * await db.select().from(cars).where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Select all cars with the green or blue color
       * await db.select().from(cars).where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        if (typeof where === "function") {
          where = where(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.where = where;
        return this;
      }
      /**
       * Adds a `having` clause to the query.
       *
       * Calling this method will select only those rows that fulfill a specified condition. It is typically used with aggregate functions to filter the aggregated data based on a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#aggregations}
       *
       * @param having the `having` clause.
       *
       * @example
       *
       * ```ts
       * // Select all brands with more than one car
       * await db.select({
       * 	brand: cars.brand,
       * 	count: sql<number>`cast(count(${cars.id}) as int)`,
       * })
       *   .from(cars)
       *   .groupBy(cars.brand)
       *   .having(({ count }) => gt(count, 1));
       * ```
       */
      having(having) {
        if (typeof having === "function") {
          having = having(
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
            )
          );
        }
        this.config.having = having;
        return this;
      }
      groupBy(...columns) {
        if (typeof columns[0] === "function") {
          const groupBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          this.config.groupBy = Array.isArray(groupBy) ? groupBy : [groupBy];
        } else {
          this.config.groupBy = columns;
        }
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.fields,
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        } else {
          const orderByArray = columns;
          if (this.config.setOperators.length > 0) {
            this.config.setOperators.at(-1).orderBy = orderByArray;
          } else {
            this.config.orderBy = orderByArray;
          }
        }
        return this;
      }
      /**
       * Adds a `limit` clause to the query.
       *
       * Calling this method will set the maximum number of rows that will be returned by this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param limit the `limit` clause.
       *
       * @example
       *
       * ```ts
       * // Get the first 10 people from this query.
       * await db.select().from(people).limit(10);
       * ```
       */
      limit(limit) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).limit = limit;
        } else {
          this.config.limit = limit;
        }
        return this;
      }
      /**
       * Adds an `offset` clause to the query.
       *
       * Calling this method will skip a number of rows when returning results from this query.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#limit--offset}
       *
       * @param offset the `offset` clause.
       *
       * @example
       *
       * ```ts
       * // Get the 10th-20th people from this query.
       * await db.select().from(people).offset(10).limit(10);
       * ```
       */
      offset(offset) {
        if (this.config.setOperators.length > 0) {
          this.config.setOperators.at(-1).offset = offset;
        } else {
          this.config.offset = offset;
        }
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildSelectQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      as(alias2) {
        const usedTables = [];
        usedTables.push(...extractUsedTable4(this.config.table));
        if (this.config.joins) {
          for (const it2 of this.config.joins) usedTables.push(...extractUsedTable4(it2.table));
        }
        return new Proxy(
          new Subquery(this.getSQL(), this.config.fields, alias2, false, [...new Set(usedTables)]),
          new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      /** @internal */
      getSelectedFields() {
        return new Proxy(
          this.config.fields,
          new SelectionProxyHandler({ alias: this.tableName, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
        );
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SQLiteSelectQueryBuilderBase, _a416, "SQLiteSelectQueryBuilder");
    SQLiteSelectBase = class extends (_b314 = SQLiteSelectQueryBuilderBase, _a417 = entityKind, _b314) {
      constructor() {
        super(...arguments);
        __publicField(this, "run", (placeholderValues) => {
          return this._prepare().run(placeholderValues);
        });
        __publicField(this, "all", (placeholderValues) => {
          return this._prepare().all(placeholderValues);
        });
        __publicField(this, "get", (placeholderValues) => {
          return this._prepare().get(placeholderValues);
        });
        __publicField(this, "values", (placeholderValues) => {
          return this._prepare().values(placeholderValues);
        });
      }
      /** @internal */
      _prepare(isOneTimeQuery = true) {
        if (!this.session) {
          throw new Error("Cannot execute a query on a query builder. Please use a database instance instead.");
        }
        const fieldsList = orderSelectedFields(this.config.fields);
        const query = this.session[isOneTimeQuery ? "prepareOneTimeQuery" : "prepareQuery"](
          this.dialect.sqlToQuery(this.getSQL()),
          fieldsList,
          "all",
          true,
          void 0,
          {
            type: "select",
            tables: [...this.usedTables]
          },
          this.cacheConfig
        );
        query.joinsNotNullableMap = this.joinsNotNullableMap;
        return query;
      }
      $withCache(config) {
        this.cacheConfig = config === void 0 ? { config: {}, enable: true, autoInvalidate: true } : config === false ? { enable: false } : { enable: true, autoInvalidate: true, ...config };
        return this;
      }
      prepare() {
        return this._prepare(false);
      }
      async execute() {
        return this.all();
      }
    };
    __publicField(SQLiteSelectBase, _a417, "SQLiteSelect");
    applyMixins(SQLiteSelectBase, [QueryPromise]);
    getSQLiteSetOperators = () => ({
      union: union4,
      unionAll: unionAll4,
      intersect: intersect4,
      except: except4
    });
    union4 = createSetOperator4("union", false);
    unionAll4 = createSetOperator4("union", true);
    intersect4 = createSetOperator4("intersect", false);
    except4 = createSetOperator4("except", false);
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/query-builder.js
var _a418, QueryBuilder4;
var init_query_builder5 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/query-builder.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_dialect4();
    init_subquery();
    init_select5();
    _a418 = entityKind;
    QueryBuilder4 = class {
      constructor(dialect6) {
        __publicField(this, "dialect");
        __publicField(this, "dialectConfig");
        __publicField(this, "$with", (alias2, selection) => {
          const queryBuilder = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(queryBuilder);
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        this.dialect = is(dialect6, SQLiteDialect) ? dialect6 : void 0;
        this.dialectConfig = is(dialect6, SQLiteDialect) ? void 0 : dialect6;
      }
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new SQLiteSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new SQLiteSelectBuilder({
            fields: fields ?? void 0,
            session: void 0,
            dialect: self2.getDialect(),
            withList: queries,
            distinct: true
          });
        }
        return { select: select2, selectDistinct };
      }
      select(fields) {
        return new SQLiteSelectBuilder({ fields: fields ?? void 0, session: void 0, dialect: this.getDialect() });
      }
      selectDistinct(fields) {
        return new SQLiteSelectBuilder({
          fields: fields ?? void 0,
          session: void 0,
          dialect: this.getDialect(),
          distinct: true
        });
      }
      // Lazy load dialect to avoid circular dependency
      getDialect() {
        if (!this.dialect) {
          this.dialect = new SQLiteSyncDialect(this.dialectConfig);
        }
        return this.dialect;
      }
    };
    __publicField(QueryBuilder4, _a418, "SQLiteQueryBuilder");
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/insert.js
var _a419, SQLiteInsertBuilder, _a420, _b315, SQLiteInsertBase;
var init_insert4 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/insert.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_sql();
    init_table5();
    init_table();
    init_utils();
    init_utils7();
    init_query_builder5();
    _a419 = entityKind;
    SQLiteInsertBuilder = class {
      constructor(table6, session, dialect6, withList) {
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.withList = withList;
      }
      values(values2) {
        values2 = Array.isArray(values2) ? values2 : [values2];
        if (values2.length === 0) {
          throw new Error("values() must be called with at least one value");
        }
        const mappedValues = values2.map((entry) => {
          const result = {};
          const cols = this.table[Table.Symbol.Columns];
          for (const colKey of Object.keys(entry)) {
            const colValue = entry[colKey];
            result[colKey] = is(colValue, SQL) ? colValue : new Param(colValue, cols[colKey]);
          }
          return result;
        });
        return new SQLiteInsertBase(this.table, mappedValues, this.session, this.dialect, this.withList);
      }
      select(selectQuery) {
        const select2 = typeof selectQuery === "function" ? selectQuery(new QueryBuilder4()) : selectQuery;
        if (!is(select2, SQL) && !haveSameKeys(this.table[Columns], select2._.selectedFields)) {
          throw new Error(
            "Insert select error: selected fields are not the same or are in a different order compared to the table definition"
          );
        }
        return new SQLiteInsertBase(this.table, select2, this.session, this.dialect, this.withList, true);
      }
    };
    __publicField(SQLiteInsertBuilder, _a419, "SQLiteInsertBuilder");
    SQLiteInsertBase = class extends (_b315 = QueryPromise, _a420 = entityKind, _b315) {
      constructor(table6, values2, session, dialect6, withList, select2) {
        super();
        /** @internal */
        __publicField(this, "config");
        __publicField(this, "run", (placeholderValues) => {
          return this._prepare().run(placeholderValues);
        });
        __publicField(this, "all", (placeholderValues) => {
          return this._prepare().all(placeholderValues);
        });
        __publicField(this, "get", (placeholderValues) => {
          return this._prepare().get(placeholderValues);
        });
        __publicField(this, "values", (placeholderValues) => {
          return this._prepare().values(placeholderValues);
        });
        this.session = session;
        this.dialect = dialect6;
        this.config = { table: table6, values: values2, withList, select: select2 };
      }
      returning(fields = this.config.table[SQLiteTable.Symbol.Columns]) {
        this.config.returning = orderSelectedFields(fields);
        return this;
      }
      /**
       * Adds an `on conflict do nothing` clause to the query.
       *
       * Calling this method simply avoids inserting a row as its alternative action.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert#on-conflict-do-nothing}
       *
       * @param config The `target` and `where` clauses.
       *
       * @example
       * ```ts
       * // Insert one row and cancel the insert if there's a conflict
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoNothing();
       *
       * // Explicitly specify conflict target
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoNothing({ target: cars.id });
       * ```
       */
      onConflictDoNothing(config = {}) {
        if (!this.config.onConflict) this.config.onConflict = [];
        if (config.target === void 0) {
          this.config.onConflict.push(sql` on conflict do nothing`);
        } else {
          const targetSql = Array.isArray(config.target) ? sql`${config.target}` : sql`${[config.target]}`;
          const whereSql = config.where ? sql` where ${config.where}` : sql``;
          this.config.onConflict.push(sql` on conflict ${targetSql} do nothing${whereSql}`);
        }
        return this;
      }
      /**
       * Adds an `on conflict do update` clause to the query.
       *
       * Calling this method will update the existing row that conflicts with the row proposed for insertion as its alternative action.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert#upserts-and-conflicts}
       *
       * @param config The `target`, `set` and `where` clauses.
       *
       * @example
       * ```ts
       * // Update the row if there's a conflict
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoUpdate({
       *     target: cars.id,
       *     set: { brand: 'Porsche' }
       *   });
       *
       * // Upsert with 'where' clause
       * await db.insert(cars)
       *   .values({ id: 1, brand: 'BMW' })
       *   .onConflictDoUpdate({
       *     target: cars.id,
       *     set: { brand: 'newBMW' },
       *     where: sql`${cars.createdAt} > '2023-01-01'::date`,
       *   });
       * ```
       */
      onConflictDoUpdate(config) {
        if (config.where && (config.targetWhere || config.setWhere)) {
          throw new Error(
            'You cannot use both "where" and "targetWhere"/"setWhere" at the same time - "where" is deprecated, use "targetWhere" or "setWhere" instead.'
          );
        }
        if (!this.config.onConflict) this.config.onConflict = [];
        const whereSql = config.where ? sql` where ${config.where}` : void 0;
        const targetWhereSql = config.targetWhere ? sql` where ${config.targetWhere}` : void 0;
        const setWhereSql = config.setWhere ? sql` where ${config.setWhere}` : void 0;
        const targetSql = Array.isArray(config.target) ? sql`${config.target}` : sql`${[config.target]}`;
        const setSql = this.dialect.buildUpdateSet(this.config.table, mapUpdateSet(this.config.table, config.set));
        this.config.onConflict.push(
          sql` on conflict ${targetSql}${targetWhereSql} do update set ${setSql}${whereSql}${setWhereSql}`
        );
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildInsertQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(isOneTimeQuery = true) {
        return this.session[isOneTimeQuery ? "prepareOneTimeQuery" : "prepareQuery"](
          this.dialect.sqlToQuery(this.getSQL()),
          this.config.returning,
          this.config.returning ? "all" : "run",
          true,
          void 0,
          {
            type: "insert",
            tables: extractUsedTable4(this.config.table)
          }
        );
      }
      prepare() {
        return this._prepare(false);
      }
      async execute() {
        return this.config.returning ? this.all() : this.run();
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SQLiteInsertBase, _a420, "SQLiteInsert");
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/select.types.js
var init_select_types4 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/select.types.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/update.js
var _a421, SQLiteUpdateBuilder, _a422, _b316, SQLiteUpdateBase;
var init_update4 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/update.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_selection_proxy();
    init_table5();
    init_subquery();
    init_table();
    init_utils();
    init_view_common();
    init_utils7();
    init_view_base3();
    _a421 = entityKind;
    SQLiteUpdateBuilder = class {
      constructor(table6, session, dialect6, withList) {
        this.table = table6;
        this.session = session;
        this.dialect = dialect6;
        this.withList = withList;
      }
      set(values2) {
        return new SQLiteUpdateBase(
          this.table,
          mapUpdateSet(this.table, values2),
          this.session,
          this.dialect,
          this.withList
        );
      }
    };
    __publicField(SQLiteUpdateBuilder, _a421, "SQLiteUpdateBuilder");
    SQLiteUpdateBase = class extends (_b316 = QueryPromise, _a422 = entityKind, _b316) {
      constructor(table6, set, session, dialect6, withList) {
        super();
        /** @internal */
        __publicField(this, "config");
        __publicField(this, "leftJoin", this.createJoin("left"));
        __publicField(this, "rightJoin", this.createJoin("right"));
        __publicField(this, "innerJoin", this.createJoin("inner"));
        __publicField(this, "fullJoin", this.createJoin("full"));
        __publicField(this, "run", (placeholderValues) => {
          return this._prepare().run(placeholderValues);
        });
        __publicField(this, "all", (placeholderValues) => {
          return this._prepare().all(placeholderValues);
        });
        __publicField(this, "get", (placeholderValues) => {
          return this._prepare().get(placeholderValues);
        });
        __publicField(this, "values", (placeholderValues) => {
          return this._prepare().values(placeholderValues);
        });
        this.session = session;
        this.dialect = dialect6;
        this.config = { set, table: table6, withList, joins: [] };
      }
      from(source) {
        this.config.from = source;
        return this;
      }
      createJoin(joinType) {
        return (table6, on3) => {
          const tableName = getTableLikeName(table6);
          if (typeof tableName === "string" && this.config.joins.some((join7) => join7.alias === tableName)) {
            throw new Error(`Alias "${tableName}" is already used in this query`);
          }
          if (typeof on3 === "function") {
            const from = this.config.from ? is(table6, SQLiteTable) ? table6[Table.Symbol.Columns] : is(table6, Subquery) ? table6._.selectedFields : is(table6, SQLiteViewBase) ? table6[ViewBaseConfig].selectedFields : void 0 : void 0;
            on3 = on3(
              new Proxy(
                this.config.table[Table.Symbol.Columns],
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              ),
              from && new Proxy(
                from,
                new SelectionProxyHandler({ sqlAliasedBehavior: "sql", sqlBehavior: "sql" })
              )
            );
          }
          this.config.joins.push({ on: on3, table: table6, joinType, alias: tableName });
          return this;
        };
      }
      /**
       * Adds a 'where' clause to the query.
       *
       * Calling this method will update only those rows that fulfill a specified condition.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param where the 'where' clause.
       *
       * @example
       * You can use conditional operators and `sql function` to filter the rows to be updated.
       *
       * ```ts
       * // Update all cars with green color
       * db.update(cars).set({ color: 'red' })
       *   .where(eq(cars.color, 'green'));
       * // or
       * db.update(cars).set({ color: 'red' })
       *   .where(sql`${cars.color} = 'green'`)
       * ```
       *
       * You can logically combine conditional operators with `and()` and `or()` operators:
       *
       * ```ts
       * // Update all BMW cars with a green color
       * db.update(cars).set({ color: 'red' })
       *   .where(and(eq(cars.color, 'green'), eq(cars.brand, 'BMW')));
       *
       * // Update all cars with the green or blue color
       * db.update(cars).set({ color: 'red' })
       *   .where(or(eq(cars.color, 'green'), eq(cars.color, 'blue')));
       * ```
       */
      where(where) {
        this.config.where = where;
        return this;
      }
      orderBy(...columns) {
        if (typeof columns[0] === "function") {
          const orderBy = columns[0](
            new Proxy(
              this.config.table[Table.Symbol.Columns],
              new SelectionProxyHandler({ sqlAliasedBehavior: "alias", sqlBehavior: "sql" })
            )
          );
          const orderByArray = Array.isArray(orderBy) ? orderBy : [orderBy];
          this.config.orderBy = orderByArray;
        } else {
          const orderByArray = columns;
          this.config.orderBy = orderByArray;
        }
        return this;
      }
      limit(limit) {
        this.config.limit = limit;
        return this;
      }
      returning(fields = this.config.table[SQLiteTable.Symbol.Columns]) {
        this.config.returning = orderSelectedFields(fields);
        return this;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildUpdateQuery(this.config);
      }
      toSQL() {
        const { typings: _typings, ...rest } = this.dialect.sqlToQuery(this.getSQL());
        return rest;
      }
      /** @internal */
      _prepare(isOneTimeQuery = true) {
        return this.session[isOneTimeQuery ? "prepareOneTimeQuery" : "prepareQuery"](
          this.dialect.sqlToQuery(this.getSQL()),
          this.config.returning,
          this.config.returning ? "all" : "run",
          true,
          void 0,
          {
            type: "insert",
            tables: extractUsedTable4(this.config.table)
          }
        );
      }
      prepare() {
        return this._prepare(false);
      }
      async execute() {
        return this.config.returning ? this.all() : this.run();
      }
      $dynamic() {
        return this;
      }
    };
    __publicField(SQLiteUpdateBase, _a422, "SQLiteUpdate");
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/index.js
var init_query_builders4 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/index.js"() {
    "use strict";
    init_delete4();
    init_insert4();
    init_query_builder5();
    init_select5();
    init_select_types4();
    init_update4();
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/count.js
var _a423, _b317, _c13, _SQLiteCountBuilder, SQLiteCountBuilder;
var init_count4 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/count.js"() {
    "use strict";
    init_entity();
    init_sql();
    _SQLiteCountBuilder = class _SQLiteCountBuilder extends (_c13 = SQL, _b317 = entityKind, _a423 = Symbol.toStringTag, _c13) {
      constructor(params) {
        super(_SQLiteCountBuilder.buildEmbeddedCount(params.source, params.filters).queryChunks);
        __publicField(this, "sql");
        __publicField(this, _a423, "SQLiteCountBuilderAsync");
        __publicField(this, "session");
        this.params = params;
        this.session = params.session;
        this.sql = _SQLiteCountBuilder.buildCount(
          params.source,
          params.filters
        );
      }
      static buildEmbeddedCount(source, filters) {
        return sql`(select count(*) from ${source}${sql.raw(" where ").if(filters)}${filters})`;
      }
      static buildCount(source, filters) {
        return sql`select count(*) from ${source}${sql.raw(" where ").if(filters)}${filters}`;
      }
      then(onfulfilled, onrejected) {
        return Promise.resolve(this.session.count(this.sql)).then(
          onfulfilled,
          onrejected
        );
      }
      catch(onRejected) {
        return this.then(void 0, onRejected);
      }
      finally(onFinally) {
        return this.then(
          (value) => {
            onFinally?.();
            return value;
          },
          (reason) => {
            onFinally?.();
            throw reason;
          }
        );
      }
    };
    __publicField(_SQLiteCountBuilder, _b317, "SQLiteCountBuilderAsync");
    SQLiteCountBuilder = _SQLiteCountBuilder;
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/query.js
var _a424, RelationalQueryBuilder3, _a425, _b318, SQLiteRelationalQuery, _a426, _b319, SQLiteSyncRelationalQuery;
var init_query3 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/query.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    init_relations();
    _a424 = entityKind;
    RelationalQueryBuilder3 = class {
      constructor(mode, fullSchema, schema6, tableNamesMap, table6, tableConfig, dialect6, session) {
        this.mode = mode;
        this.fullSchema = fullSchema;
        this.schema = schema6;
        this.tableNamesMap = tableNamesMap;
        this.table = table6;
        this.tableConfig = tableConfig;
        this.dialect = dialect6;
        this.session = session;
      }
      findMany(config) {
        return this.mode === "sync" ? new SQLiteSyncRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? config : {},
          "many"
        ) : new SQLiteRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? config : {},
          "many"
        );
      }
      findFirst(config) {
        return this.mode === "sync" ? new SQLiteSyncRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? { ...config, limit: 1 } : { limit: 1 },
          "first"
        ) : new SQLiteRelationalQuery(
          this.fullSchema,
          this.schema,
          this.tableNamesMap,
          this.table,
          this.tableConfig,
          this.dialect,
          this.session,
          config ? { ...config, limit: 1 } : { limit: 1 },
          "first"
        );
      }
    };
    __publicField(RelationalQueryBuilder3, _a424, "SQLiteAsyncRelationalQueryBuilder");
    SQLiteRelationalQuery = class extends (_b318 = QueryPromise, _a425 = entityKind, _b318) {
      constructor(fullSchema, schema6, tableNamesMap, table6, tableConfig, dialect6, session, config, mode) {
        super();
        /** @internal */
        __publicField(this, "mode");
        this.fullSchema = fullSchema;
        this.schema = schema6;
        this.tableNamesMap = tableNamesMap;
        this.table = table6;
        this.tableConfig = tableConfig;
        this.dialect = dialect6;
        this.session = session;
        this.config = config;
        this.mode = mode;
      }
      /** @internal */
      getSQL() {
        return this.dialect.buildRelationalQuery({
          fullSchema: this.fullSchema,
          schema: this.schema,
          tableNamesMap: this.tableNamesMap,
          table: this.table,
          tableConfig: this.tableConfig,
          queryConfig: this.config,
          tableAlias: this.tableConfig.tsName
        }).sql;
      }
      /** @internal */
      _prepare(isOneTimeQuery = false) {
        const { query, builtQuery } = this._toSQL();
        return this.session[isOneTimeQuery ? "prepareOneTimeQuery" : "prepareQuery"](
          builtQuery,
          void 0,
          this.mode === "first" ? "get" : "all",
          true,
          (rawRows, mapColumnValue) => {
            const rows = rawRows.map(
              (row) => mapRelationalRow(this.schema, this.tableConfig, row, query.selection, mapColumnValue)
            );
            if (this.mode === "first") {
              return rows[0];
            }
            return rows;
          }
        );
      }
      prepare() {
        return this._prepare(false);
      }
      _toSQL() {
        const query = this.dialect.buildRelationalQuery({
          fullSchema: this.fullSchema,
          schema: this.schema,
          tableNamesMap: this.tableNamesMap,
          table: this.table,
          tableConfig: this.tableConfig,
          queryConfig: this.config,
          tableAlias: this.tableConfig.tsName
        });
        const builtQuery = this.dialect.sqlToQuery(query.sql);
        return { query, builtQuery };
      }
      toSQL() {
        return this._toSQL().builtQuery;
      }
      /** @internal */
      executeRaw() {
        if (this.mode === "first") {
          return this._prepare(false).get();
        }
        return this._prepare(false).all();
      }
      async execute() {
        return this.executeRaw();
      }
    };
    __publicField(SQLiteRelationalQuery, _a425, "SQLiteAsyncRelationalQuery");
    SQLiteSyncRelationalQuery = class extends (_b319 = SQLiteRelationalQuery, _a426 = entityKind, _b319) {
      sync() {
        return this.executeRaw();
      }
    };
    __publicField(SQLiteSyncRelationalQuery, _a426, "SQLiteSyncRelationalQuery");
  }
});

// ../drizzle-orm/dist/sqlite-core/query-builders/raw.js
var _a427, _b320, SQLiteRaw;
var init_raw2 = __esm({
  "../drizzle-orm/dist/sqlite-core/query-builders/raw.js"() {
    "use strict";
    init_entity();
    init_query_promise();
    SQLiteRaw = class extends (_b320 = QueryPromise, _a427 = entityKind, _b320) {
      constructor(execute, getSQL, action, dialect6, mapBatchResult) {
        super();
        /** @internal */
        __publicField(this, "config");
        this.execute = execute;
        this.getSQL = getSQL;
        this.dialect = dialect6;
        this.mapBatchResult = mapBatchResult;
        this.config = { action };
      }
      getQuery() {
        return { ...this.dialect.sqlToQuery(this.getSQL()), method: this.config.action };
      }
      mapResult(result, isFromBatch) {
        return isFromBatch ? this.mapBatchResult(result) : result;
      }
      _prepare() {
        return this;
      }
      /** @internal */
      isResponseInArrayMode() {
        return false;
      }
    };
    __publicField(SQLiteRaw, _a427, "SQLiteRaw");
  }
});

// ../drizzle-orm/dist/sqlite-core/db.js
var _a428, BaseSQLiteDatabase;
var init_db4 = __esm({
  "../drizzle-orm/dist/sqlite-core/db.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_sql();
    init_query_builders4();
    init_subquery();
    init_count4();
    init_query3();
    init_raw2();
    _a428 = entityKind;
    BaseSQLiteDatabase = class {
      constructor(resultKind, dialect6, session, schema6) {
        __publicField(this, "query");
        /**
         * Creates a subquery that defines a temporary named result set as a CTE.
         *
         * It is useful for breaking down complex queries into simpler parts and for reusing the result set in subsequent parts of the query.
         *
         * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
         *
         * @param alias The alias for the subquery.
         *
         * Failure to provide an alias will result in a DrizzleTypeError, preventing the subquery from being referenced in other queries.
         *
         * @example
         *
         * ```ts
         * // Create a subquery with alias 'sq' and use it in the select query
         * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
         *
         * const result = await db.with(sq).select().from(sq);
         * ```
         *
         * To select arbitrary SQL values as fields in a CTE and reference them in other CTEs or in the main query, you need to add aliases to them:
         *
         * ```ts
         * // Select an arbitrary SQL value as a field in a CTE and reference it in the main query
         * const sq = db.$with('sq').as(db.select({
         *   name: sql<string>`upper(${users.name})`.as('name'),
         * })
         * .from(users));
         *
         * const result = await db.with(sq).select({ name: sq.name }).from(sq);
         * ```
         */
        __publicField(this, "$with", (alias2, selection) => {
          const self2 = this;
          const as = (qb) => {
            if (typeof qb === "function") {
              qb = qb(new QueryBuilder4(self2.dialect));
            }
            return new Proxy(
              new WithSubquery(
                qb.getSQL(),
                selection ?? ("getSelectedFields" in qb ? qb.getSelectedFields() ?? {} : {}),
                alias2,
                true
              ),
              new SelectionProxyHandler({ alias: alias2, sqlAliasedBehavior: "alias", sqlBehavior: "error" })
            );
          };
          return { as };
        });
        __publicField(this, "$cache");
        this.resultKind = resultKind;
        this.dialect = dialect6;
        this.session = session;
        this._ = schema6 ? {
          schema: schema6.schema,
          fullSchema: schema6.fullSchema,
          tableNamesMap: schema6.tableNamesMap
        } : {
          schema: void 0,
          fullSchema: {},
          tableNamesMap: {}
        };
        this.query = {};
        const query = this.query;
        if (this._.schema) {
          for (const [tableName, columns] of Object.entries(this._.schema)) {
            query[tableName] = new RelationalQueryBuilder3(
              resultKind,
              schema6.fullSchema,
              this._.schema,
              this._.tableNamesMap,
              schema6.fullSchema[tableName],
              columns,
              dialect6,
              session
            );
          }
        }
        this.$cache = { invalidate: async (_params2) => {
        } };
      }
      $count(source, filters) {
        return new SQLiteCountBuilder({ source, filters, session: this.session });
      }
      /**
       * Incorporates a previously defined CTE (using `$with`) into the main query.
       *
       * This method allows the main query to reference a temporary named result set.
       *
       * See docs: {@link https://orm.drizzle.team/docs/select#with-clause}
       *
       * @param queries The CTEs to incorporate into the main query.
       *
       * @example
       *
       * ```ts
       * // Define a subquery 'sq' as a CTE using $with
       * const sq = db.$with('sq').as(db.select().from(users).where(eq(users.id, 42)));
       *
       * // Incorporate the CTE 'sq' into the main query and select from it
       * const result = await db.with(sq).select().from(sq);
       * ```
       */
      with(...queries) {
        const self2 = this;
        function select2(fields) {
          return new SQLiteSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries
          });
        }
        function selectDistinct(fields) {
          return new SQLiteSelectBuilder({
            fields: fields ?? void 0,
            session: self2.session,
            dialect: self2.dialect,
            withList: queries,
            distinct: true
          });
        }
        function update(table6) {
          return new SQLiteUpdateBuilder(table6, self2.session, self2.dialect, queries);
        }
        function insert(into) {
          return new SQLiteInsertBuilder(into, self2.session, self2.dialect, queries);
        }
        function delete_(from) {
          return new SQLiteDeleteBase(from, self2.session, self2.dialect, queries);
        }
        return { select: select2, selectDistinct, update, insert, delete: delete_ };
      }
      select(fields) {
        return new SQLiteSelectBuilder({ fields: fields ?? void 0, session: this.session, dialect: this.dialect });
      }
      selectDistinct(fields) {
        return new SQLiteSelectBuilder({
          fields: fields ?? void 0,
          session: this.session,
          dialect: this.dialect,
          distinct: true
        });
      }
      /**
       * Creates an update query.
       *
       * Calling this method without `.where()` clause will update all rows in a table. The `.where()` clause specifies which rows should be updated.
       *
       * Use `.set()` method to specify which values to update.
       *
       * See docs: {@link https://orm.drizzle.team/docs/update}
       *
       * @param table The table to update.
       *
       * @example
       *
       * ```ts
       * // Update all rows in the 'cars' table
       * await db.update(cars).set({ color: 'red' });
       *
       * // Update rows with filters and conditions
       * await db.update(cars).set({ color: 'red' }).where(eq(cars.brand, 'BMW'));
       *
       * // Update with returning clause
       * const updatedCar: Car[] = await db.update(cars)
       *   .set({ color: 'red' })
       *   .where(eq(cars.id, 1))
       *   .returning();
       * ```
       */
      update(table6) {
        return new SQLiteUpdateBuilder(table6, this.session, this.dialect);
      }
      /**
       * Creates an insert query.
       *
       * Calling this method will create new rows in a table. Use `.values()` method to specify which values to insert.
       *
       * See docs: {@link https://orm.drizzle.team/docs/insert}
       *
       * @param table The table to insert into.
       *
       * @example
       *
       * ```ts
       * // Insert one row
       * await db.insert(cars).values({ brand: 'BMW' });
       *
       * // Insert multiple rows
       * await db.insert(cars).values([{ brand: 'BMW' }, { brand: 'Porsche' }]);
       *
       * // Insert with returning clause
       * const insertedCar: Car[] = await db.insert(cars)
       *   .values({ brand: 'BMW' })
       *   .returning();
       * ```
       */
      insert(into) {
        return new SQLiteInsertBuilder(into, this.session, this.dialect);
      }
      /**
       * Creates a delete query.
       *
       * Calling this method without `.where()` clause will delete all rows in a table. The `.where()` clause specifies which rows should be deleted.
       *
       * See docs: {@link https://orm.drizzle.team/docs/delete}
       *
       * @param table The table to delete from.
       *
       * @example
       *
       * ```ts
       * // Delete all rows in the 'cars' table
       * await db.delete(cars);
       *
       * // Delete rows with filters and conditions
       * await db.delete(cars).where(eq(cars.color, 'green'));
       *
       * // Delete with returning clause
       * const deletedCar: Car[] = await db.delete(cars)
       *   .where(eq(cars.id, 1))
       *   .returning();
       * ```
       */
      delete(from) {
        return new SQLiteDeleteBase(from, this.session, this.dialect);
      }
      run(query) {
        const sequel = typeof query === "string" ? sql.raw(query) : query.getSQL();
        if (this.resultKind === "async") {
          return new SQLiteRaw(
            async () => this.session.run(sequel),
            () => sequel,
            "run",
            this.dialect,
            this.session.extractRawRunValueFromBatchResult.bind(this.session)
          );
        }
        return this.session.run(sequel);
      }
      all(query) {
        const sequel = typeof query === "string" ? sql.raw(query) : query.getSQL();
        if (this.resultKind === "async") {
          return new SQLiteRaw(
            async () => this.session.all(sequel),
            () => sequel,
            "all",
            this.dialect,
            this.session.extractRawAllValueFromBatchResult.bind(this.session)
          );
        }
        return this.session.all(sequel);
      }
      get(query) {
        const sequel = typeof query === "string" ? sql.raw(query) : query.getSQL();
        if (this.resultKind === "async") {
          return new SQLiteRaw(
            async () => this.session.get(sequel),
            () => sequel,
            "get",
            this.dialect,
            this.session.extractRawGetValueFromBatchResult.bind(this.session)
          );
        }
        return this.session.get(sequel);
      }
      values(query) {
        const sequel = typeof query === "string" ? sql.raw(query) : query.getSQL();
        if (this.resultKind === "async") {
          return new SQLiteRaw(
            async () => this.session.values(sequel),
            () => sequel,
            "values",
            this.dialect,
            this.session.extractRawValuesValueFromBatchResult.bind(this.session)
          );
        }
        return this.session.values(sequel);
      }
      transaction(transaction, config) {
        return this.session.transaction(transaction, config);
      }
    };
    __publicField(BaseSQLiteDatabase, _a428, "BaseSQLiteDatabase");
  }
});

// ../drizzle-orm/dist/sqlite-core/session.js
var _a429, _b321, ExecuteResultSync, _a430, SQLitePreparedQuery, _a431, SQLiteSession, _a432, _b322, SQLiteTransaction;
var init_session4 = __esm({
  "../drizzle-orm/dist/sqlite-core/session.js"() {
    "use strict";
    init_cache();
    init_entity();
    init_errors();
    init_query_promise();
    init_db4();
    ExecuteResultSync = class extends (_b321 = QueryPromise, _a429 = entityKind, _b321) {
      constructor(resultCb) {
        super();
        this.resultCb = resultCb;
      }
      async execute() {
        return this.resultCb();
      }
      sync() {
        return this.resultCb();
      }
    };
    __publicField(ExecuteResultSync, _a429, "ExecuteResultSync");
    _a430 = entityKind;
    SQLitePreparedQuery = class {
      constructor(mode, executeMethod, query, cache5, queryMetadata, cacheConfig) {
        /** @internal */
        __publicField(this, "joinsNotNullableMap");
        this.mode = mode;
        this.executeMethod = executeMethod;
        this.query = query;
        this.cache = cache5;
        this.queryMetadata = queryMetadata;
        this.cacheConfig = cacheConfig;
        if (cache5 && cache5.strategy() === "all" && cacheConfig === void 0) {
          this.cacheConfig = { enable: true, autoInvalidate: true };
        }
        if (!this.cacheConfig?.enable) {
          this.cacheConfig = void 0;
        }
      }
      /** @internal */
      async queryWithCache(queryString, params, query) {
        if (this.cache === void 0 || is(this.cache, NoopCache) || this.queryMetadata === void 0) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.cacheConfig && !this.cacheConfig.enable) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if ((this.queryMetadata.type === "insert" || this.queryMetadata.type === "update" || this.queryMetadata.type === "delete") && this.queryMetadata.tables.length > 0) {
          try {
            const [res] = await Promise.all([
              query(),
              this.cache.onMutate({ tables: this.queryMetadata.tables })
            ]);
            return res;
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (!this.cacheConfig) {
          try {
            return await query();
          } catch (e6) {
            throw new DrizzleQueryError(queryString, params, e6);
          }
        }
        if (this.queryMetadata.type === "select") {
          const fromCache = await this.cache.get(
            this.cacheConfig.tag ?? await hashQuery(queryString, params),
            this.queryMetadata.tables,
            this.cacheConfig.tag !== void 0,
            this.cacheConfig.autoInvalidate
          );
          if (fromCache === void 0) {
            let result;
            try {
              result = await query();
            } catch (e6) {
              throw new DrizzleQueryError(queryString, params, e6);
            }
            await this.cache.put(
              this.cacheConfig.tag ?? await hashQuery(queryString, params),
              result,
              // make sure we send tables that were used in a query only if user wants to invalidate it on each write
              this.cacheConfig.autoInvalidate ? this.queryMetadata.tables : [],
              this.cacheConfig.tag !== void 0,
              this.cacheConfig.config
            );
            return result;
          }
          return fromCache;
        }
        try {
          return await query();
        } catch (e6) {
          throw new DrizzleQueryError(queryString, params, e6);
        }
      }
      getQuery() {
        return this.query;
      }
      mapRunResult(result, _isFromBatch) {
        return result;
      }
      mapAllResult(_result, _isFromBatch) {
        throw new Error("Not implemented");
      }
      mapGetResult(_result, _isFromBatch) {
        throw new Error("Not implemented");
      }
      execute(placeholderValues) {
        if (this.mode === "async") {
          return this[this.executeMethod](placeholderValues);
        }
        return new ExecuteResultSync(() => this[this.executeMethod](placeholderValues));
      }
      mapResult(response, isFromBatch) {
        switch (this.executeMethod) {
          case "run": {
            return this.mapRunResult(response, isFromBatch);
          }
          case "all": {
            return this.mapAllResult(response, isFromBatch);
          }
          case "get": {
            return this.mapGetResult(response, isFromBatch);
          }
        }
      }
    };
    __publicField(SQLitePreparedQuery, _a430, "PreparedQuery");
    _a431 = entityKind;
    SQLiteSession = class {
      constructor(dialect6) {
        this.dialect = dialect6;
      }
      prepareOneTimeQuery(query, fields, executeMethod, isResponseInArrayMode, customResultMapper, queryMetadata, cacheConfig) {
        return this.prepareQuery(
          query,
          fields,
          executeMethod,
          isResponseInArrayMode,
          customResultMapper,
          queryMetadata,
          cacheConfig
        );
      }
      run(query) {
        const staticQuery = this.dialect.sqlToQuery(query);
        try {
          return this.prepareOneTimeQuery(staticQuery, void 0, "run", false).run();
        } catch (err3) {
          throw new DrizzleError({ cause: err3, message: `Failed to run the query '${staticQuery.sql}'` });
        }
      }
      /** @internal */
      extractRawRunValueFromBatchResult(result) {
        return result;
      }
      all(query) {
        return this.prepareOneTimeQuery(this.dialect.sqlToQuery(query), void 0, "run", false).all();
      }
      /** @internal */
      extractRawAllValueFromBatchResult(_result) {
        throw new Error("Not implemented");
      }
      get(query) {
        return this.prepareOneTimeQuery(this.dialect.sqlToQuery(query), void 0, "run", false).get();
      }
      /** @internal */
      extractRawGetValueFromBatchResult(_result) {
        throw new Error("Not implemented");
      }
      values(query) {
        return this.prepareOneTimeQuery(this.dialect.sqlToQuery(query), void 0, "run", false).values();
      }
      async count(sql3) {
        const result = await this.values(sql3);
        return result[0][0];
      }
      /** @internal */
      extractRawValuesValueFromBatchResult(_result) {
        throw new Error("Not implemented");
      }
    };
    __publicField(SQLiteSession, _a431, "SQLiteSession");
    SQLiteTransaction = class extends (_b322 = BaseSQLiteDatabase, _a432 = entityKind, _b322) {
      constructor(resultType, dialect6, session, schema6, nestedIndex = 0) {
        super(resultType, dialect6, session, schema6);
        this.schema = schema6;
        this.nestedIndex = nestedIndex;
      }
      rollback() {
        throw new TransactionRollbackError();
      }
    };
    __publicField(SQLiteTransaction, _a432, "SQLiteTransaction");
  }
});

// ../drizzle-orm/dist/sqlite-core/subquery.js
var init_subquery5 = __esm({
  "../drizzle-orm/dist/sqlite-core/subquery.js"() {
    "use strict";
  }
});

// ../drizzle-orm/dist/sqlite-core/view.js
var _a433, ViewBuilderCore2, _a434, _b323, ViewBuilder3, _a435, _b324, ManualViewBuilder3, _a436, _b325, SQLiteView;
var init_view3 = __esm({
  "../drizzle-orm/dist/sqlite-core/view.js"() {
    "use strict";
    init_entity();
    init_selection_proxy();
    init_utils();
    init_query_builder5();
    init_table5();
    init_view_base3();
    _a433 = entityKind;
    ViewBuilderCore2 = class {
      constructor(name3) {
        __publicField(this, "config", {});
        this.name = name3;
      }
    };
    __publicField(ViewBuilderCore2, _a433, "SQLiteViewBuilderCore");
    ViewBuilder3 = class extends (_b323 = ViewBuilderCore2, _a434 = entityKind, _b323) {
      as(qb) {
        if (typeof qb === "function") {
          qb = qb(new QueryBuilder4());
        }
        const selectionProxy = new SelectionProxyHandler({
          alias: this.name,
          sqlBehavior: "error",
          sqlAliasedBehavior: "alias",
          replaceOriginalName: true
        });
        const aliasedSelectedFields = qb.getSelectedFields();
        return new Proxy(
          new SQLiteView({
            // sqliteConfig: this.config,
            config: {
              name: this.name,
              schema: void 0,
              selectedFields: aliasedSelectedFields,
              query: qb.getSQL().inlineParams()
            }
          }),
          selectionProxy
        );
      }
    };
    __publicField(ViewBuilder3, _a434, "SQLiteViewBuilder");
    ManualViewBuilder3 = class extends (_b324 = ViewBuilderCore2, _a435 = entityKind, _b324) {
      constructor(name3, columns) {
        super(name3);
        __publicField(this, "columns");
        this.columns = getTableColumns(sqliteTable(name3, columns));
      }
      existing() {
        return new Proxy(
          new SQLiteView({
            config: {
              name: this.name,
              schema: void 0,
              selectedFields: this.columns,
              query: void 0
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
      as(query) {
        return new Proxy(
          new SQLiteView({
            config: {
              name: this.name,
              schema: void 0,
              selectedFields: this.columns,
              query: query.inlineParams()
            }
          }),
          new SelectionProxyHandler({
            alias: this.name,
            sqlBehavior: "error",
            sqlAliasedBehavior: "alias",
            replaceOriginalName: true
          })
        );
      }
    };
    __publicField(ManualViewBuilder3, _a435, "SQLiteManualViewBuilder");
    SQLiteView = class extends (_b325 = SQLiteViewBase, _a436 = entityKind, _b325) {
      constructor({ config }) {
        super(config);
      }
    };
    __publicField(SQLiteView, _a436, "SQLiteView");
  }
});

// ../drizzle-orm/dist/sqlite-core/index.js
var init_sqlite_core = __esm({
  "../drizzle-orm/dist/sqlite-core/index.js"() {
    "use strict";
    init_alias5();
    init_checks3();
    init_columns4();
    init_db4();
    init_dialect4();
    init_foreign_keys3();
    init_indexes4();
    init_primary_keys4();
    init_query_builders4();
    init_session4();
    init_subquery5();
    init_table5();
    init_unique_constraint4();
    init_utils7();
    init_view3();
  }
});

// ../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/vendor/ansi-styles/index.js
function assembleStyles() {
  const codes = /* @__PURE__ */ new Map();
  for (const [groupName, group] of Object.entries(styles)) {
    for (const [styleName, style] of Object.entries(group)) {
      styles[styleName] = {
        open: `\x1B[${style[0]}m`,
        close: `\x1B[${style[1]}m`
      };
      group[styleName] = styles[styleName];
      codes.set(style[0], style[1]);
    }
    Object.defineProperty(styles, groupName, {
      value: group,
      enumerable: false
    });
  }
  Object.defineProperty(styles, "codes", {
    value: codes,
    enumerable: false
  });
  styles.color.close = "\x1B[39m";
  styles.bgColor.close = "\x1B[49m";
  styles.color.ansi = wrapAnsi16();
  styles.color.ansi256 = wrapAnsi256();
  styles.color.ansi16m = wrapAnsi16m();
  styles.bgColor.ansi = wrapAnsi16(ANSI_BACKGROUND_OFFSET);
  styles.bgColor.ansi256 = wrapAnsi256(ANSI_BACKGROUND_OFFSET);
  styles.bgColor.ansi16m = wrapAnsi16m(ANSI_BACKGROUND_OFFSET);
  Object.defineProperties(styles, {
    rgbToAnsi256: {
      value(red, green, blue) {
        if (red === green && green === blue) {
          if (red < 8) {
            return 16;
          }
          if (red > 248) {
            return 231;
          }
          return Math.round((red - 8) / 247 * 24) + 232;
        }
        return 16 + 36 * Math.round(red / 255 * 5) + 6 * Math.round(green / 255 * 5) + Math.round(blue / 255 * 5);
      },
      enumerable: false
    },
    hexToRgb: {
      value(hex2) {
        const matches = /[a-f\d]{6}|[a-f\d]{3}/i.exec(hex2.toString(16));
        if (!matches) {
          return [0, 0, 0];
        }
        let [colorString] = matches;
        if (colorString.length === 3) {
          colorString = [...colorString].map((character) => character + character).join("");
        }
        const integer3 = Number.parseInt(colorString, 16);
        return [
          /* eslint-disable no-bitwise */
          integer3 >> 16 & 255,
          integer3 >> 8 & 255,
          integer3 & 255
          /* eslint-enable no-bitwise */
        ];
      },
      enumerable: false
    },
    hexToAnsi256: {
      value: (hex2) => styles.rgbToAnsi256(...styles.hexToRgb(hex2)),
      enumerable: false
    },
    ansi256ToAnsi: {
      value(code) {
        if (code < 8) {
          return 30 + code;
        }
        if (code < 16) {
          return 90 + (code - 8);
        }
        let red;
        let green;
        let blue;
        if (code >= 232) {
          red = ((code - 232) * 10 + 8) / 255;
          green = red;
          blue = red;
        } else {
          code -= 16;
          const remainder = code % 36;
          red = Math.floor(code / 36) / 5;
          green = Math.floor(remainder / 6) / 5;
          blue = remainder % 6 / 5;
        }
        const value = Math.max(red, green, blue) * 2;
        if (value === 0) {
          return 30;
        }
        let result = 30 + (Math.round(blue) << 2 | Math.round(green) << 1 | Math.round(red));
        if (value === 2) {
          result += 60;
        }
        return result;
      },
      enumerable: false
    },
    rgbToAnsi: {
      value: (red, green, blue) => styles.ansi256ToAnsi(styles.rgbToAnsi256(red, green, blue)),
      enumerable: false
    },
    hexToAnsi: {
      value: (hex2) => styles.ansi256ToAnsi(styles.hexToAnsi256(hex2)),
      enumerable: false
    }
  });
  return styles;
}
var ANSI_BACKGROUND_OFFSET, wrapAnsi16, wrapAnsi256, wrapAnsi16m, styles, modifierNames, foregroundColorNames, backgroundColorNames, colorNames, ansiStyles, ansi_styles_default;
var init_ansi_styles = __esm({
  "../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/vendor/ansi-styles/index.js"() {
    "use strict";
    ANSI_BACKGROUND_OFFSET = 10;
    wrapAnsi16 = (offset = 0) => (code) => `\x1B[${code + offset}m`;
    wrapAnsi256 = (offset = 0) => (code) => `\x1B[${38 + offset};5;${code}m`;
    wrapAnsi16m = (offset = 0) => (red, green, blue) => `\x1B[${38 + offset};2;${red};${green};${blue}m`;
    styles = {
      modifier: {
        reset: [0, 0],
        // 21 isn't widely supported and 22 does the same thing
        bold: [1, 22],
        dim: [2, 22],
        italic: [3, 23],
        underline: [4, 24],
        overline: [53, 55],
        inverse: [7, 27],
        hidden: [8, 28],
        strikethrough: [9, 29]
      },
      color: {
        black: [30, 39],
        red: [31, 39],
        green: [32, 39],
        yellow: [33, 39],
        blue: [34, 39],
        magenta: [35, 39],
        cyan: [36, 39],
        white: [37, 39],
        // Bright color
        blackBright: [90, 39],
        gray: [90, 39],
        // Alias of `blackBright`
        grey: [90, 39],
        // Alias of `blackBright`
        redBright: [91, 39],
        greenBright: [92, 39],
        yellowBright: [93, 39],
        blueBright: [94, 39],
        magentaBright: [95, 39],
        cyanBright: [96, 39],
        whiteBright: [97, 39]
      },
      bgColor: {
        bgBlack: [40, 49],
        bgRed: [41, 49],
        bgGreen: [42, 49],
        bgYellow: [43, 49],
        bgBlue: [44, 49],
        bgMagenta: [45, 49],
        bgCyan: [46, 49],
        bgWhite: [47, 49],
        // Bright color
        bgBlackBright: [100, 49],
        bgGray: [100, 49],
        // Alias of `bgBlackBright`
        bgGrey: [100, 49],
        // Alias of `bgBlackBright`
        bgRedBright: [101, 49],
        bgGreenBright: [102, 49],
        bgYellowBright: [103, 49],
        bgBlueBright: [104, 49],
        bgMagentaBright: [105, 49],
        bgCyanBright: [106, 49],
        bgWhiteBright: [107, 49]
      }
    };
    modifierNames = Object.keys(styles.modifier);
    foregroundColorNames = Object.keys(styles.color);
    backgroundColorNames = Object.keys(styles.bgColor);
    colorNames = [...foregroundColorNames, ...backgroundColorNames];
    ansiStyles = assembleStyles();
    ansi_styles_default = ansiStyles;
  }
});

// ../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/vendor/supports-color/index.js
import process2 from "process";
import os from "os";
import tty from "tty";
function hasFlag(flag, argv = globalThis.Deno ? globalThis.Deno.args : process2.argv) {
  const prefix2 = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
  const position = argv.indexOf(prefix2 + flag);
  const terminatorPosition = argv.indexOf("--");
  return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
}
function envForceColor() {
  if ("FORCE_COLOR" in env) {
    if (env.FORCE_COLOR === "true") {
      return 1;
    }
    if (env.FORCE_COLOR === "false") {
      return 0;
    }
    return env.FORCE_COLOR.length === 0 ? 1 : Math.min(Number.parseInt(env.FORCE_COLOR, 10), 3);
  }
}
function translateLevel(level) {
  if (level === 0) {
    return false;
  }
  return {
    level,
    hasBasic: true,
    has256: level >= 2,
    has16m: level >= 3
  };
}
function _supportsColor(haveStream, { streamIsTTY, sniffFlags = true } = {}) {
  const noFlagForceColor = envForceColor();
  if (noFlagForceColor !== void 0) {
    flagForceColor = noFlagForceColor;
  }
  const forceColor = sniffFlags ? flagForceColor : noFlagForceColor;
  if (forceColor === 0) {
    return 0;
  }
  if (sniffFlags) {
    if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
      return 3;
    }
    if (hasFlag("color=256")) {
      return 2;
    }
  }
  if ("TF_BUILD" in env && "AGENT_NAME" in env) {
    return 1;
  }
  if (haveStream && !streamIsTTY && forceColor === void 0) {
    return 0;
  }
  const min2 = forceColor || 0;
  if (env.TERM === "dumb") {
    return min2;
  }
  if (process2.platform === "win32") {
    const osRelease = os.release().split(".");
    if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
      return Number(osRelease[2]) >= 14931 ? 3 : 2;
    }
    return 1;
  }
  if ("CI" in env) {
    if (["GITHUB_ACTIONS", "GITEA_ACTIONS", "CIRCLECI"].some((key) => key in env)) {
      return 3;
    }
    if (["TRAVIS", "APPVEYOR", "GITLAB_CI", "BUILDKITE", "DRONE"].some((sign) => sign in env) || env.CI_NAME === "codeship") {
      return 1;
    }
    return min2;
  }
  if ("TEAMCITY_VERSION" in env) {
    return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
  }
  if (env.COLORTERM === "truecolor") {
    return 3;
  }
  if (env.TERM === "xterm-kitty") {
    return 3;
  }
  if ("TERM_PROGRAM" in env) {
    const version3 = Number.parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
    switch (env.TERM_PROGRAM) {
      case "iTerm.app": {
        return version3 >= 3 ? 3 : 2;
      }
      case "Apple_Terminal": {
        return 2;
      }
    }
  }
  if (/-256(color)?$/i.test(env.TERM)) {
    return 2;
  }
  if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
    return 1;
  }
  if ("COLORTERM" in env) {
    return 1;
  }
  return min2;
}
function createSupportsColor(stream, options = {}) {
  const level = _supportsColor(stream, {
    streamIsTTY: stream && stream.isTTY,
    ...options
  });
  return translateLevel(level);
}
var env, flagForceColor, supportsColor, supports_color_default;
var init_supports_color = __esm({
  "../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/vendor/supports-color/index.js"() {
    "use strict";
    ({ env } = process2);
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false") || hasFlag("color=never")) {
      flagForceColor = 0;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      flagForceColor = 1;
    }
    supportsColor = {
      stdout: createSupportsColor({ isTTY: tty.isatty(1) }),
      stderr: createSupportsColor({ isTTY: tty.isatty(2) })
    };
    supports_color_default = supportsColor;
  }
});

// ../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/utilities.js
function stringReplaceAll(string2, substring2, replacer) {
  let index7 = string2.indexOf(substring2);
  if (index7 === -1) {
    return string2;
  }
  const substringLength = substring2.length;
  let endIndex = 0;
  let returnValue = "";
  do {
    returnValue += string2.slice(endIndex, index7) + substring2 + replacer;
    endIndex = index7 + substringLength;
    index7 = string2.indexOf(substring2, endIndex);
  } while (index7 !== -1);
  returnValue += string2.slice(endIndex);
  return returnValue;
}
function stringEncaseCRLFWithFirstIndex(string2, prefix2, postfix, index7) {
  let endIndex = 0;
  let returnValue = "";
  do {
    const gotCR = string2[index7 - 1] === "\r";
    returnValue += string2.slice(endIndex, gotCR ? index7 - 1 : index7) + prefix2 + (gotCR ? "\r\n" : "\n") + postfix;
    endIndex = index7 + 1;
    index7 = string2.indexOf("\n", endIndex);
  } while (index7 !== -1);
  returnValue += string2.slice(endIndex);
  return returnValue;
}
var init_utilities = __esm({
  "../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/utilities.js"() {
    "use strict";
  }
});

// ../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/index.js
function createChalk(options) {
  return chalkFactory(options);
}
var stdoutColor, stderrColor, GENERATOR, STYLER, IS_EMPTY, levelMapping, styles2, applyOptions, chalkFactory, getModelAnsi, usedModels, proto, createStyler, createBuilder, applyStyle, chalk, chalkStderr, source_default;
var init_source = __esm({
  "../node_modules/.pnpm/chalk@5.4.1/node_modules/chalk/source/index.js"() {
    "use strict";
    init_ansi_styles();
    init_supports_color();
    init_utilities();
    ({ stdout: stdoutColor, stderr: stderrColor } = supports_color_default);
    GENERATOR = Symbol("GENERATOR");
    STYLER = Symbol("STYLER");
    IS_EMPTY = Symbol("IS_EMPTY");
    levelMapping = [
      "ansi",
      "ansi",
      "ansi256",
      "ansi16m"
    ];
    styles2 = /* @__PURE__ */ Object.create(null);
    applyOptions = (object2, options = {}) => {
      if (options.level && !(Number.isInteger(options.level) && options.level >= 0 && options.level <= 3)) {
        throw new Error("The `level` option should be an integer from 0 to 3");
      }
      const colorLevel = stdoutColor ? stdoutColor.level : 0;
      object2.level = options.level === void 0 ? colorLevel : options.level;
    };
    chalkFactory = (options) => {
      const chalk2 = (...strings) => strings.join(" ");
      applyOptions(chalk2, options);
      Object.setPrototypeOf(chalk2, createChalk.prototype);
      return chalk2;
    };
    Object.setPrototypeOf(createChalk.prototype, Function.prototype);
    for (const [styleName, style] of Object.entries(ansi_styles_default)) {
      styles2[styleName] = {
        get() {
          const builder = createBuilder(this, createStyler(style.open, style.close, this[STYLER]), this[IS_EMPTY]);
          Object.defineProperty(this, styleName, { value: builder });
          return builder;
        }
      };
    }
    styles2.visible = {
      get() {
        const builder = createBuilder(this, this[STYLER], true);
        Object.defineProperty(this, "visible", { value: builder });
        return builder;
      }
    };
    getModelAnsi = (model, level, type, ...arguments_2) => {
      if (model === "rgb") {
        if (level === "ansi16m") {
          return ansi_styles_default[type].ansi16m(...arguments_2);
        }
        if (level === "ansi256") {
          return ansi_styles_default[type].ansi256(ansi_styles_default.rgbToAnsi256(...arguments_2));
        }
        return ansi_styles_default[type].ansi(ansi_styles_default.rgbToAnsi(...arguments_2));
      }
      if (model === "hex") {
        return getModelAnsi("rgb", level, type, ...ansi_styles_default.hexToRgb(...arguments_2));
      }
      return ansi_styles_default[type][model](...arguments_2);
    };
    usedModels = ["rgb", "hex", "ansi256"];
    for (const model of usedModels) {
      styles2[model] = {
        get() {
          const { level } = this;
          return function(...arguments_2) {
            const styler = createStyler(getModelAnsi(model, levelMapping[level], "color", ...arguments_2), ansi_styles_default.color.close, this[STYLER]);
            return createBuilder(this, styler, this[IS_EMPTY]);
          };
        }
      };
      const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
      styles2[bgModel] = {
        get() {
          const { level } = this;
          return function(...arguments_2) {
            const styler = createStyler(getModelAnsi(model, levelMapping[level], "bgColor", ...arguments_2), ansi_styles_default.bgColor.close, this[STYLER]);
            return createBuilder(this, styler, this[IS_EMPTY]);
          };
        }
      };
    }
    proto = Object.defineProperties(() => {
    }, {
      ...styles2,
      level: {
        enumerable: true,
        get() {
          return this[GENERATOR].level;
        },
        set(level) {
          this[GENERATOR].level = level;
        }
      }
    });
    createStyler = (open, close, parent) => {
      let openAll;
      let closeAll;
      if (parent === void 0) {
        openAll = open;
        closeAll = close;
      } else {
        openAll = parent.openAll + open;
        closeAll = close + parent.closeAll;
      }
      return {
        open,
        close,
        openAll,
        closeAll,
        parent
      };
    };
    createBuilder = (self2, _styler, _isEmpty) => {
      const builder = (...arguments_2) => applyStyle(builder, arguments_2.length === 1 ? "" + arguments_2[0] : arguments_2.join(" "));
      Object.setPrototypeOf(builder, proto);
      builder[GENERATOR] = self2;
      builder[STYLER] = _styler;
      builder[IS_EMPTY] = _isEmpty;
      return builder;
    };
    applyStyle = (self2, string2) => {
      if (self2.level <= 0 || !string2) {
        return self2[IS_EMPTY] ? "" : string2;
      }
      let styler = self2[STYLER];
      if (styler === void 0) {
        return string2;
      }
      const { openAll, closeAll } = styler;
      if (string2.includes("\x1B")) {
        while (styler !== void 0) {
          string2 = stringReplaceAll(string2, styler.close, styler.open);
          styler = styler.parent;
        }
      }
      const lfIndex = string2.indexOf("\n");
      if (lfIndex !== -1) {
        string2 = stringEncaseCRLFWithFirstIndex(string2, closeAll, openAll, lfIndex);
      }
      return openAll + string2 + closeAll;
    };
    Object.defineProperties(createChalk.prototype, styles2);
    chalk = createChalk();
    chalkStderr = createChalk({ level: stderrColor ? stderrColor.level : 0 });
    source_default = chalk;
  }
});

// ../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/old.js
var require_old = __commonJS({
  "../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/old.js"(exports) {
    "use strict";
    var pathModule = __require("path");
    var isWindows = process.platform === "win32";
    var fs9 = __require("fs");
    var DEBUG = process.env.NODE_DEBUG && /fs/.test(process.env.NODE_DEBUG);
    function rethrow() {
      var callback;
      if (DEBUG) {
        var backtrace = new Error();
        callback = debugCallback;
      } else
        callback = missingCallback;
      return callback;
      function debugCallback(err3) {
        if (err3) {
          backtrace.message = err3.message;
          err3 = backtrace;
          missingCallback(err3);
        }
      }
      function missingCallback(err3) {
        if (err3) {
          if (process.throwDeprecation)
            throw err3;
          else if (!process.noDeprecation) {
            var msg = "fs: missing callback " + (err3.stack || err3.message);
            if (process.traceDeprecation)
              console.trace(msg);
            else
              console.error(msg);
          }
        }
      }
    }
    function maybeCallback(cb) {
      return typeof cb === "function" ? cb : rethrow();
    }
    var normalize = pathModule.normalize;
    if (isWindows) {
      nextPartRe = /(.*?)(?:[\/\\]+|$)/g;
    } else {
      nextPartRe = /(.*?)(?:[\/]+|$)/g;
    }
    var nextPartRe;
    if (isWindows) {
      splitRootRe = /^(?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/][^\\\/]+)?[\\\/]*/;
    } else {
      splitRootRe = /^[\/]*/;
    }
    var splitRootRe;
    exports.realpathSync = function realpathSync(p11, cache5) {
      p11 = pathModule.resolve(p11);
      if (cache5 && Object.prototype.hasOwnProperty.call(cache5, p11)) {
        return cache5[p11];
      }
      var original = p11, seenLinks = {}, knownHard = {};
      var pos;
      var current;
      var base;
      var previous;
      start2();
      function start2() {
        var m12 = splitRootRe.exec(p11);
        pos = m12[0].length;
        current = m12[0];
        base = m12[0];
        previous = "";
        if (isWindows && !knownHard[base]) {
          fs9.lstatSync(base);
          knownHard[base] = true;
        }
      }
      while (pos < p11.length) {
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p11);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;
        if (knownHard[base] || cache5 && cache5[base] === base) {
          continue;
        }
        var resolvedLink;
        if (cache5 && Object.prototype.hasOwnProperty.call(cache5, base)) {
          resolvedLink = cache5[base];
        } else {
          var stat2 = fs9.lstatSync(base);
          if (!stat2.isSymbolicLink()) {
            knownHard[base] = true;
            if (cache5) cache5[base] = base;
            continue;
          }
          var linkTarget = null;
          if (!isWindows) {
            var id = stat2.dev.toString(32) + ":" + stat2.ino.toString(32);
            if (seenLinks.hasOwnProperty(id)) {
              linkTarget = seenLinks[id];
            }
          }
          if (linkTarget === null) {
            fs9.statSync(base);
            linkTarget = fs9.readlinkSync(base);
          }
          resolvedLink = pathModule.resolve(previous, linkTarget);
          if (cache5) cache5[base] = resolvedLink;
          if (!isWindows) seenLinks[id] = linkTarget;
        }
        p11 = pathModule.resolve(resolvedLink, p11.slice(pos));
        start2();
      }
      if (cache5) cache5[original] = p11;
      return p11;
    };
    exports.realpath = function realpath(p11, cache5, cb) {
      if (typeof cb !== "function") {
        cb = maybeCallback(cache5);
        cache5 = null;
      }
      p11 = pathModule.resolve(p11);
      if (cache5 && Object.prototype.hasOwnProperty.call(cache5, p11)) {
        return process.nextTick(cb.bind(null, null, cache5[p11]));
      }
      var original = p11, seenLinks = {}, knownHard = {};
      var pos;
      var current;
      var base;
      var previous;
      start2();
      function start2() {
        var m12 = splitRootRe.exec(p11);
        pos = m12[0].length;
        current = m12[0];
        base = m12[0];
        previous = "";
        if (isWindows && !knownHard[base]) {
          fs9.lstat(base, function(err3) {
            if (err3) return cb(err3);
            knownHard[base] = true;
            LOOP();
          });
        } else {
          process.nextTick(LOOP);
        }
      }
      function LOOP() {
        if (pos >= p11.length) {
          if (cache5) cache5[original] = p11;
          return cb(null, p11);
        }
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p11);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;
        if (knownHard[base] || cache5 && cache5[base] === base) {
          return process.nextTick(LOOP);
        }
        if (cache5 && Object.prototype.hasOwnProperty.call(cache5, base)) {
          return gotResolvedLink(cache5[base]);
        }
        return fs9.lstat(base, gotStat);
      }
      function gotStat(err3, stat2) {
        if (err3) return cb(err3);
        if (!stat2.isSymbolicLink()) {
          knownHard[base] = true;
          if (cache5) cache5[base] = base;
          return process.nextTick(LOOP);
        }
        if (!isWindows) {
          var id = stat2.dev.toString(32) + ":" + stat2.ino.toString(32);
          if (seenLinks.hasOwnProperty(id)) {
            return gotTarget(null, seenLinks[id], base);
          }
        }
        fs9.stat(base, function(err4) {
          if (err4) return cb(err4);
          fs9.readlink(base, function(err5, target) {
            if (!isWindows) seenLinks[id] = target;
            gotTarget(err5, target);
          });
        });
      }
      function gotTarget(err3, target, base2) {
        if (err3) return cb(err3);
        var resolvedLink = pathModule.resolve(previous, target);
        if (cache5) cache5[base2] = resolvedLink;
        gotResolvedLink(resolvedLink);
      }
      function gotResolvedLink(resolvedLink) {
        p11 = pathModule.resolve(resolvedLink, p11.slice(pos));
        start2();
      }
    };
  }
});

// ../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/index.js
var require_fs = __commonJS({
  "../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/index.js"(exports, module2) {
    "use strict";
    module2.exports = realpath;
    realpath.realpath = realpath;
    realpath.sync = realpathSync;
    realpath.realpathSync = realpathSync;
    realpath.monkeypatch = monkeypatch;
    realpath.unmonkeypatch = unmonkeypatch;
    var fs9 = __require("fs");
    var origRealpath = fs9.realpath;
    var origRealpathSync = fs9.realpathSync;
    var version3 = process.version;
    var ok = /^v[0-5]\./.test(version3);
    var old = require_old();
    function newError(er3) {
      return er3 && er3.syscall === "realpath" && (er3.code === "ELOOP" || er3.code === "ENOMEM" || er3.code === "ENAMETOOLONG");
    }
    function realpath(p11, cache5, cb) {
      if (ok) {
        return origRealpath(p11, cache5, cb);
      }
      if (typeof cache5 === "function") {
        cb = cache5;
        cache5 = null;
      }
      origRealpath(p11, cache5, function(er3, result) {
        if (newError(er3)) {
          old.realpath(p11, cache5, cb);
        } else {
          cb(er3, result);
        }
      });
    }
    function realpathSync(p11, cache5) {
      if (ok) {
        return origRealpathSync(p11, cache5);
      }
      try {
        return origRealpathSync(p11, cache5);
      } catch (er3) {
        if (newError(er3)) {
          return old.realpathSync(p11, cache5);
        } else {
          throw er3;
        }
      }
    }
    function monkeypatch() {
      fs9.realpath = realpath;
      fs9.realpathSync = realpathSync;
    }
    function unmonkeypatch() {
      fs9.realpath = origRealpath;
      fs9.realpathSync = origRealpathSync;
    }
  }
});

// ../node_modules/.pnpm/minimatch@5.1.6/node_modules/minimatch/lib/path.js
var require_path = __commonJS({
  "../node_modules/.pnpm/minimatch@5.1.6/node_modules/minimatch/lib/path.js"(exports, module2) {
    "use strict";
    var isWindows = typeof process === "object" && process && process.platform === "win32";
    module2.exports = isWindows ? { sep: "\\" } : { sep: "/" };
  }
});

// ../node_modules/.pnpm/balanced-match@1.0.2/node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "../node_modules/.pnpm/balanced-match@1.0.2/node_modules/balanced-match/index.js"(exports, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a9, b9, str) {
      if (a9 instanceof RegExp) a9 = maybeMatch(a9, str);
      if (b9 instanceof RegExp) b9 = maybeMatch(b9, str);
      var r6 = range(a9, b9, str);
      return r6 && {
        start: r6[0],
        end: r6[1],
        pre: str.slice(0, r6[0]),
        body: str.slice(r6[0] + a9.length, r6[1]),
        post: str.slice(r6[1] + b9.length)
      };
    }
    function maybeMatch(reg, str) {
      var m12 = str.match(reg);
      return m12 ? m12[0] : null;
    }
    balanced.range = range;
    function range(a9, b9, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a9);
      var bi = str.indexOf(b9, ai + 1);
      var i8 = ai;
      if (ai >= 0 && bi > 0) {
        if (a9 === b9) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i8 >= 0 && !result) {
          if (i8 == ai) {
            begs.push(i8);
            ai = str.indexOf(a9, i8 + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b9, i8 + 1);
          }
          i8 = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// ../node_modules/.pnpm/brace-expansion@2.0.1/node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "../node_modules/.pnpm/brace-expansion@2.0.1/node_modules/brace-expansion/index.js"(exports, module2) {
    "use strict";
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric3(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts2 = [];
      var m12 = balanced("{", "}", str);
      if (!m12)
        return str.split(",");
      var pre = m12.pre;
      var body2 = m12.body;
      var post = m12.post;
      var p11 = pre.split(",");
      p11[p11.length - 1] += "{" + body2 + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p11[p11.length - 1] += postParts.shift();
        p11.push.apply(p11, postParts);
      }
      parts2.push.apply(parts2, p11);
      return parts2;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand2(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte2(i8, y7) {
      return i8 <= y7;
    }
    function gte2(i8, y7) {
      return i8 >= y7;
    }
    function expand2(str, isTop) {
      var expansions = [];
      var m12 = balanced("{", "}", str);
      if (!m12) return [str];
      var pre = m12.pre;
      var post = m12.post.length ? expand2(m12.post, false) : [""];
      if (/\$$/.test(m12.pre)) {
        for (var k9 = 0; k9 < post.length; k9++) {
          var expansion = pre + "{" + m12.body + "}" + post[k9];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m12.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m12.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m12.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m12.post.match(/,.*\}/)) {
            str = m12.pre + "{" + m12.body + escClose + m12.post;
            return expand2(str);
          }
          return [str];
        }
        var n7;
        if (isSequence) {
          n7 = m12.body.split(/\.\./);
        } else {
          n7 = parseCommaParts(m12.body);
          if (n7.length === 1) {
            n7 = expand2(n7[0], false).map(embrace);
            if (n7.length === 1) {
              return post.map(function(p11) {
                return m12.pre + n7[0] + p11;
              });
            }
          }
        }
        var N5;
        if (isSequence) {
          var x11 = numeric3(n7[0]);
          var y7 = numeric3(n7[1]);
          var width = Math.max(n7[0].length, n7[1].length);
          var incr = n7.length == 3 ? Math.abs(numeric3(n7[2])) : 1;
          var test = lte2;
          var reverse = y7 < x11;
          if (reverse) {
            incr *= -1;
            test = gte2;
          }
          var pad = n7.some(isPadded);
          N5 = [];
          for (var i8 = x11; test(i8, y7); i8 += incr) {
            var c6;
            if (isAlphaSequence) {
              c6 = String.fromCharCode(i8);
              if (c6 === "\\")
                c6 = "";
            } else {
              c6 = String(i8);
              if (pad) {
                var need = width - c6.length;
                if (need > 0) {
                  var z6 = new Array(need + 1).join("0");
                  if (i8 < 0)
                    c6 = "-" + z6 + c6.slice(1);
                  else
                    c6 = z6 + c6;
                }
              }
            }
            N5.push(c6);
          }
        } else {
          N5 = [];
          for (var j7 = 0; j7 < n7.length; j7++) {
            N5.push.apply(N5, expand2(n7[j7], false));
          }
        }
        for (var j7 = 0; j7 < N5.length; j7++) {
          for (var k9 = 0; k9 < post.length; k9++) {
            var expansion = pre + N5[j7] + post[k9];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
  }
});

// ../node_modules/.pnpm/minimatch@5.1.6/node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "../node_modules/.pnpm/minimatch@5.1.6/node_modules/minimatch/minimatch.js"(exports, module2) {
    "use strict";
    var minimatch2 = module2.exports = (p11, pattern, options = {}) => {
      assertValidPattern2(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch2(pattern, options).match(p11);
    };
    module2.exports = minimatch2;
    var path3 = require_path();
    minimatch2.sep = path3.sep;
    var GLOBSTAR2 = Symbol("globstar **");
    minimatch2.GLOBSTAR = GLOBSTAR2;
    var expand2 = require_brace_expansion();
    var plTypes2 = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark2 = "[^/]";
    var star2 = qmark2 + "*?";
    var twoStarDot2 = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot2 = "(?:(?!(?:\\/|^)\\.).)*?";
    var charSet2 = (s10) => s10.split("").reduce((set, c6) => {
      set[c6] = true;
      return set;
    }, {});
    var reSpecials2 = charSet2("().*{}+?[]^$\\!");
    var addPatternStartSet2 = charSet2("[.(");
    var slashSplit = /\/+/;
    minimatch2.filter = (pattern, options = {}) => (p11, i8, list) => minimatch2(p11, pattern, options);
    var ext2 = (a9, b9 = {}) => {
      const t6 = {};
      Object.keys(a9).forEach((k9) => t6[k9] = a9[k9]);
      Object.keys(b9).forEach((k9) => t6[k9] = b9[k9]);
      return t6;
    };
    minimatch2.defaults = (def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch2;
      }
      const orig = minimatch2;
      const m12 = (p11, pattern, options) => orig(p11, pattern, ext2(def, options));
      m12.Minimatch = class Minimatch extends orig.Minimatch {
        constructor(pattern, options) {
          super(pattern, ext2(def, options));
        }
      };
      m12.Minimatch.defaults = (options) => orig.defaults(ext2(def, options)).Minimatch;
      m12.filter = (pattern, options) => orig.filter(pattern, ext2(def, options));
      m12.defaults = (options) => orig.defaults(ext2(def, options));
      m12.makeRe = (pattern, options) => orig.makeRe(pattern, ext2(def, options));
      m12.braceExpand = (pattern, options) => orig.braceExpand(pattern, ext2(def, options));
      m12.match = (list, pattern, options) => orig.match(list, pattern, ext2(def, options));
      return m12;
    };
    minimatch2.braceExpand = (pattern, options) => braceExpand2(pattern, options);
    var braceExpand2 = (pattern, options = {}) => {
      assertValidPattern2(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return expand2(pattern);
    };
    var MAX_PATTERN_LENGTH2 = 1024 * 64;
    var assertValidPattern2 = (pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH2) {
        throw new TypeError("pattern is too long");
      }
    };
    var SUBPARSE = Symbol("subparse");
    minimatch2.makeRe = (pattern, options) => new Minimatch2(pattern, options || {}).makeRe();
    minimatch2.match = (list, pattern, options = {}) => {
      const mm = new Minimatch2(pattern, options);
      list = list.filter((f9) => mm.match(f9));
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    var globUnescape2 = (s10) => s10.replace(/\\(.)/g, "$1");
    var charUnescape = (s10) => s10.replace(/\\([^-\]])/g, "$1");
    var regExpEscape2 = (s10) => s10.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var braExpEscape = (s10) => s10.replace(/[[\]\\]/g, "\\$&");
    var Minimatch2 = class {
      constructor(pattern, options) {
        assertValidPattern2(pattern);
        if (!options) options = {};
        this.options = options;
        this.set = [];
        this.pattern = pattern;
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.regexp = null;
        this.negate = false;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.make();
      }
      debug() {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        let set = this.globSet = this.braceExpand();
        if (options.debug) this.debug = (...args2) => console.error(...args2);
        this.debug(this.pattern, set);
        set = this.globParts = set.map((s10) => s10.split(slashSplit));
        this.debug(this.pattern, set);
        set = set.map((s10, si2, set2) => s10.map(this.parse, this));
        this.debug(this.pattern, set);
        set = set.filter((s10) => s10.indexOf(false) === -1);
        this.debug(this.pattern, set);
        this.set = set;
      }
      parseNegate() {
        if (this.options.nonegate) return;
        const pattern = this.pattern;
        let negate2 = false;
        let negateOffset = 0;
        for (let i8 = 0; i8 < pattern.length && pattern.charAt(i8) === "!"; i8++) {
          negate2 = !negate2;
          negateOffset++;
        }
        if (negateOffset) this.pattern = pattern.slice(negateOffset);
        this.negate = negate2;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial) {
        var options = this.options;
        this.debug(
          "matchOne",
          { "this": this, file, pattern }
        );
        this.debug("matchOne", file.length, pattern.length);
        for (var fi2 = 0, pi2 = 0, fl = file.length, pl = pattern.length; fi2 < fl && pi2 < pl; fi2++, pi2++) {
          this.debug("matchOne loop");
          var p11 = pattern[pi2];
          var f9 = file[fi2];
          this.debug(pattern, p11, f9);
          if (p11 === false) return false;
          if (p11 === GLOBSTAR2) {
            this.debug("GLOBSTAR", [pattern, p11, f9]);
            var fr3 = fi2;
            var pr2 = pi2 + 1;
            if (pr2 === pl) {
              this.debug("** at the end");
              for (; fi2 < fl; fi2++) {
                if (file[fi2] === "." || file[fi2] === ".." || !options.dot && file[fi2].charAt(0) === ".") return false;
              }
              return true;
            }
            while (fr3 < fl) {
              var swallowee = file[fr3];
              this.debug("\nglobstar while", file, fr3, pattern, pr2, swallowee);
              if (this.matchOne(file.slice(fr3), pattern.slice(pr2), partial)) {
                this.debug("globstar found match!", fr3, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr3, pattern, pr2);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr3++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr3, pattern, pr2);
              if (fr3 === fl) return true;
            }
            return false;
          }
          var hit;
          if (typeof p11 === "string") {
            hit = f9 === p11;
            this.debug("string match", p11, f9, hit);
          } else {
            hit = f9.match(p11);
            this.debug("pattern match", p11, f9, hit);
          }
          if (!hit) return false;
        }
        if (fi2 === fl && pi2 === pl) {
          return true;
        } else if (fi2 === fl) {
          return partial;
        } else if (pi2 === pl) {
          return fi2 === fl - 1 && file[fi2] === "";
        }
        throw new Error("wtf?");
      }
      braceExpand() {
        return braceExpand2(this.pattern, this.options);
      }
      parse(pattern, isSub) {
        assertValidPattern2(pattern);
        const options = this.options;
        if (pattern === "**") {
          if (!options.noglobstar)
            return GLOBSTAR2;
          else
            pattern = "*";
        }
        if (pattern === "") return "";
        let re3 = "";
        let hasMagic = false;
        let escaping = false;
        const patternListStack = [];
        const negativeLists = [];
        let stateChar;
        let inClass = false;
        let reClassStart = -1;
        let classStart = -1;
        let cs2;
        let pl;
        let sp;
        let dotTravAllowed = pattern.charAt(0) === ".";
        let dotFileAllowed = options.dot || dotTravAllowed;
        const patternStart = () => dotTravAllowed ? "" : dotFileAllowed ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
        const subPatternStart = (p11) => p11.charAt(0) === "." ? "" : options.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
        const clearStateChar = () => {
          if (stateChar) {
            switch (stateChar) {
              case "*":
                re3 += star2;
                hasMagic = true;
                break;
              case "?":
                re3 += qmark2;
                hasMagic = true;
                break;
              default:
                re3 += "\\" + stateChar;
                break;
            }
            this.debug("clearStateChar %j %j", stateChar, re3);
            stateChar = false;
          }
        };
        for (let i8 = 0, c6; i8 < pattern.length && (c6 = pattern.charAt(i8)); i8++) {
          this.debug("%s	%s %s %j", pattern, i8, re3, c6);
          if (escaping) {
            if (c6 === "/") {
              return false;
            }
            if (reSpecials2[c6]) {
              re3 += "\\";
            }
            re3 += c6;
            escaping = false;
            continue;
          }
          switch (c6) {
            /* istanbul ignore next */
            case "/": {
              return false;
            }
            case "\\":
              if (inClass && pattern.charAt(i8 + 1) === "-") {
                re3 += c6;
                continue;
              }
              clearStateChar();
              escaping = true;
              continue;
            // the various stateChar values
            // for the "extglob" stuff.
            case "?":
            case "*":
            case "+":
            case "@":
            case "!":
              this.debug("%s	%s %s %j <-- stateChar", pattern, i8, re3, c6);
              if (inClass) {
                this.debug("  in class");
                if (c6 === "!" && i8 === classStart + 1) c6 = "^";
                re3 += c6;
                continue;
              }
              this.debug("call clearStateChar %j", stateChar);
              clearStateChar();
              stateChar = c6;
              if (options.noext) clearStateChar();
              continue;
            case "(": {
              if (inClass) {
                re3 += "(";
                continue;
              }
              if (!stateChar) {
                re3 += "\\(";
                continue;
              }
              const plEntry = {
                type: stateChar,
                start: i8 - 1,
                reStart: re3.length,
                open: plTypes2[stateChar].open,
                close: plTypes2[stateChar].close
              };
              this.debug(this.pattern, "	", plEntry);
              patternListStack.push(plEntry);
              re3 += plEntry.open;
              if (plEntry.start === 0 && plEntry.type !== "!") {
                dotTravAllowed = true;
                re3 += subPatternStart(pattern.slice(i8 + 1));
              }
              this.debug("plType %j %j", stateChar, re3);
              stateChar = false;
              continue;
            }
            case ")": {
              const plEntry = patternListStack[patternListStack.length - 1];
              if (inClass || !plEntry) {
                re3 += "\\)";
                continue;
              }
              patternListStack.pop();
              clearStateChar();
              hasMagic = true;
              pl = plEntry;
              re3 += pl.close;
              if (pl.type === "!") {
                negativeLists.push(Object.assign(pl, { reEnd: re3.length }));
              }
              continue;
            }
            case "|": {
              const plEntry = patternListStack[patternListStack.length - 1];
              if (inClass || !plEntry) {
                re3 += "\\|";
                continue;
              }
              clearStateChar();
              re3 += "|";
              if (plEntry.start === 0 && plEntry.type !== "!") {
                dotTravAllowed = true;
                re3 += subPatternStart(pattern.slice(i8 + 1));
              }
              continue;
            }
            // these are mostly the same in regexp and glob
            case "[":
              clearStateChar();
              if (inClass) {
                re3 += "\\" + c6;
                continue;
              }
              inClass = true;
              classStart = i8;
              reClassStart = re3.length;
              re3 += c6;
              continue;
            case "]":
              if (i8 === classStart + 1 || !inClass) {
                re3 += "\\" + c6;
                continue;
              }
              cs2 = pattern.substring(classStart + 1, i8);
              try {
                RegExp("[" + braExpEscape(charUnescape(cs2)) + "]");
                re3 += c6;
              } catch (er3) {
                re3 = re3.substring(0, reClassStart) + "(?:$.)";
              }
              hasMagic = true;
              inClass = false;
              continue;
            default:
              clearStateChar();
              if (reSpecials2[c6] && !(c6 === "^" && inClass)) {
                re3 += "\\";
              }
              re3 += c6;
              break;
          }
        }
        if (inClass) {
          cs2 = pattern.slice(classStart + 1);
          sp = this.parse(cs2, SUBPARSE);
          re3 = re3.substring(0, reClassStart) + "\\[" + sp[0];
          hasMagic = hasMagic || sp[1];
        }
        for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
          let tail;
          tail = re3.slice(pl.reStart + pl.open.length);
          this.debug("setting tail", re3, pl);
          tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, (_7, $1, $22) => {
            if (!$22) {
              $22 = "\\";
            }
            return $1 + $1 + $22 + "|";
          });
          this.debug("tail=%j\n   %s", tail, tail, pl, re3);
          const t6 = pl.type === "*" ? star2 : pl.type === "?" ? qmark2 : "\\" + pl.type;
          hasMagic = true;
          re3 = re3.slice(0, pl.reStart) + t6 + "\\(" + tail;
        }
        clearStateChar();
        if (escaping) {
          re3 += "\\\\";
        }
        const addPatternStart = addPatternStartSet2[re3.charAt(0)];
        for (let n7 = negativeLists.length - 1; n7 > -1; n7--) {
          const nl = negativeLists[n7];
          const nlBefore = re3.slice(0, nl.reStart);
          const nlFirst = re3.slice(nl.reStart, nl.reEnd - 8);
          let nlAfter = re3.slice(nl.reEnd);
          const nlLast = re3.slice(nl.reEnd - 8, nl.reEnd) + nlAfter;
          const closeParensBefore = nlBefore.split(")").length;
          const openParensBefore = nlBefore.split("(").length - closeParensBefore;
          let cleanAfter = nlAfter;
          for (let i8 = 0; i8 < openParensBefore; i8++) {
            cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
          }
          nlAfter = cleanAfter;
          const dollar = nlAfter === "" && isSub !== SUBPARSE ? "(?:$|\\/)" : "";
          re3 = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        if (re3 !== "" && hasMagic) {
          re3 = "(?=.)" + re3;
        }
        if (addPatternStart) {
          re3 = patternStart() + re3;
        }
        if (isSub === SUBPARSE) {
          return [re3, hasMagic];
        }
        if (options.nocase && !hasMagic) {
          hasMagic = pattern.toUpperCase() !== pattern.toLowerCase();
        }
        if (!hasMagic) {
          return globUnescape2(pattern);
        }
        const flags2 = options.nocase ? "i" : "";
        try {
          return Object.assign(new RegExp("^" + re3 + "$", flags2), {
            _glob: pattern,
            _src: re3
          });
        } catch (er3) {
          return new RegExp("$.");
        }
      }
      makeRe() {
        if (this.regexp || this.regexp === false) return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star2 : options.dot ? twoStarDot2 : twoStarNoDot2;
        const flags2 = options.nocase ? "i" : "";
        let re3 = set.map((pattern) => {
          pattern = pattern.map(
            (p11) => typeof p11 === "string" ? regExpEscape2(p11) : p11 === GLOBSTAR2 ? GLOBSTAR2 : p11._src
          ).reduce((set2, p11) => {
            if (!(set2[set2.length - 1] === GLOBSTAR2 && p11 === GLOBSTAR2)) {
              set2.push(p11);
            }
            return set2;
          }, []);
          pattern.forEach((p11, i8) => {
            if (p11 !== GLOBSTAR2 || pattern[i8 - 1] === GLOBSTAR2) {
              return;
            }
            if (i8 === 0) {
              if (pattern.length > 1) {
                pattern[i8 + 1] = "(?:\\/|" + twoStar + "\\/)?" + pattern[i8 + 1];
              } else {
                pattern[i8] = twoStar;
              }
            } else if (i8 === pattern.length - 1) {
              pattern[i8 - 1] += "(?:\\/|" + twoStar + ")?";
            } else {
              pattern[i8 - 1] += "(?:\\/|\\/" + twoStar + "\\/)" + pattern[i8 + 1];
              pattern[i8 + 1] = GLOBSTAR2;
            }
          });
          return pattern.filter((p11) => p11 !== GLOBSTAR2).join("/");
        }).join("|");
        re3 = "^(?:" + re3 + ")$";
        if (this.negate) re3 = "^(?!" + re3 + ").*$";
        try {
          this.regexp = new RegExp(re3, flags2);
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      match(f9, partial = this.partial) {
        this.debug("match", f9, this.pattern);
        if (this.comment) return false;
        if (this.empty) return f9 === "";
        if (f9 === "/" && partial) return true;
        const options = this.options;
        if (path3.sep !== "/") {
          f9 = f9.split(path3.sep).join("/");
        }
        f9 = f9.split(slashSplit);
        this.debug(this.pattern, "split", f9);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename;
        for (let i8 = f9.length - 1; i8 >= 0; i8--) {
          filename = f9[i8];
          if (filename) break;
        }
        for (let i8 = 0; i8 < set.length; i8++) {
          const pattern = set[i8];
          let file = f9;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) return true;
            return !this.negate;
          }
        }
        if (options.flipNegate) return false;
        return this.negate;
      }
      static defaults(def) {
        return minimatch2.defaults(def).Minimatch;
      }
    };
    minimatch2.Minimatch = Minimatch2;
  }
});

// ../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js"(exports, module2) {
    "use strict";
    if (typeof Object.create === "function") {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function() {
          };
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
  }
});

// ../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits.js"(exports, module2) {
    "use strict";
    try {
      util2 = __require("util");
      if (typeof util2.inherits !== "function") throw "";
      module2.exports = util2.inherits;
    } catch (e6) {
      module2.exports = require_inherits_browser();
    }
    var util2;
  }
});

// ../node_modules/.pnpm/glob@8.1.0/node_modules/glob/common.js
var require_common = __commonJS({
  "../node_modules/.pnpm/glob@8.1.0/node_modules/glob/common.js"(exports) {
    "use strict";
    exports.setopts = setopts;
    exports.ownProp = ownProp;
    exports.makeAbs = makeAbs;
    exports.finish = finish;
    exports.mark = mark;
    exports.isIgnored = isIgnored;
    exports.childrenIgnored = childrenIgnored;
    function ownProp(obj, field) {
      return Object.prototype.hasOwnProperty.call(obj, field);
    }
    var fs9 = __require("fs");
    var path3 = __require("path");
    var minimatch2 = require_minimatch();
    var isAbsolute = __require("path").isAbsolute;
    var Minimatch2 = minimatch2.Minimatch;
    function alphasort(a9, b9) {
      return a9.localeCompare(b9, "en");
    }
    function setupIgnores(self2, options) {
      self2.ignore = options.ignore || [];
      if (!Array.isArray(self2.ignore))
        self2.ignore = [self2.ignore];
      if (self2.ignore.length) {
        self2.ignore = self2.ignore.map(ignoreMap);
      }
    }
    function ignoreMap(pattern) {
      var gmatcher = null;
      if (pattern.slice(-3) === "/**") {
        var gpattern = pattern.replace(/(\/\*\*)+$/, "");
        gmatcher = new Minimatch2(gpattern, { dot: true });
      }
      return {
        matcher: new Minimatch2(pattern, { dot: true }),
        gmatcher
      };
    }
    function setopts(self2, pattern, options) {
      if (!options)
        options = {};
      if (options.matchBase && -1 === pattern.indexOf("/")) {
        if (options.noglobstar) {
          throw new Error("base matching requires globstar");
        }
        pattern = "**/" + pattern;
      }
      self2.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
      if (self2.windowsPathsNoEscape) {
        pattern = pattern.replace(/\\/g, "/");
      }
      self2.silent = !!options.silent;
      self2.pattern = pattern;
      self2.strict = options.strict !== false;
      self2.realpath = !!options.realpath;
      self2.realpathCache = options.realpathCache || /* @__PURE__ */ Object.create(null);
      self2.follow = !!options.follow;
      self2.dot = !!options.dot;
      self2.mark = !!options.mark;
      self2.nodir = !!options.nodir;
      if (self2.nodir)
        self2.mark = true;
      self2.sync = !!options.sync;
      self2.nounique = !!options.nounique;
      self2.nonull = !!options.nonull;
      self2.nosort = !!options.nosort;
      self2.nocase = !!options.nocase;
      self2.stat = !!options.stat;
      self2.noprocess = !!options.noprocess;
      self2.absolute = !!options.absolute;
      self2.fs = options.fs || fs9;
      self2.maxLength = options.maxLength || Infinity;
      self2.cache = options.cache || /* @__PURE__ */ Object.create(null);
      self2.statCache = options.statCache || /* @__PURE__ */ Object.create(null);
      self2.symlinks = options.symlinks || /* @__PURE__ */ Object.create(null);
      setupIgnores(self2, options);
      self2.changedCwd = false;
      var cwd = process.cwd();
      if (!ownProp(options, "cwd"))
        self2.cwd = path3.resolve(cwd);
      else {
        self2.cwd = path3.resolve(options.cwd);
        self2.changedCwd = self2.cwd !== cwd;
      }
      self2.root = options.root || path3.resolve(self2.cwd, "/");
      self2.root = path3.resolve(self2.root);
      self2.cwdAbs = isAbsolute(self2.cwd) ? self2.cwd : makeAbs(self2, self2.cwd);
      self2.nomount = !!options.nomount;
      if (process.platform === "win32") {
        self2.root = self2.root.replace(/\\/g, "/");
        self2.cwd = self2.cwd.replace(/\\/g, "/");
        self2.cwdAbs = self2.cwdAbs.replace(/\\/g, "/");
      }
      options.nonegate = true;
      options.nocomment = true;
      self2.minimatch = new Minimatch2(pattern, options);
      self2.options = self2.minimatch.options;
    }
    function finish(self2) {
      var nou = self2.nounique;
      var all = nou ? [] : /* @__PURE__ */ Object.create(null);
      for (var i8 = 0, l7 = self2.matches.length; i8 < l7; i8++) {
        var matches = self2.matches[i8];
        if (!matches || Object.keys(matches).length === 0) {
          if (self2.nonull) {
            var literal = self2.minimatch.globSet[i8];
            if (nou)
              all.push(literal);
            else
              all[literal] = true;
          }
        } else {
          var m12 = Object.keys(matches);
          if (nou)
            all.push.apply(all, m12);
          else
            m12.forEach(function(m13) {
              all[m13] = true;
            });
        }
      }
      if (!nou)
        all = Object.keys(all);
      if (!self2.nosort)
        all = all.sort(alphasort);
      if (self2.mark) {
        for (var i8 = 0; i8 < all.length; i8++) {
          all[i8] = self2._mark(all[i8]);
        }
        if (self2.nodir) {
          all = all.filter(function(e6) {
            var notDir = !/\/$/.test(e6);
            var c6 = self2.cache[e6] || self2.cache[makeAbs(self2, e6)];
            if (notDir && c6)
              notDir = c6 !== "DIR" && !Array.isArray(c6);
            return notDir;
          });
        }
      }
      if (self2.ignore.length)
        all = all.filter(function(m13) {
          return !isIgnored(self2, m13);
        });
      self2.found = all;
    }
    function mark(self2, p11) {
      var abs = makeAbs(self2, p11);
      var c6 = self2.cache[abs];
      var m12 = p11;
      if (c6) {
        var isDir = c6 === "DIR" || Array.isArray(c6);
        var slash = p11.slice(-1) === "/";
        if (isDir && !slash)
          m12 += "/";
        else if (!isDir && slash)
          m12 = m12.slice(0, -1);
        if (m12 !== p11) {
          var mabs = makeAbs(self2, m12);
          self2.statCache[mabs] = self2.statCache[abs];
          self2.cache[mabs] = self2.cache[abs];
        }
      }
      return m12;
    }
    function makeAbs(self2, f9) {
      var abs = f9;
      if (f9.charAt(0) === "/") {
        abs = path3.join(self2.root, f9);
      } else if (isAbsolute(f9) || f9 === "") {
        abs = f9;
      } else if (self2.changedCwd) {
        abs = path3.resolve(self2.cwd, f9);
      } else {
        abs = path3.resolve(f9);
      }
      if (process.platform === "win32")
        abs = abs.replace(/\\/g, "/");
      return abs;
    }
    function isIgnored(self2, path4) {
      if (!self2.ignore.length)
        return false;
      return self2.ignore.some(function(item) {
        return item.matcher.match(path4) || !!(item.gmatcher && item.gmatcher.match(path4));
      });
    }
    function childrenIgnored(self2, path4) {
      if (!self2.ignore.length)
        return false;
      return self2.ignore.some(function(item) {
        return !!(item.gmatcher && item.gmatcher.match(path4));
      });
    }
  }
});

// ../node_modules/.pnpm/glob@8.1.0/node_modules/glob/sync.js
var require_sync = __commonJS({
  "../node_modules/.pnpm/glob@8.1.0/node_modules/glob/sync.js"(exports, module2) {
    "use strict";
    module2.exports = globSync;
    globSync.GlobSync = GlobSync;
    var rp = require_fs();
    var minimatch2 = require_minimatch();
    var Minimatch2 = minimatch2.Minimatch;
    var Glob = require_glob().Glob;
    var util2 = __require("util");
    var path3 = __require("path");
    var assert2 = __require("assert");
    var isAbsolute = __require("path").isAbsolute;
    var common = require_common();
    var setopts = common.setopts;
    var ownProp = common.ownProp;
    var childrenIgnored = common.childrenIgnored;
    var isIgnored = common.isIgnored;
    function globSync(pattern, options) {
      if (typeof options === "function" || arguments.length === 3)
        throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
      return new GlobSync(pattern, options).found;
    }
    function GlobSync(pattern, options) {
      if (!pattern)
        throw new Error("must provide pattern");
      if (typeof options === "function" || arguments.length === 3)
        throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
      if (!(this instanceof GlobSync))
        return new GlobSync(pattern, options);
      setopts(this, pattern, options);
      if (this.noprocess)
        return this;
      var n7 = this.minimatch.set.length;
      this.matches = new Array(n7);
      for (var i8 = 0; i8 < n7; i8++) {
        this._process(this.minimatch.set[i8], i8, false);
      }
      this._finish();
    }
    GlobSync.prototype._finish = function() {
      assert2.ok(this instanceof GlobSync);
      if (this.realpath) {
        var self2 = this;
        this.matches.forEach(function(matchset, index7) {
          var set = self2.matches[index7] = /* @__PURE__ */ Object.create(null);
          for (var p11 in matchset) {
            try {
              p11 = self2._makeAbs(p11);
              var real5 = rp.realpathSync(p11, self2.realpathCache);
              set[real5] = true;
            } catch (er3) {
              if (er3.syscall === "stat")
                set[self2._makeAbs(p11)] = true;
              else
                throw er3;
            }
          }
        });
      }
      common.finish(this);
    };
    GlobSync.prototype._process = function(pattern, index7, inGlobStar) {
      assert2.ok(this instanceof GlobSync);
      var n7 = 0;
      while (typeof pattern[n7] === "string") {
        n7++;
      }
      var prefix2;
      switch (n7) {
        // if not, then this is rather simple
        case pattern.length:
          this._processSimple(pattern.join("/"), index7);
          return;
        case 0:
          prefix2 = null;
          break;
        default:
          prefix2 = pattern.slice(0, n7).join("/");
          break;
      }
      var remain = pattern.slice(n7);
      var read;
      if (prefix2 === null)
        read = ".";
      else if (isAbsolute(prefix2) || isAbsolute(pattern.map(function(p11) {
        return typeof p11 === "string" ? p11 : "[*]";
      }).join("/"))) {
        if (!prefix2 || !isAbsolute(prefix2))
          prefix2 = "/" + prefix2;
        read = prefix2;
      } else
        read = prefix2;
      var abs = this._makeAbs(read);
      if (childrenIgnored(this, read))
        return;
      var isGlobStar = remain[0] === minimatch2.GLOBSTAR;
      if (isGlobStar)
        this._processGlobStar(prefix2, read, abs, remain, index7, inGlobStar);
      else
        this._processReaddir(prefix2, read, abs, remain, index7, inGlobStar);
    };
    GlobSync.prototype._processReaddir = function(prefix2, read, abs, remain, index7, inGlobStar) {
      var entries = this._readdir(abs, inGlobStar);
      if (!entries)
        return;
      var pn2 = remain[0];
      var negate2 = !!this.minimatch.negate;
      var rawGlob = pn2._glob;
      var dotOk = this.dot || rawGlob.charAt(0) === ".";
      var matchedEntries = [];
      for (var i8 = 0; i8 < entries.length; i8++) {
        var e6 = entries[i8];
        if (e6.charAt(0) !== "." || dotOk) {
          var m12;
          if (negate2 && !prefix2) {
            m12 = !e6.match(pn2);
          } else {
            m12 = e6.match(pn2);
          }
          if (m12)
            matchedEntries.push(e6);
        }
      }
      var len = matchedEntries.length;
      if (len === 0)
        return;
      if (remain.length === 1 && !this.mark && !this.stat) {
        if (!this.matches[index7])
          this.matches[index7] = /* @__PURE__ */ Object.create(null);
        for (var i8 = 0; i8 < len; i8++) {
          var e6 = matchedEntries[i8];
          if (prefix2) {
            if (prefix2.slice(-1) !== "/")
              e6 = prefix2 + "/" + e6;
            else
              e6 = prefix2 + e6;
          }
          if (e6.charAt(0) === "/" && !this.nomount) {
            e6 = path3.join(this.root, e6);
          }
          this._emitMatch(index7, e6);
        }
        return;
      }
      remain.shift();
      for (var i8 = 0; i8 < len; i8++) {
        var e6 = matchedEntries[i8];
        var newPattern;
        if (prefix2)
          newPattern = [prefix2, e6];
        else
          newPattern = [e6];
        this._process(newPattern.concat(remain), index7, inGlobStar);
      }
    };
    GlobSync.prototype._emitMatch = function(index7, e6) {
      if (isIgnored(this, e6))
        return;
      var abs = this._makeAbs(e6);
      if (this.mark)
        e6 = this._mark(e6);
      if (this.absolute) {
        e6 = abs;
      }
      if (this.matches[index7][e6])
        return;
      if (this.nodir) {
        var c6 = this.cache[abs];
        if (c6 === "DIR" || Array.isArray(c6))
          return;
      }
      this.matches[index7][e6] = true;
      if (this.stat)
        this._stat(e6);
    };
    GlobSync.prototype._readdirInGlobStar = function(abs) {
      if (this.follow)
        return this._readdir(abs, false);
      var entries;
      var lstat;
      var stat2;
      try {
        lstat = this.fs.lstatSync(abs);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return null;
        }
      }
      var isSym = lstat && lstat.isSymbolicLink();
      this.symlinks[abs] = isSym;
      if (!isSym && lstat && !lstat.isDirectory())
        this.cache[abs] = "FILE";
      else
        entries = this._readdir(abs, false);
      return entries;
    };
    GlobSync.prototype._readdir = function(abs, inGlobStar) {
      var entries;
      if (inGlobStar && !ownProp(this.symlinks, abs))
        return this._readdirInGlobStar(abs);
      if (ownProp(this.cache, abs)) {
        var c6 = this.cache[abs];
        if (!c6 || c6 === "FILE")
          return null;
        if (Array.isArray(c6))
          return c6;
      }
      try {
        return this._readdirEntries(abs, this.fs.readdirSync(abs));
      } catch (er3) {
        this._readdirError(abs, er3);
        return null;
      }
    };
    GlobSync.prototype._readdirEntries = function(abs, entries) {
      if (!this.mark && !this.stat) {
        for (var i8 = 0; i8 < entries.length; i8++) {
          var e6 = entries[i8];
          if (abs === "/")
            e6 = abs + e6;
          else
            e6 = abs + "/" + e6;
          this.cache[e6] = true;
        }
      }
      this.cache[abs] = entries;
      return entries;
    };
    GlobSync.prototype._readdirError = function(f9, er3) {
      switch (er3.code) {
        case "ENOTSUP":
        // https://github.com/isaacs/node-glob/issues/205
        case "ENOTDIR":
          var abs = this._makeAbs(f9);
          this.cache[abs] = "FILE";
          if (abs === this.cwdAbs) {
            var error2 = new Error(er3.code + " invalid cwd " + this.cwd);
            error2.path = this.cwd;
            error2.code = er3.code;
            throw error2;
          }
          break;
        case "ENOENT":
        // not terribly unusual
        case "ELOOP":
        case "ENAMETOOLONG":
        case "UNKNOWN":
          this.cache[this._makeAbs(f9)] = false;
          break;
        default:
          this.cache[this._makeAbs(f9)] = false;
          if (this.strict)
            throw er3;
          if (!this.silent)
            console.error("glob error", er3);
          break;
      }
    };
    GlobSync.prototype._processGlobStar = function(prefix2, read, abs, remain, index7, inGlobStar) {
      var entries = this._readdir(abs, inGlobStar);
      if (!entries)
        return;
      var remainWithoutGlobStar = remain.slice(1);
      var gspref = prefix2 ? [prefix2] : [];
      var noGlobStar = gspref.concat(remainWithoutGlobStar);
      this._process(noGlobStar, index7, false);
      var len = entries.length;
      var isSym = this.symlinks[abs];
      if (isSym && inGlobStar)
        return;
      for (var i8 = 0; i8 < len; i8++) {
        var e6 = entries[i8];
        if (e6.charAt(0) === "." && !this.dot)
          continue;
        var instead = gspref.concat(entries[i8], remainWithoutGlobStar);
        this._process(instead, index7, true);
        var below = gspref.concat(entries[i8], remain);
        this._process(below, index7, true);
      }
    };
    GlobSync.prototype._processSimple = function(prefix2, index7) {
      var exists2 = this._stat(prefix2);
      if (!this.matches[index7])
        this.matches[index7] = /* @__PURE__ */ Object.create(null);
      if (!exists2)
        return;
      if (prefix2 && isAbsolute(prefix2) && !this.nomount) {
        var trail = /[\/\\]$/.test(prefix2);
        if (prefix2.charAt(0) === "/") {
          prefix2 = path3.join(this.root, prefix2);
        } else {
          prefix2 = path3.resolve(this.root, prefix2);
          if (trail)
            prefix2 += "/";
        }
      }
      if (process.platform === "win32")
        prefix2 = prefix2.replace(/\\/g, "/");
      this._emitMatch(index7, prefix2);
    };
    GlobSync.prototype._stat = function(f9) {
      var abs = this._makeAbs(f9);
      var needDir = f9.slice(-1) === "/";
      if (f9.length > this.maxLength)
        return false;
      if (!this.stat && ownProp(this.cache, abs)) {
        var c6 = this.cache[abs];
        if (Array.isArray(c6))
          c6 = "DIR";
        if (!needDir || c6 === "DIR")
          return c6;
        if (needDir && c6 === "FILE")
          return false;
      }
      var exists2;
      var stat2 = this.statCache[abs];
      if (!stat2) {
        var lstat;
        try {
          lstat = this.fs.lstatSync(abs);
        } catch (er3) {
          if (er3 && (er3.code === "ENOENT" || er3.code === "ENOTDIR")) {
            this.statCache[abs] = false;
            return false;
          }
        }
        if (lstat && lstat.isSymbolicLink()) {
          try {
            stat2 = this.fs.statSync(abs);
          } catch (er3) {
            stat2 = lstat;
          }
        } else {
          stat2 = lstat;
        }
      }
      this.statCache[abs] = stat2;
      var c6 = true;
      if (stat2)
        c6 = stat2.isDirectory() ? "DIR" : "FILE";
      this.cache[abs] = this.cache[abs] || c6;
      if (needDir && c6 === "FILE")
        return false;
      return c6;
    };
    GlobSync.prototype._mark = function(p11) {
      return common.mark(this, p11);
    };
    GlobSync.prototype._makeAbs = function(f9) {
      return common.makeAbs(this, f9);
    };
  }
});

// ../node_modules/.pnpm/wrappy@1.0.2/node_modules/wrappy/wrappy.js
var require_wrappy = __commonJS({
  "../node_modules/.pnpm/wrappy@1.0.2/node_modules/wrappy/wrappy.js"(exports, module2) {
    "use strict";
    module2.exports = wrappy;
    function wrappy(fn3, cb) {
      if (fn3 && cb) return wrappy(fn3)(cb);
      if (typeof fn3 !== "function")
        throw new TypeError("need wrapper function");
      Object.keys(fn3).forEach(function(k9) {
        wrapper[k9] = fn3[k9];
      });
      return wrapper;
      function wrapper() {
        var args2 = new Array(arguments.length);
        for (var i8 = 0; i8 < args2.length; i8++) {
          args2[i8] = arguments[i8];
        }
        var ret = fn3.apply(this, args2);
        var cb2 = args2[args2.length - 1];
        if (typeof ret === "function" && ret !== cb2) {
          Object.keys(cb2).forEach(function(k9) {
            ret[k9] = cb2[k9];
          });
        }
        return ret;
      }
    }
  }
});

// ../node_modules/.pnpm/once@1.4.0/node_modules/once/once.js
var require_once = __commonJS({
  "../node_modules/.pnpm/once@1.4.0/node_modules/once/once.js"(exports, module2) {
    "use strict";
    var wrappy = require_wrappy();
    module2.exports = wrappy(once3);
    module2.exports.strict = wrappy(onceStrict);
    once3.proto = once3(function() {
      Object.defineProperty(Function.prototype, "once", {
        value: function() {
          return once3(this);
        },
        configurable: true
      });
      Object.defineProperty(Function.prototype, "onceStrict", {
        value: function() {
          return onceStrict(this);
        },
        configurable: true
      });
    });
    function once3(fn3) {
      var f9 = function() {
        if (f9.called) return f9.value;
        f9.called = true;
        return f9.value = fn3.apply(this, arguments);
      };
      f9.called = false;
      return f9;
    }
    function onceStrict(fn3) {
      var f9 = function() {
        if (f9.called)
          throw new Error(f9.onceError);
        f9.called = true;
        return f9.value = fn3.apply(this, arguments);
      };
      var name3 = fn3.name || "Function wrapped with `once`";
      f9.onceError = name3 + " shouldn't be called more than once";
      f9.called = false;
      return f9;
    }
  }
});

// ../node_modules/.pnpm/inflight@1.0.6/node_modules/inflight/inflight.js
var require_inflight = __commonJS({
  "../node_modules/.pnpm/inflight@1.0.6/node_modules/inflight/inflight.js"(exports, module2) {
    "use strict";
    var wrappy = require_wrappy();
    var reqs = /* @__PURE__ */ Object.create(null);
    var once3 = require_once();
    module2.exports = wrappy(inflight);
    function inflight(key, cb) {
      if (reqs[key]) {
        reqs[key].push(cb);
        return null;
      } else {
        reqs[key] = [cb];
        return makeres(key);
      }
    }
    function makeres(key) {
      return once3(function RES() {
        var cbs = reqs[key];
        var len = cbs.length;
        var args2 = slice(arguments);
        try {
          for (var i8 = 0; i8 < len; i8++) {
            cbs[i8].apply(null, args2);
          }
        } finally {
          if (cbs.length > len) {
            cbs.splice(0, len);
            process.nextTick(function() {
              RES.apply(null, args2);
            });
          } else {
            delete reqs[key];
          }
        }
      });
    }
    function slice(args2) {
      var length = args2.length;
      var array3 = [];
      for (var i8 = 0; i8 < length; i8++) array3[i8] = args2[i8];
      return array3;
    }
  }
});

// ../node_modules/.pnpm/glob@8.1.0/node_modules/glob/glob.js
var require_glob = __commonJS({
  "../node_modules/.pnpm/glob@8.1.0/node_modules/glob/glob.js"(exports, module2) {
    "use strict";
    module2.exports = glob2;
    var rp = require_fs();
    var minimatch2 = require_minimatch();
    var Minimatch2 = minimatch2.Minimatch;
    var inherits = require_inherits();
    var EE = __require("events").EventEmitter;
    var path3 = __require("path");
    var assert2 = __require("assert");
    var isAbsolute = __require("path").isAbsolute;
    var globSync = require_sync();
    var common = require_common();
    var setopts = common.setopts;
    var ownProp = common.ownProp;
    var inflight = require_inflight();
    var util2 = __require("util");
    var childrenIgnored = common.childrenIgnored;
    var isIgnored = common.isIgnored;
    var once3 = require_once();
    function glob2(pattern, options, cb) {
      if (typeof options === "function") cb = options, options = {};
      if (!options) options = {};
      if (options.sync) {
        if (cb)
          throw new TypeError("callback provided to sync glob");
        return globSync(pattern, options);
      }
      return new Glob(pattern, options, cb);
    }
    glob2.sync = globSync;
    var GlobSync = glob2.GlobSync = globSync.GlobSync;
    glob2.glob = glob2;
    function extend(origin, add) {
      if (add === null || typeof add !== "object") {
        return origin;
      }
      var keys = Object.keys(add);
      var i8 = keys.length;
      while (i8--) {
        origin[keys[i8]] = add[keys[i8]];
      }
      return origin;
    }
    glob2.hasMagic = function(pattern, options_) {
      var options = extend({}, options_);
      options.noprocess = true;
      var g10 = new Glob(pattern, options);
      var set = g10.minimatch.set;
      if (!pattern)
        return false;
      if (set.length > 1)
        return true;
      for (var j7 = 0; j7 < set[0].length; j7++) {
        if (typeof set[0][j7] !== "string")
          return true;
      }
      return false;
    };
    glob2.Glob = Glob;
    inherits(Glob, EE);
    function Glob(pattern, options, cb) {
      if (typeof options === "function") {
        cb = options;
        options = null;
      }
      if (options && options.sync) {
        if (cb)
          throw new TypeError("callback provided to sync glob");
        return new GlobSync(pattern, options);
      }
      if (!(this instanceof Glob))
        return new Glob(pattern, options, cb);
      setopts(this, pattern, options);
      this._didRealPath = false;
      var n7 = this.minimatch.set.length;
      this.matches = new Array(n7);
      if (typeof cb === "function") {
        cb = once3(cb);
        this.on("error", cb);
        this.on("end", function(matches) {
          cb(null, matches);
        });
      }
      var self2 = this;
      this._processing = 0;
      this._emitQueue = [];
      this._processQueue = [];
      this.paused = false;
      if (this.noprocess)
        return this;
      if (n7 === 0)
        return done();
      var sync2 = true;
      for (var i8 = 0; i8 < n7; i8++) {
        this._process(this.minimatch.set[i8], i8, false, done);
      }
      sync2 = false;
      function done() {
        --self2._processing;
        if (self2._processing <= 0) {
          if (sync2) {
            process.nextTick(function() {
              self2._finish();
            });
          } else {
            self2._finish();
          }
        }
      }
    }
    Glob.prototype._finish = function() {
      assert2(this instanceof Glob);
      if (this.aborted)
        return;
      if (this.realpath && !this._didRealpath)
        return this._realpath();
      common.finish(this);
      this.emit("end", this.found);
    };
    Glob.prototype._realpath = function() {
      if (this._didRealpath)
        return;
      this._didRealpath = true;
      var n7 = this.matches.length;
      if (n7 === 0)
        return this._finish();
      var self2 = this;
      for (var i8 = 0; i8 < this.matches.length; i8++)
        this._realpathSet(i8, next);
      function next() {
        if (--n7 === 0)
          self2._finish();
      }
    };
    Glob.prototype._realpathSet = function(index7, cb) {
      var matchset = this.matches[index7];
      if (!matchset)
        return cb();
      var found = Object.keys(matchset);
      var self2 = this;
      var n7 = found.length;
      if (n7 === 0)
        return cb();
      var set = this.matches[index7] = /* @__PURE__ */ Object.create(null);
      found.forEach(function(p11, i8) {
        p11 = self2._makeAbs(p11);
        rp.realpath(p11, self2.realpathCache, function(er3, real5) {
          if (!er3)
            set[real5] = true;
          else if (er3.syscall === "stat")
            set[p11] = true;
          else
            self2.emit("error", er3);
          if (--n7 === 0) {
            self2.matches[index7] = set;
            cb();
          }
        });
      });
    };
    Glob.prototype._mark = function(p11) {
      return common.mark(this, p11);
    };
    Glob.prototype._makeAbs = function(f9) {
      return common.makeAbs(this, f9);
    };
    Glob.prototype.abort = function() {
      this.aborted = true;
      this.emit("abort");
    };
    Glob.prototype.pause = function() {
      if (!this.paused) {
        this.paused = true;
        this.emit("pause");
      }
    };
    Glob.prototype.resume = function() {
      if (this.paused) {
        this.emit("resume");
        this.paused = false;
        if (this._emitQueue.length) {
          var eq2 = this._emitQueue.slice(0);
          this._emitQueue.length = 0;
          for (var i8 = 0; i8 < eq2.length; i8++) {
            var e6 = eq2[i8];
            this._emitMatch(e6[0], e6[1]);
          }
        }
        if (this._processQueue.length) {
          var pq = this._processQueue.slice(0);
          this._processQueue.length = 0;
          for (var i8 = 0; i8 < pq.length; i8++) {
            var p11 = pq[i8];
            this._processing--;
            this._process(p11[0], p11[1], p11[2], p11[3]);
          }
        }
      }
    };
    Glob.prototype._process = function(pattern, index7, inGlobStar, cb) {
      assert2(this instanceof Glob);
      assert2(typeof cb === "function");
      if (this.aborted)
        return;
      this._processing++;
      if (this.paused) {
        this._processQueue.push([pattern, index7, inGlobStar, cb]);
        return;
      }
      var n7 = 0;
      while (typeof pattern[n7] === "string") {
        n7++;
      }
      var prefix2;
      switch (n7) {
        // if not, then this is rather simple
        case pattern.length:
          this._processSimple(pattern.join("/"), index7, cb);
          return;
        case 0:
          prefix2 = null;
          break;
        default:
          prefix2 = pattern.slice(0, n7).join("/");
          break;
      }
      var remain = pattern.slice(n7);
      var read;
      if (prefix2 === null)
        read = ".";
      else if (isAbsolute(prefix2) || isAbsolute(pattern.map(function(p11) {
        return typeof p11 === "string" ? p11 : "[*]";
      }).join("/"))) {
        if (!prefix2 || !isAbsolute(prefix2))
          prefix2 = "/" + prefix2;
        read = prefix2;
      } else
        read = prefix2;
      var abs = this._makeAbs(read);
      if (childrenIgnored(this, read))
        return cb();
      var isGlobStar = remain[0] === minimatch2.GLOBSTAR;
      if (isGlobStar)
        this._processGlobStar(prefix2, read, abs, remain, index7, inGlobStar, cb);
      else
        this._processReaddir(prefix2, read, abs, remain, index7, inGlobStar, cb);
    };
    Glob.prototype._processReaddir = function(prefix2, read, abs, remain, index7, inGlobStar, cb) {
      var self2 = this;
      this._readdir(abs, inGlobStar, function(er3, entries) {
        return self2._processReaddir2(prefix2, read, abs, remain, index7, inGlobStar, entries, cb);
      });
    };
    Glob.prototype._processReaddir2 = function(prefix2, read, abs, remain, index7, inGlobStar, entries, cb) {
      if (!entries)
        return cb();
      var pn2 = remain[0];
      var negate2 = !!this.minimatch.negate;
      var rawGlob = pn2._glob;
      var dotOk = this.dot || rawGlob.charAt(0) === ".";
      var matchedEntries = [];
      for (var i8 = 0; i8 < entries.length; i8++) {
        var e6 = entries[i8];
        if (e6.charAt(0) !== "." || dotOk) {
          var m12;
          if (negate2 && !prefix2) {
            m12 = !e6.match(pn2);
          } else {
            m12 = e6.match(pn2);
          }
          if (m12)
            matchedEntries.push(e6);
        }
      }
      var len = matchedEntries.length;
      if (len === 0)
        return cb();
      if (remain.length === 1 && !this.mark && !this.stat) {
        if (!this.matches[index7])
          this.matches[index7] = /* @__PURE__ */ Object.create(null);
        for (var i8 = 0; i8 < len; i8++) {
          var e6 = matchedEntries[i8];
          if (prefix2) {
            if (prefix2 !== "/")
              e6 = prefix2 + "/" + e6;
            else
              e6 = prefix2 + e6;
          }
          if (e6.charAt(0) === "/" && !this.nomount) {
            e6 = path3.join(this.root, e6);
          }
          this._emitMatch(index7, e6);
        }
        return cb();
      }
      remain.shift();
      for (var i8 = 0; i8 < len; i8++) {
        var e6 = matchedEntries[i8];
        var newPattern;
        if (prefix2) {
          if (prefix2 !== "/")
            e6 = prefix2 + "/" + e6;
          else
            e6 = prefix2 + e6;
        }
        this._process([e6].concat(remain), index7, inGlobStar, cb);
      }
      cb();
    };
    Glob.prototype._emitMatch = function(index7, e6) {
      if (this.aborted)
        return;
      if (isIgnored(this, e6))
        return;
      if (this.paused) {
        this._emitQueue.push([index7, e6]);
        return;
      }
      var abs = isAbsolute(e6) ? e6 : this._makeAbs(e6);
      if (this.mark)
        e6 = this._mark(e6);
      if (this.absolute)
        e6 = abs;
      if (this.matches[index7][e6])
        return;
      if (this.nodir) {
        var c6 = this.cache[abs];
        if (c6 === "DIR" || Array.isArray(c6))
          return;
      }
      this.matches[index7][e6] = true;
      var st2 = this.statCache[abs];
      if (st2)
        this.emit("stat", e6, st2);
      this.emit("match", e6);
    };
    Glob.prototype._readdirInGlobStar = function(abs, cb) {
      if (this.aborted)
        return;
      if (this.follow)
        return this._readdir(abs, false, cb);
      var lstatkey = "lstat\0" + abs;
      var self2 = this;
      var lstatcb = inflight(lstatkey, lstatcb_);
      if (lstatcb)
        self2.fs.lstat(abs, lstatcb);
      function lstatcb_(er3, lstat) {
        if (er3 && er3.code === "ENOENT")
          return cb();
        var isSym = lstat && lstat.isSymbolicLink();
        self2.symlinks[abs] = isSym;
        if (!isSym && lstat && !lstat.isDirectory()) {
          self2.cache[abs] = "FILE";
          cb();
        } else
          self2._readdir(abs, false, cb);
      }
    };
    Glob.prototype._readdir = function(abs, inGlobStar, cb) {
      if (this.aborted)
        return;
      cb = inflight("readdir\0" + abs + "\0" + inGlobStar, cb);
      if (!cb)
        return;
      if (inGlobStar && !ownProp(this.symlinks, abs))
        return this._readdirInGlobStar(abs, cb);
      if (ownProp(this.cache, abs)) {
        var c6 = this.cache[abs];
        if (!c6 || c6 === "FILE")
          return cb();
        if (Array.isArray(c6))
          return cb(null, c6);
      }
      var self2 = this;
      self2.fs.readdir(abs, readdirCb(this, abs, cb));
    };
    function readdirCb(self2, abs, cb) {
      return function(er3, entries) {
        if (er3)
          self2._readdirError(abs, er3, cb);
        else
          self2._readdirEntries(abs, entries, cb);
      };
    }
    Glob.prototype._readdirEntries = function(abs, entries, cb) {
      if (this.aborted)
        return;
      if (!this.mark && !this.stat) {
        for (var i8 = 0; i8 < entries.length; i8++) {
          var e6 = entries[i8];
          if (abs === "/")
            e6 = abs + e6;
          else
            e6 = abs + "/" + e6;
          this.cache[e6] = true;
        }
      }
      this.cache[abs] = entries;
      return cb(null, entries);
    };
    Glob.prototype._readdirError = function(f9, er3, cb) {
      if (this.aborted)
        return;
      switch (er3.code) {
        case "ENOTSUP":
        // https://github.com/isaacs/node-glob/issues/205
        case "ENOTDIR":
          var abs = this._makeAbs(f9);
          this.cache[abs] = "FILE";
          if (abs === this.cwdAbs) {
            var error2 = new Error(er3.code + " invalid cwd " + this.cwd);
            error2.path = this.cwd;
            error2.code = er3.code;
            this.emit("error", error2);
            this.abort();
          }
          break;
        case "ENOENT":
        // not terribly unusual
        case "ELOOP":
        case "ENAMETOOLONG":
        case "UNKNOWN":
          this.cache[this._makeAbs(f9)] = false;
          break;
        default:
          this.cache[this._makeAbs(f9)] = false;
          if (this.strict) {
            this.emit("error", er3);
            this.abort();
          }
          if (!this.silent)
            console.error("glob error", er3);
          break;
      }
      return cb();
    };
    Glob.prototype._processGlobStar = function(prefix2, read, abs, remain, index7, inGlobStar, cb) {
      var self2 = this;
      this._readdir(abs, inGlobStar, function(er3, entries) {
        self2._processGlobStar2(prefix2, read, abs, remain, index7, inGlobStar, entries, cb);
      });
    };
    Glob.prototype._processGlobStar2 = function(prefix2, read, abs, remain, index7, inGlobStar, entries, cb) {
      if (!entries)
        return cb();
      var remainWithoutGlobStar = remain.slice(1);
      var gspref = prefix2 ? [prefix2] : [];
      var noGlobStar = gspref.concat(remainWithoutGlobStar);
      this._process(noGlobStar, index7, false, cb);
      var isSym = this.symlinks[abs];
      var len = entries.length;
      if (isSym && inGlobStar)
        return cb();
      for (var i8 = 0; i8 < len; i8++) {
        var e6 = entries[i8];
        if (e6.charAt(0) === "." && !this.dot)
          continue;
        var instead = gspref.concat(entries[i8], remainWithoutGlobStar);
        this._process(instead, index7, true, cb);
        var below = gspref.concat(entries[i8], remain);
        this._process(below, index7, true, cb);
      }
      cb();
    };
    Glob.prototype._processSimple = function(prefix2, index7, cb) {
      var self2 = this;
      this._stat(prefix2, function(er3, exists2) {
        self2._processSimple2(prefix2, index7, er3, exists2, cb);
      });
    };
    Glob.prototype._processSimple2 = function(prefix2, index7, er3, exists2, cb) {
      if (!this.matches[index7])
        this.matches[index7] = /* @__PURE__ */ Object.create(null);
      if (!exists2)
        return cb();
      if (prefix2 && isAbsolute(prefix2) && !this.nomount) {
        var trail = /[\/\\]$/.test(prefix2);
        if (prefix2.charAt(0) === "/") {
          prefix2 = path3.join(this.root, prefix2);
        } else {
          prefix2 = path3.resolve(this.root, prefix2);
          if (trail)
            prefix2 += "/";
        }
      }
      if (process.platform === "win32")
        prefix2 = prefix2.replace(/\\/g, "/");
      this._emitMatch(index7, prefix2);
      cb();
    };
    Glob.prototype._stat = function(f9, cb) {
      var abs = this._makeAbs(f9);
      var needDir = f9.slice(-1) === "/";
      if (f9.length > this.maxLength)
        return cb();
      if (!this.stat && ownProp(this.cache, abs)) {
        var c6 = this.cache[abs];
        if (Array.isArray(c6))
          c6 = "DIR";
        if (!needDir || c6 === "DIR")
          return cb(null, c6);
        if (needDir && c6 === "FILE")
          return cb();
      }
      var exists2;
      var stat2 = this.statCache[abs];
      if (stat2 !== void 0) {
        if (stat2 === false)
          return cb(null, stat2);
        else {
          var type = stat2.isDirectory() ? "DIR" : "FILE";
          if (needDir && type === "FILE")
            return cb();
          else
            return cb(null, type, stat2);
        }
      }
      var self2 = this;
      var statcb = inflight("stat\0" + abs, lstatcb_);
      if (statcb)
        self2.fs.lstat(abs, statcb);
      function lstatcb_(er3, lstat) {
        if (lstat && lstat.isSymbolicLink()) {
          return self2.fs.stat(abs, function(er4, stat3) {
            if (er4)
              self2._stat2(f9, abs, null, lstat, cb);
            else
              self2._stat2(f9, abs, er4, stat3, cb);
          });
        } else {
          self2._stat2(f9, abs, er3, lstat, cb);
        }
      }
    };
    Glob.prototype._stat2 = function(f9, abs, er3, stat2, cb) {
      if (er3 && (er3.code === "ENOENT" || er3.code === "ENOTDIR")) {
        this.statCache[abs] = false;
        return cb();
      }
      var needDir = f9.slice(-1) === "/";
      this.statCache[abs] = stat2;
      if (abs.slice(-1) === "/" && stat2 && !stat2.isDirectory())
        return cb(null, false, stat2);
      var c6 = true;
      if (stat2)
        c6 = stat2.isDirectory() ? "DIR" : "FILE";
      this.cache[abs] = this.cache[abs] || c6;
      if (needDir && c6 === "FILE")
        return cb();
      return cb(null, c6, stat2);
    };
  }
});

// ../node_modules/.pnpm/hanji@0.0.5/node_modules/hanji/readline.js
var require_readline = __commonJS({
  "../node_modules/.pnpm/hanji@0.0.5/node_modules/hanji/readline.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.prepareReadLine = void 0;
    var prepareReadLine = () => {
      const stdin = process.stdin;
      const stdout = process.stdout;
      const readline = __require("readline");
      const rl = readline.createInterface({
        input: stdin,
        escapeCodeTimeout: 50
      });
      readline.emitKeypressEvents(stdin, rl);
      return {
        stdin,
        stdout,
        closable: rl
      };
    };
    exports.prepareReadLine = prepareReadLine;
  }
});

// ../node_modules/.pnpm/sisteransi@1.0.5/node_modules/sisteransi/src/index.js
var require_src = __commonJS({
  "../node_modules/.pnpm/sisteransi@1.0.5/node_modules/sisteransi/src/index.js"(exports, module2) {
    "use strict";
    var ESC = "\x1B";
    var CSI = `${ESC}[`;
    var beep = "\x07";
    var cursor = {
      to(x11, y7) {
        if (!y7) return `${CSI}${x11 + 1}G`;
        return `${CSI}${y7 + 1};${x11 + 1}H`;
      },
      move(x11, y7) {
        let ret = "";
        if (x11 < 0) ret += `${CSI}${-x11}D`;
        else if (x11 > 0) ret += `${CSI}${x11}C`;
        if (y7 < 0) ret += `${CSI}${-y7}A`;
        else if (y7 > 0) ret += `${CSI}${y7}B`;
        return ret;
      },
      up: (count2 = 1) => `${CSI}${count2}A`,
      down: (count2 = 1) => `${CSI}${count2}B`,
      forward: (count2 = 1) => `${CSI}${count2}C`,
      backward: (count2 = 1) => `${CSI}${count2}D`,
      nextLine: (count2 = 1) => `${CSI}E`.repeat(count2),
      prevLine: (count2 = 1) => `${CSI}F`.repeat(count2),
      left: `${CSI}G`,
      hide: `${CSI}?25l`,
      show: `${CSI}?25h`,
      save: `${ESC}7`,
      restore: `${ESC}8`
    };
    var scroll = {
      up: (count2 = 1) => `${CSI}S`.repeat(count2),
      down: (count2 = 1) => `${CSI}T`.repeat(count2)
    };
    var erase = {
      screen: `${CSI}2J`,
      up: (count2 = 1) => `${CSI}1J`.repeat(count2),
      down: (count2 = 1) => `${CSI}J`.repeat(count2),
      line: `${CSI}2K`,
      lineEnd: `${CSI}K`,
      lineStart: `${CSI}1K`,
      lines(count2) {
        let clear = "";
        for (let i8 = 0; i8 < count2; i8++)
          clear += this.line + (i8 < count2 - 1 ? cursor.up() : "");
        if (count2)
          clear += cursor.left;
        return clear;
      }
    };
    module2.exports = { cursor, scroll, erase, beep };
  }
});

// ../node_modules/.pnpm/hanji@0.0.5/node_modules/hanji/utils.js
var require_utils = __commonJS({
  "../node_modules/.pnpm/hanji@0.0.5/node_modules/hanji/utils.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.clear = void 0;
    var sisteransi_1 = require_src();
    var strip = (str) => {
      const pattern = [
        "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
        "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PRZcf-ntqry=><~]))"
      ].join("|");
      const RGX = new RegExp(pattern, "g");
      return typeof str === "string" ? str.replace(RGX, "") : str;
    };
    var stringWidth = (str) => [...strip(str)].length;
    var clear = function(prompt, perLine) {
      if (!perLine)
        return sisteransi_1.erase.line + sisteransi_1.cursor.to(0);
      let rows = 0;
      const lines = prompt.split(/\r?\n/);
      for (let line2 of lines) {
        rows += 1 + Math.floor(Math.max(stringWidth(line2) - 1, 0) / perLine);
      }
      return sisteransi_1.erase.lines(rows);
    };
    exports.clear = clear;
  }
});

// ../node_modules/.pnpm/lodash.throttle@4.1.1/node_modules/lodash.throttle/index.js
var require_lodash = __commonJS({
  "../node_modules/.pnpm/lodash.throttle@4.1.1/node_modules/lodash.throttle/index.js"(exports, module2) {
    "use strict";
    var FUNC_ERROR_TEXT = "Expected a function";
    var NAN = 0 / 0;
    var symbolTag = "[object Symbol]";
    var reTrim = /^\s+|\s+$/g;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var freeParseInt = parseInt;
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    var nativeMax = Math.max;
    var nativeMin = Math.min;
    var now = function() {
      return root.Date.now();
    };
    function debounce(func2, wait, options) {
      var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
      if (typeof func2 != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      wait = toNumber(wait) || 0;
      if (isObject(options)) {
        leading = !!options.leading;
        maxing = "maxWait" in options;
        maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
        trailing = "trailing" in options ? !!options.trailing : trailing;
      }
      function invokeFunc(time4) {
        var args2 = lastArgs, thisArg = lastThis;
        lastArgs = lastThis = void 0;
        lastInvokeTime = time4;
        result = func2.apply(thisArg, args2);
        return result;
      }
      function leadingEdge(time4) {
        lastInvokeTime = time4;
        timerId = setTimeout(timerExpired, wait);
        return leading ? invokeFunc(time4) : result;
      }
      function remainingWait(time4) {
        var timeSinceLastCall = time4 - lastCallTime, timeSinceLastInvoke = time4 - lastInvokeTime, result2 = wait - timeSinceLastCall;
        return maxing ? nativeMin(result2, maxWait - timeSinceLastInvoke) : result2;
      }
      function shouldInvoke(time4) {
        var timeSinceLastCall = time4 - lastCallTime, timeSinceLastInvoke = time4 - lastInvokeTime;
        return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
      }
      function timerExpired() {
        var time4 = now();
        if (shouldInvoke(time4)) {
          return trailingEdge(time4);
        }
        timerId = setTimeout(timerExpired, remainingWait(time4));
      }
      function trailingEdge(time4) {
        timerId = void 0;
        if (trailing && lastArgs) {
          return invokeFunc(time4);
        }
        lastArgs = lastThis = void 0;
        return result;
      }
      function cancel() {
        if (timerId !== void 0) {
          clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = void 0;
      }
      function flush2() {
        return timerId === void 0 ? result : trailingEdge(now());
      }
      function debounced() {
        var time4 = now(), isInvoking = shouldInvoke(time4);
        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time4;
        if (isInvoking) {
          if (timerId === void 0) {
            return leadingEdge(lastCallTime);
          }
          if (maxing) {
            timerId = setTimeout(timerExpired, wait);
            return invokeFunc(lastCallTime);
          }
        }
        if (timerId === void 0) {
          timerId = setTimeout(timerExpired, wait);
        }
        return result;
      }
      debounced.cancel = cancel;
      debounced.flush = flush2;
      return debounced;
    }
    function throttle(func2, wait, options) {
      var leading = true, trailing = true;
      if (typeof func2 != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      if (isObject(options)) {
        leading = "leading" in options ? !!options.leading : leading;
        trailing = "trailing" in options ? !!options.trailing : trailing;
      }
      return debounce(func2, wait, {
        "leading": leading,
        "maxWait": wait,
        "trailing": trailing
      });
    }
    function isObject(value) {
      var type = typeof value;
      return !!value && (type == "object" || type == "function");
    }
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isSymbol(value) {
      return typeof value == "symbol" || isObjectLike(value) && objectToString.call(value) == symbolTag;
    }
    function toNumber(value) {
      if (typeof value == "number") {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      if (isObject(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = isObject(other) ? other + "" : other;
      }
      if (typeof value != "string") {
        return value === 0 ? value : +value;
      }
      value = value.replace(reTrim, "");
      var isBinary2 = reIsBinary.test(value);
      return isBinary2 || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary2 ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    module2.exports = throttle;
  }
});

// ../node_modules/.pnpm/hanji@0.0.5/node_modules/hanji/index.js
var require_hanji = __commonJS({
  "../node_modules/.pnpm/hanji@0.0.5/node_modules/hanji/index.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P5, generator) {
      function adopt(value) {
        return value instanceof P5 ? value : new P5(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P5 || (P5 = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e6) {
            reject(e6);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e6) {
            reject(e6);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __importDefault = exports && exports.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.onTerminate = exports.renderWithTask = exports.render = exports.TaskTerminal = exports.TaskView = exports.Terminal = exports.deferred = exports.SelectState = exports.Prompt = void 0;
    var readline_1 = require_readline();
    var sisteransi_1 = require_src();
    var utils_1 = require_utils();
    var lodash_throttle_1 = __importDefault(require_lodash());
    var Prompt3 = class {
      constructor() {
        this.attachCallbacks = [];
        this.detachCallbacks = [];
        this.inputCallbacks = [];
      }
      requestLayout() {
        this.terminal.requestLayout();
      }
      on(type, callback) {
        if (type === "attach") {
          this.attachCallbacks.push(callback);
        } else if (type === "detach") {
          this.detachCallbacks.push(callback);
        } else if (type === "input") {
          this.inputCallbacks.push(callback);
        }
      }
      attach(terminal) {
        this.terminal = terminal;
        this.attachCallbacks.forEach((it2) => it2(terminal));
      }
      detach(terminal) {
        this.detachCallbacks.forEach((it2) => it2(terminal));
        this.terminal = void 0;
      }
      input(str, key) {
        this.inputCallbacks.forEach((it2) => it2(str, key));
      }
    };
    exports.Prompt = Prompt3;
    var SelectState3 = class {
      constructor(items) {
        this.items = items;
        this.selectedIdx = 0;
      }
      bind(prompt) {
        prompt.on("input", (str, key) => {
          const invalidate = this.consume(str, key);
          if (invalidate)
            prompt.requestLayout();
        });
      }
      consume(str, key) {
        if (!key)
          return false;
        if (key.name === "down") {
          this.selectedIdx = (this.selectedIdx + 1) % this.items.length;
          return true;
        }
        if (key.name === "up") {
          this.selectedIdx -= 1;
          this.selectedIdx = this.selectedIdx < 0 ? this.items.length - 1 : this.selectedIdx;
          return true;
        }
        return false;
      }
    };
    exports.SelectState = SelectState3;
    var deferred = () => {
      let resolve2;
      let reject;
      const promise = new Promise((res, rej) => {
        resolve2 = res;
        reject = rej;
      });
      return {
        resolve: resolve2,
        reject,
        promise
      };
    };
    exports.deferred = deferred;
    var Terminal = class {
      constructor(view5, stdin, stdout, closable) {
        this.view = view5;
        this.stdin = stdin;
        this.stdout = stdout;
        this.closable = closable;
        this.text = "";
        this.status = "idle";
        if (this.stdin.isTTY)
          this.stdin.setRawMode(true);
        const keypress = (str, key) => {
          if (key.name === "c" && key.ctrl === true) {
            this.requestLayout();
            this.view.detach(this);
            this.tearDown(keypress);
            if (terminateHandler) {
              terminateHandler(this.stdin, this.stdout);
              return;
            }
            this.stdout.write(`
^C
`);
            process.exit(1);
          }
          if (key.name === "escape") {
            this.status = "aborted";
            this.requestLayout();
            this.view.detach(this);
            this.tearDown(keypress);
            this.resolve({ status: "aborted", data: void 0 });
            return;
          }
          if (key.name === "return") {
            this.status = "submitted";
            this.requestLayout();
            this.view.detach(this);
            this.tearDown(keypress);
            this.resolve({ status: "submitted", data: this.view.result() });
            return;
          }
          view5.input(str, key);
        };
        this.stdin.on("keypress", keypress);
        this.view.attach(this);
        const { resolve: resolve2, promise } = (0, exports.deferred)();
        this.resolve = resolve2;
        this.promise = promise;
        this.renderFunc = (0, lodash_throttle_1.default)((str) => {
          this.stdout.write(str);
        });
      }
      tearDown(keypress) {
        this.stdout.write(sisteransi_1.cursor.show);
        this.stdin.removeListener("keypress", keypress);
        if (this.stdin.isTTY)
          this.stdin.setRawMode(false);
        this.closable.close();
      }
      result() {
        return this.promise;
      }
      toggleCursor(state2) {
        if (state2 === "hide") {
          this.stdout.write(sisteransi_1.cursor.hide);
        } else {
          this.stdout.write(sisteransi_1.cursor.show);
        }
      }
      requestLayout() {
        const string2 = this.view.render(this.status);
        const clearPrefix = this.text ? (0, utils_1.clear)(this.text, this.stdout.columns) : "";
        this.text = string2;
        this.renderFunc(`${clearPrefix}${string2}`);
      }
    };
    exports.Terminal = Terminal;
    var TaskView2 = class {
      constructor() {
        this.attachCallbacks = [];
        this.detachCallbacks = [];
      }
      requestLayout() {
        this.terminal.requestLayout();
      }
      attach(terminal) {
        this.terminal = terminal;
        this.attachCallbacks.forEach((it2) => it2(terminal));
      }
      detach(terminal) {
        this.detachCallbacks.forEach((it2) => it2(terminal));
        this.terminal = void 0;
      }
      on(type, callback) {
        if (type === "attach") {
          this.attachCallbacks.push(callback);
        } else if (type === "detach") {
          this.detachCallbacks.push(callback);
        }
      }
    };
    exports.TaskView = TaskView2;
    var TaskTerminal = class {
      constructor(view5, stdout) {
        this.view = view5;
        this.stdout = stdout;
        this.text = "";
        this.view.attach(this);
      }
      requestLayout() {
        const string2 = this.view.render("pending");
        const clearPrefix = this.text ? (0, utils_1.clear)(this.text, this.stdout.columns) : "";
        this.text = string2;
        this.stdout.write(`${clearPrefix}${string2}`);
      }
      clear() {
        const string2 = this.view.render("done");
        this.view.detach(this);
        const clearPrefix = this.text ? (0, utils_1.clear)(this.text, this.stdout.columns) : "";
        this.stdout.write(`${clearPrefix}${string2}`);
      }
    };
    exports.TaskTerminal = TaskTerminal;
    function render7(view5) {
      const { stdin, stdout, closable } = (0, readline_1.prepareReadLine)();
      if (view5 instanceof Prompt3) {
        const terminal = new Terminal(view5, stdin, stdout, closable);
        terminal.requestLayout();
        return terminal.result();
      }
      stdout.write(`${view5}
`);
      closable.close();
      return;
    }
    exports.render = render7;
    function renderWithTask5(view5, task) {
      return __awaiter(this, void 0, void 0, function* () {
        const terminal = new TaskTerminal(view5, process.stdout);
        terminal.requestLayout();
        const result = yield task;
        terminal.clear();
        return result;
      });
    }
    exports.renderWithTask = renderWithTask5;
    var terminateHandler;
    function onTerminate(callback) {
      terminateHandler = callback;
    }
    exports.onTerminate = onTerminate;
  }
});

// src/global.ts
function assertUnreachable(x11) {
  throw new Error("Didn't expect to get here");
}
var originUUID, snapshotVersion, mapValues, mapKeys, mapEntries, customMapEntries;
var init_global = __esm({
  "src/global.ts"() {
    "use strict";
    originUUID = "00000000-0000-0000-0000-000000000000";
    snapshotVersion = "7";
    mapValues = (obj, map2) => {
      const result = Object.keys(obj).reduce(function(result2, key) {
        result2[key] = map2(obj[key]);
        return result2;
      }, {});
      return result;
    };
    mapKeys = (obj, map2) => {
      const result = Object.fromEntries(
        Object.entries(obj).map(([key, val2]) => {
          const newKey = map2(key, val2);
          return [newKey, val2];
        })
      );
      return result;
    };
    mapEntries = (obj, map2) => {
      const result = Object.fromEntries(
        Object.entries(obj).map(([key, val2]) => {
          const [newKey, newVal] = map2(key, val2);
          return [newKey, newVal];
        })
      );
      return result;
    };
    customMapEntries = (obj, map2) => {
      const result = Object.fromEntries(
        Object.entries(obj).map(([key, val2]) => {
          const [newKey, newVal] = map2(key, val2);
          return [newKey, newVal];
        })
      );
      return result;
    };
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/util.js
var util, objectUtil, ZodParsedType, getParsedType;
var init_util = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/util.js"() {
    "use strict";
    (function(util2) {
      util2.assertEqual = (_7) => {
      };
      function assertIs(_arg) {
      }
      util2.assertIs = assertIs;
      function assertNever(_x) {
        throw new Error();
      }
      util2.assertNever = assertNever;
      util2.arrayToEnum = (items) => {
        const obj = {};
        for (const item of items) {
          obj[item] = item;
        }
        return obj;
      };
      util2.getValidEnumValues = (obj) => {
        const validKeys = util2.objectKeys(obj).filter((k9) => typeof obj[obj[k9]] !== "number");
        const filtered = {};
        for (const k9 of validKeys) {
          filtered[k9] = obj[k9];
        }
        return util2.objectValues(filtered);
      };
      util2.objectValues = (obj) => {
        return util2.objectKeys(obj).map(function(e6) {
          return obj[e6];
        });
      };
      util2.objectKeys = typeof Object.keys === "function" ? (obj) => Object.keys(obj) : (object2) => {
        const keys = [];
        for (const key in object2) {
          if (Object.prototype.hasOwnProperty.call(object2, key)) {
            keys.push(key);
          }
        }
        return keys;
      };
      util2.find = (arr, checker) => {
        for (const item of arr) {
          if (checker(item))
            return item;
        }
        return void 0;
      };
      util2.isInteger = typeof Number.isInteger === "function" ? (val2) => Number.isInteger(val2) : (val2) => typeof val2 === "number" && Number.isFinite(val2) && Math.floor(val2) === val2;
      function joinValues(array3, separator = " | ") {
        return array3.map((val2) => typeof val2 === "string" ? `'${val2}'` : val2).join(separator);
      }
      util2.joinValues = joinValues;
      util2.jsonStringifyReplacer = (_7, value) => {
        if (typeof value === "bigint") {
          return value.toString();
        }
        return value;
      };
    })(util || (util = {}));
    (function(objectUtil2) {
      objectUtil2.mergeShapes = (first, second) => {
        return {
          ...first,
          ...second
          // second overwrites first
        };
      };
    })(objectUtil || (objectUtil = {}));
    ZodParsedType = util.arrayToEnum([
      "string",
      "nan",
      "number",
      "integer",
      "float",
      "boolean",
      "date",
      "bigint",
      "symbol",
      "function",
      "undefined",
      "null",
      "array",
      "object",
      "unknown",
      "promise",
      "void",
      "never",
      "map",
      "set"
    ]);
    getParsedType = (data) => {
      const t6 = typeof data;
      switch (t6) {
        case "undefined":
          return ZodParsedType.undefined;
        case "string":
          return ZodParsedType.string;
        case "number":
          return Number.isNaN(data) ? ZodParsedType.nan : ZodParsedType.number;
        case "boolean":
          return ZodParsedType.boolean;
        case "function":
          return ZodParsedType.function;
        case "bigint":
          return ZodParsedType.bigint;
        case "symbol":
          return ZodParsedType.symbol;
        case "object":
          if (Array.isArray(data)) {
            return ZodParsedType.array;
          }
          if (data === null) {
            return ZodParsedType.null;
          }
          if (data.then && typeof data.then === "function" && data.catch && typeof data.catch === "function") {
            return ZodParsedType.promise;
          }
          if (typeof Map !== "undefined" && data instanceof Map) {
            return ZodParsedType.map;
          }
          if (typeof Set !== "undefined" && data instanceof Set) {
            return ZodParsedType.set;
          }
          if (typeof Date !== "undefined" && data instanceof Date) {
            return ZodParsedType.date;
          }
          return ZodParsedType.object;
        default:
          return ZodParsedType.unknown;
      }
    };
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/ZodError.js
var ZodIssueCode, quotelessJson, ZodError;
var init_ZodError = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/ZodError.js"() {
    "use strict";
    init_util();
    ZodIssueCode = util.arrayToEnum([
      "invalid_type",
      "invalid_literal",
      "custom",
      "invalid_union",
      "invalid_union_discriminator",
      "invalid_enum_value",
      "unrecognized_keys",
      "invalid_arguments",
      "invalid_return_type",
      "invalid_date",
      "invalid_string",
      "too_small",
      "too_big",
      "invalid_intersection_types",
      "not_multiple_of",
      "not_finite"
    ]);
    quotelessJson = (obj) => {
      const json4 = JSON.stringify(obj, null, 2);
      return json4.replace(/"([^"]+)":/g, "$1:");
    };
    ZodError = class _ZodError extends Error {
      get errors() {
        return this.issues;
      }
      constructor(issues) {
        super();
        this.issues = [];
        this.addIssue = (sub) => {
          this.issues = [...this.issues, sub];
        };
        this.addIssues = (subs = []) => {
          this.issues = [...this.issues, ...subs];
        };
        const actualProto = new.target.prototype;
        if (Object.setPrototypeOf) {
          Object.setPrototypeOf(this, actualProto);
        } else {
          this.__proto__ = actualProto;
        }
        this.name = "ZodError";
        this.issues = issues;
      }
      format(_mapper) {
        const mapper = _mapper || function(issue) {
          return issue.message;
        };
        const fieldErrors = { _errors: [] };
        const processError = (error2) => {
          for (const issue of error2.issues) {
            if (issue.code === "invalid_union") {
              issue.unionErrors.map(processError);
            } else if (issue.code === "invalid_return_type") {
              processError(issue.returnTypeError);
            } else if (issue.code === "invalid_arguments") {
              processError(issue.argumentsError);
            } else if (issue.path.length === 0) {
              fieldErrors._errors.push(mapper(issue));
            } else {
              let curr = fieldErrors;
              let i8 = 0;
              while (i8 < issue.path.length) {
                const el = issue.path[i8];
                const terminal = i8 === issue.path.length - 1;
                if (!terminal) {
                  curr[el] = curr[el] || { _errors: [] };
                } else {
                  curr[el] = curr[el] || { _errors: [] };
                  curr[el]._errors.push(mapper(issue));
                }
                curr = curr[el];
                i8++;
              }
            }
          }
        };
        processError(this);
        return fieldErrors;
      }
      static assert(value) {
        if (!(value instanceof _ZodError)) {
          throw new Error(`Not a ZodError: ${value}`);
        }
      }
      toString() {
        return this.message;
      }
      get message() {
        return JSON.stringify(this.issues, util.jsonStringifyReplacer, 2);
      }
      get isEmpty() {
        return this.issues.length === 0;
      }
      flatten(mapper = (issue) => issue.message) {
        const fieldErrors = {};
        const formErrors = [];
        for (const sub of this.issues) {
          if (sub.path.length > 0) {
            fieldErrors[sub.path[0]] = fieldErrors[sub.path[0]] || [];
            fieldErrors[sub.path[0]].push(mapper(sub));
          } else {
            formErrors.push(mapper(sub));
          }
        }
        return { formErrors, fieldErrors };
      }
      get formErrors() {
        return this.flatten();
      }
    };
    ZodError.create = (issues) => {
      const error2 = new ZodError(issues);
      return error2;
    };
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/locales/en.js
var errorMap, en_default;
var init_en = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/locales/en.js"() {
    "use strict";
    init_ZodError();
    init_util();
    errorMap = (issue, _ctx) => {
      let message;
      switch (issue.code) {
        case ZodIssueCode.invalid_type:
          if (issue.received === ZodParsedType.undefined) {
            message = "Required";
          } else {
            message = `Expected ${issue.expected}, received ${issue.received}`;
          }
          break;
        case ZodIssueCode.invalid_literal:
          message = `Invalid literal value, expected ${JSON.stringify(issue.expected, util.jsonStringifyReplacer)}`;
          break;
        case ZodIssueCode.unrecognized_keys:
          message = `Unrecognized key(s) in object: ${util.joinValues(issue.keys, ", ")}`;
          break;
        case ZodIssueCode.invalid_union:
          message = `Invalid input`;
          break;
        case ZodIssueCode.invalid_union_discriminator:
          message = `Invalid discriminator value. Expected ${util.joinValues(issue.options)}`;
          break;
        case ZodIssueCode.invalid_enum_value:
          message = `Invalid enum value. Expected ${util.joinValues(issue.options)}, received '${issue.received}'`;
          break;
        case ZodIssueCode.invalid_arguments:
          message = `Invalid function arguments`;
          break;
        case ZodIssueCode.invalid_return_type:
          message = `Invalid function return type`;
          break;
        case ZodIssueCode.invalid_date:
          message = `Invalid date`;
          break;
        case ZodIssueCode.invalid_string:
          if (typeof issue.validation === "object") {
            if ("includes" in issue.validation) {
              message = `Invalid input: must include "${issue.validation.includes}"`;
              if (typeof issue.validation.position === "number") {
                message = `${message} at one or more positions greater than or equal to ${issue.validation.position}`;
              }
            } else if ("startsWith" in issue.validation) {
              message = `Invalid input: must start with "${issue.validation.startsWith}"`;
            } else if ("endsWith" in issue.validation) {
              message = `Invalid input: must end with "${issue.validation.endsWith}"`;
            } else {
              util.assertNever(issue.validation);
            }
          } else if (issue.validation !== "regex") {
            message = `Invalid ${issue.validation}`;
          } else {
            message = "Invalid";
          }
          break;
        case ZodIssueCode.too_small:
          if (issue.type === "array")
            message = `Array must contain ${issue.exact ? "exactly" : issue.inclusive ? `at least` : `more than`} ${issue.minimum} element(s)`;
          else if (issue.type === "string")
            message = `String must contain ${issue.exact ? "exactly" : issue.inclusive ? `at least` : `over`} ${issue.minimum} character(s)`;
          else if (issue.type === "number")
            message = `Number must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${issue.minimum}`;
          else if (issue.type === "date")
            message = `Date must be ${issue.exact ? `exactly equal to ` : issue.inclusive ? `greater than or equal to ` : `greater than `}${new Date(Number(issue.minimum))}`;
          else
            message = "Invalid input";
          break;
        case ZodIssueCode.too_big:
          if (issue.type === "array")
            message = `Array must contain ${issue.exact ? `exactly` : issue.inclusive ? `at most` : `less than`} ${issue.maximum} element(s)`;
          else if (issue.type === "string")
            message = `String must contain ${issue.exact ? `exactly` : issue.inclusive ? `at most` : `under`} ${issue.maximum} character(s)`;
          else if (issue.type === "number")
            message = `Number must be ${issue.exact ? `exactly` : issue.inclusive ? `less than or equal to` : `less than`} ${issue.maximum}`;
          else if (issue.type === "bigint")
            message = `BigInt must be ${issue.exact ? `exactly` : issue.inclusive ? `less than or equal to` : `less than`} ${issue.maximum}`;
          else if (issue.type === "date")
            message = `Date must be ${issue.exact ? `exactly` : issue.inclusive ? `smaller than or equal to` : `smaller than`} ${new Date(Number(issue.maximum))}`;
          else
            message = "Invalid input";
          break;
        case ZodIssueCode.custom:
          message = `Invalid input`;
          break;
        case ZodIssueCode.invalid_intersection_types:
          message = `Intersection results could not be merged`;
          break;
        case ZodIssueCode.not_multiple_of:
          message = `Number must be a multiple of ${issue.multipleOf}`;
          break;
        case ZodIssueCode.not_finite:
          message = "Number must be finite";
          break;
        default:
          message = _ctx.defaultError;
          util.assertNever(issue);
      }
      return { message };
    };
    en_default = errorMap;
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/errors.js
function setErrorMap(map2) {
  overrideErrorMap = map2;
}
function getErrorMap() {
  return overrideErrorMap;
}
var overrideErrorMap;
var init_errors2 = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/errors.js"() {
    "use strict";
    init_en();
    overrideErrorMap = en_default;
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/parseUtil.js
function addIssueToContext(ctx, issueData) {
  const overrideMap = getErrorMap();
  const issue = makeIssue({
    issueData,
    data: ctx.data,
    path: ctx.path,
    errorMaps: [
      ctx.common.contextualErrorMap,
      // contextual error map is first priority
      ctx.schemaErrorMap,
      // then schema-bound map if available
      overrideMap,
      // then global override map
      overrideMap === en_default ? void 0 : en_default
      // then global default map
    ].filter((x11) => !!x11)
  });
  ctx.common.issues.push(issue);
}
var makeIssue, EMPTY_PATH, ParseStatus, INVALID, DIRTY, OK, isAborted, isDirty, isValid, isAsync;
var init_parseUtil = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/parseUtil.js"() {
    "use strict";
    init_errors2();
    init_en();
    makeIssue = (params) => {
      const { data, path: path3, errorMaps, issueData } = params;
      const fullPath = [...path3, ...issueData.path || []];
      const fullIssue = {
        ...issueData,
        path: fullPath
      };
      if (issueData.message !== void 0) {
        return {
          ...issueData,
          path: fullPath,
          message: issueData.message
        };
      }
      let errorMessage = "";
      const maps = errorMaps.filter((m12) => !!m12).slice().reverse();
      for (const map2 of maps) {
        errorMessage = map2(fullIssue, { data, defaultError: errorMessage }).message;
      }
      return {
        ...issueData,
        path: fullPath,
        message: errorMessage
      };
    };
    EMPTY_PATH = [];
    ParseStatus = class _ParseStatus {
      constructor() {
        this.value = "valid";
      }
      dirty() {
        if (this.value === "valid")
          this.value = "dirty";
      }
      abort() {
        if (this.value !== "aborted")
          this.value = "aborted";
      }
      static mergeArray(status, results) {
        const arrayValue = [];
        for (const s10 of results) {
          if (s10.status === "aborted")
            return INVALID;
          if (s10.status === "dirty")
            status.dirty();
          arrayValue.push(s10.value);
        }
        return { status: status.value, value: arrayValue };
      }
      static async mergeObjectAsync(status, pairs) {
        const syncPairs = [];
        for (const pair of pairs) {
          const key = await pair.key;
          const value = await pair.value;
          syncPairs.push({
            key,
            value
          });
        }
        return _ParseStatus.mergeObjectSync(status, syncPairs);
      }
      static mergeObjectSync(status, pairs) {
        const finalObject = {};
        for (const pair of pairs) {
          const { key, value } = pair;
          if (key.status === "aborted")
            return INVALID;
          if (value.status === "aborted")
            return INVALID;
          if (key.status === "dirty")
            status.dirty();
          if (value.status === "dirty")
            status.dirty();
          if (key.value !== "__proto__" && (typeof value.value !== "undefined" || pair.alwaysSet)) {
            finalObject[key.value] = value.value;
          }
        }
        return { status: status.value, value: finalObject };
      }
    };
    INVALID = Object.freeze({
      status: "aborted"
    });
    DIRTY = (value) => ({ status: "dirty", value });
    OK = (value) => ({ status: "valid", value });
    isAborted = (x11) => x11.status === "aborted";
    isDirty = (x11) => x11.status === "dirty";
    isValid = (x11) => x11.status === "valid";
    isAsync = (x11) => typeof Promise !== "undefined" && x11 instanceof Promise;
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/typeAliases.js
var init_typeAliases = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/typeAliases.js"() {
    "use strict";
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/errorUtil.js
var errorUtil;
var init_errorUtil = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/helpers/errorUtil.js"() {
    "use strict";
    (function(errorUtil2) {
      errorUtil2.errToObj = (message) => typeof message === "string" ? { message } : message || {};
      errorUtil2.toString = (message) => typeof message === "string" ? message : message?.message;
    })(errorUtil || (errorUtil = {}));
  }
});

// ../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/types.js
function processCreateParams(params) {
  if (!params)
    return {};
  const { errorMap: errorMap2, invalid_type_error, required_error, description } = params;
  if (errorMap2 && (invalid_type_error || required_error)) {
    throw new Error(`Can't use "invalid_type_error" or "required_error" in conjunction with custom error map.`);
  }
  if (errorMap2)
    return { errorMap: errorMap2, description };
  const customMap = (iss, ctx) => {
    const { message } = params;
    if (iss.code === "invalid_enum_value") {
      return { message: message ?? ctx.defaultError };
    }
    if (typeof ctx.data === "undefined") {
      return { message: message ?? required_error ?? ctx.defaultError };
    }
    if (iss.code !== "invalid_type")
      return { message: ctx.defaultError };
    return { message: message ?? invalid_type_error ?? ctx.defaultError };
  };
  return { errorMap: customMap, description };
}
function timeRegexSource(args2) {
  let secondsRegexSource = `[0-5]\\d`;
  if (args2.precision) {
    secondsRegexSource = `${secondsRegexSource}\\.\\d{${args2.precision}}`;
  } else if (args2.precision == null) {
    secondsRegexSource = `${secondsRegexSource}(\\.\\d+)?`;
  }
  const secondsQuantifier = args2.precision ? "+" : "?";
  return `([01]\\d|2[0-3]):[0-5]\\d(:${secondsRegexSource})${secondsQuantifier}`;
}
function timeRegex(args2) {
  return new RegExp(`^${timeRegexSource(args2)}$`);
}
function datetimeRegex(args2) {
  let regex = `${dateRegexSource}T${timeRegexSource(args2)}`;
  const opts = [];
  opts.push(args2.local ? `Z?` : `Z`);
  if (args2.offset)
    opts.push(`([+-]\\d{2}:?\\d{2})`);
  regex = `${regex}(${opts.join("|")})`;
  return new RegExp(`^${regex}$`);
}
function isValidIP(ip, version3) {
  if ((version3 === "v4" || !version3) && ipv4Regex.test(ip)) {
    return true;
  }
  if ((version3 === "v6" || !version3) && ipv6Regex.test(ip)) {
    return true;
  }
  return false;
}
function isValidJWT(jwt, alg) {
  if (!jwtRegex.test(jwt))
    return false;
  try {
    const [header] = jwt.split(".");
    const base64 = header.replace(/-/g, "+").replace(/_/g, "/").padEnd(header.length + (4 - header.length % 4) % 4, "=");
    const decoded = JSON.parse(atob(base64));
    if (typeof decoded !== "object" || decoded === null)
      return false;
    if ("typ" in decoded && decoded?.typ !== "JWT")
      return false;
    if (!decoded.alg)
      return false;
    if (alg && decoded.alg !== alg)
      return false;
    return true;
  } catch {
    return false;
  }
}
function isValidCidr(ip, version3) {
  if ((version3 === "v4" || !version3) && ipv4CidrRegex.test(ip)) {
    return true;
  }
  if ((version3 === "v6" || !version3) && ipv6CidrRegex.test(ip)) {
    return true;
  }
  return false;
}
function floatSafeRemainder(val2, step) {
  const valDecCount = (val2.toString().split(".")[1] || "").length;
  const stepDecCount = (step.toString().split(".")[1] || "").length;
  const decCount = valDecCount > stepDecCount ? valDecCount : stepDecCount;
  const valInt = Number.parseInt(val2.toFixed(decCount).replace(".", ""));
  const stepInt = Number.parseInt(step.toFixed(decCount).replace(".", ""));
  return valInt % stepInt / 10 ** decCount;
}
function deepPartialify(schema6) {
  if (schema6 instanceof ZodObject) {
    const newShape = {};
    for (const key in schema6.shape) {
      const fieldSchema = schema6.shape[key];
      newShape[key] = ZodOptional.create(deepPartialify(fieldSchema));
    }
    return new ZodObject({
      ...schema6._def,
      shape: () => newShape
    });
  } else if (schema6 instanceof ZodArray) {
    return new ZodArray({
      ...schema6._def,
      type: deepPartialify(schema6.element)
    });
  } else if (schema6 instanceof ZodOptional) {
    return ZodOptional.create(deepPartialify(schema6.unwrap()));
  } else if (schema6 instanceof ZodNullable) {
    return ZodNullable.create(deepPartialify(schema6.unwrap()));
  } else if (schema6 instanceof ZodTuple) {
    return ZodTuple.create(schema6.items.map((item) => deepPartialify(item)));
  } else {
    return schema6;
  }
}
function mergeValues(a9, b9) {
  const aType = getParsedType(a9);
  const bType = getParsedType(b9);
  if (a9 === b9) {
    return { valid: true, data: a9 };
  } else if (aType === ZodParsedType.object && bType === ZodParsedType.object) {
    const bKeys = util.objectKeys(b9);
    const sharedKeys = util.objectKeys(a9).filter((key) => bKeys.indexOf(key) !== -1);
    const newObj = { ...a9, ...b9 };
    for (const key of sharedKeys) {
      const sharedValue = mergeValues(a9[key], b9[key]);
      if (!sharedValue.valid) {
        return { valid: false };
      }
      newObj[key] = sharedValue.data;
    }
    return { valid: true, data: newObj };
  } else if (aType === ZodParsedType.array && bType === ZodParsedType.array) {
    if (a9.length !== b9.length) {
      return { valid: false };
    }
    const newArray = [];
    for (let index7 = 0; index7 < a9.length; index7++) {
      const itemA = a9[index7];
      const itemB = b9[index7];
      const sharedValue = mergeValues(itemA, itemB);
      if (!sharedValue.valid) {
        return { valid: false };
      }
      newArray.push(sharedValue.data);
    }
    return { valid: true, data: newArray };
  } else if (aType === ZodParsedType.date && bType === ZodParsedType.date && +a9 === +b9) {
    return { valid: true, data: a9 };
  } else {
    return { valid: false };
  }
}
function createZodEnum(values2, params) {
  return new ZodEnum({
    values: values2,
    typeName: ZodFirstPartyTypeKind.ZodEnum,
    ...processCreateParams(params)
  });
}
function cleanParams(params, data) {
  const p11 = typeof params === "function" ? params(data) : typeof params === "string" ? { message: params } : params;
  const p22 = typeof p11 === "string" ? { message: p11 } : p11;
  return p22;
}
function custom(check2, _params2 = {}, fatal) {
  if (check2)
    return ZodAny.create().superRefine((data, ctx) => {
      const r6 = check2(data);
      if (r6 instanceof Promise) {
        return r6.then((r7) => {
          if (!r7) {
            const params = cleanParams(_params2, data);
            const _fatal = params.fatal ?? fatal ?? true;
            ctx.addIssue({ code: "custom", ...params, fatal: _fatal });
          }
        });
      }
      if (!r6) {
        const params = cleanParams(_params2, data);
        const _fatal = params.fatal ?? fatal ?? true;
        ctx.addIssue({ code: "custom", ...params, fatal: _fatal });
      }
      return;
    });
  return ZodAny.create();
}
var ParseInputLazyPath, handleResult, ZodType, cuidRegex, cuid2Regex, ulidRegex, uuidRegex, nanoidRegex, jwtRegex, durationRegex, emailRegex, _emojiRegex, emojiRegex, ipv4Regex, ipv4CidrRegex, ipv6Regex, ipv6CidrRegex, base64Regex, base64urlRegex, dateRegexSource, dateRegex, ZodString, ZodNumber, ZodBigInt, ZodBoolean, ZodDate, ZodSymbol, ZodUndefined, ZodNull, ZodAny, ZodUnknown, ZodNever, ZodVoid, ZodArray, ZodObject, ZodUnion, getDiscriminator, ZodDiscriminatedUnion, ZodIntersection, ZodTuple, ZodRecord, ZodMap, ZodSet, ZodFunction, ZodLazy, ZodLiteral, ZodEnum, ZodNativeEnum, ZodPromise, ZodEffects, ZodOptional, ZodNullable, ZodDefault, ZodCatch, ZodNaN, BRAND, ZodBranded, ZodPipeline, ZodReadonly, late, ZodFirstPartyTypeKind, instanceOfType, stringType, numberType, nanType, bigIntType, booleanType, dateType, symbolType, undefinedType, nullType, anyType, unknownType, neverType, voidType, arrayType, objectType, strictObjectType, unionType, discriminatedUnionType, intersectionType, tupleType, recordType, mapType, setType, functionType, lazyType, literalType, enumType, nativeEnumType, promiseType, effectsType, optionalType, nullableType, preprocessType, pipelineType, ostring, onumber, oboolean, coerce, NEVER;
var init_types = __esm({
  "../node_modules/.pnpm/zod@3.25.42/node_modules/zod/dist/esm/v3/types.js"() {
    "use strict";
    init_ZodError();
    init_errors2();
    init_errorUtil();
    init_parseUtil();
    init_util();
    ParseInputLazyPath = class {
      constructor(parent, value, path3, key) {
        this._cachedPath = [];
        this.parent = parent;
        this.data = value;
        this._path = path3;
        this._key = key;
      }
      get path() {
        if (!this._cachedPath.length) {
          if (Array.isArray(this._key)) {
            this._cachedPath.push(...this._path, ...this._key);
          } else {
            this._cachedPath.push(...this._path, this._key);
          }
        }
        return this._cachedPath;
      }
    };
    handleResult = (ctx, result) => {
      if (isValid(result)) {
        return { success: true, data: result.value };
      } else {
        if (!ctx.common.issues.length) {
          throw new Error("Validation failed but no issues detected.");
        }
        return {
          success: false,
          get error() {
            if (this._error)
              return this._error;
            const error2 = new ZodError(ctx.common.issues);
            this._error = error2;
            return this._error;
          }
        };
      }
    };
    ZodType = class {
      get description() {
        return this._def.description;
      }
      _getType(input) {
        return getParsedType(input.data);
      }
      _getOrReturnCtx(input, ctx) {
        return ctx || {
          common: input.parent.common,
          data: input.data,
          parsedType: getParsedType(input.data),
          schemaErrorMap: this._def.errorMap,
          path: input.path,
          parent: input.parent
        };
      }
      _processInputParams(input) {
        return {
          status: new ParseStatus(),
          ctx: {
            common: input.parent.common,
            data: input.data,
            parsedType: getParsedType(input.data),
            schemaErrorMap: this._def.errorMap,
            path: input.path,
            parent: input.parent
          }
        };
      }
      _parseSync(input) {
        const result = this._parse(input);
        if (isAsync(result)) {
          throw new Error("Synchronous parse encountered promise.");
        }
        return result;
      }
      _parseAsync(input) {
        const result = this._parse(input);
        return Promise.resolve(result);
      }
      parse(data, params) {
        const result = this.safeParse(data, params);
        if (result.success)
          return result.data;
        throw result.error;
      }
      safeParse(data, params) {
        const ctx = {
          common: {
            issues: [],
            async: params?.async ?? false,
            contextualErrorMap: params?.errorMap
          },
          path: params?.path || [],
          schemaErrorMap: this._def.errorMap,
          parent: null,
          data,
          parsedType: getParsedType(data)
        };
        const result = this._parseSync({ data, path: ctx.path, parent: ctx });
        return handleResult(ctx, result);
      }
      "~validate"(data) {
        const ctx = {
          common: {
            issues: [],
            async: !!this["~standard"].async
          },
          path: [],
          schemaErrorMap: this._def.errorMap,
          parent: null,
          data,
          parsedType: getParsedType(data)
        };
        if (!this["~standard"].async) {
          try {
            const result = this._parseSync({ data, path: [], parent: ctx });
            return isValid(result) ? {
              value: result.value
            } : {
              issues: ctx.common.issues
            };
          } catch (err3) {
            if (err3?.message?.toLowerCase()?.includes("encountered")) {
              this["~standard"].async = true;
            }
            ctx.common = {
              issues: [],
              async: true
            };
          }
        }
        return this._parseAsync({ data, path: [], parent: ctx }).then((result) => isValid(result) ? {
          value: result.value
        } : {
          issues: ctx.common.issues
        });
      }
      async parseAsync(data, params) {
        const result = await this.safeParseAsync(data, params);
        if (result.success)
          return result.data;
        throw result.error;
      }
      async safeParseAsync(data, params) {
        const ctx = {
          common: {
            issues: [],
            contextualErrorMap: params?.errorMap,
            async: true
          },
          path: params?.path || [],
          schemaErrorMap: this._def.errorMap,
          parent: null,
          data,
          parsedType: getParsedType(data)
        };
        const maybeAsyncResult = this._parse({ data, path: ctx.path, parent: ctx });
        const result = await (isAsync(maybeAsyncResult) ? maybeAsyncResult : Promise.resolve(maybeAsyncResult));
        return handleResult(ctx, result);
      }
      refine(check2, message) {
        const getIssueProperties = (val2) => {
          if (typeof message === "string" || typeof message === "undefined") {
            return { message };
          } else if (typeof message === "function") {
            return message(val2);
          } else {
            return message;
          }
        };
        return this._refinement((val2, ctx) => {
          const result = check2(val2);
          const setError = () => ctx.addIssue({
            code: ZodIssueCode.custom,
            ...getIssueProperties(val2)
          });
          if (typeof Promise !== "undefined" && result instanceof Promise) {
            return result.then((data) => {
              if (!data) {
                setError();
                return false;
              } else {
                return true;
              }
            });
          }
          if (!result) {
            setError();
            return false;
          } else {
            return true;
          }
        });
      }
      refinement(check2, refinementData) {
        return this._refinement((val2, ctx) => {
          if (!check2(val2)) {
            ctx.addIssue(typeof refinementData === "function" ? refinementData(val2, ctx) : refinementData);
            return false;
          } else {
            return true;
          }
        });
      }
      _refinement(refinement) {
        return new ZodEffects({
          schema: this,
          typeName: ZodFirstPartyTypeKind.ZodEffects,
          effect: { type: "refinement", refinement }
        });
      }
      superRefine(refinement) {
        return this._refinement(refinement);
      }
      constructor(def) {
        this.spa = this.safeParseAsync;
        this._def = def;
        this.parse = this.parse.bind(this);
        this.safeParse = this.safeParse.bind(this);
        this.parseAsync = this.parseAsync.bind(this);
        this.safeParseAsync = this.safeParseAsync.bind(this);
        this.spa = this.spa.bind(this);
        this.refine = this.refine.bind(this);
        this.refinement = this.refinement.bind(this);
        this.superRefine = this.superRefine.bind(this);
        this.optional = this.optional.bind(this);
        this.nullable = this.nullable.bind(this);
        this.nullish = this.nullish.bind(this);
        this.array = this.array.bind(this);
        this.promise = this.promise.bind(this);
        this.or = this.or.bind(this);
        this.and = this.and.bind(this);
        this.transform = this.transform.bind(this);
        this.brand = this.brand.bind(this);
        this.default = this.default.bind(this);
        this.catch = this.catch.bind(this);
        this.describe = this.describe.bind(this);
        this.pipe = this.pipe.bind(this);
        this.readonly = this.readonly.bind(this);
        this.isNullable = this.isNullable.bind(this);
        this.isOptional = this.isOptional.bind(this);
        this["~standard"] = {
          version: 1,
          vendor: "zod",
          validate: (data) => this["~validate"](data)
        };
      }
      optional() {
        return ZodOptional.create(this, this._def);
      }
      nullable() {
        return ZodNullable.create(this, this._def);
      }
      nullish() {
        return this.nullable().optional();
      }
      array() {
        return ZodArray.create(this);
      }
      promise() {
        return ZodPromise.create(this, this._def);
      }
      or(option) {
        return ZodUnion.create([this, option], this._def);
      }
      and(incoming) {
        return ZodIntersection.create(this, incoming, this._def);
      }
      transform(transform) {
        return new ZodEffects({
          ...processCreateParams(this._def),
          schema: this,
          typeName: ZodFirstPartyTypeKind.ZodEffects,
          effect: { type: "transform", transform }
        });
      }
      default(def) {
        const defaultValueFunc = typeof def === "function" ? def : () => def;
        return new ZodDefault({
          ...processCreateParams(this._def),
          innerType: this,
          defaultValue: defaultValueFunc,
          typeName: ZodFirstPartyTypeKind.ZodDefault
        });
      }
      brand() {
        return new ZodBranded({
          typeName: ZodFirstPartyTypeKind.ZodBranded,
          type: this,
          ...processCreateParams(this._def)
        });
      }
      catch(def) {
        const catchValueFunc = typeof def === "function" ? def : () => def;
        return new ZodCatch({
          ...processCreateParams(this._def),
          innerType: this,
          catchValue: catchValueFunc,
          typeName: ZodFirstPartyTypeKind.ZodCatch
        });
      }
      describe(description) {
        const This = this.constructor;
        return new This({
          ...this._def,
          description
        });
      }
      pipe(target) {
        return ZodPipeline.create(this, target);
      }
      readonly() {
        return ZodReadonly.create(this);
      }
      isOptional() {
        return this.safeParse(void 0).success;
      }
      isNullable() {
        return this.safeParse(null).success;
      }
    };
    cuidRegex = /^c[^\s-]{8,}$/i;
    cuid2Regex = /^[0-9a-z]+$/;
    ulidRegex = /^[0-9A-HJKMNP-TV-Z]{26}$/i;
    uuidRegex = /^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/i;
    nanoidRegex = /^[a-z0-9_-]{21}$/i;
    jwtRegex = /^[A-Za-z0-9-_]+\.[A-Za-z0-9-_]+\.[A-Za-z0-9-_]*$/;
    durationRegex = /^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/;
    emailRegex = /^(?!\.)(?!.*\.\.)([A-Z0-9_'+\-\.]*)[A-Z0-9_+-]@([A-Z0-9][A-Z0-9\-]*\.)+[A-Z]{2,}$/i;
    _emojiRegex = `^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$`;
    ipv4Regex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
    ipv4CidrRegex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/(3[0-2]|[12]?[0-9])$/;
    ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
    ipv6CidrRegex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/;
    base64Regex = /^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/;
    base64urlRegex = /^([0-9a-zA-Z-_]{4})*(([0-9a-zA-Z-_]{2}(==)?)|([0-9a-zA-Z-_]{3}(=)?))?$/;
    dateRegexSource = `((\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-((0[13578]|1[02])-(0[1-9]|[12]\\d|3[01])|(0[469]|11)-(0[1-9]|[12]\\d|30)|(02)-(0[1-9]|1\\d|2[0-8])))`;
    dateRegex = new RegExp(`^${dateRegexSource}$`);
    ZodString = class _ZodString extends ZodType {
      _parse(input) {
        if (this._def.coerce) {
          input.data = String(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.string) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.string,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        const status = new ParseStatus();
        let ctx = void 0;
        for (const check2 of this._def.checks) {
          if (check2.kind === "min") {
            if (input.data.length < check2.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                minimum: check2.value,
                type: "string",
                inclusive: true,
                exact: false,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "max") {
            if (input.data.length > check2.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                maximum: check2.value,
                type: "string",
                inclusive: true,
                exact: false,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "length") {
            const tooBig = input.data.length > check2.value;
            const tooSmall = input.data.length < check2.value;
            if (tooBig || tooSmall) {
              ctx = this._getOrReturnCtx(input, ctx);
              if (tooBig) {
                addIssueToContext(ctx, {
                  code: ZodIssueCode.too_big,
                  maximum: check2.value,
                  type: "string",
                  inclusive: true,
                  exact: true,
                  message: check2.message
                });
              } else if (tooSmall) {
                addIssueToContext(ctx, {
                  code: ZodIssueCode.too_small,
                  minimum: check2.value,
                  type: "string",
                  inclusive: true,
                  exact: true,
                  message: check2.message
                });
              }
              status.dirty();
            }
          } else if (check2.kind === "email") {
            if (!emailRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "email",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "emoji") {
            if (!emojiRegex) {
              emojiRegex = new RegExp(_emojiRegex, "u");
            }
            if (!emojiRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "emoji",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "uuid") {
            if (!uuidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "uuid",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "nanoid") {
            if (!nanoidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "nanoid",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "cuid") {
            if (!cuidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "cuid",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "cuid2") {
            if (!cuid2Regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "cuid2",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "ulid") {
            if (!ulidRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "ulid",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "url") {
            try {
              new URL(input.data);
            } catch {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "url",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "regex") {
            check2.regex.lastIndex = 0;
            const testResult = check2.regex.test(input.data);
            if (!testResult) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "regex",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "trim") {
            input.data = input.data.trim();
          } else if (check2.kind === "includes") {
            if (!input.data.includes(check2.value, check2.position)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: { includes: check2.value, position: check2.position },
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "toLowerCase") {
            input.data = input.data.toLowerCase();
          } else if (check2.kind === "toUpperCase") {
            input.data = input.data.toUpperCase();
          } else if (check2.kind === "startsWith") {
            if (!input.data.startsWith(check2.value)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: { startsWith: check2.value },
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "endsWith") {
            if (!input.data.endsWith(check2.value)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: { endsWith: check2.value },
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "datetime") {
            const regex = datetimeRegex(check2);
            if (!regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: "datetime",
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "date") {
            const regex = dateRegex;
            if (!regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: "date",
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "time") {
            const regex = timeRegex(check2);
            if (!regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_string,
                validation: "time",
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "duration") {
            if (!durationRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "duration",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "ip") {
            if (!isValidIP(input.data, check2.version)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "ip",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "jwt") {
            if (!isValidJWT(input.data, check2.alg)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "jwt",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "cidr") {
            if (!isValidCidr(input.data, check2.version)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "cidr",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "base64") {
            if (!base64Regex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "base64",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "base64url") {
            if (!base64urlRegex.test(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                validation: "base64url",
                code: ZodIssueCode.invalid_string,
                message: check2.message
              });
              status.dirty();
            }
          } else {
            util.assertNever(check2);
          }
        }
        return { status: status.value, value: input.data };
      }
      _regex(regex, validation, message) {
        return this.refinement((data) => regex.test(data), {
          validation,
          code: ZodIssueCode.invalid_string,
          ...errorUtil.errToObj(message)
        });
      }
      _addCheck(check2) {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, check2]
        });
      }
      email(message) {
        return this._addCheck({ kind: "email", ...errorUtil.errToObj(message) });
      }
      url(message) {
        return this._addCheck({ kind: "url", ...errorUtil.errToObj(message) });
      }
      emoji(message) {
        return this._addCheck({ kind: "emoji", ...errorUtil.errToObj(message) });
      }
      uuid(message) {
        return this._addCheck({ kind: "uuid", ...errorUtil.errToObj(message) });
      }
      nanoid(message) {
        return this._addCheck({ kind: "nanoid", ...errorUtil.errToObj(message) });
      }
      cuid(message) {
        return this._addCheck({ kind: "cuid", ...errorUtil.errToObj(message) });
      }
      cuid2(message) {
        return this._addCheck({ kind: "cuid2", ...errorUtil.errToObj(message) });
      }
      ulid(message) {
        return this._addCheck({ kind: "ulid", ...errorUtil.errToObj(message) });
      }
      base64(message) {
        return this._addCheck({ kind: "base64", ...errorUtil.errToObj(message) });
      }
      base64url(message) {
        return this._addCheck({
          kind: "base64url",
          ...errorUtil.errToObj(message)
        });
      }
      jwt(options) {
        return this._addCheck({ kind: "jwt", ...errorUtil.errToObj(options) });
      }
      ip(options) {
        return this._addCheck({ kind: "ip", ...errorUtil.errToObj(options) });
      }
      cidr(options) {
        return this._addCheck({ kind: "cidr", ...errorUtil.errToObj(options) });
      }
      datetime(options) {
        if (typeof options === "string") {
          return this._addCheck({
            kind: "datetime",
            precision: null,
            offset: false,
            local: false,
            message: options
          });
        }
        return this._addCheck({
          kind: "datetime",
          precision: typeof options?.precision === "undefined" ? null : options?.precision,
          offset: options?.offset ?? false,
          local: options?.local ?? false,
          ...errorUtil.errToObj(options?.message)
        });
      }
      date(message) {
        return this._addCheck({ kind: "date", message });
      }
      time(options) {
        if (typeof options === "string") {
          return this._addCheck({
            kind: "time",
            precision: null,
            message: options
          });
        }
        return this._addCheck({
          kind: "time",
          precision: typeof options?.precision === "undefined" ? null : options?.precision,
          ...errorUtil.errToObj(options?.message)
        });
      }
      duration(message) {
        return this._addCheck({ kind: "duration", ...errorUtil.errToObj(message) });
      }
      regex(regex, message) {
        return this._addCheck({
          kind: "regex",
          regex,
          ...errorUtil.errToObj(message)
        });
      }
      includes(value, options) {
        return this._addCheck({
          kind: "includes",
          value,
          position: options?.position,
          ...errorUtil.errToObj(options?.message)
        });
      }
      startsWith(value, message) {
        return this._addCheck({
          kind: "startsWith",
          value,
          ...errorUtil.errToObj(message)
        });
      }
      endsWith(value, message) {
        return this._addCheck({
          kind: "endsWith",
          value,
          ...errorUtil.errToObj(message)
        });
      }
      min(minLength, message) {
        return this._addCheck({
          kind: "min",
          value: minLength,
          ...errorUtil.errToObj(message)
        });
      }
      max(maxLength, message) {
        return this._addCheck({
          kind: "max",
          value: maxLength,
          ...errorUtil.errToObj(message)
        });
      }
      length(len, message) {
        return this._addCheck({
          kind: "length",
          value: len,
          ...errorUtil.errToObj(message)
        });
      }
      /**
       * Equivalent to `.min(1)`
       */
      nonempty(message) {
        return this.min(1, errorUtil.errToObj(message));
      }
      trim() {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, { kind: "trim" }]
        });
      }
      toLowerCase() {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, { kind: "toLowerCase" }]
        });
      }
      toUpperCase() {
        return new _ZodString({
          ...this._def,
          checks: [...this._def.checks, { kind: "toUpperCase" }]
        });
      }
      get isDatetime() {
        return !!this._def.checks.find((ch) => ch.kind === "datetime");
      }
      get isDate() {
        return !!this._def.checks.find((ch) => ch.kind === "date");
      }
      get isTime() {
        return !!this._def.checks.find((ch) => ch.kind === "time");
      }
      get isDuration() {
        return !!this._def.checks.find((ch) => ch.kind === "duration");
      }
      get isEmail() {
        return !!this._def.checks.find((ch) => ch.kind === "email");
      }
      get isURL() {
        return !!this._def.checks.find((ch) => ch.kind === "url");
      }
      get isEmoji() {
        return !!this._def.checks.find((ch) => ch.kind === "emoji");
      }
      get isUUID() {
        return !!this._def.checks.find((ch) => ch.kind === "uuid");
      }
      get isNANOID() {
        return !!this._def.checks.find((ch) => ch.kind === "nanoid");
      }
      get isCUID() {
        return !!this._def.checks.find((ch) => ch.kind === "cuid");
      }
      get isCUID2() {
        return !!this._def.checks.find((ch) => ch.kind === "cuid2");
      }
      get isULID() {
        return !!this._def.checks.find((ch) => ch.kind === "ulid");
      }
      get isIP() {
        return !!this._def.checks.find((ch) => ch.kind === "ip");
      }
      get isCIDR() {
        return !!this._def.checks.find((ch) => ch.kind === "cidr");
      }
      get isBase64() {
        return !!this._def.checks.find((ch) => ch.kind === "base64");
      }
      get isBase64url() {
        return !!this._def.checks.find((ch) => ch.kind === "base64url");
      }
      get minLength() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2;
      }
      get maxLength() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2;
      }
    };
    ZodString.create = (params) => {
      return new ZodString({
        checks: [],
        typeName: ZodFirstPartyTypeKind.ZodString,
        coerce: params?.coerce ?? false,
        ...processCreateParams(params)
      });
    };
    ZodNumber = class _ZodNumber extends ZodType {
      constructor() {
        super(...arguments);
        this.min = this.gte;
        this.max = this.lte;
        this.step = this.multipleOf;
      }
      _parse(input) {
        if (this._def.coerce) {
          input.data = Number(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.number) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.number,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        let ctx = void 0;
        const status = new ParseStatus();
        for (const check2 of this._def.checks) {
          if (check2.kind === "int") {
            if (!util.isInteger(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.invalid_type,
                expected: "integer",
                received: "float",
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "min") {
            const tooSmall = check2.inclusive ? input.data < check2.value : input.data <= check2.value;
            if (tooSmall) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                minimum: check2.value,
                type: "number",
                inclusive: check2.inclusive,
                exact: false,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "max") {
            const tooBig = check2.inclusive ? input.data > check2.value : input.data >= check2.value;
            if (tooBig) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                maximum: check2.value,
                type: "number",
                inclusive: check2.inclusive,
                exact: false,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "multipleOf") {
            if (floatSafeRemainder(input.data, check2.value) !== 0) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.not_multiple_of,
                multipleOf: check2.value,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "finite") {
            if (!Number.isFinite(input.data)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.not_finite,
                message: check2.message
              });
              status.dirty();
            }
          } else {
            util.assertNever(check2);
          }
        }
        return { status: status.value, value: input.data };
      }
      gte(value, message) {
        return this.setLimit("min", value, true, errorUtil.toString(message));
      }
      gt(value, message) {
        return this.setLimit("min", value, false, errorUtil.toString(message));
      }
      lte(value, message) {
        return this.setLimit("max", value, true, errorUtil.toString(message));
      }
      lt(value, message) {
        return this.setLimit("max", value, false, errorUtil.toString(message));
      }
      setLimit(kind, value, inclusive, message) {
        return new _ZodNumber({
          ...this._def,
          checks: [
            ...this._def.checks,
            {
              kind,
              value,
              inclusive,
              message: errorUtil.toString(message)
            }
          ]
        });
      }
      _addCheck(check2) {
        return new _ZodNumber({
          ...this._def,
          checks: [...this._def.checks, check2]
        });
      }
      int(message) {
        return this._addCheck({
          kind: "int",
          message: errorUtil.toString(message)
        });
      }
      positive(message) {
        return this._addCheck({
          kind: "min",
          value: 0,
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      negative(message) {
        return this._addCheck({
          kind: "max",
          value: 0,
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      nonpositive(message) {
        return this._addCheck({
          kind: "max",
          value: 0,
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      nonnegative(message) {
        return this._addCheck({
          kind: "min",
          value: 0,
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      multipleOf(value, message) {
        return this._addCheck({
          kind: "multipleOf",
          value,
          message: errorUtil.toString(message)
        });
      }
      finite(message) {
        return this._addCheck({
          kind: "finite",
          message: errorUtil.toString(message)
        });
      }
      safe(message) {
        return this._addCheck({
          kind: "min",
          inclusive: true,
          value: Number.MIN_SAFE_INTEGER,
          message: errorUtil.toString(message)
        })._addCheck({
          kind: "max",
          inclusive: true,
          value: Number.MAX_SAFE_INTEGER,
          message: errorUtil.toString(message)
        });
      }
      get minValue() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2;
      }
      get maxValue() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2;
      }
      get isInt() {
        return !!this._def.checks.find((ch) => ch.kind === "int" || ch.kind === "multipleOf" && util.isInteger(ch.value));
      }
      get isFinite() {
        let max2 = null;
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "finite" || ch.kind === "int" || ch.kind === "multipleOf") {
            return true;
          } else if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          } else if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return Number.isFinite(min2) && Number.isFinite(max2);
      }
    };
    ZodNumber.create = (params) => {
      return new ZodNumber({
        checks: [],
        typeName: ZodFirstPartyTypeKind.ZodNumber,
        coerce: params?.coerce || false,
        ...processCreateParams(params)
      });
    };
    ZodBigInt = class _ZodBigInt extends ZodType {
      constructor() {
        super(...arguments);
        this.min = this.gte;
        this.max = this.lte;
      }
      _parse(input) {
        if (this._def.coerce) {
          try {
            input.data = BigInt(input.data);
          } catch {
            return this._getInvalidInput(input);
          }
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.bigint) {
          return this._getInvalidInput(input);
        }
        let ctx = void 0;
        const status = new ParseStatus();
        for (const check2 of this._def.checks) {
          if (check2.kind === "min") {
            const tooSmall = check2.inclusive ? input.data < check2.value : input.data <= check2.value;
            if (tooSmall) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                type: "bigint",
                minimum: check2.value,
                inclusive: check2.inclusive,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "max") {
            const tooBig = check2.inclusive ? input.data > check2.value : input.data >= check2.value;
            if (tooBig) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                type: "bigint",
                maximum: check2.value,
                inclusive: check2.inclusive,
                message: check2.message
              });
              status.dirty();
            }
          } else if (check2.kind === "multipleOf") {
            if (input.data % check2.value !== BigInt(0)) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.not_multiple_of,
                multipleOf: check2.value,
                message: check2.message
              });
              status.dirty();
            }
          } else {
            util.assertNever(check2);
          }
        }
        return { status: status.value, value: input.data };
      }
      _getInvalidInput(input) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.bigint,
          received: ctx.parsedType
        });
        return INVALID;
      }
      gte(value, message) {
        return this.setLimit("min", value, true, errorUtil.toString(message));
      }
      gt(value, message) {
        return this.setLimit("min", value, false, errorUtil.toString(message));
      }
      lte(value, message) {
        return this.setLimit("max", value, true, errorUtil.toString(message));
      }
      lt(value, message) {
        return this.setLimit("max", value, false, errorUtil.toString(message));
      }
      setLimit(kind, value, inclusive, message) {
        return new _ZodBigInt({
          ...this._def,
          checks: [
            ...this._def.checks,
            {
              kind,
              value,
              inclusive,
              message: errorUtil.toString(message)
            }
          ]
        });
      }
      _addCheck(check2) {
        return new _ZodBigInt({
          ...this._def,
          checks: [...this._def.checks, check2]
        });
      }
      positive(message) {
        return this._addCheck({
          kind: "min",
          value: BigInt(0),
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      negative(message) {
        return this._addCheck({
          kind: "max",
          value: BigInt(0),
          inclusive: false,
          message: errorUtil.toString(message)
        });
      }
      nonpositive(message) {
        return this._addCheck({
          kind: "max",
          value: BigInt(0),
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      nonnegative(message) {
        return this._addCheck({
          kind: "min",
          value: BigInt(0),
          inclusive: true,
          message: errorUtil.toString(message)
        });
      }
      multipleOf(value, message) {
        return this._addCheck({
          kind: "multipleOf",
          value,
          message: errorUtil.toString(message)
        });
      }
      get minValue() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2;
      }
      get maxValue() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2;
      }
    };
    ZodBigInt.create = (params) => {
      return new ZodBigInt({
        checks: [],
        typeName: ZodFirstPartyTypeKind.ZodBigInt,
        coerce: params?.coerce ?? false,
        ...processCreateParams(params)
      });
    };
    ZodBoolean = class extends ZodType {
      _parse(input) {
        if (this._def.coerce) {
          input.data = Boolean(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.boolean) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.boolean,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodBoolean.create = (params) => {
      return new ZodBoolean({
        typeName: ZodFirstPartyTypeKind.ZodBoolean,
        coerce: params?.coerce || false,
        ...processCreateParams(params)
      });
    };
    ZodDate = class _ZodDate extends ZodType {
      _parse(input) {
        if (this._def.coerce) {
          input.data = new Date(input.data);
        }
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.date) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.date,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        if (Number.isNaN(input.data.getTime())) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_date
          });
          return INVALID;
        }
        const status = new ParseStatus();
        let ctx = void 0;
        for (const check2 of this._def.checks) {
          if (check2.kind === "min") {
            if (input.data.getTime() < check2.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_small,
                message: check2.message,
                inclusive: true,
                exact: false,
                minimum: check2.value,
                type: "date"
              });
              status.dirty();
            }
          } else if (check2.kind === "max") {
            if (input.data.getTime() > check2.value) {
              ctx = this._getOrReturnCtx(input, ctx);
              addIssueToContext(ctx, {
                code: ZodIssueCode.too_big,
                message: check2.message,
                inclusive: true,
                exact: false,
                maximum: check2.value,
                type: "date"
              });
              status.dirty();
            }
          } else {
            util.assertNever(check2);
          }
        }
        return {
          status: status.value,
          value: new Date(input.data.getTime())
        };
      }
      _addCheck(check2) {
        return new _ZodDate({
          ...this._def,
          checks: [...this._def.checks, check2]
        });
      }
      min(minDate, message) {
        return this._addCheck({
          kind: "min",
          value: minDate.getTime(),
          message: errorUtil.toString(message)
        });
      }
      max(maxDate, message) {
        return this._addCheck({
          kind: "max",
          value: maxDate.getTime(),
          message: errorUtil.toString(message)
        });
      }
      get minDate() {
        let min2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "min") {
            if (min2 === null || ch.value > min2)
              min2 = ch.value;
          }
        }
        return min2 != null ? new Date(min2) : null;
      }
      get maxDate() {
        let max2 = null;
        for (const ch of this._def.checks) {
          if (ch.kind === "max") {
            if (max2 === null || ch.value < max2)
              max2 = ch.value;
          }
        }
        return max2 != null ? new Date(max2) : null;
      }
    };
    ZodDate.create = (params) => {
      return new ZodDate({
        checks: [],
        coerce: params?.coerce || false,
        typeName: ZodFirstPartyTypeKind.ZodDate,
        ...processCreateParams(params)
      });
    };
    ZodSymbol = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.symbol) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.symbol,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodSymbol.create = (params) => {
      return new ZodSymbol({
        typeName: ZodFirstPartyTypeKind.ZodSymbol,
        ...processCreateParams(params)
      });
    };
    ZodUndefined = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.undefined) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.undefined,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodUndefined.create = (params) => {
      return new ZodUndefined({
        typeName: ZodFirstPartyTypeKind.ZodUndefined,
        ...processCreateParams(params)
      });
    };
    ZodNull = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.null) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.null,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodNull.create = (params) => {
      return new ZodNull({
        typeName: ZodFirstPartyTypeKind.ZodNull,
        ...processCreateParams(params)
      });
    };
    ZodAny = class extends ZodType {
      constructor() {
        super(...arguments);
        this._any = true;
      }
      _parse(input) {
        return OK(input.data);
      }
    };
    ZodAny.create = (params) => {
      return new ZodAny({
        typeName: ZodFirstPartyTypeKind.ZodAny,
        ...processCreateParams(params)
      });
    };
    ZodUnknown = class extends ZodType {
      constructor() {
        super(...arguments);
        this._unknown = true;
      }
      _parse(input) {
        return OK(input.data);
      }
    };
    ZodUnknown.create = (params) => {
      return new ZodUnknown({
        typeName: ZodFirstPartyTypeKind.ZodUnknown,
        ...processCreateParams(params)
      });
    };
    ZodNever = class extends ZodType {
      _parse(input) {
        const ctx = this._getOrReturnCtx(input);
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_type,
          expected: ZodParsedType.never,
          received: ctx.parsedType
        });
        return INVALID;
      }
    };
    ZodNever.create = (params) => {
      return new ZodNever({
        typeName: ZodFirstPartyTypeKind.ZodNever,
        ...processCreateParams(params)
      });
    };
    ZodVoid = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.undefined) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.void,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return OK(input.data);
      }
    };
    ZodVoid.create = (params) => {
      return new ZodVoid({
        typeName: ZodFirstPartyTypeKind.ZodVoid,
        ...processCreateParams(params)
      });
    };
    ZodArray = class _ZodArray extends ZodType {
      _parse(input) {
        const { ctx, status } = this._processInputParams(input);
        const def = this._def;
        if (ctx.parsedType !== ZodParsedType.array) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.array,
            received: ctx.parsedType
          });
          return INVALID;
        }
        if (def.exactLength !== null) {
          const tooBig = ctx.data.length > def.exactLength.value;
          const tooSmall = ctx.data.length < def.exactLength.value;
          if (tooBig || tooSmall) {
            addIssueToContext(ctx, {
              code: tooBig ? ZodIssueCode.too_big : ZodIssueCode.too_small,
              minimum: tooSmall ? def.exactLength.value : void 0,
              maximum: tooBig ? def.exactLength.value : void 0,
              type: "array",
              inclusive: true,
              exact: true,
              message: def.exactLength.message
            });
            status.dirty();
          }
        }
        if (def.minLength !== null) {
          if (ctx.data.length < def.minLength.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: def.minLength.value,
              type: "array",
              inclusive: true,
              exact: false,
              message: def.minLength.message
            });
            status.dirty();
          }
        }
        if (def.maxLength !== null) {
          if (ctx.data.length > def.maxLength.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: def.maxLength.value,
              type: "array",
              inclusive: true,
              exact: false,
              message: def.maxLength.message
            });
            status.dirty();
          }
        }
        if (ctx.common.async) {
          return Promise.all([...ctx.data].map((item, i8) => {
            return def.type._parseAsync(new ParseInputLazyPath(ctx, item, ctx.path, i8));
          })).then((result2) => {
            return ParseStatus.mergeArray(status, result2);
          });
        }
        const result = [...ctx.data].map((item, i8) => {
          return def.type._parseSync(new ParseInputLazyPath(ctx, item, ctx.path, i8));
        });
        return ParseStatus.mergeArray(status, result);
      }
      get element() {
        return this._def.type;
      }
      min(minLength, message) {
        return new _ZodArray({
          ...this._def,
          minLength: { value: minLength, message: errorUtil.toString(message) }
        });
      }
      max(maxLength, message) {
        return new _ZodArray({
          ...this._def,
          maxLength: { value: maxLength, message: errorUtil.toString(message) }
        });
      }
      length(len, message) {
        return new _ZodArray({
          ...this._def,
          exactLength: { value: len, message: errorUtil.toString(message) }
        });
      }
      nonempty(message) {
        return this.min(1, message);
      }
    };
    ZodArray.create = (schema6, params) => {
      return new ZodArray({
        type: schema6,
        minLength: null,
        maxLength: null,
        exactLength: null,
        typeName: ZodFirstPartyTypeKind.ZodArray,
        ...processCreateParams(params)
      });
    };
    ZodObject = class _ZodObject extends ZodType {
      constructor() {
        super(...arguments);
        this._cached = null;
        this.nonstrict = this.passthrough;
        this.augment = this.extend;
      }
      _getCached() {
        if (this._cached !== null)
          return this._cached;
        const shape = this._def.shape();
        const keys = util.objectKeys(shape);
        this._cached = { shape, keys };
        return this._cached;
      }
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.object) {
          const ctx2 = this._getOrReturnCtx(input);
          addIssueToContext(ctx2, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.object,
            received: ctx2.parsedType
          });
          return INVALID;
        }
        const { status, ctx } = this._processInputParams(input);
        const { shape, keys: shapeKeys } = this._getCached();
        const extraKeys = [];
        if (!(this._def.catchall instanceof ZodNever && this._def.unknownKeys === "strip")) {
          for (const key in ctx.data) {
            if (!shapeKeys.includes(key)) {
              extraKeys.push(key);
            }
          }
        }
        const pairs = [];
        for (const key of shapeKeys) {
          const keyValidator = shape[key];
          const value = ctx.data[key];
          pairs.push({
            key: { status: "valid", value: key },
            value: keyValidator._parse(new ParseInputLazyPath(ctx, value, ctx.path, key)),
            alwaysSet: key in ctx.data
          });
        }
        if (this._def.catchall instanceof ZodNever) {
          const unknownKeys = this._def.unknownKeys;
          if (unknownKeys === "passthrough") {
            for (const key of extraKeys) {
              pairs.push({
                key: { status: "valid", value: key },
                value: { status: "valid", value: ctx.data[key] }
              });
            }
          } else if (unknownKeys === "strict") {
            if (extraKeys.length > 0) {
              addIssueToContext(ctx, {
                code: ZodIssueCode.unrecognized_keys,
                keys: extraKeys
              });
              status.dirty();
            }
          } else if (unknownKeys === "strip") {
          } else {
            throw new Error(`Internal ZodObject error: invalid unknownKeys value.`);
          }
        } else {
          const catchall = this._def.catchall;
          for (const key of extraKeys) {
            const value = ctx.data[key];
            pairs.push({
              key: { status: "valid", value: key },
              value: catchall._parse(
                new ParseInputLazyPath(ctx, value, ctx.path, key)
                //, ctx.child(key), value, getParsedType(value)
              ),
              alwaysSet: key in ctx.data
            });
          }
        }
        if (ctx.common.async) {
          return Promise.resolve().then(async () => {
            const syncPairs = [];
            for (const pair of pairs) {
              const key = await pair.key;
              const value = await pair.value;
              syncPairs.push({
                key,
                value,
                alwaysSet: pair.alwaysSet
              });
            }
            return syncPairs;
          }).then((syncPairs) => {
            return ParseStatus.mergeObjectSync(status, syncPairs);
          });
        } else {
          return ParseStatus.mergeObjectSync(status, pairs);
        }
      }
      get shape() {
        return this._def.shape();
      }
      strict(message) {
        errorUtil.errToObj;
        return new _ZodObject({
          ...this._def,
          unknownKeys: "strict",
          ...message !== void 0 ? {
            errorMap: (issue, ctx) => {
              const defaultError = this._def.errorMap?.(issue, ctx).message ?? ctx.defaultError;
              if (issue.code === "unrecognized_keys")
                return {
                  message: errorUtil.errToObj(message).message ?? defaultError
                };
              return {
                message: defaultError
              };
            }
          } : {}
        });
      }
      strip() {
        return new _ZodObject({
          ...this._def,
          unknownKeys: "strip"
        });
      }
      passthrough() {
        return new _ZodObject({
          ...this._def,
          unknownKeys: "passthrough"
        });
      }
      // const AugmentFactory =
      //   <Def extends ZodObjectDef>(def: Def) =>
      //   <Augmentation extends ZodRawShape>(
      //     augmentation: Augmentation
      //   ): ZodObject<
      //     extendShape<ReturnType<Def["shape"]>, Augmentation>,
      //     Def["unknownKeys"],
      //     Def["catchall"]
      //   > => {
      //     return new ZodObject({
      //       ...def,
      //       shape: () => ({
      //         ...def.shape(),
      //         ...augmentation,
      //       }),
      //     }) as any;
      //   };
      extend(augmentation) {
        return new _ZodObject({
          ...this._def,
          shape: () => ({
            ...this._def.shape(),
            ...augmentation
          })
        });
      }
      /**
       * Prior to zod@1.0.12 there was a bug in the
       * inferred type of merged objects. Please
       * upgrade if you are experiencing issues.
       */
      merge(merging) {
        const merged = new _ZodObject({
          unknownKeys: merging._def.unknownKeys,
          catchall: merging._def.catchall,
          shape: () => ({
            ...this._def.shape(),
            ...merging._def.shape()
          }),
          typeName: ZodFirstPartyTypeKind.ZodObject
        });
        return merged;
      }
      // merge<
      //   Incoming extends AnyZodObject,
      //   Augmentation extends Incoming["shape"],
      //   NewOutput extends {
      //     [k in keyof Augmentation | keyof Output]: k extends keyof Augmentation
      //       ? Augmentation[k]["_output"]
      //       : k extends keyof Output
      //       ? Output[k]
      //       : never;
      //   },
      //   NewInput extends {
      //     [k in keyof Augmentation | keyof Input]: k extends keyof Augmentation
      //       ? Augmentation[k]["_input"]
      //       : k extends keyof Input
      //       ? Input[k]
      //       : never;
      //   }
      // >(
      //   merging: Incoming
      // ): ZodObject<
      //   extendShape<T, ReturnType<Incoming["_def"]["shape"]>>,
      //   Incoming["_def"]["unknownKeys"],
      //   Incoming["_def"]["catchall"],
      //   NewOutput,
      //   NewInput
      // > {
      //   const merged: any = new ZodObject({
      //     unknownKeys: merging._def.unknownKeys,
      //     catchall: merging._def.catchall,
      //     shape: () =>
      //       objectUtil.mergeShapes(this._def.shape(), merging._def.shape()),
      //     typeName: ZodFirstPartyTypeKind.ZodObject,
      //   }) as any;
      //   return merged;
      // }
      setKey(key, schema6) {
        return this.augment({ [key]: schema6 });
      }
      // merge<Incoming extends AnyZodObject>(
      //   merging: Incoming
      // ): //ZodObject<T & Incoming["_shape"], UnknownKeys, Catchall> = (merging) => {
      // ZodObject<
      //   extendShape<T, ReturnType<Incoming["_def"]["shape"]>>,
      //   Incoming["_def"]["unknownKeys"],
      //   Incoming["_def"]["catchall"]
      // > {
      //   // const mergedShape = objectUtil.mergeShapes(
      //   //   this._def.shape(),
      //   //   merging._def.shape()
      //   // );
      //   const merged: any = new ZodObject({
      //     unknownKeys: merging._def.unknownKeys,
      //     catchall: merging._def.catchall,
      //     shape: () =>
      //       objectUtil.mergeShapes(this._def.shape(), merging._def.shape()),
      //     typeName: ZodFirstPartyTypeKind.ZodObject,
      //   }) as any;
      //   return merged;
      // }
      catchall(index7) {
        return new _ZodObject({
          ...this._def,
          catchall: index7
        });
      }
      pick(mask) {
        const shape = {};
        for (const key of util.objectKeys(mask)) {
          if (mask[key] && this.shape[key]) {
            shape[key] = this.shape[key];
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => shape
        });
      }
      omit(mask) {
        const shape = {};
        for (const key of util.objectKeys(this.shape)) {
          if (!mask[key]) {
            shape[key] = this.shape[key];
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => shape
        });
      }
      /**
       * @deprecated
       */
      deepPartial() {
        return deepPartialify(this);
      }
      partial(mask) {
        const newShape = {};
        for (const key of util.objectKeys(this.shape)) {
          const fieldSchema = this.shape[key];
          if (mask && !mask[key]) {
            newShape[key] = fieldSchema;
          } else {
            newShape[key] = fieldSchema.optional();
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => newShape
        });
      }
      required(mask) {
        const newShape = {};
        for (const key of util.objectKeys(this.shape)) {
          if (mask && !mask[key]) {
            newShape[key] = this.shape[key];
          } else {
            const fieldSchema = this.shape[key];
            let newField = fieldSchema;
            while (newField instanceof ZodOptional) {
              newField = newField._def.innerType;
            }
            newShape[key] = newField;
          }
        }
        return new _ZodObject({
          ...this._def,
          shape: () => newShape
        });
      }
      keyof() {
        return createZodEnum(util.objectKeys(this.shape));
      }
    };
    ZodObject.create = (shape, params) => {
      return new ZodObject({
        shape: () => shape,
        unknownKeys: "strip",
        catchall: ZodNever.create(),
        typeName: ZodFirstPartyTypeKind.ZodObject,
        ...processCreateParams(params)
      });
    };
    ZodObject.strictCreate = (shape, params) => {
      return new ZodObject({
        shape: () => shape,
        unknownKeys: "strict",
        catchall: ZodNever.create(),
        typeName: ZodFirstPartyTypeKind.ZodObject,
        ...processCreateParams(params)
      });
    };
    ZodObject.lazycreate = (shape, params) => {
      return new ZodObject({
        shape,
        unknownKeys: "strip",
        catchall: ZodNever.create(),
        typeName: ZodFirstPartyTypeKind.ZodObject,
        ...processCreateParams(params)
      });
    };
    ZodUnion = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const options = this._def.options;
        function handleResults(results) {
          for (const result of results) {
            if (result.result.status === "valid") {
              return result.result;
            }
          }
          for (const result of results) {
            if (result.result.status === "dirty") {
              ctx.common.issues.push(...result.ctx.common.issues);
              return result.result;
            }
          }
          const unionErrors = results.map((result) => new ZodError(result.ctx.common.issues));
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_union,
            unionErrors
          });
          return INVALID;
        }
        if (ctx.common.async) {
          return Promise.all(options.map(async (option) => {
            const childCtx = {
              ...ctx,
              common: {
                ...ctx.common,
                issues: []
              },
              parent: null
            };
            return {
              result: await option._parseAsync({
                data: ctx.data,
                path: ctx.path,
                parent: childCtx
              }),
              ctx: childCtx
            };
          })).then(handleResults);
        } else {
          let dirty = void 0;
          const issues = [];
          for (const option of options) {
            const childCtx = {
              ...ctx,
              common: {
                ...ctx.common,
                issues: []
              },
              parent: null
            };
            const result = option._parseSync({
              data: ctx.data,
              path: ctx.path,
              parent: childCtx
            });
            if (result.status === "valid") {
              return result;
            } else if (result.status === "dirty" && !dirty) {
              dirty = { result, ctx: childCtx };
            }
            if (childCtx.common.issues.length) {
              issues.push(childCtx.common.issues);
            }
          }
          if (dirty) {
            ctx.common.issues.push(...dirty.ctx.common.issues);
            return dirty.result;
          }
          const unionErrors = issues.map((issues2) => new ZodError(issues2));
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_union,
            unionErrors
          });
          return INVALID;
        }
      }
      get options() {
        return this._def.options;
      }
    };
    ZodUnion.create = (types6, params) => {
      return new ZodUnion({
        options: types6,
        typeName: ZodFirstPartyTypeKind.ZodUnion,
        ...processCreateParams(params)
      });
    };
    getDiscriminator = (type) => {
      if (type instanceof ZodLazy) {
        return getDiscriminator(type.schema);
      } else if (type instanceof ZodEffects) {
        return getDiscriminator(type.innerType());
      } else if (type instanceof ZodLiteral) {
        return [type.value];
      } else if (type instanceof ZodEnum) {
        return type.options;
      } else if (type instanceof ZodNativeEnum) {
        return util.objectValues(type.enum);
      } else if (type instanceof ZodDefault) {
        return getDiscriminator(type._def.innerType);
      } else if (type instanceof ZodUndefined) {
        return [void 0];
      } else if (type instanceof ZodNull) {
        return [null];
      } else if (type instanceof ZodOptional) {
        return [void 0, ...getDiscriminator(type.unwrap())];
      } else if (type instanceof ZodNullable) {
        return [null, ...getDiscriminator(type.unwrap())];
      } else if (type instanceof ZodBranded) {
        return getDiscriminator(type.unwrap());
      } else if (type instanceof ZodReadonly) {
        return getDiscriminator(type.unwrap());
      } else if (type instanceof ZodCatch) {
        return getDiscriminator(type._def.innerType);
      } else {
        return [];
      }
    };
    ZodDiscriminatedUnion = class _ZodDiscriminatedUnion extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.object) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.object,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const discriminator = this.discriminator;
        const discriminatorValue = ctx.data[discriminator];
        const option = this.optionsMap.get(discriminatorValue);
        if (!option) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_union_discriminator,
            options: Array.from(this.optionsMap.keys()),
            path: [discriminator]
          });
          return INVALID;
        }
        if (ctx.common.async) {
          return option._parseAsync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
        } else {
          return option._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
        }
      }
      get discriminator() {
        return this._def.discriminator;
      }
      get options() {
        return this._def.options;
      }
      get optionsMap() {
        return this._def.optionsMap;
      }
      /**
       * The constructor of the discriminated union schema. Its behaviour is very similar to that of the normal z.union() constructor.
       * However, it only allows a union of objects, all of which need to share a discriminator property. This property must
       * have a different value for each object in the union.
       * @param discriminator the name of the discriminator property
       * @param types an array of object schemas
       * @param params
       */
      static create(discriminator, options, params) {
        const optionsMap = /* @__PURE__ */ new Map();
        for (const type of options) {
          const discriminatorValues = getDiscriminator(type.shape[discriminator]);
          if (!discriminatorValues.length) {
            throw new Error(`A discriminator value for key \`${discriminator}\` could not be extracted from all schema options`);
          }
          for (const value of discriminatorValues) {
            if (optionsMap.has(value)) {
              throw new Error(`Discriminator property ${String(discriminator)} has duplicate value ${String(value)}`);
            }
            optionsMap.set(value, type);
          }
        }
        return new _ZodDiscriminatedUnion({
          typeName: ZodFirstPartyTypeKind.ZodDiscriminatedUnion,
          discriminator,
          options,
          optionsMap,
          ...processCreateParams(params)
        });
      }
    };
    ZodIntersection = class extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        const handleParsed = (parsedLeft, parsedRight) => {
          if (isAborted(parsedLeft) || isAborted(parsedRight)) {
            return INVALID;
          }
          const merged = mergeValues(parsedLeft.value, parsedRight.value);
          if (!merged.valid) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.invalid_intersection_types
            });
            return INVALID;
          }
          if (isDirty(parsedLeft) || isDirty(parsedRight)) {
            status.dirty();
          }
          return { status: status.value, value: merged.data };
        };
        if (ctx.common.async) {
          return Promise.all([
            this._def.left._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            }),
            this._def.right._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            })
          ]).then(([left, right]) => handleParsed(left, right));
        } else {
          return handleParsed(this._def.left._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          }), this._def.right._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          }));
        }
      }
    };
    ZodIntersection.create = (left, right, params) => {
      return new ZodIntersection({
        left,
        right,
        typeName: ZodFirstPartyTypeKind.ZodIntersection,
        ...processCreateParams(params)
      });
    };
    ZodTuple = class _ZodTuple extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.array) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.array,
            received: ctx.parsedType
          });
          return INVALID;
        }
        if (ctx.data.length < this._def.items.length) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            minimum: this._def.items.length,
            inclusive: true,
            exact: false,
            type: "array"
          });
          return INVALID;
        }
        const rest = this._def.rest;
        if (!rest && ctx.data.length > this._def.items.length) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            maximum: this._def.items.length,
            inclusive: true,
            exact: false,
            type: "array"
          });
          status.dirty();
        }
        const items = [...ctx.data].map((item, itemIndex) => {
          const schema6 = this._def.items[itemIndex] || this._def.rest;
          if (!schema6)
            return null;
          return schema6._parse(new ParseInputLazyPath(ctx, item, ctx.path, itemIndex));
        }).filter((x11) => !!x11);
        if (ctx.common.async) {
          return Promise.all(items).then((results) => {
            return ParseStatus.mergeArray(status, results);
          });
        } else {
          return ParseStatus.mergeArray(status, items);
        }
      }
      get items() {
        return this._def.items;
      }
      rest(rest) {
        return new _ZodTuple({
          ...this._def,
          rest
        });
      }
    };
    ZodTuple.create = (schemas, params) => {
      if (!Array.isArray(schemas)) {
        throw new Error("You must pass an array of schemas to z.tuple([ ... ])");
      }
      return new ZodTuple({
        items: schemas,
        typeName: ZodFirstPartyTypeKind.ZodTuple,
        rest: null,
        ...processCreateParams(params)
      });
    };
    ZodRecord = class _ZodRecord extends ZodType {
      get keySchema() {
        return this._def.keyType;
      }
      get valueSchema() {
        return this._def.valueType;
      }
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.object) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.object,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const pairs = [];
        const keyType = this._def.keyType;
        const valueType = this._def.valueType;
        for (const key in ctx.data) {
          pairs.push({
            key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, key)),
            value: valueType._parse(new ParseInputLazyPath(ctx, ctx.data[key], ctx.path, key)),
            alwaysSet: key in ctx.data
          });
        }
        if (ctx.common.async) {
          return ParseStatus.mergeObjectAsync(status, pairs);
        } else {
          return ParseStatus.mergeObjectSync(status, pairs);
        }
      }
      get element() {
        return this._def.valueType;
      }
      static create(first, second, third) {
        if (second instanceof ZodType) {
          return new _ZodRecord({
            keyType: first,
            valueType: second,
            typeName: ZodFirstPartyTypeKind.ZodRecord,
            ...processCreateParams(third)
          });
        }
        return new _ZodRecord({
          keyType: ZodString.create(),
          valueType: first,
          typeName: ZodFirstPartyTypeKind.ZodRecord,
          ...processCreateParams(second)
        });
      }
    };
    ZodMap = class extends ZodType {
      get keySchema() {
        return this._def.keyType;
      }
      get valueSchema() {
        return this._def.valueType;
      }
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.map) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.map,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const keyType = this._def.keyType;
        const valueType = this._def.valueType;
        const pairs = [...ctx.data.entries()].map(([key, value], index7) => {
          return {
            key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, [index7, "key"])),
            value: valueType._parse(new ParseInputLazyPath(ctx, value, ctx.path, [index7, "value"]))
          };
        });
        if (ctx.common.async) {
          const finalMap = /* @__PURE__ */ new Map();
          return Promise.resolve().then(async () => {
            for (const pair of pairs) {
              const key = await pair.key;
              const value = await pair.value;
              if (key.status === "aborted" || value.status === "aborted") {
                return INVALID;
              }
              if (key.status === "dirty" || value.status === "dirty") {
                status.dirty();
              }
              finalMap.set(key.value, value.value);
            }
            return { status: status.value, value: finalMap };
          });
        } else {
          const finalMap = /* @__PURE__ */ new Map();
          for (const pair of pairs) {
            const key = pair.key;
            const value = pair.value;
            if (key.status === "aborted" || value.status === "aborted") {
              return INVALID;
            }
            if (key.status === "dirty" || value.status === "dirty") {
              status.dirty();
            }
            finalMap.set(key.value, value.value);
          }
          return { status: status.value, value: finalMap };
        }
      }
    };
    ZodMap.create = (keyType, valueType, params) => {
      return new ZodMap({
        valueType,
        keyType,
        typeName: ZodFirstPartyTypeKind.ZodMap,
        ...processCreateParams(params)
      });
    };
    ZodSet = class _ZodSet extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.set) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.set,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const def = this._def;
        if (def.minSize !== null) {
          if (ctx.data.size < def.minSize.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: def.minSize.value,
              type: "set",
              inclusive: true,
              exact: false,
              message: def.minSize.message
            });
            status.dirty();
          }
        }
        if (def.maxSize !== null) {
          if (ctx.data.size > def.maxSize.value) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: def.maxSize.value,
              type: "set",
              inclusive: true,
              exact: false,
              message: def.maxSize.message
            });
            status.dirty();
          }
        }
        const valueType = this._def.valueType;
        function finalizeSet(elements2) {
          const parsedSet = /* @__PURE__ */ new Set();
          for (const element of elements2) {
            if (element.status === "aborted")
              return INVALID;
            if (element.status === "dirty")
              status.dirty();
            parsedSet.add(element.value);
          }
          return { status: status.value, value: parsedSet };
        }
        const elements = [...ctx.data.values()].map((item, i8) => valueType._parse(new ParseInputLazyPath(ctx, item, ctx.path, i8)));
        if (ctx.common.async) {
          return Promise.all(elements).then((elements2) => finalizeSet(elements2));
        } else {
          return finalizeSet(elements);
        }
      }
      min(minSize, message) {
        return new _ZodSet({
          ...this._def,
          minSize: { value: minSize, message: errorUtil.toString(message) }
        });
      }
      max(maxSize, message) {
        return new _ZodSet({
          ...this._def,
          maxSize: { value: maxSize, message: errorUtil.toString(message) }
        });
      }
      size(size2, message) {
        return this.min(size2, message).max(size2, message);
      }
      nonempty(message) {
        return this.min(1, message);
      }
    };
    ZodSet.create = (valueType, params) => {
      return new ZodSet({
        valueType,
        minSize: null,
        maxSize: null,
        typeName: ZodFirstPartyTypeKind.ZodSet,
        ...processCreateParams(params)
      });
    };
    ZodFunction = class _ZodFunction extends ZodType {
      constructor() {
        super(...arguments);
        this.validate = this.implement;
      }
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.function) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.function,
            received: ctx.parsedType
          });
          return INVALID;
        }
        function makeArgsIssue(args2, error2) {
          return makeIssue({
            data: args2,
            path: ctx.path,
            errorMaps: [ctx.common.contextualErrorMap, ctx.schemaErrorMap, getErrorMap(), en_default].filter((x11) => !!x11),
            issueData: {
              code: ZodIssueCode.invalid_arguments,
              argumentsError: error2
            }
          });
        }
        function makeReturnsIssue(returns, error2) {
          return makeIssue({
            data: returns,
            path: ctx.path,
            errorMaps: [ctx.common.contextualErrorMap, ctx.schemaErrorMap, getErrorMap(), en_default].filter((x11) => !!x11),
            issueData: {
              code: ZodIssueCode.invalid_return_type,
              returnTypeError: error2
            }
          });
        }
        const params = { errorMap: ctx.common.contextualErrorMap };
        const fn3 = ctx.data;
        if (this._def.returns instanceof ZodPromise) {
          const me2 = this;
          return OK(async function(...args2) {
            const error2 = new ZodError([]);
            const parsedArgs = await me2._def.args.parseAsync(args2, params).catch((e6) => {
              error2.addIssue(makeArgsIssue(args2, e6));
              throw error2;
            });
            const result = await Reflect.apply(fn3, this, parsedArgs);
            const parsedReturns = await me2._def.returns._def.type.parseAsync(result, params).catch((e6) => {
              error2.addIssue(makeReturnsIssue(result, e6));
              throw error2;
            });
            return parsedReturns;
          });
        } else {
          const me2 = this;
          return OK(function(...args2) {
            const parsedArgs = me2._def.args.safeParse(args2, params);
            if (!parsedArgs.success) {
              throw new ZodError([makeArgsIssue(args2, parsedArgs.error)]);
            }
            const result = Reflect.apply(fn3, this, parsedArgs.data);
            const parsedReturns = me2._def.returns.safeParse(result, params);
            if (!parsedReturns.success) {
              throw new ZodError([makeReturnsIssue(result, parsedReturns.error)]);
            }
            return parsedReturns.data;
          });
        }
      }
      parameters() {
        return this._def.args;
      }
      returnType() {
        return this._def.returns;
      }
      args(...items) {
        return new _ZodFunction({
          ...this._def,
          args: ZodTuple.create(items).rest(ZodUnknown.create())
        });
      }
      returns(returnType) {
        return new _ZodFunction({
          ...this._def,
          returns: returnType
        });
      }
      implement(func2) {
        const validatedFunc = this.parse(func2);
        return validatedFunc;
      }
      strictImplement(func2) {
        const validatedFunc = this.parse(func2);
        return validatedFunc;
      }
      static create(args2, returns, params) {
        return new _ZodFunction({
          args: args2 ? args2 : ZodTuple.create([]).rest(ZodUnknown.create()),
          returns: returns || ZodUnknown.create(),
          typeName: ZodFirstPartyTypeKind.ZodFunction,
          ...processCreateParams(params)
        });
      }
    };
    ZodLazy = class extends ZodType {
      get schema() {
        return this._def.getter();
      }
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const lazySchema = this._def.getter();
        return lazySchema._parse({ data: ctx.data, path: ctx.path, parent: ctx });
      }
    };
    ZodLazy.create = (getter, params) => {
      return new ZodLazy({
        getter,
        typeName: ZodFirstPartyTypeKind.ZodLazy,
        ...processCreateParams(params)
      });
    };
    ZodLiteral = class extends ZodType {
      _parse(input) {
        if (input.data !== this._def.value) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            received: ctx.data,
            code: ZodIssueCode.invalid_literal,
            expected: this._def.value
          });
          return INVALID;
        }
        return { status: "valid", value: input.data };
      }
      get value() {
        return this._def.value;
      }
    };
    ZodLiteral.create = (value, params) => {
      return new ZodLiteral({
        value,
        typeName: ZodFirstPartyTypeKind.ZodLiteral,
        ...processCreateParams(params)
      });
    };
    ZodEnum = class _ZodEnum extends ZodType {
      _parse(input) {
        if (typeof input.data !== "string") {
          const ctx = this._getOrReturnCtx(input);
          const expectedValues = this._def.values;
          addIssueToContext(ctx, {
            expected: util.joinValues(expectedValues),
            received: ctx.parsedType,
            code: ZodIssueCode.invalid_type
          });
          return INVALID;
        }
        if (!this._cache) {
          this._cache = new Set(this._def.values);
        }
        if (!this._cache.has(input.data)) {
          const ctx = this._getOrReturnCtx(input);
          const expectedValues = this._def.values;
          addIssueToContext(ctx, {
            received: ctx.data,
            code: ZodIssueCode.invalid_enum_value,
            options: expectedValues
          });
          return INVALID;
        }
        return OK(input.data);
      }
      get options() {
        return this._def.values;
      }
      get enum() {
        const enumValues = {};
        for (const val2 of this._def.values) {
          enumValues[val2] = val2;
        }
        return enumValues;
      }
      get Values() {
        const enumValues = {};
        for (const val2 of this._def.values) {
          enumValues[val2] = val2;
        }
        return enumValues;
      }
      get Enum() {
        const enumValues = {};
        for (const val2 of this._def.values) {
          enumValues[val2] = val2;
        }
        return enumValues;
      }
      extract(values2, newDef = this._def) {
        return _ZodEnum.create(values2, {
          ...this._def,
          ...newDef
        });
      }
      exclude(values2, newDef = this._def) {
        return _ZodEnum.create(this.options.filter((opt) => !values2.includes(opt)), {
          ...this._def,
          ...newDef
        });
      }
    };
    ZodEnum.create = createZodEnum;
    ZodNativeEnum = class extends ZodType {
      _parse(input) {
        const nativeEnumValues = util.getValidEnumValues(this._def.values);
        const ctx = this._getOrReturnCtx(input);
        if (ctx.parsedType !== ZodParsedType.string && ctx.parsedType !== ZodParsedType.number) {
          const expectedValues = util.objectValues(nativeEnumValues);
          addIssueToContext(ctx, {
            expected: util.joinValues(expectedValues),
            received: ctx.parsedType,
            code: ZodIssueCode.invalid_type
          });
          return INVALID;
        }
        if (!this._cache) {
          this._cache = new Set(util.getValidEnumValues(this._def.values));
        }
        if (!this._cache.has(input.data)) {
          const expectedValues = util.objectValues(nativeEnumValues);
          addIssueToContext(ctx, {
            received: ctx.data,
            code: ZodIssueCode.invalid_enum_value,
            options: expectedValues
          });
          return INVALID;
        }
        return OK(input.data);
      }
      get enum() {
        return this._def.values;
      }
    };
    ZodNativeEnum.create = (values2, params) => {
      return new ZodNativeEnum({
        values: values2,
        typeName: ZodFirstPartyTypeKind.ZodNativeEnum,
        ...processCreateParams(params)
      });
    };
    ZodPromise = class extends ZodType {
      unwrap() {
        return this._def.type;
      }
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        if (ctx.parsedType !== ZodParsedType.promise && ctx.common.async === false) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.promise,
            received: ctx.parsedType
          });
          return INVALID;
        }
        const promisified = ctx.parsedType === ZodParsedType.promise ? ctx.data : Promise.resolve(ctx.data);
        return OK(promisified.then((data) => {
          return this._def.type.parseAsync(data, {
            path: ctx.path,
            errorMap: ctx.common.contextualErrorMap
          });
        }));
      }
    };
    ZodPromise.create = (schema6, params) => {
      return new ZodPromise({
        type: schema6,
        typeName: ZodFirstPartyTypeKind.ZodPromise,
        ...processCreateParams(params)
      });
    };
    ZodEffects = class extends ZodType {
      innerType() {
        return this._def.schema;
      }
      sourceType() {
        return this._def.schema._def.typeName === ZodFirstPartyTypeKind.ZodEffects ? this._def.schema.sourceType() : this._def.schema;
      }
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        const effect = this._def.effect || null;
        const checkCtx = {
          addIssue: (arg) => {
            addIssueToContext(ctx, arg);
            if (arg.fatal) {
              status.abort();
            } else {
              status.dirty();
            }
          },
          get path() {
            return ctx.path;
          }
        };
        checkCtx.addIssue = checkCtx.addIssue.bind(checkCtx);
        if (effect.type === "preprocess") {
          const processed = effect.transform(ctx.data, checkCtx);
          if (ctx.common.async) {
            return Promise.resolve(processed).then(async (processed2) => {
              if (status.value === "aborted")
                return INVALID;
              const result = await this._def.schema._parseAsync({
                data: processed2,
                path: ctx.path,
                parent: ctx
              });
              if (result.status === "aborted")
                return INVALID;
              if (result.status === "dirty")
                return DIRTY(result.value);
              if (status.value === "dirty")
                return DIRTY(result.value);
              return result;
            });
          } else {
            if (status.value === "aborted")
              return INVALID;
            const result = this._def.schema._parseSync({
              data: processed,
              path: ctx.path,
              parent: ctx
            });
            if (result.status === "aborted")
              return INVALID;
            if (result.status === "dirty")
              return DIRTY(result.value);
            if (status.value === "dirty")
              return DIRTY(result.value);
            return result;
          }
        }
        if (effect.type === "refinement") {
          const executeRefinement = (acc) => {
            const result = effect.refinement(acc, checkCtx);
            if (ctx.common.async) {
              return Promise.resolve(result);
            }
            if (result instanceof Promise) {
              throw new Error("Async refinement encountered during synchronous parse operation. Use .parseAsync instead.");
            }
            return acc;
          };
          if (ctx.common.async === false) {
            const inner = this._def.schema._parseSync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            });
            if (inner.status === "aborted")
              return INVALID;
            if (inner.status === "dirty")
              status.dirty();
            executeRefinement(inner.value);
            return { status: status.value, value: inner.value };
          } else {
            return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((inner) => {
              if (inner.status === "aborted")
                return INVALID;
              if (inner.status === "dirty")
                status.dirty();
              return executeRefinement(inner.value).then(() => {
                return { status: status.value, value: inner.value };
              });
            });
          }
        }
        if (effect.type === "transform") {
          if (ctx.common.async === false) {
            const base = this._def.schema._parseSync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            });
            if (!isValid(base))
              return INVALID;
            const result = effect.transform(base.value, checkCtx);
            if (result instanceof Promise) {
              throw new Error(`Asynchronous transform encountered during synchronous parse operation. Use .parseAsync instead.`);
            }
            return { status: status.value, value: result };
          } else {
            return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((base) => {
              if (!isValid(base))
                return INVALID;
              return Promise.resolve(effect.transform(base.value, checkCtx)).then((result) => ({
                status: status.value,
                value: result
              }));
            });
          }
        }
        util.assertNever(effect);
      }
    };
    ZodEffects.create = (schema6, effect, params) => {
      return new ZodEffects({
        schema: schema6,
        typeName: ZodFirstPartyTypeKind.ZodEffects,
        effect,
        ...processCreateParams(params)
      });
    };
    ZodEffects.createWithPreprocess = (preprocess, schema6, params) => {
      return new ZodEffects({
        schema: schema6,
        effect: { type: "preprocess", transform: preprocess },
        typeName: ZodFirstPartyTypeKind.ZodEffects,
        ...processCreateParams(params)
      });
    };
    ZodOptional = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType === ZodParsedType.undefined) {
          return OK(void 0);
        }
        return this._def.innerType._parse(input);
      }
      unwrap() {
        return this._def.innerType;
      }
    };
    ZodOptional.create = (type, params) => {
      return new ZodOptional({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodOptional,
        ...processCreateParams(params)
      });
    };
    ZodNullable = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType === ZodParsedType.null) {
          return OK(null);
        }
        return this._def.innerType._parse(input);
      }
      unwrap() {
        return this._def.innerType;
      }
    };
    ZodNullable.create = (type, params) => {
      return new ZodNullable({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodNullable,
        ...processCreateParams(params)
      });
    };
    ZodDefault = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        let data = ctx.data;
        if (ctx.parsedType === ZodParsedType.undefined) {
          data = this._def.defaultValue();
        }
        return this._def.innerType._parse({
          data,
          path: ctx.path,
          parent: ctx
        });
      }
      removeDefault() {
        return this._def.innerType;
      }
    };
    ZodDefault.create = (type, params) => {
      return new ZodDefault({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodDefault,
        defaultValue: typeof params.default === "function" ? params.default : () => params.default,
        ...processCreateParams(params)
      });
    };
    ZodCatch = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const newCtx = {
          ...ctx,
          common: {
            ...ctx.common,
            issues: []
          }
        };
        const result = this._def.innerType._parse({
          data: newCtx.data,
          path: newCtx.path,
          parent: {
            ...newCtx
          }
        });
        if (isAsync(result)) {
          return result.then((result2) => {
            return {
              status: "valid",
              value: result2.status === "valid" ? result2.value : this._def.catchValue({
                get error() {
                  return new ZodError(newCtx.common.issues);
                },
                input: newCtx.data
              })
            };
          });
        } else {
          return {
            status: "valid",
            value: result.status === "valid" ? result.value : this._def.catchValue({
              get error() {
                return new ZodError(newCtx.common.issues);
              },
              input: newCtx.data
            })
          };
        }
      }
      removeCatch() {
        return this._def.innerType;
      }
    };
    ZodCatch.create = (type, params) => {
      return new ZodCatch({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodCatch,
        catchValue: typeof params.catch === "function" ? params.catch : () => params.catch,
        ...processCreateParams(params)
      });
    };
    ZodNaN = class extends ZodType {
      _parse(input) {
        const parsedType = this._getType(input);
        if (parsedType !== ZodParsedType.nan) {
          const ctx = this._getOrReturnCtx(input);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: ZodParsedType.nan,
            received: ctx.parsedType
          });
          return INVALID;
        }
        return { status: "valid", value: input.data };
      }
    };
    ZodNaN.create = (params) => {
      return new ZodNaN({
        typeName: ZodFirstPartyTypeKind.ZodNaN,
        ...processCreateParams(params)
      });
    };
    BRAND = Symbol("zod_brand");
    ZodBranded = class extends ZodType {
      _parse(input) {
        const { ctx } = this._processInputParams(input);
        const data = ctx.data;
        return this._def.type._parse({
          data,
          path: ctx.path,
          parent: ctx
        });
      }
      unwrap() {
        return this._def.type;
      }
    };
    ZodPipeline = class _ZodPipeline extends ZodType {
      _parse(input) {
        const { status, ctx } = this._processInputParams(input);
        if (ctx.common.async) {
          const handleAsync = async () => {
            const inResult = await this._def.in._parseAsync({
              data: ctx.data,
              path: ctx.path,
              parent: ctx
            });
            if (inResult.status === "aborted")
              return INVALID;
            if (inResult.status === "dirty") {
              status.dirty();
              return DIRTY(inResult.value);
            } else {
              return this._def.out._parseAsync({
                data: inResult.value,
                path: ctx.path,
                parent: ctx
              });
            }
          };
          return handleAsync();
        } else {
          const inResult = this._def.in._parseSync({
            data: ctx.data,
            path: ctx.path,
            parent: ctx
          });
          if (inResult.status === "aborted")
            return INVALID;
          if (inResult.status === "dirty") {
            status.dirty();
            return {
              status: "dirty",
              value: inResult.value
            };
          } else {
            return this._def.out._parseSync({
              data: inResult.value,
              path: ctx.path,
              parent: ctx
            });
          }
        }
      }
      static create(a9, b9) {
        return new _ZodPipeline({
          in: a9,
          out: b9,
          typeName: ZodFirstPartyTypeKind.ZodPipeline
        });
      }
    };
    ZodReadonly = class extends ZodType {
      _parse(input) {
        const result = this._def.innerType._parse(input);
        const freeze = (data) => {
          if (isValid(data)) {
            data.value = Object.freeze(data.value);
          }
          return data;
        };
        return isAsync(result) ? result.then((data) => freeze(data)) : freeze(result);
      }
      unwrap() {
        return this._def.innerType;
      }
    };
    ZodReadonly.create = (type, params) => {
      return new ZodReadonly({
        innerType: type,
        typeName: ZodFirstPartyTypeKind.ZodReadonly,
        ...processCreateParams(params)
      });
    };
    late = {
      object: ZodObject.lazycreate
    };
    (function(ZodFirstPartyTypeKind2) {
      ZodFirstPartyTypeKind2["ZodString"] = "ZodString";
      ZodFirstPartyTypeKind2["ZodNumber"] = "ZodNumber";
      ZodFirstPartyTypeKind2["ZodNaN"] = "ZodNaN";
      ZodFirstPartyTypeKind2["ZodBigInt"] = "ZodBigInt";
      ZodFirstPartyTypeKind2["ZodBoolean"] = "ZodBoolean";
      ZodFirstPartyTypeKind2["ZodDate"] = "ZodDate";
      ZodFirstPartyTypeKind2["ZodSymbol"] = "ZodSymbol";
      ZodFirstPartyTypeKind2["ZodUndefined"] = "ZodUndefined";
      ZodFirstPartyTypeKind2["ZodNull"] = "ZodNull";
      ZodFirstPartyTypeKind2["ZodAny"] = "ZodAny";
      ZodFirstPartyTypeKind2["ZodUnknown"] = "ZodUnknown";
      ZodFirstPartyTypeKind2["ZodNever"] = "ZodNever";
      ZodFirstPartyTypeKind2["ZodVoid"] = "ZodVoid";
      ZodFirstPartyTypeKind2["ZodArray"] = "ZodArray";
      ZodFirstPartyTypeKind2["ZodObject"] = "ZodObject";
      ZodFirstPartyTypeKind2["ZodUnion"] = "ZodUnion";
      ZodFirstPartyTypeKind2["ZodDiscriminatedUnion"] = "ZodDiscriminatedUnion";
      ZodFirstPartyTypeKind2["ZodIntersection"] = "ZodIntersection";
      ZodFirstPartyTypeKind2["ZodTuple"] = "ZodTuple";
      ZodFirstPartyTypeKind2["ZodRecord"] = "ZodRecord";
      ZodFirstPartyTypeKind2["ZodMap"] = "ZodMap";
      ZodFirstPartyTypeKind2["ZodSet"] = "ZodSet";
      ZodFirstPartyTypeKind2["ZodFunction"] = "ZodFunction";
      ZodFirstPartyTypeKind2["ZodLazy"] = "ZodLazy";
      ZodFirstPartyTypeKind2["ZodLiteral"] = "ZodLiteral";
      ZodFirstPartyTypeKind2["ZodEnum"] = "ZodEnum";
      ZodFirstPartyTypeKind2["ZodEffects"] = "ZodEffects";
      ZodFirstPartyTypeKind2["ZodNativeEnum"] = "ZodNativeEnum";
      ZodFirstPartyTypeKind2["ZodOptional"] = "ZodOptional";
      ZodFirstPartyTypeKind2["ZodNullable"] = "ZodNullable";
      ZodFirstPartyTypeKind2["ZodDefault"] = "ZodDefault";
      ZodFirstPartyTypeKind2["ZodCatch"] = "ZodCatch";
      ZodFirstPartyTypeKind2["ZodPromise"] = "ZodPromise";
      ZodFirstPartyTypeKind2["ZodBranded"] = "ZodBranded";
      ZodFirstPartyTypeKind2["ZodPipeline"] = "ZodPipeline";
      ZodFirstPartyTypeKind2["ZodReadonly"] = "ZodReadonly";
    })(ZodFirstPartyTypeKind || (ZodFirstPartyTypeKind = {}));
    instanceOfType = (cls, params = {
      message: `Input not instance of ${cls.name}`
    }) => custom((data) => data instanceof cls, params);
    stringType = ZodString.create;
    numberType = ZodNumber.create;
    nanType = ZodNaN.create;
    bigIntType = ZodBigInt.create;
    booleanType = ZodBoolean.create;
    dateType = ZodDate.create;
    symbolType = ZodSymbol.create;
    undefinedType = ZodUndefined.create;
    nullType = ZodNull.create;
    anyType = ZodAny.create;
    unknownType = ZodUnknown.create;
    neverType = ZodNever.create;
    voidType = ZodVoid.create;
    arrayType = ZodArray.create;
    objectType = ZodObject.create;
    strictObjectType = ZodObject.strictCreate;
    unionType = ZodUnion.create;
    discriminatedUnionType = ZodDiscriminatedUnion.create;
    intersectionType = ZodIntersection.create;
    tupleType = ZodTuple.create;
    recordType = ZodRecord.create;
    mapType = ZodMap.create;
    setType = ZodSet.create;
    functionType = ZodFunction.create;
    lazyType = ZodLazy.create;
    literalType = ZodLiteral.create;
    enumType = ZodEnum.create;
    nativeEnumType = ZodNativeEnum.create;
    promiseType = ZodPromise.create;
    effectsType = ZodEffects.create;
    optionalType = ZodOptional.create;
    nullableType = ZodNullable.create;
    preprocessType = ZodEffects.createWithPreprocess;
    pipelineType = ZodPipeline.create;
    o